/*
 * Decompiled with CFR 0.152.
 */
package yuma140902.uptodatemod.vrl.model;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import yuma140902.uptodatemod.vrl.extract.ExtractionTask;
import yuma140902.uptodatemod.vrl.extract.func.EnumExtractFunction;
import yuma140902.uptodatemod.vrl.model.File;

public class Part {
    public String archive_id;
    public String part_id;
    public String src_dir;
    public String dst_dir;
    public List<File> files;

    public Stream<ExtractionTask> streamExtractionTasks(Path baseDir) {
        if (this.files == null) {
            System.out.printf("part_id=%s 's files are somehow null%n", this.part_id);
            return Stream.of(new ExtractionTask[0]);
        }
        return this.files.stream().filter(Objects::nonNull).map(f -> {
            String archive_id = this.archive_id;
            Path srcPath = Paths.get(this.src_dir + f.src, new String[0]);
            Path dstPath = baseDir.resolve(this.dst_dir + f.dst);
            EnumExtractFunction function = f.func == null ? EnumExtractFunction.COPY_ONLY : (f.func.equals("rotate90") ? EnumExtractFunction.ROTATE90 : (f.func.equals("rotate180") ? EnumExtractFunction.ROTATE180 : (f.func.equals("rotate270") ? EnumExtractFunction.ROTATE270 : (f.func.equals("flip") ? EnumExtractFunction.FLIP : EnumExtractFunction.COPY_ONLY))));
            return new ExtractionTask(archive_id, srcPath, dstPath, function);
        });
    }
}

