/*
 * Decompiled with CFR 0.152.
 */
package yuma140902.uptodatemod.vrl.extract.func;

import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import javax.imageio.ImageIO;
import yuma140902.uptodatemod.vrl.extract.func.IExtractFunction;
import yuma140902.uptodatemod.vrl.extract.func.TemporaryFile;

public class ExtractFunctionRotate
implements IExtractFunction {
    private int angle;
    private AffineTransform transform;

    public ExtractFunctionRotate(int angle) {
        this.angle = angle;
        this.transform = new AffineTransform();
    }

    @Override
    public void handle(Path src, Path dst) throws IOException {
        try (TemporaryFile temporaryFile = new TemporaryFile(dst);){
            Path tmp = temporaryFile.getPath();
            Files.copy(src, tmp, StandardCopyOption.REPLACE_EXISTING);
            BufferedImage inBuff = ImageIO.read(tmp.toFile());
            if (this.angle == 90) {
                this.transform.setToRotation(Math.toRadians(90.0), (double)inBuff.getHeight() / 2.0, (double)inBuff.getHeight() / 2.0);
            } else if (this.angle == 180) {
                this.transform.setToRotation(Math.toRadians(180.0), (double)inBuff.getWidth() / 2.0, (double)inBuff.getHeight() / 2.0);
            } else if (this.angle == 270) {
                this.transform.setToRotation(Math.toRadians(270.0), (double)inBuff.getWidth() / 2.0, (double)inBuff.getWidth() / 2.0);
            }
            BufferedImage outBuff = null;
            if (this.angle == 90 || this.angle == 270) {
                outBuff = new BufferedImage(inBuff.getHeight(), inBuff.getWidth(), inBuff.getType());
            } else if (this.angle == 180) {
                outBuff = new BufferedImage(inBuff.getWidth(), inBuff.getHeight(), inBuff.getType());
            }
            AffineTransformOp transformOp = new AffineTransformOp(this.transform, 3);
            transformOp.filter(inBuff, outBuff);
            ImageIO.write((RenderedImage)outBuff, "png", dst.toFile());
        }
    }
}

