/*
 * Decompiled with CFR 0.152.
 */
package yuma140902.uptodatemod.vrl.extract;

import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import yuma140902.uptodatemod.vrl.VRLException;
import yuma140902.uptodatemod.vrl.archives.ArchiveFileSystemStore;
import yuma140902.uptodatemod.vrl.extract.ExtractionTask;
import yuma140902.uptodatemod.vrl.extract.ExtractionTaskStatus;
import yuma140902.uptodatemod.vrl.extract.func.IExtractFunction;

public class Extractor {
    private final List<ExtractionTask> tasks = new ArrayList<ExtractionTask>();
    private final ArchiveFileSystemStore archiveStore;

    public Extractor(List<ExtractionTask> tasks, ArchiveFileSystemStore archiveStore) {
        this.tasks.addAll(tasks);
        this.archiveStore = archiveStore;
    }

    public void start() throws VRLException {
        for (ExtractionTask task : this.tasks) {
            try {
                this.extract(task);
            }
            catch (IOException e) {
                task.setFailed(e);
            }
        }
        List failedTasks = this.tasks.stream().filter(t -> t.getStatus() == ExtractionTaskStatus.FAILED).collect(Collectors.toList());
        for (ExtractionTask t2 : failedTasks) {
            Throwable e = t2.getFailureReason();
            if (e == null) continue;
            e.printStackTrace();
        }
        if (failedTasks.size() > 0) {
            throw new VRLException(String.format("%d extraction tasks failed", failedTasks.size()));
        }
    }

    private void extract(ExtractionTask task) throws IOException {
        FileSystem fs = this.archiveStore.getFileSystem(task.getArchiveId());
        Path src = fs.getPath(task.getSourcePathInArchive().toString(), new String[0]);
        Path dst = task.getDestPath();
        task.setStatus(ExtractionTaskStatus.EXTRACTING);
        if (!Files.exists(src, new LinkOption[0])) {
            System.out.printf("[%s] %s was not found. Skipping.%n", task.getArchiveId(), src);
            task.setFailed(new VRLException("source path not found"));
            return;
        }
        Files.createDirectories(dst.getParent(), new FileAttribute[0]);
        IExtractFunction function = task.getFunction().getFunction();
        function.handle(src, dst);
        task.setStatus(ExtractionTaskStatus.DONE);
    }
}

