/*
 * Decompiled with CFR 0.152.
 */
package yuma140902.uptodatemod.vrl.extract;

import java.nio.file.Path;
import yuma140902.uptodatemod.vrl.extract.ExtractionTaskStatus;
import yuma140902.uptodatemod.vrl.extract.func.EnumExtractFunction;

public class ExtractionTask {
    private final String archiveId;
    private final Path sourcePathInArchive;
    private final Path destPath;
    private final EnumExtractFunction function;
    private ExtractionTaskStatus status;
    private Throwable failureReason;

    public ExtractionTask(String archiveId, Path sourcePathInArchive, Path destPath, EnumExtractFunction function) {
        this.archiveId = archiveId;
        this.sourcePathInArchive = sourcePathInArchive;
        this.destPath = destPath;
        this.function = function == null ? EnumExtractFunction.COPY_ONLY : function;
        this.status = ExtractionTaskStatus.NOT_STARTED;
    }

    public String getArchiveId() {
        return this.archiveId;
    }

    public Path getSourcePathInArchive() {
        return this.sourcePathInArchive;
    }

    public Path getDestPath() {
        return this.destPath;
    }

    public EnumExtractFunction getFunction() {
        return this.function;
    }

    public ExtractionTaskStatus getStatus() {
        return this.status;
    }

    public void setStatus(ExtractionTaskStatus status) {
        this.status = status;
    }

    public Throwable getFailureReason() {
        return this.failureReason;
    }

    public void setFailed(Throwable failureReason) {
        this.status = ExtractionTaskStatus.FAILED;
        this.failureReason = failureReason;
    }
}

