/*
 * Decompiled with CFR 0.152.
 */
package yuma140902.uptodatemod.vrl;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.codec.digest.DigestUtils;
import yuma140902.uptodatemod.ModUpToDateMod;
import yuma140902.uptodatemod.vrl.VRLException;
import yuma140902.uptodatemod.vrl.model.VRLSetting;

public class VRLSettingFileLoader {
    private String settingFileName;

    public VRLSettingFileLoader(String settingFileName) {
        this.settingFileName = settingFileName;
    }

    public String loadSettingHash() throws VRLException {
        try {
            InputStream stream = ModUpToDateMod.class.getResourceAsStream(this.settingFileName);
            if (stream == null) {
                throw new VRLException(this.settingFileName + " not found");
            }
            return DigestUtils.md5Hex((InputStream)stream);
        }
        catch (IOException e) {
            throw new VRLException("Failed to Open VRL " + this.settingFileName, e);
        }
    }

    public VRLSetting loadSetting() throws VRLException {
        Gson gson = new Gson();
        InputStream stream = ModUpToDateMod.class.getResourceAsStream(this.settingFileName);
        if (stream == null) {
            throw new VRLException(this.settingFileName + " not found");
        }
        InputStreamReader reader = new InputStreamReader(stream);
        return (VRLSetting)gson.fromJson((Reader)reader, VRLSetting.class);
    }
}

