/*
 * Decompiled with CFR 0.152.
 */
package yuma140902.uptodatemod.loot;

import java.util.Random;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.item.Item;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import yuma140902.uptodatemod.MyBlocks;
import yuma140902.uptodatemod.MyItems;
import yuma140902.uptodatemod.config.ModConfigCore;
import yuma140902.uptodatemod.registry.EnumDisableableFeatures;
import yuma140902.uptodatemod.registry.IDisableableFeature;
import yuma140902.yumalib.api.loot.IMobLootInfo;
import yuma140902.yumalib.api.loot.MobLootInfo;
import yuma140902.yumalib.loot.MobDropHandler;

public class MobLoot {
    private MobLoot() {
    }

    private static IMobLootInfo mobLootInfoOf(IDisableableFeature feature, Class<? extends Entity> entityClass, Item item) {
        return MobLootInfo.of(feature.featureEnabled(), entityClass, item);
    }

    private static IMobLootInfo mobLootInfoOf(IDisableableFeature feature, Class<? extends Entity> entityClass, Item item, int itemMeta, int itemNum) {
        return MobLootInfo.of(feature.featureEnabled(), entityClass, item, itemMeta, itemNum);
    }

    private static IMobLootInfo mobLootInfoOf(IDisableableFeature feature, Class<? extends Entity> entityClass, Item item, int itemMeta, int itemNum, Predicate<LivingDropsEvent> extraValidator) {
        return MobLootInfo.of(feature.featureEnabled(), entityClass, item, itemMeta, itemNum, extraValidator);
    }

    private static IMobLootInfo mobLootInfoOf(IDisableableFeature feature, Class<? extends Entity> entityClass, Item item, int itemMeta, Function<Random, Integer> itemNumProvider) {
        return MobLootInfo.of(feature.featureEnabled(), entityClass, item, itemMeta, itemNumProvider, null);
    }

    private static IMobLootInfo mobLootInfoOf(IDisableableFeature feature, Class<? extends Entity> entityClass, Item item, int itemMeta, Function<Random, Integer> itemNumProvider, Predicate<LivingDropsEvent> extraValidator) {
        return MobLootInfo.of(feature.featureEnabled(), entityClass, item, itemMeta, itemNumProvider, extraValidator);
    }

    public static void registerBasicMobLoots() {
        MobDropHandler.INSTANCE.register(MobLoot.mobLootInfoOf((IDisableableFeature)EnumDisableableFeatures.mutton, EntitySheep.class, (Item)MyItems.cookedMutton, 0, rand -> rand.nextInt(2) + 1, (LivingDropsEvent event) -> event.entity.func_70027_ad()));
        MobDropHandler.INSTANCE.register(MobLoot.mobLootInfoOf((IDisableableFeature)EnumDisableableFeatures.mutton, EntitySheep.class, (Item)MyItems.rawMutton, 0, rand -> rand.nextInt(2) + 1, (LivingDropsEvent event) -> !event.entity.func_70027_ad()));
        if (ModConfigCore.Alternative.altPrismarine()) {
            MobDropHandler.INSTANCE.register(MobLoot.mobLootInfoOf((IDisableableFeature)EnumDisableableFeatures.prismarineStuffs, EntitySquid.class, (Item)MyItems.prismarineShard, 0, rand -> (rand.nextInt(6) + rand.nextInt(2)) * 2));
            MobDropHandler.INSTANCE.register(MobLoot.mobLootInfoOf((IDisableableFeature)EnumDisableableFeatures.prismarineStuffs, EntitySquid.class, (Item)MyItems.prismarineCrystal, 0, rand -> (rand.nextInt(2) + rand.nextInt(2)) * 1));
        }
        if (ModConfigCore.Alternative.altPurpur()) {
            MobDropHandler.INSTANCE.register(MobLoot.mobLootInfoOf((IDisableableFeature)EnumDisableableFeatures.purpurStuffs, EntityEnderman.class, Item.func_150898_a((Block)MyBlocks.purpurBlock), 0, rand -> (rand.nextInt(3) + rand.nextInt(3)) * 2, (LivingDropsEvent event) -> event.entity.field_70170_p.field_73011_w.field_76574_g == 1));
            MobDropHandler.INSTANCE.register(MobLoot.mobLootInfoOf((IDisableableFeature)EnumDisableableFeatures.purpurStuffs, EntityEnderman.class, Item.func_150898_a((Block)MyBlocks.purpurBlock), 0, rand -> rand.nextInt(3), (LivingDropsEvent event) -> {
                int dimId = event.entity.field_70170_p.field_73011_w.field_76574_g;
                return dimId != 0 && dimId != -1;
            }));
        }
    }
}

