/*
 * Decompiled with CFR 0.152.
 */
package yuma140902.uptodatemod.items;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import yuma140902.uptodatemod.MyBlocks;
import yuma140902.uptodatemod.blocks.BlockNewFlower;
import yuma140902.uptodatemod.registry.RecipeRegister;
import yuma140902.uptodatemod.util.StringUtil;
import yuma140902.yumalib.ModYumaLib;
import yuma140902.yumalib.api.IHasRecipes;
import yuma140902.yumalib.api.IRegisterable;
import yuma140902.yumalib.api.items.ItemFoodMultiMeta;

public class ItemSuspiciousStew
extends ItemFoodMultiMeta
implements IRegisterable,
IHasRecipes {
    @Nonnull
    private static final String[] flowerNames = new String[]{"poppy", "blue_orchid", "allium", "houstonia", "dandelion", "lily_of_the_valley", "cornflower", "tulip", "oxeye_daisy", "wither_rose"};
    private static final int SEC = 30;
    private static final int POTION = 0;
    private static final int DURATION = 1;
    private static final int AMPLIFIER = 2;
    @Nonnull
    public static final int[][] potionInfos = new int[][]{{Potion.field_76439_r.field_76415_H, 150, 0}, {Potion.field_76443_y.field_76415_H, 10, 0}, {Potion.field_76426_n.field_76415_H, 90, 0}, {Potion.field_76440_q.field_76415_H, 210, 0}, {Potion.field_76443_y.field_76415_H, 10, 0}, {Potion.field_76436_u.field_76415_H, 330, 0}, {Potion.field_76430_j.field_76415_H, 150, 0}, {Potion.field_76437_t.field_76415_H, 240, 0}, {Potion.field_76428_l.field_76415_H, 210, 0}, {Potion.field_82731_v.field_76415_H, 210, 0}};

    public ItemSuspiciousStew() {
        super(6, 0.6f, "suspicious_stew", flowerNames, StringUtil.name.domainedTextures("suspicious_stew"));
        this.func_77848_i();
        this.func_77625_d(1);
    }

    @Override
    public void registerRecipes() {
        this.redFlower(0, 0);
        this.redFlower(1, 1);
        this.redFlower(2, 2);
        this.redFlower(3, 3);
        this.addStewRecipe(4, new ItemStack((Block)Blocks.field_150327_N));
        this.addStewRecipe(5, new ItemStack((Block)MyBlocks.flower, 1, BlockNewFlower.LILY));
        this.addStewRecipe(6, new ItemStack((Block)MyBlocks.flower, 1, BlockNewFlower.CORNFLOWER));
        this.redFlower(7, 4);
        this.redFlower(7, 6);
        this.redFlower(7, 7);
        this.redFlower(7, 5);
        this.redFlower(8, 8);
        this.addStewRecipe(9, new ItemStack((Block)MyBlocks.witherRose));
        if (ModYumaLib.proxy.isYuma140902()) {
            ItemStack goldenStew = new ItemStack((Item)this);
            NBT.write(goldenStew, Potion.field_76422_e.field_76415_H, 1500, 19);
            NBT.write(goldenStew, Potion.field_76430_j.field_76415_H, 1500, 4);
            NBT.write(goldenStew, Potion.field_76424_c.field_76415_H, 1500, 5);
            NBT.write(goldenStew, Potion.field_76428_l.field_76415_H, 1500, 9);
            NBT.write(goldenStew, Potion.field_76432_h.field_76415_H, 1500, 9);
            NBT.write(goldenStew, Potion.field_76441_p.field_76415_H, 1500, 0);
            NBT.write(goldenStew, Potion.field_76426_n.field_76415_H, 1500, 0);
            NBT.write(goldenStew, Potion.field_76420_g.field_76415_H, 1500, 9);
            NBT.write(goldenStew, Potion.field_76439_r.field_76415_H, 1500, 0);
            NBT.write(goldenStew, Potion.field_76427_o.field_76415_H, 1500, 0);
            NBT.write(goldenStew, Potion.field_76443_y.field_76415_H, 1500, 9);
            NBT.write(goldenStew, Potion.field_76434_w.field_76415_H, 1500, 29);
            NBT.write(goldenStew, Potion.field_76444_x.field_76415_H, 1500, 19);
            assert (goldenStew.func_77978_p() != null);
            goldenStew.func_77978_p().func_74782_a("ench", (NBTBase)new NBTTagList());
            ItemStack notchApple = new ItemStack(Items.field_151153_ao, 1, 1);
            RecipeRegister.addShaped(goldenStew, "AAA", "ASA", "AAA", Character.valueOf('A'), notchApple, Character.valueOf('S'), Items.field_151009_A);
        }
    }

    private void redFlower(int stewId, int flowerMeta) {
        this.addStewRecipe(stewId, new ItemStack((Block)Blocks.field_150328_O, 1, flowerMeta));
    }

    private void addStewRecipe(int stewId, ItemStack flower) {
        RecipeRegister.addShapeless(this.stew(stewId), Items.field_151054_z, Blocks.field_150338_P, Blocks.field_150337_Q, flower);
    }

    private ItemStack stew(int stewId) {
        ItemStack stew = new ItemStack((Item)this);
        int[] potionInfo = potionInfos[stewId];
        int potionId = potionInfo[0];
        int duration = potionInfo[1];
        int amplifier = potionInfo[2];
        NBT.write(stew, potionId, duration, amplifier);
        return stew;
    }

    @Override
    public String func_77667_c(ItemStack itemstack) {
        return super.func_77658_a();
    }

    @Override
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < potionInfos.length; ++i) {
            list.add(this.stew(i));
        }
    }

    public ItemStack func_77654_b(ItemStack itemstack, World world, EntityPlayer player) {
        super.func_77654_b(itemstack, world, player);
        return new ItemStack(Items.field_151054_z);
    }

    protected void func_77849_c(ItemStack itemstack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            PotionEffect[] effects;
            for (PotionEffect effect : effects = NBT.getPotionEffects(itemstack)) {
                player.func_70690_d(effect);
            }
        }
    }

    public static class NBT {
        private static final String EFFECTS = "Effects";
        private static final String EFFECT_ID = "EffectId";
        private static final String EFFECT_DURATION = "EffectDuration";
        private static final String EFFECT_AMPLIFIER = "EffectAmplifier";
        private static final int NBTTAG_COMPOUND = new NBTTagCompound().func_74732_a();

        private static ItemStack write(ItemStack itemstack, int potionId, int duration, int amplifier) {
            NBTTagList effects;
            if (itemstack == null) {
                return null;
            }
            NBTTagCompound tag = itemstack.func_77978_p();
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            if ((effects = tag.func_150295_c(EFFECTS, NBTTAG_COMPOUND)) == null) {
                effects = new NBTTagList();
            }
            NBTTagCompound effectTag = new NBTTagCompound();
            effectTag.func_74768_a(EFFECT_ID, potionId);
            effectTag.func_74768_a(EFFECT_DURATION, duration);
            effectTag.func_74768_a(EFFECT_AMPLIFIER, amplifier);
            effects.func_74742_a((NBTBase)effectTag);
            tag.func_74782_a(EFFECTS, (NBTBase)effects);
            itemstack.func_77982_d(tag);
            return itemstack;
        }

        private static PotionEffect[] read(ItemStack itemstack) {
            if (itemstack == null) {
                return null;
            }
            NBTTagCompound tag = itemstack.func_77978_p();
            if (tag == null) {
                return null;
            }
            NBTTagList effects = tag.func_150295_c(EFFECTS, NBTTAG_COMPOUND);
            if (effects == null) {
                return null;
            }
            PotionEffect[] potionEffects = new PotionEffect[effects.func_74745_c()];
            for (int i = 0; i < potionEffects.length; ++i) {
                PotionEffect potionEffect;
                NBTTagCompound effectTag = effects.func_150305_b(i);
                int potionId = effectTag.func_74762_e(EFFECT_ID);
                int duration = effectTag.func_74762_e(EFFECT_DURATION);
                int amplifier = effectTag.func_74762_e(EFFECT_AMPLIFIER);
                potionEffects[i] = potionEffect = new PotionEffect(potionId, duration, amplifier);
            }
            return potionEffects;
        }

        public static PotionEffect[] getPotionEffects(ItemStack itemstack) {
            PotionEffect[] effects = NBT.read(itemstack);
            if (effects != null) {
                return effects;
            }
            int meta = itemstack.func_77960_j();
            if (0 <= meta && meta < potionInfos.length) {
                int[] potionInfo = potionInfos[meta];
                int potion = potionInfo[0];
                int duration = potionInfo[1];
                int amplifier = potionInfo[2];
                return new PotionEffect[]{new PotionEffect(potion, duration, amplifier)};
            }
            return new PotionEffect[0];
        }
    }
}

