/*
 * Decompiled with CFR 0.152.
 */
package yuma140902.uptodatemod.integration;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import yuma140902.uptodatemod.Recipes;
import yuma140902.uptodatemod.integration.IConfiguratingPlugin;
import yuma140902.uptodatemod.integration.IPlugin;
import yuma140902.uptodatemod.integration.ITweakingPlugin;
import yuma140902.uptodatemod.integration.ITweakingPostPlugin;
import yuma140902.uptodatemod.integration.PluginEtFuturum;
import yuma140902.uptodatemod.integration.PluginProjectE;
import yuma140902.uptodatemod.integration.PluginThaumcraft;

public final class Plugins {
    private static List<IPlugin> plugins = new ArrayList<IPlugin>();
    private static final Logger logger = LogManager.getLogger((String)"UpToDateMod-Plugins");

    private Plugins() {
    }

    private static void registerPlugin(IPlugin plugin) {
        plugins.add(plugin);
    }

    public static Iterator<IPlugin> iterator() {
        return plugins.iterator();
    }

    public static void logPluginStats() {
        for (IPlugin plugin : plugins) {
            logger.info(plugin.getModName() + " : " + (plugin.isIntegrationEnabled() ? "Enabled" : "Disabled"));
        }
    }

    public static void tweakMods() {
        Plugins.removeOtherModsRecipes();
        for (IPlugin plugin : plugins) {
            if (!plugin.isIntegrationEnabled() || !(plugin instanceof ITweakingPlugin)) continue;
            ((ITweakingPlugin)plugin).tweakMod();
        }
    }

    public static void tweakModsPost() {
        for (IPlugin plugin : plugins) {
            if (!plugin.isIntegrationEnabled() || !(plugin instanceof ITweakingPostPlugin)) continue;
            ((ITweakingPostPlugin)plugin).tweakModPost();
        }
    }

    static void initConfig(Configuration cfg) {
        plugins.stream().filter(IPlugin::isIntegrationEnabled).filter(p -> p instanceof IConfiguratingPlugin).map(p -> (IConfiguratingPlugin)p).forEach(p -> p.initConfig(cfg));
    }

    static void syncConfig(Configuration cfg) {
        plugins.stream().filter(IPlugin::isIntegrationEnabled).filter(p -> p instanceof IConfiguratingPlugin).map(p -> (IConfiguratingPlugin)p).forEach(p -> p.syncConfig(cfg));
    }

    static void wrapConfig(Configuration cfg) {
        plugins.stream().filter(IPlugin::isIntegrationEnabled).filter(p -> p instanceof IConfiguratingPlugin).map(p -> (IConfiguratingPlugin)p).forEach(p -> p.wrapConfig(cfg));
    }

    private static void removeOtherModsRecipes() {
        ArrayList<String> list = new ArrayList<String>();
        if (PluginEtFuturum.INSTANCE.isIntegrationEnabled()) {
            PluginEtFuturum.INSTANCE.getNamesToRemoveFromRecipe(list);
        }
        Recipes.removeRecipesByOutputName(list);
    }

    static {
        Plugins.registerPlugin(PluginEtFuturum.INSTANCE);
        Plugins.registerPlugin(PluginProjectE.INSTANCE);
        Plugins.registerPlugin(PluginThaumcraft.INSTANCE);
    }
}

