/*
 * Decompiled with CFR 0.152.
 */
package yuma140902.uptodatemod.event_handlers;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import yuma140902.uptodatemod.MyBlocks;
import yuma140902.uptodatemod.blocks.BlockFullWood;
import yuma140902.uptodatemod.blocks.generics.BlockGenericStrippedLog;
import yuma140902.uptodatemod.event_handlers.IWoodStrippingInfo;
import yuma140902.uptodatemod.event_handlers.WoodStrippingInfo;
import yuma140902.uptodatemod.registry.DisabledFeaturesRegistry;
import yuma140902.uptodatemod.registry.EnumDisableableFeatures;
import yuma140902.yumalib.api.blockstate.EnumVanillaLog;
import yuma140902.yumalib.api.blockstate.EnumVanillaLog2;
import yuma140902.yumalib.api.blockstate.VanillaRotatedPillarState;
import yuma140902.yumalib.api.util.BlockWithMetadata;

public class StripWoodHandler {
    @Nonnull
    private static List<IWoodStrippingInfo> registry = new ArrayList<IWoodStrippingInfo>();

    public static void register(@Nonnull IWoodStrippingInfo info) {
        registry.add(info);
    }

    private static boolean isAxe(ItemStack itemstack) {
        if (itemstack != null && itemstack.func_77973_b() != null) {
            Set toolClasses = itemstack.func_77973_b().getToolClasses(itemstack);
            return toolClasses != null && toolClasses.contains("axe");
        }
        return false;
    }

    public static void handle(PlayerInteractEvent event) {
        World world = event.world;
        int x = event.x;
        int y = event.y;
        int z = event.z;
        ItemStack heldItem = event.entityPlayer.func_70694_bm();
        if (!DisabledFeaturesRegistry.INSTANCE.isEnabled(EnumDisableableFeatures.strippedLogs)) {
            return;
        }
        if (!StripWoodHandler.isAxe(heldItem)) {
            return;
        }
        BlockWithMetadata state = BlockWithMetadata.fromCoord(world, x, y, z);
        for (IWoodStrippingInfo info : registry) {
            BlockWithMetadata stateToBe = info.blockStateToPlace(state);
            if (stateToBe == null) continue;
            world.func_147449_b(x, y, z, stateToBe.block);
            world.func_72921_c(x, y, z, stateToBe.meta, 3);
            String soundName = info.soundName();
            if (soundName == null) continue;
            world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, soundName, 1.0f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
    }

    public static void registerBasicWoodStripping() {
        StripWoodHandler.register(WoodStrippingInfo.of(blockWithMeta -> {
            BlockGenericStrippedLog strippedLog;
            VanillaRotatedPillarState.Axis axis;
            VanillaRotatedPillarState<Enum> state;
            Block block = blockWithMeta.block;
            if (block != Blocks.field_150364_r && block != Blocks.field_150363_s) {
                return null;
            }
            if (block == Blocks.field_150364_r) {
                state = VanillaRotatedPillarState.fromMetadata(blockWithMeta.meta, EnumVanillaLog.class);
                axis = state.axis();
                switch ((EnumVanillaLog)state.blockType()) {
                    case Oak: {
                        strippedLog = MyBlocks.strippedLogOak;
                        break;
                    }
                    case Spruce: {
                        strippedLog = MyBlocks.strippedLogSpruce;
                        break;
                    }
                    case Birch: {
                        strippedLog = MyBlocks.strippedLogBirch;
                        break;
                    }
                    case Jungle: {
                        strippedLog = MyBlocks.strippedLogJungle;
                        break;
                    }
                    default: {
                        return null;
                    }
                }
            } else {
                state = VanillaRotatedPillarState.fromMetadata(blockWithMeta.meta, EnumVanillaLog2.class);
                axis = state.axis();
                switch ((EnumVanillaLog2)state.blockType()) {
                    case Acacia: {
                        strippedLog = MyBlocks.strippedLogAcacia;
                        break;
                    }
                    case DarkOak: {
                        strippedLog = MyBlocks.strippedLogDarkOak;
                        break;
                    }
                    default: {
                        return null;
                    }
                }
            }
            if (strippedLog == null) {
                return null;
            }
            VanillaRotatedPillarState<VanillaRotatedPillarState.NoBlockType> newState = new VanillaRotatedPillarState<VanillaRotatedPillarState.NoBlockType>(VanillaRotatedPillarState.NoBlockType.NONE, axis, VanillaRotatedPillarState.NoBlockType.class);
            return new BlockWithMetadata((Block)strippedLog, newState.metadata());
        }, "dig.cloth"));
        StripWoodHandler.register(WoodStrippingInfo.of(blockWithMeta -> {
            if (blockWithMeta.block != MyBlocks.wood) {
                return null;
            }
            int meta = MathHelper.func_76125_a((int)blockWithMeta.meta, (int)0, (int)5);
            BlockGenericStrippedLog blockToPlace = BlockFullWood.getStrippedLog(meta);
            VanillaRotatedPillarState<VanillaRotatedPillarState.NoBlockType> newState = new VanillaRotatedPillarState<VanillaRotatedPillarState.NoBlockType>(VanillaRotatedPillarState.NoBlockType.NONE, VanillaRotatedPillarState.Axis.NO_AXIS, VanillaRotatedPillarState.NoBlockType.class);
            return new BlockWithMetadata((Block)blockToPlace, newState.metadata());
        }, "dig.cloth"));
    }
}

