/*
 * Decompiled with CFR 0.152.
 */
package yuma140902.uptodatemod.event_handlers;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.NoteBlockEvent;
import yuma140902.uptodatemod.ModUpToDateMod;
import yuma140902.uptodatemod.MyBlocks;
import yuma140902.uptodatemod.blocks.BlockCoarseDirt;
import yuma140902.uptodatemod.blocks.BlockWitherRose;
import yuma140902.uptodatemod.config.ModConfigCore;
import yuma140902.uptodatemod.event_handlers.StripWoodHandler;
import yuma140902.uptodatemod.network.NoteBlockPlayMessage;
import yuma140902.uptodatemod.registry.EnumDisableableFeatures;
import yuma140902.uptodatemod.registry.EnumNoteBlockInstrument;
import yuma140902.uptodatemod.registry.HoeEfficientBlockRegistry;

public class CommonEventHandler {
    public static final CommonEventHandler INSTANCE = new CommonEventHandler();

    private CommonEventHandler() {
    }

    @SubscribeEvent
    public void onUseHoeEvent(UseHoeEvent event) {
        BlockCoarseDirt.onUseHoeEvent(event);
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        if (EnumDisableableFeatures.witherRose.featureEnabled()) {
            BlockWitherRose.onLivingDeathEvent(event);
        }
    }

    private Item.ToolMaterial getHoeMaterial(ItemStack itemStack) {
        block4: {
            if (itemStack == null || itemStack.func_77973_b() == null) {
                return null;
            }
            if (itemStack.func_77973_b() instanceof ItemHoe) {
                ItemHoe hoe = (ItemHoe)itemStack.func_77973_b();
                try {
                    return Item.ToolMaterial.valueOf((String)hoe.func_77842_f());
                }
                catch (IllegalArgumentException ex) {
                    if ($assertionsDisabled) break block4;
                    throw new AssertionError((Object)ex);
                }
            }
        }
        return null;
    }

    @SubscribeEvent
    public void hoeBreakSpeed(PlayerEvent.BreakSpeed event) {
        Item.ToolMaterial material = this.getHoeMaterial(event.entityPlayer.func_70694_bm());
        if (material == null) {
            return;
        }
        if (HoeEfficientBlockRegistry.INSTANCE.isHoeEfficient(event.block)) {
            event.newSpeed = event.originalSpeed * material.func_77998_b();
        }
    }

    @SubscribeEvent
    public void onBreakBlock(BlockEvent.BreakEvent event) {
        ItemStack heldItem = event.getPlayer().func_70694_bm();
        if (heldItem == null || heldItem.func_77973_b() == null) {
            return;
        }
        if (heldItem.func_77973_b() instanceof ItemHoe) {
            heldItem.func_77972_a(1, (EntityLivingBase)event.getPlayer());
        }
    }

    private boolean isShovel(ItemStack itemstack) {
        if (itemstack != null && itemstack.func_77973_b() != null) {
            Set toolClasses = itemstack.func_77973_b().getToolClasses(itemstack);
            return toolClasses != null && toolClasses.contains("shovel");
        }
        return false;
    }

    private boolean canBlockTurnIntoGlassPath(Block block) {
        return block == Blocks.field_150349_c || block == Blocks.field_150346_d || block == MyBlocks.coarseDirt;
    }

    @SubscribeEvent
    public void onPlayerUsedItem(PlayerInteractEvent event) {
        if (event.action != PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        World world = event.world;
        int x = event.x;
        int y = event.y;
        int z = event.z;
        ItemStack heldItem = event.entityPlayer.func_70694_bm();
        if (heldItem == null) {
            return;
        }
        if (EnumDisableableFeatures.grassPath.featureEnabled() && this.isShovel(heldItem) && this.canBlockTurnIntoGlassPath(world.func_147439_a(x, y, z))) {
            Block blockAbove = world.func_147439_a(x, y + 1, z);
            if (blockAbove != null && blockAbove.func_149662_c()) {
                return;
            }
            world.func_147449_b(x, y, z, (Block)MyBlocks.grassPath);
            world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "dig.grass", 1.0f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        StripWoodHandler.handle(event);
    }

    @SubscribeEvent
    public void onNoteBlockPlay(NoteBlockEvent.Play event) {
        if (!EnumDisableableFeatures.newNoteBlockInstruments.featureEnabled()) {
            return;
        }
        World world = event.world;
        int x = event.x;
        int y = event.y;
        int z = event.z;
        int dimId = world.field_73011_w.field_76574_g;
        int noteId = event.getVanillaNoteId();
        EnumNoteBlockInstrument instrument = null;
        Block blockUnder = world.func_147439_a(x, y - 1, z);
        boolean matched = false;
        for (int i = 0; i < EnumNoteBlockInstrument.getLength(); ++i) {
            instrument = EnumNoteBlockInstrument.fromId(i);
            if (!instrument.matches(blockUnder)) continue;
            matched = true;
            break;
        }
        if (!matched) {
            return;
        }
        float f = (float)Math.pow(2.0, (double)(noteId - 12) / 12.0);
        world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, instrument.getSoundName(), 3.0f, f);
        ModUpToDateMod.networkWrapper.sendToAllAround((IMessage)new NoteBlockPlayMessage(instrument, noteId, dimId, x, y, z), new NetworkRegistry.TargetPoint(dimId, (double)x, (double)y, (double)z, 32.0));
        event.setCanceled(true);
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if ("uptodate".equals(event.modID)) {
            ModConfigCore.syncConfig();
        }
    }
}

