/*
 * Decompiled with CFR 0.152.
 */
package yuma140902.uptodatemod.config;

import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import java.util.ArrayList;
import java.util.regex.Pattern;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import yuma140902.uptodatemod.ModUpToDateMod;
import yuma140902.uptodatemod.integration.IntegrationConfigs;
import yuma140902.uptodatemod.registry.DisabledFeaturesRegistry;
import yuma140902.uptodatemod.registry.EnumDisableableFeatures;
import yuma140902.yumalib.api.config.CategoryBuilder;
import yuma140902.yumalib.api.config.LangKey;
import yuma140902.yumalib.api.config.PropertyBuilder;

public class ModConfigCore {
    public static final String CATEGORY_GENERAL = "General";
    public static final String CATEGORY_WORLDGEN = ModConfigCore.getSubCategory("WorldGen");
    public static final String CATEGORY_RECIPE = ModConfigCore.getSubCategory("Recipe");
    public static final String CATEGORY_ENTITY = ModConfigCore.getSubCategory("Entity");
    public static final String CATEGORY_DISABLE_FEATURES = ModConfigCore.getSubCategory("DisableFeatures");
    public static final String CATEGORY_ALTERNATIVE = ModConfigCore.getSubCategory("Alternative");
    public static final String CATEGORY_DEPRECATED = "Deprecated";
    public static final String CONFIG_PROP_LANGKEY = "config.uptodate.prop.";
    public static final String CONFIG_CATEGORY_LANGKEY = "config.uptodate.category.";
    public static Configuration cfg;
    private static final Logger logger;
    private static CategoryBuilder generalCategory;
    private static CategoryBuilder worldGenCategory;
    private static CategoryBuilder recipeCategory;
    private static CategoryBuilder entityCategory;
    private static CategoryBuilder disableFeaturesCategory;
    private static CategoryBuilder alternativeCategory;
    private static CategoryBuilder deprecatedCategory;

    public static void loadConfig(FMLPreInitializationEvent event) {
        cfg = new Configuration(event.getSuggestedConfigurationFile(), "2.4.1", true);
        ModConfigCore.initConfig();
        ModConfigCore.syncConfig();
        ModConfigCore.wrapConfig();
    }

    private static void initConfig() {
        generalCategory = new CategoryBuilder(CATEGORY_GENERAL).langKey(ModConfigCore.getCategoryLangkey("general")).requireMcRestart().add(PropertyBuilder.bool("doUpdateChecking").defaultBool(General.doCheckUpdate).comment("If true, the mod will check for updates automatically", "\u30a2\u30c3\u30d7\u30c7\u30fc\u30c8\u3092\u81ea\u52d5\u3067\u78ba\u8a8d\u3059\u308b\u304b\u3069\u3046\u304b").langKey(ModConfigCore.getPropertyLangkey("do_check_update"))).add(PropertyBuilder.string("updateChannel").defaultString(General.updateChannel).validStrings(new String[]{"recommended", "latest"}).comment("Channel of updates checking", "\u30a2\u30c3\u30d7\u30c7\u30fc\u30c8\u306e\u30c1\u30e3\u30f3\u30cd\u30eb").langKey(ModConfigCore.getPropertyLangkey("update_channel"))).add(PropertyBuilder.bool("enableDebugMode").defaultBool(General.debugMode).comment("Enable debug mode", "\u30c7\u30d0\u30c3\u30b0\u30e2\u30fc\u30c9\u3002\u901a\u5e38\u306ffalse\u306b\u3059\u308b\u3053\u3068\u3092\u63a8\u5968").langKey(ModConfigCore.getPropertyLangkey("debug_mode"))).add(PropertyBuilder.bool("validateVanillaJar").defaultBool(General.validateVanillaJar).comment("Validate vanilla jar hash", "\u30d0\u30cb\u30e9\u306eJar\u30d5\u30a1\u30a4\u30eb\u306e\u30cf\u30c3\u30b7\u30e5\u5024\u3092\u78ba\u8a8d\u3059\u308b"));
        generalCategory.registerToForge(cfg);
        Pattern numberPattern = Pattern.compile("-?[0-9]+");
        worldGenCategory = new CategoryBuilder(CATEGORY_WORLDGEN).langKey(ModConfigCore.getCategoryLangkey("worldgen")).add(PropertyBuilder.bool("genStones").defaultBool(WorldGen.genStones).comment("Generate Granite, Diorite, Andesite in Overworld or not", "\u82b1\u5d17\u5ca9\u3001\u9583\u7dd1\u5ca9\u3001\u5b89\u5c71\u5ca9\u3092\u30ef\u30fc\u30eb\u30c9\u306b\u751f\u6210\u3059\u308b\u304b\u5426\u304b").langKey(ModConfigCore.getPropertyLangkey("generate_stones"))).add(PropertyBuilder.stringList("genStonesDimensionBlackList").defaultStringList(ModConfigCore.toStringList(WorldGen.stonesBlackList)).langKey(ModConfigCore.getPropertyLangkey("generate_stones_blacklist")).validationPattern(numberPattern)).add(PropertyBuilder.bool("genFossiles").defaultBool(WorldGen.genFossiles).comment("Generate fossiles in Overworld or not", "\u5316\u77f3\u3092\u751f\u6210\u3059\u308b\u304b\u5426\u304b").langKey(ModConfigCore.getPropertyLangkey("generate_fossiles"))).add(PropertyBuilder.stringList("genFossilesDimensionBlackList").defaultStringList(ModConfigCore.toStringList(WorldGen.fossilesBlackList)).langKey(ModConfigCore.getPropertyLangkey("generate_fossiles_blacklist")).validationPattern(numberPattern)).add(PropertyBuilder.bool("genCoarseDirt").defaultBool(WorldGen.genCoarseDirt).comment("Generate coarse dirt in Overworld or not", "\u7c97\u3044\u571f\u3092\u751f\u6210\u3059\u308b\u304b\u5426\u304b").langKey(ModConfigCore.getPropertyLangkey("generate_coarse_dirt"))).add(PropertyBuilder.stringList("genCoarseDirtDimensionBlackList").defaultStringList(ModConfigCore.toStringList(WorldGen.coarseDirtBlackList)).langKey(ModConfigCore.getPropertyLangkey("generate_coarse_dirt_blacklist")).validationPattern(numberPattern)).add(PropertyBuilder.bool("genMagmaBlock").defaultBool(WorldGen.genMagmaBlock).comment("Generate magma block or not", "\u30de\u30b0\u30de\u30d6\u30ed\u30c3\u30af\u3092\u751f\u6210\u3059\u308b\u304b\u5426\u304b").langKey(ModConfigCore.getPropertyLangkey("generate_magma_block"))).add(PropertyBuilder.integerList("genMagmaBlockDimensionBlackList").defaultIntList(WorldGen.magmaBlockBlackList).langKey(ModConfigCore.getPropertyLangkey("generate_magma_block_blacklist"))).add(PropertyBuilder.bool("genDeepslate").defaultBool(WorldGen.genDeepslate).comment("Generate Deepslate or not", "\u6df1\u5c64\u5ca9\u3092\u751f\u6210\u3059\u308b\u304b\u3069\u3046\u304b").langKey(ModConfigCore.getPropertyLangkey("generate_deepslate"))).add(PropertyBuilder.integerList("genDeepslateDimensionBlackList").defaultIntList(WorldGen.deepslateBlackList).langKey(ModConfigCore.getPropertyLangkey("generate_deepslate_blacklist")));
        worldGenCategory.registerToForge(cfg);
        recipeCategory = new CategoryBuilder(CATEGORY_RECIPE).langKey(ModConfigCore.getCategoryLangkey("recipe")).requireMcRestart().add(PropertyBuilder.bool("removeOldFenceRecipe").defaultBool(Recipe.removeOldFenceRecipe).comment("Delete the recipe of 2 fences from 6 sticks", "\u68d26\u672c\u304b\u3089\u30d5\u30a7\u30f3\u30b92\u500b\u3092\u4f5c\u308b\u30ec\u30b7\u30d4\u3092\u524a\u9664\u3059\u308b\u304b\u3069\u3046\u304b(\u6728\u67504\u3064\u3068\u68d22\u672c\u304b\u3089\u30d5\u30a7\u30f3\u30b9\u3092\u4f5c\u308b\u30ec\u30b7\u30d4\u306f\u3001\u3053\u306e\u8a2d\u5b9a\u306b\u95a2\u308f\u3089\u305a\u5e38\u306b\u8ffd\u52a0\u3055\u308c\u307e\u3059)").langKey(ModConfigCore.getPropertyLangkey("remove_old_fence_recipe"))).add(PropertyBuilder.bool("useOldSmoothStoneSlabRecipe").defaultBool(Recipe.useOldSmoothStoneSlabRecipe).comment("If set to true, old smooth stone slab recipe will be kept", "\u53e4\u3044\u77f3\u30cf\u30fc\u30d5\u30d6\u30ed\u30c3\u30af\u306e\u30ec\u30b7\u30d4\u3092\u4f7f\u3046\u304b\u3069\u3046\u304b").langKey(ModConfigCore.getPropertyLangkey("use_old_smooth_stone_slab_recipe")));
        recipeCategory.registerToForge(cfg);
        entityCategory = new CategoryBuilder(CATEGORY_ENTITY).langKey(ModConfigCore.getCategoryLangkey("entity")).requireMcRestart().add(PropertyBuilder.bool("boatCrashWhenCollide").defaultBool(Entity.boatCrashWhenCollide).comment("Boat added by this mod will crash when collision", "\u3053\u306eMOD\u304c\u8ffd\u52a0\u3059\u308b\u30dc\u30fc\u30c8\u304c\u3001\u885d\u7a81\u6642\u306b\u58ca\u308c\u308b\u304b\u3069\u3046\u304b(\u30d0\u30cb\u30e9\u306e\u30dc\u30fc\u30c8\u306f\u885d\u7a81\u6642\u306b\u58ca\u308c\u308b)").langKey(ModConfigCore.getPropertyLangkey("boat_crash_when_collide")));
        entityCategory.registerToForge(cfg);
        disableFeaturesCategory = new CategoryBuilder(CATEGORY_DISABLE_FEATURES).langKey(ModConfigCore.getCategoryLangkey("disable_features")).requireMcRestart();
        disableFeaturesCategory.registerToForge(cfg);
        alternativeCategory = new CategoryBuilder(CATEGORY_ALTERNATIVE).langKey(ModConfigCore.getCategoryLangkey("alternative")).add(PropertyBuilder.bool("altPrismarine").defaultBool(Alternative.altPrismarine).comment("Make squid drop prismarine stuff", "\u30a4\u30ab\u304c\u30d7\u30ea\u30ba\u30de\u30ea\u30f3\u7cfb\u306e\u30a2\u30a4\u30c6\u30e0\u3092\u30c9\u30ed\u30c3\u30d7\u3059\u308b\u3088\u3046\u306b\u306a\u308b").langKey(ModConfigCore.getPropertyLangkey("alt_prismarine")).requireMcRestart()).add(PropertyBuilder.bool("altPurpur").defaultBool(Alternative.altPurpur).comment("Make enderman drop purpur stuff", "\u30a8\u30f3\u30c0\u30fc\u30de\u30f3\u304c\u30d7\u30eb\u30d7\u30a1\u7cfb\u306e\u30a2\u30a4\u30c6\u30e0\u3092\u30c9\u30ed\u30c3\u30d7\u3059\u308b\u3088\u3046\u306b\u306a\u308b").langKey(ModConfigCore.getPropertyLangkey("alt_purpur")).requireMcRestart());
        alternativeCategory.registerToForge(cfg);
        deprecatedCategory = new CategoryBuilder(CATEGORY_DEPRECATED).comment("You do not have to change the configurations in Deprecated section.").requireMcRestart();
        deprecatedCategory.registerToForge(cfg);
        IntegrationConfigs.initConfig(cfg);
    }

    public static void syncConfig() {
        ModUpToDateMod.LOGGER.info("Loading config");
        generalCategory.registerPropertiesToForge(cfg);
        General.doCheckUpdate = ModConfigCore.generalCategory.get("doUpdateChecking", ModConfigCore.cfg).getBoolean();
        General.updateChannel = ModConfigCore.generalCategory.get("updateChannel", ModConfigCore.cfg).getString();
        General.debugMode = ModConfigCore.generalCategory.get("enableDebugMode", ModConfigCore.cfg).getBoolean();
        General.validateVanillaJar = ModConfigCore.generalCategory.get("validateVanillaJar", ModConfigCore.cfg).getBoolean();
        worldGenCategory.registerPropertiesToForge(cfg);
        WorldGen.genStones = ModConfigCore.worldGenCategory.get("genStones", ModConfigCore.cfg).getBoolean();
        WorldGen.access$1202(ModConfigCore.toIntList(worldGenCategory.get("genStonesDimensionBlackList", cfg).getStringList()));
        WorldGen.genFossiles = ModConfigCore.worldGenCategory.get("genFossiles", ModConfigCore.cfg).getBoolean();
        WorldGen.access$1002(ModConfigCore.toIntList(worldGenCategory.get("genFossilesDimensionBlackList", cfg).getStringList()));
        WorldGen.genCoarseDirt = ModConfigCore.worldGenCategory.get("genCoarseDirt", ModConfigCore.cfg).getBoolean();
        WorldGen.access$802(ModConfigCore.toIntList(worldGenCategory.get("genCoarseDirtDimensionBlackList", cfg).getStringList()));
        WorldGen.genMagmaBlock = ModConfigCore.worldGenCategory.get("genMagmaBlock", ModConfigCore.cfg).getBoolean();
        WorldGen.access$602(worldGenCategory.get("genMagmaBlockDimensionBlackList", cfg).getIntList());
        WorldGen.genDeepslate = ModConfigCore.worldGenCategory.get("genDeepslate", ModConfigCore.cfg).getBoolean();
        WorldGen.access$402(worldGenCategory.get("genDeepslateDimensionBlackList", cfg).getIntList());
        recipeCategory.registerPropertiesToForge(cfg);
        Recipe.removeOldFenceRecipe = ModConfigCore.recipeCategory.get("removeOldFenceRecipe", ModConfigCore.cfg).getBoolean();
        cfg.getCategory(CATEGORY_RECIPE).remove((Object)"addStoneSlabRecipe");
        Recipe.useOldSmoothStoneSlabRecipe = ModConfigCore.recipeCategory.get("useOldSmoothStoneSlabRecipe", ModConfigCore.cfg).getBoolean();
        entityCategory.registerPropertiesToForge(cfg);
        Entity.boatCrashWhenCollide = ModConfigCore.entityCategory.get("boatCrashWhenCollide", ModConfigCore.cfg).getBoolean();
        ModConfigCore.syncDisableableFeaturesConfig(cfg);
        alternativeCategory.registerPropertiesToForge(cfg);
        Alternative.altPrismarine = ModConfigCore.alternativeCategory.get("altPrismarine", ModConfigCore.cfg).getBoolean();
        Alternative.altPurpur = ModConfigCore.alternativeCategory.get("altPurpur", ModConfigCore.cfg).getBoolean();
        cfg.removeCategory(cfg.getCategory(ModConfigCore.getSubCategory("Experimental")));
        deprecatedCategory.registerPropertiesToForge(cfg);
        Deprecated.idBoatAcacia = ModConfigCore.cfg.getInt("idBoatAcacia", CATEGORY_DEPRECATED, Deprecated.idBoatAcacia, 0, Integer.MAX_VALUE, "Entity ID for Acacia Boat");
        Deprecated.idBoatBirch = ModConfigCore.cfg.getInt("idBoatBirch", CATEGORY_DEPRECATED, Deprecated.idBoatBirch, 0, Integer.MAX_VALUE, "Entity ID for Birch Boat");
        Deprecated.idBoatDarkOak = ModConfigCore.cfg.getInt("idBoatDarkOak", CATEGORY_DEPRECATED, Deprecated.idBoatDarkOak, 0, Integer.MAX_VALUE, "Entity ID for Dark Oak Boat");
        Deprecated.idBoatJungle = ModConfigCore.cfg.getInt("idBoatJungle", CATEGORY_DEPRECATED, Deprecated.idBoatJungle, 0, Integer.MAX_VALUE, "Entity ID for Jungle Boat");
        Deprecated.idBoatSpruce = ModConfigCore.cfg.getInt("idBoatSpruce", CATEGORY_DEPRECATED, Deprecated.idBoatSpruce, 0, Integer.MAX_VALUE, "Entity ID for Spruce Boat");
        Deprecated.idArmorStand = ModConfigCore.cfg.getInt("idArmorStand", CATEGORY_DEPRECATED, Deprecated.idArmorStand, 0, Integer.MAX_VALUE, "Entity ID for Armorstand");
        IntegrationConfigs.syncConfig(cfg);
        cfg.save();
    }

    private static void syncDisableableFeaturesConfig(Configuration cfg) {
        logger.info("== Features Status ==");
        ArrayList<String> orderedPropNameList = new ArrayList<String>();
        for (EnumDisableableFeatures feature : EnumDisableableFeatures.values()) {
            Property prop;
            String propName = "enable " + feature.toString();
            orderedPropNameList.add(propName);
            String comment = feature.getComment();
            Property property = prop = comment == null ? cfg.get(CATEGORY_DISABLE_FEATURES, propName, true) : cfg.get(CATEGORY_DISABLE_FEATURES, propName, true, comment);
            if (!prop.getBoolean()) {
                DisabledFeaturesRegistry.INSTANCE.setDisabled(feature);
            }
            logger.info(feature + " : " + (prop.getBoolean() ? "Enabled" : "Disabled"));
        }
        cfg.setCategoryPropertyOrder(CATEGORY_DISABLE_FEATURES, orderedPropNameList);
    }

    private static void wrapConfig() {
        IntegrationConfigs.wrapConfig(cfg);
    }

    private static int[] toIntList(String[] strList) {
        int[] list = new int[strList.length];
        int dstIdx = 0;
        for (int srcIdx = 0; srcIdx < strList.length; ++srcIdx) {
            try {
                list[dstIdx] = Integer.parseInt(strList[srcIdx]);
                ++dstIdx;
                continue;
            }
            catch (NumberFormatException e) {
                logger.warn("Config error: The value '" + strList[srcIdx] + "' cannot be parsed into integer.");
            }
        }
        return list;
    }

    private static String[] toStringList(int[] intList) {
        String[] strList = new String[intList.length];
        for (int i = 0; i < intList.length; ++i) {
            strList[i] = Integer.toString(intList[i]);
        }
        return strList;
    }

    public static String getSubCategory(String subCategory) {
        return "General." + subCategory;
    }

    public static LangKey getCategoryLangkey(String key) {
        return LangKey.of(CONFIG_CATEGORY_LANGKEY + key);
    }

    public static LangKey getPropertyLangkey(String key) {
        return LangKey.of(CONFIG_PROP_LANGKEY + key);
    }

    static {
        logger = LogManager.getLogger((String)"UpToDateMod-Config");
    }

    public static class Deprecated {
        private static int idBoatAcacia = 0;
        private static int idBoatBirch = 1;
        private static int idBoatDarkOak = 2;
        private static int idBoatJungle = 3;
        private static int idBoatSpruce = 4;
        private static int idArmorStand = 5;

        public static int idBoatAcacia() {
            return idBoatAcacia;
        }

        public static int idBoatBirch() {
            return idBoatBirch;
        }

        public static int idBoatDarkOak() {
            return idBoatDarkOak;
        }

        public static int idBoatJungle() {
            return idBoatJungle;
        }

        public static int idBoatSpruce() {
            return idBoatSpruce;
        }

        public static int idArmorStand() {
            return idArmorStand;
        }
    }

    public static class Alternative {
        private static boolean altPrismarine = false;
        private static boolean altPurpur = false;

        public static boolean altPrismarine() {
            return altPrismarine;
        }

        public static boolean altPurpur() {
            return altPurpur;
        }
    }

    public static class Entity {
        private static boolean boatCrashWhenCollide = false;

        public static boolean boatCrashWhenCollide() {
            return boatCrashWhenCollide;
        }
    }

    public static class Recipe {
        private static boolean removeOldFenceRecipe = false;
        private static boolean useOldSmoothStoneSlabRecipe = false;

        public static boolean removeOldFenceRecipe() {
            return removeOldFenceRecipe;
        }

        public static boolean useOldSmoothStoneSlabRecipe() {
            return useOldSmoothStoneSlabRecipe;
        }
    }

    public static class WorldGen {
        private static boolean genStones = true;
        private static int[] stonesBlackList = new int[]{1, -1};
        private static boolean genFossiles = true;
        private static int[] fossilesBlackList = new int[]{1, -1};
        private static boolean genCoarseDirt = true;
        private static int[] coarseDirtBlackList = new int[]{1, -1};
        private static boolean genMagmaBlock = true;
        private static int[] magmaBlockBlackList = new int[]{0, 1};
        private static boolean genDeepslate = true;
        private static int[] deepslateBlackList = new int[]{1, -1};

        public static boolean genStones() {
            return genStones;
        }

        public static int[] stonesBlackList() {
            return stonesBlackList;
        }

        public static boolean genFossiles() {
            return genFossiles;
        }

        public static int[] fossilesBlackList() {
            return fossilesBlackList;
        }

        public static boolean genCoarseDirt() {
            return genCoarseDirt;
        }

        public static int[] coarseDirtBlackList() {
            return coarseDirtBlackList;
        }

        public static boolean genMagmaBlock() {
            return genMagmaBlock;
        }

        public static int[] magmaBlockBlackList() {
            return magmaBlockBlackList;
        }

        public static boolean genDeepslate() {
            return genDeepslate;
        }

        public static int[] deepslateBlackList() {
            return deepslateBlackList;
        }

        static /* synthetic */ int[] access$1202(int[] x0) {
            stonesBlackList = x0;
            return x0;
        }

        static /* synthetic */ int[] access$1002(int[] x0) {
            fossilesBlackList = x0;
            return x0;
        }

        static /* synthetic */ int[] access$802(int[] x0) {
            coarseDirtBlackList = x0;
            return x0;
        }

        static /* synthetic */ int[] access$602(int[] x0) {
            magmaBlockBlackList = x0;
            return x0;
        }

        static /* synthetic */ int[] access$402(int[] x0) {
            deepslateBlackList = x0;
            return x0;
        }
    }

    public static class General {
        private static boolean doCheckUpdate = true;
        private static String updateChannel = "recommended";
        private static boolean debugMode = false;
        private static boolean validateVanillaJar = true;

        public static boolean doCheckUpdate() {
            return doCheckUpdate;
        }

        public static String updateChannel() {
            return updateChannel;
        }

        public static boolean debugMode() {
            return debugMode;
        }

        public static boolean validateVanillaJar() {
            return validateVanillaJar;
        }
    }
}

