/*
 * Decompiled with CFR 0.152.
 */
package yuma140902.uptodatemod.blocks;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import yuma140902.uptodatemod.MyBlocks;
import yuma140902.uptodatemod.MyItems;
import yuma140902.uptodatemod.registry.RecipeRegister;
import yuma140902.uptodatemod.util.StringUtil;
import yuma140902.yumalib.api.IHasRecipes;
import yuma140902.yumalib.api.IRegisterable;

public class BlockWitherRose
extends BlockBush
implements IRegisterable,
IHasRecipes {
    public BlockWitherRose() {
        super(Material.field_151585_k);
        this.func_149672_a(field_149779_h);
        float f = 0.2f;
        this.func_149676_a(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, f * 3.0f, 0.5f + f);
        this.func_149647_a(CreativeTabs.field_78031_c);
    }

    @Override
    public void register() {
        this.func_149663_c(StringUtil.name.domainedUnlocalized("wither_rose"));
        this.func_149658_d(StringUtil.name.domainedTexture("wither_rose"));
        GameRegistry.registerBlock((Block)this, ItemBlock.class, (String)"wither_rose");
    }

    @Override
    public void registerRecipes() {
        RecipeRegister.addShapeless(new ItemStack((Item)MyItems.dye, 1, 2), this);
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return BlockWitherRose.canPlace(world, x, y, z);
    }

    protected boolean func_149854_a(Block block) {
        return true;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        this.func_149855_e(world, x, y, z);
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        this.func_149855_e(world, x, y, z);
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        return BlockWitherRose.canPlace(world, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        double posX = (double)x + 0.5 + (rand.nextDouble() - 0.5) * 0.5;
        double posY = (double)y + 0.6 + (rand.nextDouble() - 0.5) * 0.5;
        double posZ = (double)z + 0.5 + (rand.nextDouble() - 0.5) * 0.5;
        double velX = 0.0;
        double velY = rand.nextDouble() * 0.05;
        double velZ = 0.0;
        world.func_72869_a("smoke", posX, posY, posZ, velX, velY, velZ);
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        EntityLivingBase entityLiving;
        if (entity instanceof EntityLivingBase && !this.hasWitherEffect((entityLiving = (EntityLivingBase)entity).func_70651_bq())) {
            entityLiving.func_70690_d(new PotionEffect(Potion.field_82731_v.field_76415_H, 60, 0, true));
        }
    }

    private boolean hasWitherEffect(Collection potionEffects) {
        for (Object obj : potionEffects) {
            PotionEffect effect;
            if (!(obj instanceof PotionEffect) || (effect = (PotionEffect)obj).func_76456_a() != Potion.field_82731_v.field_76415_H) continue;
            return true;
        }
        return false;
    }

    public static void onLivingDeathEvent(LivingDeathEvent event) {
        if (event == null || event.entityLiving == null) {
            return;
        }
        PotionEffect potionEffect = event.entityLiving.func_70660_b(Potion.field_82731_v);
        if (potionEffect == null || potionEffect.func_76458_c() <= 0) {
            return;
        }
        EntityLivingBase entityLiving = event.entityLiving;
        int posX = (int)entityLiving.field_70165_t;
        int posY = (int)entityLiving.field_70163_u;
        int posZ = (int)entityLiving.field_70161_v;
        World world = entityLiving.field_70170_p;
        int[] aroundX = new int[]{0, 1, -1, 0, 0, 1, -1, 1, -1};
        int[] aroundZ = new int[]{0, 0, 0, 1, -1, 1, 1, -1, -1};
        int[] aroundY = new int[]{0, 1, -1};
        for (int i = 0; i < aroundX.length; ++i) {
            int x = posX + aroundX[i];
            int z = posZ + aroundZ[i];
            for (int j = 0; j < aroundY.length; ++j) {
                int y = posY + aroundY[j];
                if (!world.func_147437_c(x, y, z) || !BlockWitherRose.canPlace(world, x, y, z)) continue;
                world.func_147449_b(x, y, z, (Block)MyBlocks.witherRose);
                return;
            }
        }
        if (!world.field_72995_K) {
            entityLiving.func_145779_a(Item.func_150898_a((Block)MyBlocks.witherRose), 1);
        }
    }

    private static boolean canPlace(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y - 1, z);
        return block.isSideSolid((IBlockAccess)world, x, y - 1, z, ForgeDirection.UP) || block == Blocks.field_150458_ak || block == Blocks.field_150457_bL || block == MyBlocks.unlimitedPot;
    }

    public static class ItemBlock
    extends net.minecraft.item.ItemBlock {
        public ItemBlock(Block block) {
            super(block);
        }

        public boolean func_77648_a(ItemStack itemstack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
            boolean success = MyBlocks.unlimitedPot.putItemIn(itemstack, player, world, x, y, z);
            if (success) {
                return true;
            }
            return super.func_77648_a(itemstack, player, world, x, y, z, side, hitX, hitY, hitZ);
        }
    }
}

