/*
 * Decompiled with CFR 0.152.
 */
package yuma140902.uptodatemod.blocks;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import yuma140902.uptodatemod.MyBlocks;
import yuma140902.uptodatemod.registry.RecipeRegister;
import yuma140902.uptodatemod.util.StringUtil;
import yuma140902.yumalib.api.IHasRecipes;
import yuma140902.yumalib.api.IRegisterable;
import yuma140902.yumalib.api.items.ItemBlockMultiName;
import yuma140902.yumalib.api.util.BlockPos;

public class BlockSponge
extends Block
implements IRegisterable,
IHasRecipes {
    public static final Material spongeMaterial = new Material(MapColor.field_151673_t);
    private static final String[] names = new String[]{"", "wet"};
    public static final int META_DRY = 0;
    public static final int META_WET = 1;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;

    public BlockSponge() {
        super(spongeMaterial);
        this.func_149711_c(0.6f);
        this.func_149752_b(0.6f);
        this.func_149672_a(field_149779_h);
        this.func_149647_a(CreativeTabs.field_78030_b);
        this.setHarvestLevel("axe", 0);
    }

    @Override
    public void register() {
        this.func_149663_c(StringUtil.name.domainedUnlocalized("sponge"));
        GameRegistry.registerBlock((Block)this, Companion.class, (String)"sponge");
    }

    @Override
    public void registerRecipes() {
        RecipeRegister.addSmelting(new ItemStack((Block)this, 1, 1), new ItemStack((Block)this, 1, 0), 0.1f);
    }

    public void func_149651_a(IIconRegister register) {
        this.icons = new IIcon[2];
        this.icons[0] = register.func_94245_a(StringUtil.name.domainedTexture("sponge"));
        this.icons[1] = register.func_94245_a(StringUtil.name.domainedTexture("wet_sponge"));
    }

    public IIcon func_149691_a(int side, int meta) {
        return this.icons[meta % 2];
    }

    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        list.add(new ItemStack((Block)this, 1, 0));
        list.add(new ItemStack((Block)this, 1, 1));
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        if (world.func_72805_g(x, y, z) == 1) {
            double posX = (double)x + 0.5 + (rand.nextDouble() - 0.5) * 1.0;
            double posY = (double)y + 0.3 + (rand.nextDouble() - 0.5) * 1.0;
            double posZ = (double)z + 0.5 + (rand.nextDouble() - 0.5) * 1.0;
            double velX = 0.0;
            double velY = -rand.nextDouble() * 0.05;
            double velZ = 0.0;
            world.func_72869_a("dripWater", posX, posY, posZ, velX, velY, velZ);
        }
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        BlockSponge.tryAbsorb(world, x, y, z, world.func_72805_g(x, y, z));
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        int meta = world.func_72805_g(x, y, z);
        if (meta == 1 && world.field_73011_w.field_76574_g == -1) {
            world.func_72921_c(x, y, z, 0, 3);
            Random rand = world.field_73012_v;
            world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.fizz", 1.1f, 2.6f + (rand.nextFloat() - rand.nextFloat()) * 0.8f);
            for (int i = 0; i < rand.nextInt(10) + 5; ++i) {
                double posX = (double)x + 0.5 + (rand.nextDouble() - 0.5) * 0.5;
                double posY = (double)y + 1.0 + (rand.nextDouble() - 0.5) * 0.2;
                double posZ = (double)z + 0.5 + (rand.nextDouble() - 0.5) * 0.5;
                double velY = rand.nextDouble() * 0.05;
                world.func_72869_a("cloud", posX, posY, posZ, 0.0, velY, 0.0);
            }
        } else {
            BlockSponge.tryAbsorb(world, x, y, z, meta);
        }
    }

    private static int tryAbsorb(World world, int x, int y, int z, int meta) {
        boolean absorbed = meta == 0 ? BlockSponge.absorb(world, new BlockPos(x, y, z)) : true;
        return absorbed ? 1 : 0;
    }

    private static boolean absorb(World world, BlockPos pos) {
        LinkedList<ImmutablePair> queue = new LinkedList<ImmutablePair>();
        queue.add(new ImmutablePair((Object)pos, (Object)0));
        int blockRemoved = 0;
        while (!queue.isEmpty()) {
            Pair tuple = (Pair)queue.poll();
            BlockPos blockPosOrig = (BlockPos)tuple.getLeft();
            int distanceFromSponge = (Integer)tuple.getRight();
            for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                BlockPos blockpos = blockPosOrig.offset(direction);
                Block block = world.func_147439_a(blockpos.x(), blockpos.y(), blockpos.z());
                if (block != Blocks.field_150355_j && block != Blocks.field_150358_i) continue;
                world.func_147465_d(blockpos.x(), blockpos.y(), blockpos.z(), Blocks.field_150350_a, 0, 3);
                ++blockRemoved;
                if (distanceFromSponge >= 6) continue;
                queue.add(new ImmutablePair((Object)blockpos, (Object)(distanceFromSponge + 1)));
            }
            if (blockRemoved <= 64) continue;
            break;
        }
        if (blockRemoved > 0) {
            world.func_147465_d(pos.x(), pos.y(), pos.z(), (Block)MyBlocks.sponge, 1, 2);
        }
        return blockRemoved > 0;
    }

    public static class Companion
    extends ItemBlockMultiName {
        public Companion(Block block) {
            super(block, names);
        }
    }
}

