/*
 * Decompiled with CFR 0.152.
 */
package yuma140902.uptodatemod.blocks;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import yuma140902.uptodatemod.MyBlocks;
import yuma140902.uptodatemod.entity.item.EntityFallingConcretePowderBlock;
import yuma140902.uptodatemod.registry.RecipeRegister;
import yuma140902.uptodatemod.util.ColorUtil;
import yuma140902.uptodatemod.util.StringUtil;
import yuma140902.yumalib.api.IHasRecipes;
import yuma140902.yumalib.api.IRegisterable;
import yuma140902.yumalib.api.items.ItemBlockColored;

public class BlockConcretePowder
extends BlockFalling
implements IRegisterable,
IHasRecipes {
    public static final int META_MAX = 15;
    private IIcon[] iicons = new IIcon[16];
    public static boolean fallInstantly;

    public BlockConcretePowder() {
        super(Material.field_151595_p);
        this.func_149711_c(0.5f);
        this.func_149672_a(field_149776_m);
        this.func_149647_a(CreativeTabs.field_78030_b);
    }

    @Override
    public void register() {
        this.func_149663_c(StringUtil.name.domainedUnlocalized("concrete_powder"));
        GameRegistry.registerBlock((Block)this, ItemBlockColored.class, (String)"concrete_powder");
    }

    @Override
    public void registerRecipes() {
        Block gravel = Blocks.field_150351_n;
        for (int meta = 0; meta <= 15; ++meta) {
            RecipeRegister.addShapelessOre(new ItemStack((Block)this, 8, meta), "sand", "sand", "sand", "sand", gravel, gravel, gravel, gravel, "dye" + ColorUtil.metaToDyeName(meta));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        for (int meta = 0; meta <= 15; ++meta) {
            this.iicons[meta] = register.func_94245_a(StringUtil.name.domainedTexture("concrete_powder_" + ColorUtil.metaToString(meta)));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.iicons[meta % 16];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs creativeTab, List list) {
        for (int meta = 0; meta <= 15; ++meta) {
            list.add(new ItemStack(item, 1, meta));
        }
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    public MapColor func_149728_f(int meta) {
        return ColorUtil.metaToMapColor(meta);
    }

    public void func_149726_b(World world, int x, int y, int z) {
        this.tryReplaceToConcrete(world, x, y, z);
        world.func_147464_a(x, y, z, (Block)this, this.func_149738_a(world));
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighborBlock) {
        this.tryReplaceToConcrete(world, x, y, z);
        world.func_147464_a(x, y, z, (Block)this, this.func_149738_a(world));
    }

    private boolean tryReplaceToConcrete(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        Block[] aroundBlocks = new Block[]{world.func_147439_a(x + 1, y, z), world.func_147439_a(x - 1, y, z), world.func_147439_a(x, y + 1, z), world.func_147439_a(x, y, z + 1), world.func_147439_a(x, y, z - 1)};
        for (int i = 0; i < 5; ++i) {
            if (aroundBlocks[i].func_149688_o() != Material.field_151586_h) continue;
            world.func_147465_d(x, y, z, (Block)MyBlocks.concreteBlock, meta, 3);
            return true;
        }
        return false;
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        if (!world.field_72995_K) {
            this.dropBlockFrom(world, x, y, z);
        }
    }

    private void dropBlockFrom(World world, int x, int y, int z) {
        if (BlockConcretePowder.func_149831_e((World)world, (int)x, (int)(y - 1), (int)z) && y >= 0) {
            int range = 32;
            if (!fallInstantly && world.func_72904_c(x - range, y - range, z - range, x + range, y + range, z + range)) {
                if (!world.field_72995_K) {
                    double posX = (float)x + 0.5f;
                    double posY = (float)y + 0.5f;
                    double posZ = (float)z + 0.5f;
                    int meta = world.func_72805_g(x, y, z);
                    EntityFallingConcretePowderBlock entityfallingblock = new EntityFallingConcretePowderBlock(world, posX, posY, posZ, meta);
                    this.func_149829_a(entityfallingblock);
                    world.func_72838_d((Entity)entityfallingblock);
                }
            } else {
                world.func_147468_f(x, y, z);
                while (BlockConcretePowder.func_149831_e((World)world, (int)x, (int)(y - 1), (int)z) && y > 0) {
                    --y;
                }
                if (y > 0) {
                    world.func_147449_b(x, y, z, (Block)this);
                }
            }
        }
    }

    public static boolean shouldNotStopFalling(World world, int x, int y, int z) {
        Block blockUnder = world.func_147439_a(x, y, z);
        return blockUnder.isAir((IBlockAccess)world, x, y, z) || blockUnder == Blocks.field_150480_ab || blockUnder.func_149688_o() == Material.field_151587_i || blockUnder.func_149688_o() == Material.field_151586_h;
    }
}

