/*
 * Decompiled with CFR 0.152.
 */
package yuma140902.uptodatemod;

import cpw.mods.fml.common.registry.FMLControlledNamespacedRegistry;
import cpw.mods.fml.common.registry.GameData;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import yuma140902.uptodatemod.MyBlocks;
import yuma140902.uptodatemod.MyItems;
import yuma140902.uptodatemod.config.ModConfigCore;
import yuma140902.uptodatemod.registry.EnumDisableableFeatures;
import yuma140902.uptodatemod.registry.RecipeRegister;
import yuma140902.uptodatemod.util.ListUtils;
import yuma140902.yumalib.api.IHasRecipes;

public final class Recipes {
    public static final ItemStack PLANK_ACACIA = new ItemStack(Blocks.field_150344_f, 1, 4);
    public static final ItemStack PLANK_BIRCH = new ItemStack(Blocks.field_150344_f, 1, 2);
    public static final ItemStack PLANK_DARK_OAK = new ItemStack(Blocks.field_150344_f, 1, 5);
    public static final ItemStack PLANK_JUNGLE = new ItemStack(Blocks.field_150344_f, 1, 3);
    public static final ItemStack PLANK_SPRUCE = new ItemStack(Blocks.field_150344_f, 1, 1);
    public static final ItemStack PLANK_OAK = new ItemStack(Blocks.field_150344_f, 1, 0);

    private Recipes() {
    }

    public static void removeVanillaRecipes() {
        ArrayList<String> removeRecipesOutputNameList = new ArrayList<String>();
        if (EnumDisableableFeatures.doors.featureEnabled()) {
            removeRecipesOutputNameList.add("minecraft:wooden_door");
        }
        if (ModConfigCore.Recipe.removeOldFenceRecipe() || EnumDisableableFeatures.fences.featureEnabled()) {
            removeRecipesOutputNameList.add("minecraft:fence");
        }
        if (EnumDisableableFeatures.fenceGates.featureEnabled()) {
            removeRecipesOutputNameList.add("minecraft:fence_gate");
        }
        if (EnumDisableableFeatures.buttons.featureEnabled()) {
            removeRecipesOutputNameList.add("minecraft:wooden_button");
        }
        if (EnumDisableableFeatures.allKindsOfWalls.featureEnabled()) {
            removeRecipesOutputNameList.add("minecraft:nether_brick_fence");
        }
        Recipes.removeRecipesByOutputName(removeRecipesOutputNameList);
    }

    public static void removeRecipesByOutputName(List<String> outputNameList) {
        List recipes = CraftingManager.func_77594_a().func_77592_b();
        ArrayList<IRecipe> removeList = new ArrayList<IRecipe>();
        FMLControlledNamespacedRegistry itemRegistry = GameData.getItemRegistry();
        for (IRecipe recipe : recipes) {
            Item outputItem;
            String name;
            if (recipe == null || recipe.func_77571_b() == null || recipe.func_77571_b().func_77973_b() == null || !ListUtils.contains(outputNameList, name = itemRegistry.func_148750_c((Object)(outputItem = recipe.func_77571_b().func_77973_b())))) continue;
            removeList.add(recipe);
            outputNameList.remove(name);
        }
        for (IRecipe removeRecipe : removeList) {
            recipes.remove(removeRecipe);
        }
    }

    public static void replaceRecipe(Predicate<IRecipe> predicator, Runnable recipeAdder) {
        List recipes = CraftingManager.func_77594_a().func_77592_b();
        IRecipe recipeToRemove = null;
        for (IRecipe recipe : recipes) {
            if (!predicator.test(recipe)) continue;
            recipeToRemove = recipe;
            break;
        }
        if (recipeToRemove != null) {
            recipes.remove(recipeToRemove);
        }
        recipeAdder.run();
    }

    public static void register() {
        Iterator<Block> blocks = MyBlocks.iterator();
        while (blocks.hasNext()) {
            Block block = blocks.next();
            if (!(block instanceof IHasRecipes)) continue;
            ((IHasRecipes)block).registerRecipes();
        }
        Iterator<Item> items = MyItems.iterator();
        while (items.hasNext()) {
            Item item = items.next();
            if (!(item instanceof IHasRecipes)) continue;
            ((IHasRecipes)item).registerRecipes();
        }
        Recipes.registerDoorRecipes();
        Recipes.registerFenceRecipes();
        Recipes.registerFenceGateRecipes();
        Recipes.registerButtonRecipes();
        Recipes.registerStarisRecipes();
        Recipes.registerSlabRecipes();
        Recipes.registerWallRecipes();
        RecipeRegister.addSmelting(new ItemStack(Blocks.field_150417_aV, 1, 0), new ItemStack(Blocks.field_150417_aV, 1, 2), 0.3f);
        RecipeRegister.addShaped(new ItemStack(Blocks.field_150417_aV, 1, 3), "#", "#", Character.valueOf('#'), new ItemStack((Block)Blocks.field_150333_U, 1, 5));
        RecipeRegister.addShaped(new ItemStack((Block)MyBlocks.trapDoorIron, 1, 0), "##", "##", Character.valueOf('#'), Items.field_151042_j);
    }

    private static void registerDoorRecipes() {
        RecipeRegister.addShaped(new ItemStack(Items.field_151135_aq, 3, 0), "##", "##", "##", Character.valueOf('#'), PLANK_OAK);
    }

    private static void registerFenceRecipes() {
        RecipeRegister.addShapedOre(new ItemStack(Blocks.field_150422_aJ, 3, 0), "#|#", "#|#", Character.valueOf('#'), PLANK_OAK, Character.valueOf('|'), "stickWood");
        RecipeRegister.addShapedOre(new ItemStack((Block)MyBlocks.fenceAcacia, 3, 0), "#|#", "#|#", Character.valueOf('#'), PLANK_ACACIA, Character.valueOf('|'), "stickWood");
        RecipeRegister.addShapedOre(new ItemStack((Block)MyBlocks.fenceBirch, 3, 0), "#|#", "#|#", Character.valueOf('#'), PLANK_BIRCH, Character.valueOf('|'), "stickWood");
        RecipeRegister.addShapedOre(new ItemStack((Block)MyBlocks.fenceDarkOak, 3, 0), "#|#", "#|#", Character.valueOf('#'), PLANK_DARK_OAK, Character.valueOf('|'), "stickWood");
        RecipeRegister.addShapedOre(new ItemStack((Block)MyBlocks.fenceJungle, 3, 0), "#|#", "#|#", Character.valueOf('#'), PLANK_JUNGLE, Character.valueOf('|'), "stickWood");
        RecipeRegister.addShapedOre(new ItemStack((Block)MyBlocks.fenceSpruce, 3, 0), "#|#", "#|#", Character.valueOf('#'), PLANK_SPRUCE, Character.valueOf('|'), "stickWood");
    }

    private static void registerFenceGateRecipes() {
        RecipeRegister.addShapedOre(new ItemStack(Blocks.field_150396_be), "|#|", "|#|", Character.valueOf('#'), PLANK_OAK, Character.valueOf('|'), "stickWood");
        RecipeRegister.addShapedOre(new ItemStack((Block)MyBlocks.fenceGateAcacia), "|#|", "|#|", Character.valueOf('#'), PLANK_ACACIA, Character.valueOf('|'), "stickWood");
        RecipeRegister.addShapedOre(new ItemStack((Block)MyBlocks.fenceGateBirch), "|#|", "|#|", Character.valueOf('#'), PLANK_BIRCH, Character.valueOf('|'), "stickWood");
        RecipeRegister.addShapedOre(new ItemStack((Block)MyBlocks.fenceGateDarkOak), "|#|", "|#|", Character.valueOf('#'), PLANK_DARK_OAK, Character.valueOf('|'), "stickWood");
        RecipeRegister.addShapedOre(new ItemStack((Block)MyBlocks.fenceGateJungle), "|#|", "|#|", Character.valueOf('#'), PLANK_JUNGLE, Character.valueOf('|'), "stickWood");
        RecipeRegister.addShapedOre(new ItemStack((Block)MyBlocks.fenceGateSpruce), "|#|", "|#|", Character.valueOf('#'), PLANK_SPRUCE, Character.valueOf('|'), "stickWood");
    }

    private static void registerButtonRecipes() {
        RecipeRegister.addShapeless(new ItemStack(Blocks.field_150471_bO), PLANK_OAK);
    }

    private static void registerStarisRecipes() {
        RecipeRegister.addShapedOre(new ItemStack((Block)MyBlocks.stairsPolishedAndesite, 4), "  #", " ##", "###", Character.valueOf('#'), "stoneAndesitePolished");
        RecipeRegister.addShapedOre(new ItemStack((Block)MyBlocks.stairsPolishedDiorite, 4), "  #", " ##", "###", Character.valueOf('#'), "stoneDioritePolished");
        RecipeRegister.addShapedOre(new ItemStack((Block)MyBlocks.stairsPolishedGranite, 4), "  #", " ##", "###", Character.valueOf('#'), "stoneGranitePolished");
    }

    private static void registerSlabRecipes() {
        RecipeRegister.addShapedOre(new ItemStack((Block)MyBlocks.slabGranite, 6), "###", Character.valueOf('#'), "stoneGranite");
        RecipeRegister.addShapedOre(new ItemStack((Block)MyBlocks.slabDiorite, 6), "###", Character.valueOf('#'), "stoneDiorite");
        RecipeRegister.addShapedOre(new ItemStack((Block)MyBlocks.slabAndesite, 6), "###", Character.valueOf('#'), "stoneAndesite");
        RecipeRegister.addShapedOre(new ItemStack((Block)MyBlocks.slabPolishedGranite, 6), "###", Character.valueOf('#'), "stoneGranitePolished");
        RecipeRegister.addShapedOre(new ItemStack((Block)MyBlocks.slabPolishedDiorite, 6), "###", Character.valueOf('#'), "stoneDioritePolished");
        RecipeRegister.addShapedOre(new ItemStack((Block)MyBlocks.slabPolishedAndesite, 6), "###", Character.valueOf('#'), "stoneAndesitePolished");
        Recipes.replaceRecipe(recipe -> {
            ItemStack output = recipe.func_77571_b();
            if (output == null) {
                return false;
            }
            return output.field_77994_a == 6 && output.func_77960_j() == 1 && output.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150333_U);
        }, () -> RecipeRegister.addShaped(new ItemStack((Block)Blocks.field_150333_U, 6, 1), "###", Character.valueOf('#'), new ItemStack(Blocks.field_150322_A, 1, 0)));
    }

    private static void registerWallRecipes() {
        RecipeRegister.addShapedOre(new ItemStack((Block)MyBlocks.wallAndesite, 6), "###", "###", Character.valueOf('#'), "stoneAndesite");
        RecipeRegister.addShapedOre(new ItemStack((Block)MyBlocks.wallDiorite, 6), "###", "###", Character.valueOf('#'), "stoneDiorite");
        RecipeRegister.addShapedOre(new ItemStack((Block)MyBlocks.wallGranite, 6), "###", "###", Character.valueOf('#'), "stoneGranite");
        RecipeRegister.addShapedOre(new ItemStack(Blocks.field_150386_bk, 6), "#-#", "#-#", Character.valueOf('#'), Blocks.field_150385_bj, Character.valueOf('-'), "ingotBrickNether");
    }
}

