/*
 * Decompiled with CFR 0.152.
 */
package yuma140902.uptodatemod;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemFood;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import yuma140902.uptodatemod.MyBlocks;
import yuma140902.uptodatemod.MyGuis;
import yuma140902.uptodatemod.MyItems;
import yuma140902.uptodatemod.Recipes;
import yuma140902.uptodatemod.WorldGenerators;
import yuma140902.uptodatemod.config.ModConfigCore;
import yuma140902.uptodatemod.event_handlers.StripWoodHandler;
import yuma140902.uptodatemod.integration.Plugins;
import yuma140902.uptodatemod.loot.MobLoot;
import yuma140902.uptodatemod.network.ArmorStandInteractHandler;
import yuma140902.uptodatemod.network.ArmorStandInteractMessage;
import yuma140902.uptodatemod.network.NoteBlockPlayHandler;
import yuma140902.uptodatemod.network.NoteBlockPlayMessage;
import yuma140902.uptodatemod.proxy.CommonProxy;
import yuma140902.uptodatemod.registry.EnumDisableableFeatures;
import yuma140902.uptodatemod.util.StringUtil;
import yuma140902.uptodatemod.vrl.VRLException;
import yuma140902.uptodatemod.world.generation.MyMinableGenerator;
import yuma140902.yumalib.api.blocks.CustomSoundType;
import yuma140902.yumalib.api.context.InitModContext;
import yuma140902.yumalib.api.registry.Contexts;
import yuma140902.yumalib.api.registry.UpdateCheckerRegistry;
import yuma140902.yumalib.api.update.TsvUpdateChecker;

@Mod(modid="uptodate", name="UpToDateMod", version="2.4.1", useMetadata=true, guiFactory="yuma140902.uptodatemod.gui.ModConfigGuiFactory", dependencies="after:etfuturum;after:ProjectE;after:Thaumcraft;required-after:yumalib")
public class ModUpToDateMod {
    @Mod.Metadata(value="uptodate")
    public static ModMetadata modMetadata;
    @Mod.Instance(value="uptodate")
    public static ModUpToDateMod INSTANCE;
    @SidedProxy(modId="uptodate", clientSide="yuma140902.uptodatemod.proxy.ClientProxy", serverSide="yuma140902.uptodatemod.proxy.ServerProxy")
    public static CommonProxy proxy;
    public static SimpleNetworkWrapper networkWrapper;
    public static final String MOD_ID = "uptodate";
    public static final String MOD_NAME = "UpToDateMod";
    public static final String MOD_TEXTURE_DOMAIN = "uptodate";
    public static final String MOD_UNLOCALIZED_ENTRY_DOMAIN = "uptodate";
    public static final String MINECRAFT_VERSION = "1.7.10";
    public static final String MOD_VERSION = "2.4.1";
    public static final String MOD_VERSIONS_TSV_URL = "https://raw.githubusercontent.com/yuma140902/UpdateJSON_Forge/master/UpToDateModVersions.tsv";
    public static final Logger LOGGER;
    public Path uptodatemodDirectory;
    public static int glazedTerracottaRenderId;
    public static int lanternRenderId;
    public static int barrelRenderId;

    private void loadModMetadata(ModMetadata modMetadata) {
        modMetadata.modId = "uptodate";
        modMetadata.name = MOD_NAME;
        modMetadata.version = MOD_VERSION;
        modMetadata.authorList.add("yuma140902");
        modMetadata.description = "Adds new Minecraft 1.8.0+ features\n\nGerman translation by DariusDarkBum";
        modMetadata.url = "https://www.curseforge.com/minecraft/mc-mods/uptodatemod";
        modMetadata.autogenerated = false;
    }

    private void tweakVanilla() {
        Items.field_151135_aq.func_77625_d(64);
        Items.field_151139_aw.func_77625_d(64);
        BlockTrapDoor.disableValidation = true;
        Items.field_151072_bj.func_77664_n();
        Blocks.field_150447_bR.func_149647_a(CreativeTabs.field_78028_d);
        ModUpToDateMod.setFinalField(ItemFood.class, Items.field_151172_bF, 3, "healAmount", "field_77853_b");
        ModUpToDateMod.setFinalField(ItemFood.class, Items.field_151168_bH, 5, "healAmount", "field_77853_b");
        Blocks.field_150403_cj.setHarvestLevel("pickaxe", 0);
        Blocks.field_150468_ap.setHarvestLevel("axe", 0);
        Blocks.field_150440_ba.setHarvestLevel("axe", 0);
        Blocks.field_150424_aL.func_149672_a((Block.SoundType)new CustomSoundType("uptodate", "netherrack"));
    }

    private static void setFinalField(Class<?> clazz, Object that, Object newValue, String ... fieldNames) {
        try {
            Field field = ReflectionHelper.findField(clazz, (String[])fieldNames);
            field.setAccessible(true);
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            field.set(that, newValue);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to tweak a property.");
            e.printStackTrace();
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) throws VRLException {
        this.loadModMetadata(modMetadata);
        ModConfigCore.loadConfig(event);
        LOGGER.info("preInit");
        Contexts.setContext(new InitModContext(MOD_NAME, StringUtil.name));
        if (ModConfigCore.General.doCheckUpdate()) {
            TsvUpdateChecker updateChecker = new TsvUpdateChecker(MOD_NAME, "https://www.curseforge.com/minecraft/mc-mods/uptodatemod", MOD_VERSIONS_TSV_URL, MOD_VERSION, ModConfigCore.General.updateChannel());
            UpdateCheckerRegistry.INSTANCE.register(updateChecker);
        }
        this.uptodatemodDirectory = Paths.get("uptodatemod", new String[0]).toAbsolutePath();
        proxy.loadVanillaResources();
        this.tweakVanilla();
        MyBlocks.register();
        MyItems.register();
        proxy.registerTileEntities();
        MyGuis.register();
        MobLoot.registerBasicMobLoots();
        StripWoodHandler.registerBasicWoodStripping();
        networkWrapper = NetworkRegistry.INSTANCE.newSimpleChannel("uptodate");
        networkWrapper.registerMessage(ArmorStandInteractHandler.class, ArmorStandInteractMessage.class, 0, Side.SERVER);
        networkWrapper.registerMessage(NoteBlockPlayHandler.class, NoteBlockPlayMessage.class, 1, Side.CLIENT);
        Contexts.removeContext();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        LOGGER.info("init");
        Recipes.removeVanillaRecipes();
        Recipes.register();
        proxy.registerEntities();
        if (EnumDisableableFeatures.glazedTerracotta.featureEnabled()) {
            glazedTerracottaRenderId = proxy.getNewRenderId();
        }
        if (EnumDisableableFeatures.lantern.featureEnabled()) {
            lanternRenderId = proxy.getNewRenderId();
        }
        if (EnumDisableableFeatures.barrel.featureEnabled()) {
            barrelRenderId = proxy.getNewRenderId();
        }
        proxy.registerRenderers();
        if (EnumDisableableFeatures.stones.featureEnabled()) {
            MyMinableGenerator.Config stoneConfig = new MyMinableGenerator.Config(ModConfigCore.WorldGen.genStones(), 33, 10, 0, 80, ModConfigCore.WorldGen.stonesBlackList());
            WorldGenerators.myMinableGenerator.addOreGenerator(MyBlocks.stone, 1, stoneConfig);
            WorldGenerators.myMinableGenerator.addOreGenerator(MyBlocks.stone, 3, stoneConfig);
            WorldGenerators.myMinableGenerator.addOreGenerator(MyBlocks.stone, 5, stoneConfig);
        }
        if (EnumDisableableFeatures.magmaBlock.featureEnabled()) {
            MyMinableGenerator.Config magmaConfig = new MyMinableGenerator.Config(ModConfigCore.WorldGen.genMagmaBlock(), 33, 5, 0, 40, ModConfigCore.WorldGen.magmaBlockBlackList(), Blocks.field_150424_aL);
            WorldGenerators.myMinableGenerator.addOreGenerator(MyBlocks.magmaBlock, magmaConfig);
        }
        if (EnumDisableableFeatures.deepslateStone.featureEnabled()) {
            MyMinableGenerator.Config config = new MyMinableGenerator.Config(ModConfigCore.WorldGen.genDeepslate(), 60, 10, 0, 16, ModConfigCore.WorldGen.deepslateBlackList());
            WorldGenerators.myMinableGenerator.addOreGenerator((Block)MyBlocks.deepslate, config);
        }
        WorldGenerators.register();
        proxy.registerEventHandlers();
        Plugins.tweakMods();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        LOGGER.info("postInit");
        Plugins.tweakModsPost();
        Plugins.logPluginStats();
    }

    static {
        LOGGER = LogManager.getLogger((String)MOD_NAME);
    }
}

