/*
 * Decompiled with CFR 0.152.
 */
package de.eydamos.backpack.inventory.container;

import de.eydamos.backpack.inventory.ISaveableInventory;
import de.eydamos.backpack.inventory.InventoryCraftingGrid;
import de.eydamos.backpack.inventory.InventoryRecipes;
import de.eydamos.backpack.inventory.container.Boundaries;
import de.eydamos.backpack.inventory.container.ContainerAdvanced;
import de.eydamos.backpack.inventory.slot.SlotPhantom;
import de.eydamos.backpack.saves.BackpackSave;
import de.eydamos.backpack.saves.PlayerSave;
import de.eydamos.backpack.util.BackpackUtil;
import invtweaks.api.container.ChestContainer;
import invtweaks.api.container.ContainerSection;
import invtweaks.api.container.ContainerSectionCallback;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.world.World;

@ChestContainer
public class ContainerWorkbenchBackpack
extends ContainerAdvanced {
    protected InventoryRecipes recipes = null;
    protected InventoryCraftingGrid craftingGrid = null;
    public IInventory craftResult = new InventoryCraftResult();
    protected World worldObj;
    protected boolean intelligent = false;
    protected boolean saveMode = false;

    public ContainerWorkbenchBackpack(InventoryCraftingGrid craftingMatrix) {
        this.craftingGrid = craftingMatrix;
        this.craftingGrid.setEventHandler(this);
    }

    public ContainerWorkbenchBackpack(IInventory[] inventories, BackpackSave save) {
        super(inventories, save);
        this.worldObj = ((InventoryPlayer)inventories[0]).field_70458_d.field_70170_p;
        this.craftingGrid = (InventoryCraftingGrid)inventories[2];
        this.craftingGrid.setEventHandler(this);
        if (inventories[3] instanceof InventoryRecipes) {
            this.intelligent = true;
            this.recipes = (InventoryRecipes)inventories[3];
            this.recipes.setEventHandler(this);
        }
        this.func_75130_a((IInventory)this.craftingGrid);
    }

    @Override
    public ItemStack func_75144_a(int slotIndex, int mouseButton, int modifier, EntityPlayer player) {
        Slot slot;
        Slot slot2 = slot = slotIndex < 0 ? null : (Slot)this.field_75151_b.get(slotIndex);
        if (slot instanceof SlotPhantom) {
            if (slot.field_75224_c == this.recipes) {
                if (BackpackUtil.isServerSide(player.field_70170_p)) {
                    if (this.saveMode) {
                        this.saveMode = false;
                        if (this.func_75139_a(0).func_75211_c() != null) {
                            this.recipes.func_70299_a(slot.getSlotIndex(), this.func_75139_a(0).func_75211_c().func_77946_l());
                        }
                    } else {
                        this.recipes.loadRecipe(slot.getSlotIndex());
                    }
                }
            } else {
                this.slotPhantomClick(slot, mouseButton, modifier, player.field_71071_by.func_70445_o());
            }
            return null;
        }
        return super.func_75144_a(slotIndex, mouseButton, modifier, player);
    }

    public void func_75130_a(IInventory inventory) {
        if (inventory == this.craftingGrid || inventory == this.craftResult) {
            this.craftResult.func_70299_a(0, CraftingManager.func_77594_a().func_82787_a((InventoryCrafting)this.craftingGrid, this.worldObj));
        }
        this.func_75142_b();
    }

    public boolean func_94530_a(ItemStack itemStack, Slot slot) {
        return slot.field_75224_c != this.craftResult && super.func_94530_a(itemStack, slot);
    }

    @Override
    public void func_75134_a(EntityPlayer entityPlayer) {
        if (BackpackUtil.isServerSide(entityPlayer.field_70170_p) && this.backpackSave != null) {
            this.backpackSave.setManualSaving();
            if (this.inventory instanceof ISaveableInventory) {
                ((ISaveableInventory)this.inventory).writeToNBT(this.backpackSave);
            }
            if (this.craftingGrid instanceof ISaveableInventory) {
                this.craftingGrid.writeToNBT(this.backpackSave);
            }
            if (this.recipes instanceof ISaveableInventory) {
                this.recipes.writeToNBT(this.backpackSave);
            }
            this.backpackSave.save();
            new PlayerSave(entityPlayer).unsetPersonalBackpackOpen();
        }
        if (this.inventory != null) {
            this.inventory.func_70305_f();
        }
        super.func_75134_a(entityPlayer);
    }

    public void clearCraftMatrix() {
        for (int i = ((Integer)this.boundaries.get((Object)Boundaries.CRAFTING)).intValue(); i < (Integer)this.boundaries.get((Object)Boundaries.CRAFTING_END); ++i) {
            this.func_75141_a(i, null);
        }
    }

    public void setSaveMode() {
        Slot slot = this.func_75139_a(0);
        if (slot.func_75216_d()) {
            this.saveMode = true;
        }
    }

    public boolean isIntelligent() {
        return this.intelligent;
    }

    @Override
    @ContainerSectionCallback
    public Map<ContainerSection, List<Slot>> getContainerSections() {
        return super.getContainerSections();
    }
}

