/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common.network;

import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S3FPacketCustomPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.ServerConfigurationManager;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import org.millenaire.common.MLN;
import org.millenaire.common.MillVillager;
import org.millenaire.common.MillWorld;
import org.millenaire.common.Point;
import org.millenaire.common.TileEntityMillChest;
import org.millenaire.common.TileEntityPanel;
import org.millenaire.common.UserProfile;
import org.millenaire.common.building.Building;
import org.millenaire.common.core.MillCommonUtilities;
import org.millenaire.common.forge.Mill;
import org.millenaire.common.network.StreamReadWrite;

public class ServerSender {
    public static void createAndSendPacketToPlayer(DataOutput data, EntityPlayer player) {
        if (((EntityPlayerMP)player).field_71135_a == null) {
            MLN.printException(new MLN.MillenaireException("Trying to send packet to a player with null playerNetServerHandler"));
            return;
        }
        S3FPacketCustomPayload packet = ServerSender.createServerPacket(data);
        ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)packet);
    }

    public static S3FPacketCustomPayload createServerPacket(DataOutput data) {
        return new S3FPacketCustomPayload("millenaire", ((ByteBufOutputStream)data).buffer());
    }

    public static void displayControlledMilitaryGUI(EntityPlayer player, Building townHall) {
        townHall.sendBuildingPacket(player, false);
        townHall.sendBuildingPacket(player, false);
        MillWorld mw = Mill.getMillWorld(player.field_70170_p);
        for (Point p : townHall.getKnownVillages()) {
            Building b = mw.getBuilding(p);
            if (b == null) continue;
            b.sendBuildingPacket(player, false);
        }
        DataOutput data = ServerSender.getNewByteBufOutputStream();
        try {
            data.write(104);
            data.write(14);
            StreamReadWrite.writeNullablePoint(townHall.getPos(), data);
        }
        catch (IOException e) {
            MLN.printException(ServerSender.class + ": Error in displayControlledMilitaryGUI", e);
        }
        ServerSender.sendPacketToPlayer((Packet)ServerSender.createServerPacket(data), player);
    }

    public static void displayControlledProjectGUI(EntityPlayer player, Building townHall) {
        townHall.sendBuildingPacket(player, false);
        DataOutput data = ServerSender.getNewByteBufOutputStream();
        try {
            data.write(104);
            data.write(11);
            StreamReadWrite.writeNullablePoint(townHall.getPos(), data);
        }
        catch (IOException e) {
            MLN.printException(ServerSender.class + ": Error in displayControlledProjectGUI", e);
        }
        ServerSender.sendPacketToPlayer((Packet)ServerSender.createServerPacket(data), player);
    }

    public static void displayHireGUI(EntityPlayer player, MillVillager villager) {
        villager.getTownHall().sendBuildingPacket(player, false);
        DataOutput data = ServerSender.getNewByteBufOutputStream();
        try {
            data.write(104);
            data.write(12);
            data.writeLong(villager.villager_id);
        }
        catch (IOException e) {
            MLN.printException(ServerSender.class + ": Error in displayHireGUI", e);
        }
        ServerSender.sendPacketToPlayer((Packet)ServerSender.createServerPacket(data), player);
    }

    public static void displayMerchantTradeGUI(EntityPlayer player, MillVillager villager) {
        DataOutput data = ServerSender.getNewByteBufOutputStream();
        int[] ids = MillCommonUtilities.packLong(villager.villager_id);
        try {
            data.write(104);
            data.write(8);
            data.writeInt(ids[0]);
            data.writeInt(ids[1]);
        }
        catch (IOException e) {
            MLN.printException(ServerSender.class + ": Error in displayMerchantTradeGUI", e);
        }
        villager.getHouse().sendBuildingPacket(player, true);
        villager.getTownHall().sendBuildingPacket(player, true);
        ServerSender.sendPacketToPlayer((Packet)ServerSender.createServerPacket(data), player);
        player.openGui((Object)Mill.instance, 8, player.field_70170_p, ids[0], ids[1], 0);
    }

    public static void displayMillChest(EntityPlayer player, Point chestPos) {
        TileEntityMillChest chest = chestPos.getMillChest(player.field_70170_p);
        if (chest == null) {
            return;
        }
        MillWorld mw = Mill.getMillWorld(player.field_70170_p);
        if (chest.buildingPos != null) {
            Building building = mw.getBuilding(chest.buildingPos);
            if (building != null) {
                building.sendBuildingPacket(player, true);
            } else {
                chest.buildingPos = null;
                chest.sendUpdatePacket(player);
            }
        } else {
            chest.sendUpdatePacket(player);
        }
        DataOutput data = ServerSender.getNewByteBufOutputStream();
        try {
            data.write(104);
            data.write(1);
            StreamReadWrite.writeNullablePoint(chestPos, data);
            data.writeBoolean(chest.isLockedFor(player));
        }
        catch (IOException e) {
            MLN.printException(ServerSender.class + ": Error in displayMillChest", e);
        }
        ServerSender.sendPacketToPlayer((Packet)ServerSender.createServerPacket(data), player);
        player.openGui((Object)Mill.instance, 1, player.field_70170_p, chestPos.getiX(), chestPos.getiY(), chestPos.getiZ());
    }

    public static void displayNegationWandGUI(EntityPlayer player, Building townHall) {
        townHall.sendBuildingPacket(player, false);
        DataOutput data = ServerSender.getNewByteBufOutputStream();
        try {
            data.write(104);
            data.write(9);
            StreamReadWrite.writeNullablePoint(townHall.getPos(), data);
        }
        catch (IOException e) {
            MLN.printException(ServerSender.class + ": Error in displayNegationWandGUI", e);
        }
        ServerSender.sendPacketToPlayer((Packet)ServerSender.createServerPacket(data), player);
    }

    public static void displayNewBuildingProjectGUI(EntityPlayer player, Building townHall, Point pos) {
        townHall.sendBuildingPacket(player, false);
        DataOutput data = ServerSender.getNewByteBufOutputStream();
        try {
            data.write(104);
            data.write(10);
            StreamReadWrite.writeNullablePoint(townHall.getPos(), data);
            StreamReadWrite.writeNullablePoint(pos, data);
        }
        catch (IOException e) {
            MLN.printException(ServerSender.class + ": Error in displayNewBuildingProjectGUI", e);
        }
        ServerSender.sendPacketToPlayer((Packet)ServerSender.createServerPacket(data), player);
    }

    public static void displayNewVillageGUI(EntityPlayer player, Point pos) {
        DataOutput data = ServerSender.getNewByteBufOutputStream();
        try {
            data.write(104);
            data.write(13);
            StreamReadWrite.writeNullablePoint(pos, data);
        }
        catch (IOException e) {
            MLN.printException(ServerSender.class + ": Error in displayNewVillageGUI", e);
        }
        ServerSender.sendPacketToPlayer((Packet)ServerSender.createServerPacket(data), player);
    }

    public static void displayPanel(EntityPlayer player, Point signPos) {
        Building building;
        TileEntityPanel panel = signPos.getPanel(player.field_70170_p);
        if (panel == null) {
            return;
        }
        MillWorld mw = Mill.getMillWorld(player.field_70170_p);
        if (panel.buildingPos != null && (building = mw.getBuilding(panel.buildingPos)) != null) {
            building.sendBuildingPacket(player, true);
        }
        DataOutput data = ServerSender.getNewByteBufOutputStream();
        try {
            data.write(104);
            data.write(7);
            StreamReadWrite.writeNullablePoint(signPos, data);
        }
        catch (IOException e) {
            MLN.printException(ServerSender.class + ": Error in displayPanel", e);
        }
        ServerSender.sendPacketToPlayer((Packet)ServerSender.createServerPacket(data), player);
    }

    public static void displayQuestGUI(EntityPlayer player, MillVillager villager) {
        DataOutput data = ServerSender.getNewByteBufOutputStream();
        try {
            data.write(104);
            data.write(3);
            data.writeLong(villager.villager_id);
        }
        catch (IOException e) {
            MLN.printException(ServerSender.class + ": Error in displayQuestGUI", e);
        }
        ServerSender.sendPacketToPlayer((Packet)ServerSender.createServerPacket(data), player);
    }

    public static void displayVillageBookGUI(EntityPlayer player, Point p) {
        MillWorld mw = Mill.getMillWorld(player.field_70170_p);
        Building th = mw.getBuilding(p);
        if (th == null) {
            return;
        }
        th.sendBuildingPacket(player, true);
        DataOutput data = ServerSender.getNewByteBufOutputStream();
        try {
            data.write(104);
            data.write(5);
            StreamReadWrite.writeNullablePoint(p, data);
        }
        catch (IOException e) {
            MLN.printException(ServerSender.class + ": Error in displayQuestGUI", e);
        }
        ServerSender.sendPacketToPlayer((Packet)ServerSender.createServerPacket(data), player);
    }

    public static void displayVillageChiefGUI(EntityPlayer player, MillVillager chief) {
        if (chief.getTownHall() == null) {
            MLN.error(chief, "Needed to send chief's TH but TH is null.");
            return;
        }
        chief.getTownHall().sendBuildingPacket(player, false);
        MillWorld mw = Mill.getMillWorld(player.field_70170_p);
        for (Point p : chief.getTownHall().getKnownVillages()) {
            Building b = mw.getBuilding(p);
            if (b == null) continue;
            b.sendBuildingPacket(player, false);
        }
        DataOutput data = ServerSender.getNewByteBufOutputStream();
        try {
            data.write(104);
            data.write(4);
            data.writeLong(chief.villager_id);
        }
        catch (IOException e) {
            MLN.printException(ServerSender.class + ": Error in displayVillageChiefGUI", e);
        }
        ServerSender.sendPacketToPlayer((Packet)ServerSender.createServerPacket(data), player);
    }

    public static void displayVillageTradeGUI(EntityPlayer player, Building building) {
        building.computeShopGoods(player);
        building.sendShopPacket(player);
        building.sendBuildingPacket(player, true);
        if (!building.isTownhall) {
            building.getTownHall().sendBuildingPacket(player, false);
        }
        DataOutput data = ServerSender.getNewByteBufOutputStream();
        try {
            data.write(104);
            data.write(2);
            StreamReadWrite.writeNullablePoint(building.getPos(), data);
        }
        catch (IOException e) {
            MLN.printException(ServerSender.class + ": Error in displayVillageTradeGUI", e);
        }
        ServerSender.sendPacketToPlayer((Packet)ServerSender.createServerPacket(data), player);
        player.openGui((Object)Mill.instance, 2, player.field_70170_p, building.getPos().getiX(), building.getPos().getiY(), building.getPos().getiZ());
    }

    public static DataOutput getNewByteBufOutputStream() {
        ByteBufOutputStream data = new ByteBufOutputStream(Unpooled.buffer());
        return data;
    }

    public static void sendAnimalBreeding(EntityAnimal animal) {
        DataOutput data = ServerSender.getNewByteBufOutputStream();
        Point pos = new Point((Entity)animal);
        try {
            data.write(107);
            StreamReadWrite.writeNullablePoint(pos, data);
            data.writeInt(animal.func_145782_y());
        }
        catch (IOException e) {
            MLN.printException(animal + ": Error in sendAnimalBreeding", e);
        }
        S3FPacketCustomPayload packet = ServerSender.createServerPacket(data);
        ServerSender.sendPacketToPlayersInRange((Packet)packet, pos, 50);
    }

    public static void sendChat(EntityPlayer player, EnumChatFormatting colour, String s) {
        ChatComponentText chat = new ChatComponentText(s);
        chat.func_150256_b().func_150238_a(colour);
        player.func_145747_a((IChatComponent)chat);
    }

    public static void sendLockedChestUpdatePacket(TileEntityMillChest chest, EntityPlayer player) {
        DataOutput data = ServerSender.getNewByteBufOutputStream();
        Point pos = new Point(chest.field_145851_c, chest.field_145848_d, chest.field_145849_e);
        try {
            data.write(5);
            StreamReadWrite.writeNullablePoint(pos, data);
            StreamReadWrite.writeNullablePoint(chest.buildingPos, data);
            data.writeBoolean(MLN.DEV);
            data.writeByte(chest.func_70302_i_());
            for (int i = 0; i < chest.func_70302_i_(); ++i) {
                StreamReadWrite.writeNullableItemStack(chest.func_70301_a(i), data);
            }
        }
        catch (IOException e) {
            MLN.printException((Object)((Object)chest) + ": Error in sendUpdatePacket", e);
        }
        ServerSender.sendPacketToPlayer((Packet)ServerSender.createServerPacket(data), player);
    }

    public static void sendPacketToPlayer(Packet packet, EntityPlayer player) {
        ((EntityPlayerMP)player).field_71135_a.func_147359_a(packet);
    }

    public static void sendPacketToPlayersInRange(DataOutput data, Point p, int range) {
        ServerSender.sendPacketToPlayersInRange((Packet)ServerSender.createServerPacket(data), p, range);
    }

    public static void sendPacketToPlayersInRange(Packet packet, Point p, int range) {
        MinecraftServer server = MinecraftServer.func_71276_C();
        if (server == null) {
            MLN.error(null, "Wanted to send a packet in sendPacketToPlayersInRange but server is null.");
            return;
        }
        ServerConfigurationManager config = server.func_71203_ab();
        config.func_148541_a(p.x, p.y, p.z, (double)range, 0, packet);
    }

    public static void sendTranslatedSentence(EntityPlayer player, char colour, String code, String ... values) {
        if (player == null) {
            return;
        }
        if (!(player instanceof EntityPlayerMP)) {
            return;
        }
        DataOutput data = ServerSender.getNewByteBufOutputStream();
        try {
            data.write(100);
            data.writeChar(colour);
            data.writeUTF(code);
            data.write(values.length);
            for (String value : values) {
                StreamReadWrite.writeNullableString(value, data);
            }
        }
        catch (IOException e) {
            MLN.printException(ServerSender.class + ": Error in sendTranslatedSentence", e);
        }
        ServerSender.sendPacketToPlayer((Packet)ServerSender.createServerPacket(data), player);
    }

    public static void sendTranslatedSentenceInRange(World world, Point p, int range, char colour, String key, String ... values) {
        for (Object oplayer : world.field_73010_i) {
            EntityPlayer player = (EntityPlayer)oplayer;
            if (!(p.distanceTo((Entity)player) < (double)range)) continue;
            ServerSender.sendTranslatedSentence(player, colour, key, values);
        }
    }

    public static void sendVillagerSentence(EntityPlayer player, MillVillager v) {
        if (player == null) {
            return;
        }
        if (!(player instanceof EntityPlayerMP)) {
            return;
        }
        DataOutput data = ServerSender.getNewByteBufOutputStream();
        try {
            data.write(108);
            data.writeLong(v.villager_id);
        }
        catch (IOException e) {
            MLN.printException(ServerSender.class + ": Error in sendVillagerSentence", e);
        }
        ServerSender.sendPacketToPlayer((Packet)ServerSender.createServerPacket(data), player);
    }

    public static void sendVillageSentenceInRange(World world, Point p, int range, MillVillager v) {
        for (Object oplayer : world.field_73010_i) {
            EntityPlayer player = (EntityPlayer)oplayer;
            if (!(p.distanceTo((Entity)player) < (double)range)) continue;
            ServerSender.sendVillagerSentence(player, v);
        }
    }

    public static void updatePanel(MillWorld mw, Point p, String[][] lines, int type, Point buildingPos, long villager_id) {
        if (lines == null) {
            return;
        }
        TileEntityPanel panel = p.getPanel(mw.world);
        if (panel != null) {
            panel.panelType = type;
            panel.buildingPos = buildingPos;
            panel.villager_id = villager_id;
        }
        String key = "" + type + ";" + buildingPos + ";" + villager_id + ";";
        ArrayList<EntityPlayer> receivers = new ArrayList<EntityPlayer>();
        for (int i = 0; i < lines.length; ++i) {
            for (int j = 0; j < lines[i].length; ++j) {
                key = key + ";" + lines[i][j];
            }
        }
        int keyHash = key.hashCode();
        for (EntityPlayer player : MillCommonUtilities.getServerPlayers(mw.world)) {
            if (!(p.distanceToSquared((Entity)player) < 256.0)) continue;
            UserProfile profile = MillCommonUtilities.getServerProfile(mw.world, player.getDisplayName());
            if (profile.panelsSent.containsKey(p) && profile.panelsSent.get(p).equals(keyHash)) continue;
            receivers.add(player);
        }
        if (receivers.size() == 0) {
            return;
        }
        DataOutput data = ServerSender.getNewByteBufOutputStream();
        try {
            data.write(106);
            StreamReadWrite.writeNullablePoint(p, data);
            data.write(type);
            StreamReadWrite.writeNullablePoint(buildingPos, data);
            data.writeLong(villager_id);
            StreamReadWrite.writeStringStringArray(lines, data);
        }
        catch (IOException e) {
            MLN.printException(ServerSender.class + ": Error in updatePanel", e);
        }
        S3FPacketCustomPayload packet = ServerSender.createServerPacket(data);
        for (EntityPlayer player : receivers) {
            ServerSender.sendPacketToPlayer((Packet)packet, player);
            UserProfile profile = MillCommonUtilities.getServerProfile(player.field_70170_p, player.getDisplayName());
            profile.panelsSent.put(p, keyHash);
        }
    }
}

