/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common.goal.generic;

import java.io.BufferedReader;
import java.io.File;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import org.millenaire.common.InvItem;
import org.millenaire.common.MLN;
import org.millenaire.common.MillVillager;
import org.millenaire.common.Point;
import org.millenaire.common.building.Building;
import org.millenaire.common.core.MillCommonUtilities;
import org.millenaire.common.forge.Mill;
import org.millenaire.common.goal.Goal;
import org.millenaire.common.goal.generic.GoalGeneric;
import org.millenaire.common.item.Goods;

public class GoalGenericPlantCrop
extends GoalGeneric {
    public String soilName = null;
    public String cropType = null;
    public InvItem seedItem = null;

    public static Block getCropBlock(String cropType) {
        if (cropType.equals("wheat")) {
            return Blocks.field_150464_aj;
        }
        if (cropType.equals("carrot")) {
            return Blocks.field_150459_bM;
        }
        if (cropType.equals("potato")) {
            return Blocks.field_150469_bN;
        }
        if (cropType.equals("rice")) {
            return Mill.cropRice;
        }
        if (cropType.equals("turmeric")) {
            return Mill.cropTurmeric;
        }
        if (cropType.equals("maize")) {
            return Mill.cropMaize;
        }
        if (cropType.equals("vine")) {
            return Mill.cropVine;
        }
        return null;
    }

    public static int getCropBlockMeta(String cropType) {
        return 0;
    }

    public static GoalGenericPlantCrop loadGenericPlantCropGoal(File file) {
        GoalGenericPlantCrop g = new GoalGenericPlantCrop();
        g.key = file.getName().split("\\.")[0].toLowerCase();
        try {
            String line;
            BufferedReader reader = MillCommonUtilities.getReader(file);
            while ((line = reader.readLine()) != null) {
                String value;
                if (line.trim().length() <= 0 || line.startsWith("//")) continue;
                String[] temp = line.split("=");
                if (temp.length != 2) {
                    MLN.error(null, "Invalid line when loading generic plating goal " + file.getName() + ": " + line);
                    continue;
                }
                String key = temp[0].trim().toLowerCase();
                if (GoalGeneric.readGenericGoalConfigLine(g, key, value = temp[1].trim(), file, line)) continue;
                if (key.equals("soilname")) {
                    g.soilName = value.trim().toLowerCase();
                    continue;
                }
                if (key.equals("croptype")) {
                    g.cropType = value.trim().toLowerCase();
                    continue;
                }
                if (key.equals("seed")) {
                    if (Goods.goodsName.containsKey(value = value.trim().toLowerCase())) {
                        g.seedItem = Goods.goodsName.get(value);
                        continue;
                    }
                    MLN.error(null, "Unknown seed in generic planting goal " + file.getName() + ": " + line);
                    continue;
                }
                MLN.error(null, "Unknown line in generic planting goal " + file.getName() + ": " + line);
            }
            if (g.soilName == null) {
                MLN.error(null, "The soilname is mandatory in custom planting goals " + file.getName());
                return null;
            }
            if (g.cropType == null) {
                MLN.error(null, "The croptype is mandatory in custom planting goals " + file.getName());
                return null;
            }
            reader.close();
        }
        catch (Exception e) {
            MLN.printException(e);
            return null;
        }
        return g;
    }

    public GoalGenericPlantCrop() {
        this.duration = 100;
    }

    @Override
    public Goal.GoalInformation getDestination(MillVillager villager) throws MLN.MillenaireException {
        Point dest = null;
        Building destBuilding = null;
        List<Building> buildings = this.getBuildings(villager);
        for (Building buildingDest : buildings) {
            List<Point> soils;
            if (!this.isDestPossible(villager, buildingDest) || (soils = buildingDest.getResManager().getSoilPoints(this.soilName)) == null) continue;
            for (Point p : soils) {
                if (!this.isValidPlantingLocation(villager.field_70170_p, p) || dest != null && !(p.distanceTo((Entity)villager) < dest.distanceTo((Entity)villager))) continue;
                dest = p;
                destBuilding = buildingDest;
            }
        }
        if (dest == null) {
            return null;
        }
        return this.packDest(dest, destBuilding);
    }

    @Override
    public boolean isDestPossibleSpecific(MillVillager villager, Building b) {
        return this.seedItem == null || b.countGoods(this.seedItem) + villager.countInv(this.seedItem) != 0;
    }

    @Override
    public boolean isPossibleGenericGoal(MillVillager villager) throws Exception {
        return this.getDestination(villager) != null;
    }

    private boolean isValidPlantingLocation(World world, Point p) {
        return !(p.getAbove().getBlock(world) != Blocks.field_150350_a && p.getAbove().getBlock(world) != Blocks.field_150433_aE && p.getAbove().getBlock(world) != Blocks.field_150362_t || p.getBlock(world) != Blocks.field_150349_c && p.getBlock(world) != Blocks.field_150346_d && p.getBlock(world) != Blocks.field_150458_ak);
    }

    @Override
    public boolean lookAtGoal() {
        return true;
    }

    @Override
    public boolean performAction(MillVillager villager) {
        int taken;
        Building dest = villager.getGoalBuildingDest();
        if (dest == null) {
            return true;
        }
        if (!this.isValidPlantingLocation(villager.field_70170_p, villager.getGoalDestPoint())) {
            return true;
        }
        if (this.seedItem != null && (taken = villager.takeFromInv(this.seedItem, 1)) == 0) {
            dest.takeGoods(this.seedItem, 1);
        }
        if (villager.getGoalDestPoint().getBlock(villager.field_70170_p) != Blocks.field_150458_ak) {
            villager.setBlockAndMetadata(villager.getGoalDestPoint(), Blocks.field_150458_ak, 0);
        }
        villager.setBlockAndMetadata(villager.getGoalDestPoint().getAbove(), GoalGenericPlantCrop.getCropBlock(this.cropType), GoalGenericPlantCrop.getCropBlockMeta(this.cropType));
        villager.func_71038_i();
        return true;
    }

    @Override
    public int priority(MillVillager villager) throws MLN.MillenaireException {
        Goal.GoalInformation info = this.getDestination(villager);
        if (info == null || info.getDest() == null) {
            return -1;
        }
        return (int)(30.0 - villager.getPos().distanceTo(info.getDest()));
    }
}

