/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common.goal;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.millenaire.common.MLN;
import org.millenaire.common.MillVillager;
import org.millenaire.common.Point;
import org.millenaire.common.core.MillCommonUtilities;
import org.millenaire.common.goal.Goal;
import org.millenaire.common.pathing.atomicstryker.AStarConfig;

public class GoalMinerMineResource
extends Goal {
    @Override
    public int actionDuration(MillVillager villager) {
        Block block = villager.getBlock(villager.getGoalDestPoint());
        if (block == Blocks.field_150348_b || block == Blocks.field_150322_A) {
            int toolEfficiency = (int)villager.getBestPickaxe().getDigSpeed(new ItemStack((Item)villager.getBestPickaxe(), 1), Blocks.field_150322_A, 0);
            return 7000 - 200 * toolEfficiency;
        }
        if (block == Blocks.field_150354_m || block == Blocks.field_150435_aG || block == Blocks.field_150351_n) {
            int toolEfficiency = (int)villager.getBestShovel().getDigSpeed(new ItemStack((Item)villager.getBestShovel(), 1), (Block)Blocks.field_150354_m, 0);
            return 7000 - 200 * toolEfficiency;
        }
        return 0;
    }

    @Override
    public Goal.GoalInformation getDestination(MillVillager villager) throws Exception {
        List<List<Point>> sources = villager.getHouse().getResManager().sources;
        ArrayList<Point> validSources = new ArrayList<Point>();
        for (int i = 0; i < sources.size(); ++i) {
            for (int j = 0; j < sources.get(i).size(); ++j) {
                Block block = villager.getBlock(sources.get(i).get(j));
                if (block != Blocks.field_150348_b && block != Blocks.field_150322_A && block != Blocks.field_150354_m && block != Blocks.field_150435_aG && block != Blocks.field_150351_n) continue;
                validSources.add(sources.get(i).get(j));
            }
        }
        if (validSources.isEmpty()) {
            return null;
        }
        return this.packDest((Point)validSources.get(MillCommonUtilities.randomInt(validSources.size())), villager.getHouse());
    }

    @Override
    public ItemStack[] getHeldItemsTravelling(MillVillager villager) throws Exception {
        if (villager.getBlock(villager.getGoalDestPoint()) == Blocks.field_150354_m || villager.getBlock(villager.getGoalDestPoint()) == Blocks.field_150435_aG || villager.getBlock(villager.getGoalDestPoint()) == Blocks.field_150351_n) {
            return villager.getBestShovelStack();
        }
        return villager.getBestPickaxeStack();
    }

    @Override
    public AStarConfig getPathingConfig() {
        return JPS_CONFIG_WIDE;
    }

    @Override
    public boolean isPossibleSpecific(MillVillager villager) throws Exception {
        return this.getDestination(villager) != null;
    }

    @Override
    public boolean lookAtGoal() {
        return true;
    }

    @Override
    public boolean performAction(MillVillager villager) throws Exception {
        Block block = villager.getBlock(villager.getGoalDestPoint());
        if (block == Blocks.field_150354_m) {
            villager.addToInv((Block)Blocks.field_150354_m, 1);
            MillCommonUtilities.playSoundBlockBreaking(villager.field_70170_p, villager.getGoalDestPoint(), (Block)Blocks.field_150354_m, 4.0f);
            if (MLN.LogMiner >= 3 && villager.extraLog) {
                MLN.debug(this, "Gathered sand at: " + villager.getGoalDestPoint());
            }
        } else if (block == Blocks.field_150348_b) {
            villager.addToInv(Blocks.field_150347_e, 1);
            MillCommonUtilities.playSoundBlockBreaking(villager.field_70170_p, villager.getGoalDestPoint(), Blocks.field_150348_b, 4.0f);
            if (MLN.LogMiner >= 3 && villager.extraLog) {
                MLN.debug(this, "Gather cobblestone at: " + villager.getGoalDestPoint());
            }
        } else if (block == Blocks.field_150322_A) {
            villager.addToInv(Blocks.field_150322_A, 1);
            MillCommonUtilities.playSoundBlockBreaking(villager.field_70170_p, villager.getGoalDestPoint(), Blocks.field_150322_A, 4.0f);
            if (MLN.LogMiner >= 3 && villager.extraLog) {
                MLN.debug(this, "Gather sand stone at: " + villager.getGoalDestPoint());
            }
        } else if (block == Blocks.field_150435_aG) {
            villager.addToInv(Items.field_151119_aD, 1);
            MillCommonUtilities.playSoundBlockBreaking(villager.field_70170_p, villager.getGoalDestPoint(), Blocks.field_150435_aG, 4.0f);
            if (MLN.LogMiner >= 3 && villager.extraLog) {
                MLN.debug(this, "Gather clay at: " + villager.getGoalDestPoint());
            }
        } else if (block == Blocks.field_150351_n) {
            villager.addToInv(Blocks.field_150351_n, 1);
            MillCommonUtilities.playSoundBlockBreaking(villager.field_70170_p, villager.getGoalDestPoint(), Blocks.field_150351_n, 4.0f);
            if (MLN.LogMiner >= 3 && villager.extraLog) {
                MLN.debug(this, "Gather gravel at: " + villager.getGoalDestPoint());
            }
        }
        return true;
    }

    @Override
    public int priority(MillVillager villager) throws Exception {
        return 30;
    }

    @Override
    public int range(MillVillager villager) {
        return 5;
    }

    @Override
    public boolean stuckAction(MillVillager villager) throws Exception {
        return this.performAction(villager);
    }

    @Override
    public boolean swingArms() {
        return true;
    }
}

