/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common.goal;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.millenaire.common.InvItem;
import org.millenaire.common.MLN;
import org.millenaire.common.MillVillager;
import org.millenaire.common.MillWorldInfo;
import org.millenaire.common.Point;
import org.millenaire.common.building.Building;
import org.millenaire.common.core.MillCommonUtilities;
import org.millenaire.common.forge.Mill;
import org.millenaire.common.goal.Goal;
import org.millenaire.common.pathing.atomicstryker.AStarConfig;

public class GoalLumbermanChopTrees
extends Goal {
    public GoalLumbermanChopTrees() {
        this.maxSimultaneousInBuilding = 1;
        try {
            this.townhallLimit.put(new InvItem(Blocks.field_150364_r, -1), 4096);
        }
        catch (MLN.MillenaireException e) {
            MLN.printException(e);
        }
    }

    @Override
    public int actionDuration(MillVillager villager) {
        int toolEfficiency = (int)villager.getBestAxe().getDigSpeed(new ItemStack((Item)villager.getBestAxe(), 1), Blocks.field_150364_r, 0);
        return 1000 - toolEfficiency * 40;
    }

    @Override
    public Goal.GoalInformation getDestination(MillVillager villager) {
        ArrayList<Point> vp = new ArrayList<Point>();
        ArrayList<Point> buildingp = new ArrayList<Point>();
        for (Building grove : villager.getTownHall().getBuildingsWithTag("grove")) {
            Point p;
            if (grove.getWoodCount() <= 4 || (p = grove.getWoodLocation()) == null) continue;
            vp.add(p);
            buildingp.add(grove.getPos());
        }
        if (vp.isEmpty()) {
            return null;
        }
        Point p = (Point)vp.get(0);
        Point buildingP = (Point)buildingp.get(0);
        for (int i = 1; i < vp.size(); ++i) {
            if (!(((Point)vp.get(i)).horizontalDistanceToSquared((Entity)villager) < p.horizontalDistanceToSquared((Entity)villager))) continue;
            p = (Point)vp.get(i);
            buildingP = (Point)buildingp.get(i);
        }
        return this.packDest(p, buildingP);
    }

    @Override
    public ItemStack[] getHeldItemsTravelling(MillVillager villager) {
        return villager.getBestAxeStack();
    }

    @Override
    public AStarConfig getPathingConfig() {
        return JPS_CONFIG_CHOPLUMBER;
    }

    @Override
    public boolean isPossibleSpecific(MillVillager villager) {
        if (villager.countInv(Blocks.field_150364_r, -1) > 64) {
            return false;
        }
        return this.getDestination(villager) != null;
    }

    @Override
    public boolean lookAtGoal() {
        return true;
    }

    @Override
    public boolean performAction(MillVillager villager) throws Exception {
        boolean woodFound = false;
        if (MLN.LogLumberman >= 3) {
            MLN.debug(this, "Attempting to gather wood at: " + villager.getGoalDestPoint());
        }
        MillWorldInfo winfo = villager.getTownHall().winfo;
        for (int i = 12; i > -12; --i) {
            for (int j = -3; j < 4; ++j) {
                for (int k = -3; k < 4; ++k) {
                    Block block;
                    Point p = villager.getGoalDestPoint().getRelative(j, i, k);
                    if (winfo.isConstructionOrLoggingForbiddenHere(p) || (block = villager.getBlock(p)) != Blocks.field_150364_r && block != Blocks.field_150362_t) continue;
                    if (!woodFound) {
                        if (block == Blocks.field_150364_r) {
                            int meta = villager.getBlockMeta(p) & 3;
                            villager.setBlock(p, Blocks.field_150350_a);
                            villager.func_71038_i();
                            villager.addToInv(Blocks.field_150364_r, meta, 1);
                            woodFound = true;
                            if (MLN.LogLumberman < 3) continue;
                            MLN.debug(this, "Gathered wood at: " + villager.getGoalDestPoint());
                            continue;
                        }
                        if (MillCommonUtilities.randomInt(4) == 0) {
                            villager.addToInv(Blocks.field_150345_g, MillCommonUtilities.getBlockMeta(villager.field_70170_p, p) & 3, 1);
                        }
                        villager.setBlock(p, Blocks.field_150350_a);
                        villager.func_71038_i();
                        if (villager.gathersApples() && MillCommonUtilities.chanceOn(16)) {
                            villager.addToInv(Mill.ciderapple, 1);
                        }
                        if (MLN.LogLumberman < 3 || !villager.extraLog) continue;
                        MLN.debug(this, "Destroyed leaves at: " + villager.getGoalDestPoint());
                        continue;
                    }
                    if (MLN.LogLumberman >= 3 && villager.extraLog) {
                        MLN.debug(this, "More wood found.");
                    }
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public int priority(MillVillager villager) {
        return Math.max(10, 125 - villager.countInv(Blocks.field_150364_r, -1));
    }

    @Override
    public int range(MillVillager villager) {
        return ACTIVATION_RANGE + 2;
    }
}

