/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common.goal;

import net.minecraft.item.ItemStack;
import org.millenaire.common.MillVillager;
import org.millenaire.common.Point;
import org.millenaire.common.core.MillCommonUtilities;
import org.millenaire.common.goal.Goal;

public class GoalGuardPatrol
extends Goal {
    GoalGuardPatrol() {
        this.leasure = true;
    }

    @Override
    public boolean allowRandomMoves() {
        return true;
    }

    @Override
    public Goal.GoalInformation getDestination(MillVillager villager) {
        return this.packDest(villager.getTownHall().getRandomLocationWithTag("Patrol"));
    }

    @Override
    public ItemStack[] getHeldItemsTravelling(MillVillager villager) {
        return new ItemStack[]{villager.getWeapon()};
    }

    @Override
    public boolean isPossibleSpecific(MillVillager villager) {
        if (villager.lastGoalTime.containsKey(this) && villager.lastGoalTime.get(this) > villager.field_70170_p.func_72820_D() + 2000L) {
            return false;
        }
        Point p = villager.getTownHall().getRandomLocationWithTag("Patrol");
        if (p == null) {
            return false;
        }
        return villager.getPos().distanceTo(p) > 5.0;
    }

    @Override
    public boolean performAction(MillVillager villager) {
        return MillCommonUtilities.chanceOn(600);
    }

    @Override
    public int priority(MillVillager villager) {
        return MillCommonUtilities.randomInt(20) - 10;
    }

    @Override
    public int range(MillVillager villager) {
        return 100;
    }
}

