/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common.goal;

import org.millenaire.common.InvItem;
import org.millenaire.common.MillVillager;
import org.millenaire.common.building.BuildingPlan;
import org.millenaire.common.goal.Goal;

public class GoalGetResourcesForBuild
extends Goal {
    @Override
    public int actionDuration(MillVillager villager) {
        return 2000;
    }

    @Override
    public Goal.GoalInformation getDestination(MillVillager villager) {
        return this.packDest(villager.getTownHall().getResManager().getSellingPos(), villager.getTownHall());
    }

    @Override
    public boolean isPossibleSpecific(MillVillager villager) {
        if (villager.getTownHall().builder != null || villager.getTownHall().buildingLocationIP == null || villager.getTownHall().getBblocks() == null) {
            return false;
        }
        for (MillVillager v : villager.getTownHall().villagers) {
            if (!Goal.getResourcesForBuild.key.equals(v.goalKey) && !Goal.construction.key.equals(v.goalKey)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isStillValidSpecific(MillVillager villager) throws Exception {
        return villager.getTownHall().builder == null || villager.getTownHall().builder == villager;
    }

    @Override
    public String nextGoal(MillVillager villager) {
        return Goal.construction.key;
    }

    @Override
    public void onAccept(MillVillager villager) {
        villager.getTownHall().builder = villager;
    }

    @Override
    public boolean performAction(MillVillager villager) {
        if (villager.getTownHall().getCurrentBuildingPlan() == null) {
            return true;
        }
        if (villager.getTownHall().canAffordBuild(villager.getTownHall().getCurrentBuildingPlan())) {
            BuildingPlan plan = villager.getTownHall().getCurrentBuildingPlan();
            for (InvItem key : plan.resCost.keySet()) {
                villager.takeFromBuilding(villager.getTownHall(), key.getItem(), key.meta, plan.resCost.get(key));
            }
        }
        return true;
    }

    @Override
    public int priority(MillVillager villager) {
        return 100;
    }
}

