/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common.goal;

import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.millenaire.common.MLN;
import org.millenaire.common.MillVillager;
import org.millenaire.common.building.BuildingBlock;
import org.millenaire.common.goal.Goal;
import org.millenaire.common.pathing.atomicstryker.AStarConfig;

public class GoalBuildPath
extends Goal {
    public GoalBuildPath() {
        this.maxSimultaneousTotal = 1;
    }

    @Override
    public int actionDuration(MillVillager villager) {
        int toolEfficiency = (int)villager.getBestShovel().getDigSpeed(new ItemStack((Item)villager.getBestShovel(), 1), Blocks.field_150346_d, 0);
        return 100 - toolEfficiency * 5;
    }

    @Override
    public Goal.GoalInformation getDestination(MillVillager villager) throws Exception {
        BuildingBlock b = villager.getTownHall().getCurrentPathBuildingBlock();
        if (b != null) {
            return this.packDest(b.p);
        }
        return null;
    }

    @Override
    public ItemStack[] getHeldItemsTravelling(MillVillager villager) {
        BuildingBlock bblock = villager.getTownHall().getCurrentPathBuildingBlock();
        if (bblock != null) {
            if (bblock.block == Blocks.field_150350_a) {
                return villager.getBestShovelStack();
            }
            return new ItemStack[]{new ItemStack(Item.func_150898_a((Block)bblock.block), 1, (int)bblock.meta)};
        }
        return villager.getBestShovelStack();
    }

    @Override
    public AStarConfig getPathingConfig() {
        return JPS_CONFIG_BUILDING;
    }

    @Override
    public boolean isPossibleSpecific(MillVillager villager) {
        return MLN.BuildVillagePaths && villager.getTownHall().getCurrentPathBuildingBlock() != null;
    }

    @Override
    public boolean isStillValidSpecific(MillVillager villager) throws Exception {
        return villager.getTownHall().getCurrentPathBuildingBlock() != null;
    }

    @Override
    public boolean lookAtGoal() {
        return true;
    }

    @Override
    public boolean performAction(MillVillager villager) throws Exception {
        BuildingBlock bblock = villager.getTownHall().getCurrentPathBuildingBlock();
        if (bblock == null) {
            return true;
        }
        if (MLN.LogVillagePaths >= 3) {
            MLN.debug(villager, "Building path block: " + bblock);
        }
        bblock.pathBuild(villager.getTownHall());
        ++villager.getTownHall().pathsToBuildPathIndex;
        BuildingBlock b = villager.getTownHall().getCurrentPathBuildingBlock();
        villager.func_71038_i();
        if (b != null) {
            villager.setGoalDestPoint(b.p);
            return false;
        }
        return true;
    }

    @Override
    public int priority(MillVillager villager) throws Exception {
        return 50;
    }

    @Override
    public int range(MillVillager villager) {
        return ACTIVATION_RANGE + 2;
    }

    @Override
    public boolean stopMovingWhileWorking() {
        return false;
    }

    @Override
    public boolean unreachableDestination(MillVillager villager) throws Exception {
        this.performAction(villager);
        return true;
    }
}

