/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common.building;

import io.netty.buffer.ByteBufInputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCocoa;
import net.minecraft.block.BlockLog;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import org.millenaire.common.InvItem;
import org.millenaire.common.MLN;
import org.millenaire.common.Point;
import org.millenaire.common.TileEntityMillChest;
import org.millenaire.common.building.Building;
import org.millenaire.common.core.MillCommonUtilities;
import org.millenaire.common.forge.Mill;
import org.millenaire.common.network.StreamReadWrite;

public class BuildingResManager {
    public List<Point> brickspot = new ArrayList<Point>();
    public List<Point> chests = new ArrayList<Point>();
    public List<Point> fishingspots = new ArrayList<Point>();
    public List<Point> sugarcanesoils = new ArrayList<Point>();
    public List<Point> healingspots = new ArrayList<Point>();
    public List<Point> furnaces = new ArrayList<Point>();
    public List<Point> brewingStands = new ArrayList<Point>();
    public List<Point> signs = new ArrayList<Point>();
    public List<List<Point>> sources = new ArrayList<List<Point>>();
    public List<Block> sourceTypes = new ArrayList<Block>();
    public List<List<Point>> spawns = new ArrayList<List<Point>>();
    public List<String> spawnTypes = new ArrayList<String>();
    public List<List<Point>> mobSpawners = new ArrayList<List<Point>>();
    public List<String> mobSpawnerTypes = new ArrayList<String>();
    public List<List<Point>> soils = new ArrayList<List<Point>>();
    public List<String> soilTypes = new ArrayList<String>();
    public List<Point> stalls = new ArrayList<Point>();
    public List<Point> woodspawn = new ArrayList<Point>();
    public List<Point> netherwartsoils = new ArrayList<Point>();
    public List<Point> silkwormblock = new ArrayList<Point>();
    public List<Point> dispenderUnknownPowder = new ArrayList<Point>();
    private Point sleepingPos = null;
    private Point sellingPos = null;
    private Point craftingPos = null;
    private Point defendingPos = null;
    private Point shelterPos = null;
    private Point pathStartPos = null;
    private Point leasurePos = null;
    private final Building building;

    public BuildingResManager(Building b) {
        this.building = b;
    }

    public void addMobSpawnerPoint(String type, Point p) {
        if (!this.mobSpawnerTypes.contains(type)) {
            ArrayList<Point> spawnsPoint = new ArrayList<Point>();
            spawnsPoint.add(p);
            this.mobSpawners.add(spawnsPoint);
            this.mobSpawnerTypes.add(type);
        } else {
            for (int i = 0; i < this.mobSpawnerTypes.size(); ++i) {
                if (!this.mobSpawnerTypes.get(i).equals(type) || this.mobSpawners.get(i).contains(p)) continue;
                this.mobSpawners.get(i).add(p);
            }
        }
    }

    public void addSoilPoint(String type, Point p) {
        if (!this.soilTypes.contains(type)) {
            ArrayList<Point> spawnsPoint = new ArrayList<Point>();
            spawnsPoint.add(p);
            this.soils.add(spawnsPoint);
            this.soilTypes.add(type);
        } else {
            for (int i = 0; i < this.soilTypes.size(); ++i) {
                if (!this.soilTypes.get(i).equals(type) || this.soils.get(i).contains(p)) continue;
                this.soils.get(i).add(p);
            }
        }
    }

    public void addSourcePoint(Block block, Point p) {
        if (!this.sourceTypes.contains(block)) {
            ArrayList<Point> spawnsPoint = new ArrayList<Point>();
            spawnsPoint.add(p);
            this.sources.add(spawnsPoint);
            this.sourceTypes.add(block);
        } else {
            for (int i = 0; i < this.sourceTypes.size(); ++i) {
                if (!this.sourceTypes.get(i).equals(block) || this.sources.get(i).contains(p)) continue;
                this.sources.get(i).add(p);
            }
        }
    }

    public void addSpawnPoint(String type, Point p) {
        if (!this.spawnTypes.contains(type)) {
            ArrayList<Point> spawnsPoint = new ArrayList<Point>();
            spawnsPoint.add(p);
            this.spawns.add(spawnsPoint);
            this.spawnTypes.add(type);
        } else {
            for (int i = 0; i < this.spawnTypes.size(); ++i) {
                if (!this.spawnTypes.get(i).equals(type) || this.spawns.get(i).contains(p)) continue;
                this.spawns.get(i).add(p);
            }
        }
    }

    public HashMap<InvItem, Integer> getChestsContent() {
        HashMap<InvItem, Integer> contents = new HashMap<InvItem, Integer>();
        for (Point p : this.chests) {
            TileEntityMillChest chest = p.getMillChest(this.building.worldObj);
            if (chest == null) continue;
            for (int i = 0; i < chest.func_70302_i_(); ++i) {
                ItemStack stack = chest.func_70301_a(i);
                if (stack == null) continue;
                try {
                    InvItem key = new InvItem(stack);
                    if (stack == null) continue;
                    if (contents.containsKey(key)) {
                        contents.put(key, stack.field_77994_a + contents.get(key));
                        continue;
                    }
                    contents.put(key, stack.field_77994_a);
                    continue;
                }
                catch (MLN.MillenaireException e) {
                    MLN.printException(e);
                }
            }
        }
        return contents;
    }

    public Point getCocoaHarvestLocation() {
        for (int i = 0; i < this.soilTypes.size(); ++i) {
            if (!this.soilTypes.get(i).equals("cacao")) continue;
            for (Point p : this.soils.get(i)) {
                int meta;
                if (p.getBlock(this.building.worldObj) != Blocks.field_150375_by || BlockCocoa.func_149987_c((int)(meta = p.getMeta(this.building.worldObj))) < 2) continue;
                return p;
            }
        }
        return null;
    }

    public Point getCocoaPlantingLocation() {
        for (int i = 0; i < this.soilTypes.size(); ++i) {
            if (!this.soilTypes.get(i).equals("cacao")) continue;
            for (Point p : this.soils.get(i)) {
                if (p.getBlock(this.building.worldObj) != Blocks.field_150350_a) continue;
                if (p.getNorth().getBlock(this.building.worldObj) == Blocks.field_150364_r && BlockLog.func_150165_c((int)p.getNorth().getMeta(this.building.worldObj)) == 3) {
                    return p;
                }
                if (p.getEast().getBlock(this.building.worldObj) == Blocks.field_150364_r && BlockLog.func_150165_c((int)p.getEast().getMeta(this.building.worldObj)) == 3) {
                    return p;
                }
                if (p.getSouth().getBlock(this.building.worldObj) == Blocks.field_150364_r && BlockLog.func_150165_c((int)p.getSouth().getMeta(this.building.worldObj)) == 3) {
                    return p;
                }
                if (p.getWest().getBlock(this.building.worldObj) != Blocks.field_150364_r || BlockLog.func_150165_c((int)p.getWest().getMeta(this.building.worldObj)) != 3) continue;
                return p;
            }
        }
        return null;
    }

    public Point getCraftingPos() {
        if (this.craftingPos != null) {
            return this.craftingPos;
        }
        if (this.sellingPos != null) {
            return this.sellingPos;
        }
        return this.sleepingPos;
    }

    public Point getDefendingPos() {
        if (this.defendingPos != null) {
            return this.defendingPos;
        }
        if (this.sellingPos != null) {
            return this.sellingPos;
        }
        return this.sleepingPos;
    }

    public Point getEmptyBrickLocation() {
        Point p;
        int start;
        int i;
        if (this.brickspot.size() == 0) {
            return null;
        }
        for (i = start = MillCommonUtilities.randomInt(this.brickspot.size()); i < this.brickspot.size(); ++i) {
            p = this.brickspot.get(i);
            if (MillCommonUtilities.getBlock(this.building.worldObj, p) != Blocks.field_150350_a) continue;
            return p;
        }
        for (i = 0; i < start; ++i) {
            p = this.brickspot.get(i);
            if (MillCommonUtilities.getBlock(this.building.worldObj, p) != Blocks.field_150350_a) continue;
            return p;
        }
        return null;
    }

    public Point getFullBrickLocation() {
        Point p;
        int start;
        int i;
        if (this.brickspot.size() == 0) {
            return null;
        }
        for (i = start = MillCommonUtilities.randomInt(this.brickspot.size()); i < this.brickspot.size(); ++i) {
            p = this.brickspot.get(i);
            if (MillCommonUtilities.getBlock(this.building.worldObj, p) != Mill.stone_decoration || MillCommonUtilities.getBlockMeta(this.building.worldObj, p) != 1) continue;
            return p;
        }
        for (i = 0; i < start; ++i) {
            p = this.brickspot.get(i);
            if (MillCommonUtilities.getBlock(this.building.worldObj, p) != Mill.stone_decoration || MillCommonUtilities.getBlockMeta(this.building.worldObj, p) != 1) continue;
            return p;
        }
        return null;
    }

    public Point getLeasurePos() {
        if (this.leasurePos != null) {
            return this.leasurePos;
        }
        return this.getSellingPos();
    }

    public int getNbEmptyBrickLocation() {
        if (this.brickspot.size() == 0) {
            return 0;
        }
        int nb = 0;
        for (int i = 0; i < this.brickspot.size(); ++i) {
            Point p = this.brickspot.get(i);
            if (MillCommonUtilities.getBlock(this.building.worldObj, p) != Blocks.field_150350_a) continue;
            ++nb;
        }
        return nb;
    }

    public int getNbFullBrickLocation() {
        if (this.brickspot.size() == 0) {
            return 0;
        }
        int nb = 0;
        for (int i = 0; i < this.brickspot.size(); ++i) {
            Point p = this.brickspot.get(i);
            if (MillCommonUtilities.getBlock(this.building.worldObj, p) != Mill.stone_decoration || MillCommonUtilities.getBlockMeta(this.building.worldObj, p) != 1) continue;
            ++nb;
        }
        return nb;
    }

    public int getNbNetherWartHarvestLocation() {
        if (this.netherwartsoils.size() == 0) {
            return 0;
        }
        int nb = 0;
        for (int i = 0; i < this.netherwartsoils.size(); ++i) {
            Point p = this.netherwartsoils.get(i);
            if (MillCommonUtilities.getBlock(this.building.worldObj, p.getAbove()) != Blocks.field_150388_bm || MillCommonUtilities.getBlockMeta(this.building.worldObj, p.getAbove()) < 3) continue;
            ++nb;
        }
        return nb;
    }

    public int getNbNetherWartPlantingLocation() {
        if (this.netherwartsoils.size() == 0) {
            return 0;
        }
        int nb = 0;
        for (int i = 0; i < this.netherwartsoils.size(); ++i) {
            Point p = this.netherwartsoils.get(i);
            if (MillCommonUtilities.getBlock(this.building.worldObj, p.getAbove()) != Blocks.field_150350_a) continue;
            ++nb;
        }
        return nb;
    }

    public int getNbSilkWormHarvestLocation() {
        if (this.silkwormblock.size() == 0) {
            return 0;
        }
        int nb = 0;
        for (int i = 0; i < this.silkwormblock.size(); ++i) {
            Point p = this.silkwormblock.get(i);
            if (MillCommonUtilities.getBlock(this.building.worldObj, p) != Mill.wood_decoration || MillCommonUtilities.getBlockMeta(this.building.worldObj, p) != 4) continue;
            ++nb;
        }
        return nb;
    }

    public int getNbSugarCaneHarvestLocation() {
        if (this.sugarcanesoils.size() == 0) {
            return 0;
        }
        int nb = 0;
        for (int i = 0; i < this.sugarcanesoils.size(); ++i) {
            Point p = this.sugarcanesoils.get(i);
            if (MillCommonUtilities.getBlock(this.building.worldObj, p.getRelative(0.0, 2.0, 0.0)) != Blocks.field_150436_aH) continue;
            ++nb;
        }
        return nb;
    }

    public int getNbSugarCanePlantingLocation() {
        if (this.sugarcanesoils.size() == 0) {
            return 0;
        }
        int nb = 0;
        for (int i = 0; i < this.sugarcanesoils.size(); ++i) {
            Point p = this.sugarcanesoils.get(i);
            if (MillCommonUtilities.getBlock(this.building.worldObj, p.getAbove()) != Blocks.field_150350_a) continue;
            ++nb;
        }
        return nb;
    }

    public Point getNetherWartsHarvestLocation() {
        Point p;
        int start;
        int i;
        if (this.netherwartsoils.size() == 0) {
            return null;
        }
        for (i = start = MillCommonUtilities.randomInt(this.netherwartsoils.size()); i < this.netherwartsoils.size(); ++i) {
            p = this.netherwartsoils.get(i);
            if (MillCommonUtilities.getBlock(this.building.worldObj, p.getAbove()) != Blocks.field_150388_bm || MillCommonUtilities.getBlockMeta(this.building.worldObj, p.getAbove()) != 3) continue;
            return p;
        }
        for (i = 0; i < start; ++i) {
            p = this.netherwartsoils.get(i);
            if (MillCommonUtilities.getBlock(this.building.worldObj, p.getAbove()) != Blocks.field_150388_bm || MillCommonUtilities.getBlockMeta(this.building.worldObj, p.getAbove()) != 3) continue;
            return p;
        }
        return null;
    }

    public Point getNetherWartsPlantingLocation() {
        Point p;
        int start;
        int i;
        if (this.netherwartsoils.size() == 0) {
            return null;
        }
        for (i = start = MillCommonUtilities.randomInt(this.netherwartsoils.size()); i < this.netherwartsoils.size(); ++i) {
            p = this.netherwartsoils.get(i);
            if (MillCommonUtilities.getBlock(this.building.worldObj, p.getAbove()) != Blocks.field_150350_a || MillCommonUtilities.getBlock(this.building.worldObj, p) != Blocks.field_150425_aM) continue;
            return p;
        }
        for (i = 0; i < start; ++i) {
            p = this.netherwartsoils.get(i);
            if (MillCommonUtilities.getBlock(this.building.worldObj, p.getAbove()) != Blocks.field_150350_a || MillCommonUtilities.getBlock(this.building.worldObj, p) != Blocks.field_150425_aM) continue;
            return p;
        }
        return null;
    }

    public Point getPathStartPos() {
        if (this.pathStartPos != null) {
            return this.pathStartPos;
        }
        return this.getSellingPos();
    }

    public Point getPlantingLocation() {
        for (Point p : this.woodspawn) {
            Block block = MillCommonUtilities.getBlock(this.building.worldObj, p);
            if (block != Blocks.field_150350_a && block != Blocks.field_150433_aE) continue;
            return p;
        }
        return null;
    }

    public Point getSellingPos() {
        if (this.sellingPos != null) {
            return this.sellingPos;
        }
        return this.sleepingPos;
    }

    public Point getShelterPos() {
        if (this.shelterPos != null) {
            return this.shelterPos;
        }
        return this.sleepingPos;
    }

    public Point getSilkwormHarvestLocation() {
        Point p;
        int start;
        int i;
        if (this.silkwormblock.size() == 0) {
            return null;
        }
        for (i = start = MillCommonUtilities.randomInt(this.silkwormblock.size()); i < this.silkwormblock.size(); ++i) {
            p = this.silkwormblock.get(i);
            if (MillCommonUtilities.getBlock(this.building.worldObj, p) != Mill.wood_decoration || MillCommonUtilities.getBlockMeta(this.building.worldObj, p) != 4) continue;
            return p;
        }
        for (i = 0; i < start; ++i) {
            p = this.silkwormblock.get(i);
            if (MillCommonUtilities.getBlock(this.building.worldObj, p) != Mill.wood_decoration || MillCommonUtilities.getBlockMeta(this.building.worldObj, p) != 4) continue;
            return p;
        }
        return null;
    }

    public Point getSleepingPos() {
        return this.sleepingPos;
    }

    public List<Point> getSoilPoints(String type) {
        for (int i = 0; i < this.soilTypes.size(); ++i) {
            if (!this.soilTypes.get(i).equals(type)) continue;
            return this.soils.get(i);
        }
        return null;
    }

    public Point getSugarCaneHarvestLocation() {
        Point p;
        int start;
        int i;
        if (this.sugarcanesoils.size() == 0) {
            return null;
        }
        for (i = start = MillCommonUtilities.randomInt(this.sugarcanesoils.size()); i < this.sugarcanesoils.size(); ++i) {
            p = this.sugarcanesoils.get(i);
            if (MillCommonUtilities.getBlock(this.building.worldObj, p.getRelative(0.0, 2.0, 0.0)) != Blocks.field_150436_aH) continue;
            return p;
        }
        for (i = 0; i < start; ++i) {
            p = this.sugarcanesoils.get(i);
            if (MillCommonUtilities.getBlock(this.building.worldObj, p.getRelative(0.0, 2.0, 0.0)) != Blocks.field_150436_aH) continue;
            return p;
        }
        return null;
    }

    public Point getSugarCanePlantingLocation() {
        Point p;
        int start;
        int i;
        if (this.sugarcanesoils.size() == 0) {
            return null;
        }
        for (i = start = MillCommonUtilities.randomInt(this.sugarcanesoils.size()); i < this.sugarcanesoils.size(); ++i) {
            p = this.sugarcanesoils.get(i);
            if (MillCommonUtilities.getBlock(this.building.worldObj, p.getAbove()) != Blocks.field_150350_a) continue;
            return p;
        }
        for (i = 0; i < start; ++i) {
            p = this.sugarcanesoils.get(i);
            if (MillCommonUtilities.getBlock(this.building.worldObj, p.getAbove()) != Blocks.field_150350_a) continue;
            return p;
        }
        return null;
    }

    public void readDataStream(ByteBufInputStream ds) throws IOException {
        this.chests = StreamReadWrite.readPointList((DataInput)ds);
        this.furnaces = StreamReadWrite.readPointList((DataInput)ds);
        this.signs = StreamReadWrite.readPointList((DataInput)ds);
        for (Point p : this.chests) {
            TileEntityMillChest chest = p.getMillChest(this.building.mw.world);
            if (chest == null) continue;
            chest.buildingPos = this.building.getPos();
        }
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        Point p;
        NBTTagList nbttaglist2;
        ArrayList<Point> v;
        Point p2;
        NBTTagCompound nbttagcompound1;
        int i;
        this.sleepingPos = Point.read(nbttagcompound, "spawnPos");
        this.sellingPos = Point.read(nbttagcompound, "sellingPos");
        this.craftingPos = Point.read(nbttagcompound, "craftingPos");
        this.defendingPos = Point.read(nbttagcompound, "defendingPos");
        this.shelterPos = Point.read(nbttagcompound, "shelterPos");
        this.pathStartPos = Point.read(nbttagcompound, "pathStartPos");
        this.leasurePos = Point.read(nbttagcompound, "leasurePos");
        if (this.sleepingPos == null) {
            this.sleepingPos = this.building.getPos().getAbove();
        }
        NBTTagList nbttaglist = nbttagcompound.func_150295_c("chests", 10);
        for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
            nbttagcompound1 = nbttaglist.func_150305_b(i);
            p2 = Point.read(nbttagcompound1, "pos");
            if (p2 == null || this.chests.contains(p2)) continue;
            this.chests.add(p2);
        }
        if (!this.chests.contains(this.building.getPos())) {
            this.chests.add(0, this.building.getPos());
        }
        nbttaglist = nbttagcompound.func_150295_c("furnaces", 10);
        for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
            nbttagcompound1 = nbttaglist.func_150305_b(i);
            p2 = Point.read(nbttagcompound1, "pos");
            if (p2 == null) continue;
            this.furnaces.add(p2);
        }
        nbttaglist = nbttagcompound.func_150295_c("brewingStands", 10);
        for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
            nbttagcompound1 = nbttaglist.func_150305_b(i);
            p2 = Point.read(nbttagcompound1, "pos");
            if (p2 == null) continue;
            this.brewingStands.add(p2);
        }
        nbttaglist = nbttagcompound.func_150295_c("signs", 10);
        for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
            nbttagcompound1 = nbttaglist.func_150305_b(i);
            p2 = Point.read(nbttagcompound1, "pos");
            if (p2 == null) continue;
            this.signs.add(p2);
        }
        nbttaglist = nbttagcompound.func_150295_c("netherwartsoils", 10);
        for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
            nbttagcompound1 = nbttaglist.func_150305_b(i);
            p2 = Point.read(nbttagcompound1, "pos");
            if (p2 == null) continue;
            this.netherwartsoils.add(p2);
        }
        nbttaglist = nbttagcompound.func_150295_c("silkwormblock", 10);
        for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
            nbttagcompound1 = nbttaglist.func_150305_b(i);
            p2 = Point.read(nbttagcompound1, "pos");
            if (p2 == null) continue;
            this.silkwormblock.add(p2);
        }
        nbttaglist = nbttagcompound.func_150295_c("sugarcanesoils", 10);
        for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
            nbttagcompound1 = nbttaglist.func_150305_b(i);
            p2 = Point.read(nbttagcompound1, "pos");
            if (p2 == null) continue;
            this.sugarcanesoils.add(p2);
        }
        nbttaglist = nbttagcompound.func_150295_c("fishingspots", 10);
        for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
            nbttagcompound1 = nbttaglist.func_150305_b(i);
            p2 = Point.read(nbttagcompound1, "pos");
            if (p2 == null) continue;
            this.fishingspots.add(p2);
        }
        nbttaglist = nbttagcompound.func_150295_c("healingspots", 10);
        for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
            nbttagcompound1 = nbttaglist.func_150305_b(i);
            p2 = Point.read(nbttagcompound1, "pos");
            if (p2 == null) continue;
            this.healingspots.add(p2);
        }
        nbttaglist = nbttagcompound.func_150295_c("stalls", 10);
        for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
            nbttagcompound1 = nbttaglist.func_150305_b(i);
            p2 = Point.read(nbttagcompound1, "pos");
            if (p2 == null) continue;
            this.stalls.add(p2);
        }
        nbttaglist = nbttagcompound.func_150295_c("woodspawn", 10);
        for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
            nbttagcompound1 = nbttaglist.func_150305_b(i);
            p2 = Point.read(nbttagcompound1, "pos");
            if (p2 == null) continue;
            this.woodspawn.add(p2);
        }
        nbttaglist = nbttagcompound.func_150295_c("brickspot", 10);
        for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
            nbttagcompound1 = nbttaglist.func_150305_b(i);
            p2 = Point.read(nbttagcompound1, "pos");
            if (p2 == null) continue;
            this.brickspot.add(p2);
        }
        nbttaglist = nbttagcompound.func_150295_c("spawns", 10);
        for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
            nbttagcompound1 = nbttaglist.func_150305_b(i);
            String spawnType = nbttagcompound1.func_74779_i("type");
            if (spawnType.equals("ml_FarmPig")) {
                spawnType = "Pig";
            } else if (spawnType.equals("ml_FarmCow")) {
                spawnType = "Cow";
            } else if (spawnType.equals("ml_FarmChicken")) {
                spawnType = "Chicken";
            } else if (spawnType.equals("ml_FarmSheep")) {
                spawnType = "Sheep";
            }
            this.spawnTypes.add(spawnType);
            ArrayList<Point> v2 = new ArrayList<Point>();
            NBTTagList nbttaglist22 = nbttagcompound1.func_150295_c("points", 10);
            for (int j = 0; j < nbttaglist22.func_74745_c(); ++j) {
                NBTTagCompound nbttagcompound2 = nbttaglist22.func_150305_b(j);
                Point p3 = Point.read(nbttagcompound2, "pos");
                if (p3 == null) continue;
                v2.add(p3);
                if (MLN.LogHybernation < 2) continue;
                MLN.minor(this, "Loaded spawn point: " + p3);
            }
            this.spawns.add(v2);
            if (MLN.LogHybernation < 2) continue;
            MLN.minor(this, "Loaded " + v2.size() + " spawn points for " + this.spawnTypes.get(i));
        }
        nbttaglist = nbttagcompound.func_150295_c("mobspawns", 10);
        for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
            nbttagcompound1 = nbttaglist.func_150305_b(i);
            this.mobSpawnerTypes.add(nbttagcompound1.func_74779_i("type"));
            v = new ArrayList<Point>();
            nbttaglist2 = nbttagcompound1.func_150295_c("points", 10);
            for (int j = 0; j < nbttaglist2.func_74745_c(); ++j) {
                NBTTagCompound nbttagcompound2 = nbttaglist2.func_150305_b(j);
                p = Point.read(nbttagcompound2, "pos");
                if (p == null) continue;
                v.add(p);
                if (MLN.LogHybernation < 2) continue;
                MLN.minor(this, "Loaded spawn point: " + p);
            }
            this.mobSpawners.add(v);
            if (MLN.LogHybernation < 2) continue;
            MLN.minor(this, "Loaded " + v.size() + " mob spawn points for " + this.spawnTypes.get(i));
        }
        nbttaglist = nbttagcompound.func_150295_c("sources", 10);
        for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
            nbttagcompound1 = nbttaglist.func_150305_b(i);
            this.sourceTypes.add(Block.func_149729_e((int)nbttagcompound1.func_74762_e("type")));
            v = new ArrayList();
            nbttaglist2 = nbttagcompound1.func_150295_c("points", 10);
            for (int j = 0; j < nbttaglist2.func_74745_c(); ++j) {
                NBTTagCompound nbttagcompound2 = nbttaglist2.func_150305_b(j);
                p = Point.read(nbttagcompound2, "pos");
                if (p == null) continue;
                v.add(p);
                if (MLN.LogHybernation < 3) continue;
                MLN.debug(this, "Loaded source point: " + p);
            }
            this.sources.add(v);
            if (MLN.LogHybernation < 1) continue;
            MLN.debug(this, "Loaded " + v.size() + " sources points for " + this.sourceTypes.get(i).func_149739_a());
        }
        nbttaglist = nbttagcompound.func_150295_c("genericsoils", 10);
        for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
            nbttagcompound1 = nbttaglist.func_150305_b(i);
            String type = nbttagcompound1.func_74779_i("type");
            nbttaglist2 = nbttagcompound1.func_150295_c("points", 10);
            for (int j = 0; j < nbttaglist2.func_74745_c(); ++j) {
                NBTTagCompound nbttagcompound2 = nbttaglist2.func_150305_b(j);
                p = Point.read(nbttagcompound2, "pos");
                if (p == null) continue;
                this.addSoilPoint(type, p);
            }
        }
        for (Point p4 : this.chests) {
            if (!this.building.worldObj.func_72899_e(p4.getiX(), p4.getiY(), p4.getiZ()) || p4.getMillChest(this.building.worldObj) == null) continue;
            p4.getMillChest((World)this.building.worldObj).buildingPos = this.building.getPos();
        }
    }

    public void sendBuildingPacket(DataOutput data) throws IOException {
        StreamReadWrite.writePointList(this.chests, data);
        StreamReadWrite.writePointList(this.furnaces, data);
        StreamReadWrite.writePointList(this.signs, data);
    }

    public void setCraftingPos(Point p) {
        this.craftingPos = p;
    }

    public void setDefendingPos(Point p) {
        this.defendingPos = p;
    }

    public void setLeasurePos(Point p) {
        this.leasurePos = p;
    }

    public void setPathStartPos(Point p) {
        this.pathStartPos = p;
    }

    public void setSellingPos(Point p) {
        this.sellingPos = p;
    }

    public void setShelterPos(Point p) {
        this.shelterPos = p;
    }

    public void setSleepingPos(Point p) {
        this.sleepingPos = p;
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        NBTTagCompound nbttagcompound2;
        NBTTagList nbttaglist2;
        NBTTagCompound nbttagcompound1;
        int i;
        NBTTagCompound nbttagcompound12;
        if (this.sleepingPos != null) {
            this.sleepingPos.write(nbttagcompound, "spawnPos");
        }
        if (this.sellingPos != null) {
            this.sellingPos.write(nbttagcompound, "sellingPos");
        }
        if (this.craftingPos != null) {
            this.craftingPos.write(nbttagcompound, "craftingPos");
        }
        if (this.defendingPos != null) {
            this.defendingPos.write(nbttagcompound, "defendingPos");
        }
        if (this.shelterPos != null) {
            this.shelterPos.write(nbttagcompound, "shelterPos");
        }
        if (this.pathStartPos != null) {
            this.pathStartPos.write(nbttagcompound, "pathStartPos");
        }
        if (this.leasurePos != null) {
            this.leasurePos.write(nbttagcompound, "leasurePos");
        }
        NBTTagList nbttaglist = new NBTTagList();
        for (Point p : this.signs) {
            if (p == null) continue;
            nbttagcompound12 = new NBTTagCompound();
            p.write(nbttagcompound12, "pos");
            nbttaglist.func_74742_a((NBTBase)nbttagcompound12);
        }
        nbttagcompound.func_74782_a("signs", (NBTBase)nbttaglist);
        nbttaglist = new NBTTagList();
        for (Point p : this.netherwartsoils) {
            nbttagcompound12 = new NBTTagCompound();
            p.write(nbttagcompound12, "pos");
            nbttaglist.func_74742_a((NBTBase)nbttagcompound12);
        }
        nbttagcompound.func_74782_a("netherwartsoils", (NBTBase)nbttaglist);
        nbttaglist = new NBTTagList();
        for (Point p : this.silkwormblock) {
            nbttagcompound12 = new NBTTagCompound();
            p.write(nbttagcompound12, "pos");
            nbttaglist.func_74742_a((NBTBase)nbttagcompound12);
        }
        nbttagcompound.func_74782_a("silkwormblock", (NBTBase)nbttaglist);
        nbttaglist = new NBTTagList();
        for (Point p : this.sugarcanesoils) {
            nbttagcompound12 = new NBTTagCompound();
            p.write(nbttagcompound12, "pos");
            nbttaglist.func_74742_a((NBTBase)nbttagcompound12);
        }
        nbttagcompound.func_74782_a("sugarcanesoils", (NBTBase)nbttaglist);
        nbttaglist = new NBTTagList();
        for (Point p : this.fishingspots) {
            nbttagcompound12 = new NBTTagCompound();
            p.write(nbttagcompound12, "pos");
            nbttaglist.func_74742_a((NBTBase)nbttagcompound12);
        }
        nbttagcompound.func_74782_a("fishingspots", (NBTBase)nbttaglist);
        nbttaglist = new NBTTagList();
        for (Point p : this.healingspots) {
            nbttagcompound12 = new NBTTagCompound();
            p.write(nbttagcompound12, "pos");
            nbttaglist.func_74742_a((NBTBase)nbttagcompound12);
        }
        nbttagcompound.func_74782_a("healingspots", (NBTBase)nbttaglist);
        nbttaglist = new NBTTagList();
        for (Point p : this.stalls) {
            nbttagcompound12 = new NBTTagCompound();
            p.write(nbttagcompound12, "pos");
            nbttaglist.func_74742_a((NBTBase)nbttagcompound12);
        }
        nbttagcompound.func_74782_a("stalls", (NBTBase)nbttaglist);
        nbttaglist = new NBTTagList();
        for (Point p : this.woodspawn) {
            nbttagcompound12 = new NBTTagCompound();
            p.write(nbttagcompound12, "pos");
            nbttaglist.func_74742_a((NBTBase)nbttagcompound12);
        }
        nbttagcompound.func_74782_a("woodspawn", (NBTBase)nbttaglist);
        nbttaglist = new NBTTagList();
        for (Point p : this.brickspot) {
            nbttagcompound12 = new NBTTagCompound();
            p.write(nbttagcompound12, "pos");
            nbttaglist.func_74742_a((NBTBase)nbttagcompound12);
        }
        nbttagcompound.func_74782_a("brickspot", (NBTBase)nbttaglist);
        nbttaglist = new NBTTagList();
        for (i = 0; i < this.spawns.size(); ++i) {
            nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74778_a("type", this.spawnTypes.get(i));
            nbttaglist2 = new NBTTagList();
            for (Point p : this.spawns.get(i)) {
                nbttagcompound2 = new NBTTagCompound();
                p.write(nbttagcompound2, "pos");
                nbttaglist2.func_74742_a((NBTBase)nbttagcompound2);
            }
            nbttagcompound1.func_74782_a("points", (NBTBase)nbttaglist2);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74782_a("spawns", (NBTBase)nbttaglist);
        nbttaglist = new NBTTagList();
        for (i = 0; i < this.soilTypes.size(); ++i) {
            nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74778_a("type", this.soilTypes.get(i));
            nbttaglist2 = new NBTTagList();
            for (Point p : this.soils.get(i)) {
                nbttagcompound2 = new NBTTagCompound();
                p.write(nbttagcompound2, "pos");
                nbttaglist2.func_74742_a((NBTBase)nbttagcompound2);
            }
            nbttagcompound1.func_74782_a("points", (NBTBase)nbttaglist2);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74782_a("genericsoils", (NBTBase)nbttaglist);
        nbttaglist = new NBTTagList();
        for (i = 0; i < this.mobSpawners.size(); ++i) {
            nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74778_a("type", this.mobSpawnerTypes.get(i));
            nbttaglist2 = new NBTTagList();
            for (Point p : this.mobSpawners.get(i)) {
                nbttagcompound2 = new NBTTagCompound();
                p.write(nbttagcompound2, "pos");
                nbttaglist2.func_74742_a((NBTBase)nbttagcompound2);
            }
            nbttagcompound1.func_74782_a("points", (NBTBase)nbttaglist2);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74782_a("mobspawns", (NBTBase)nbttaglist);
        nbttaglist = new NBTTagList();
        for (i = 0; i < this.sources.size(); ++i) {
            nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74768_a("type", Block.func_149682_b((Block)this.sourceTypes.get(i)));
            nbttaglist2 = new NBTTagList();
            for (Point p : this.sources.get(i)) {
                nbttagcompound2 = new NBTTagCompound();
                p.write(nbttagcompound2, "pos");
                nbttaglist2.func_74742_a((NBTBase)nbttagcompound2);
            }
            nbttagcompound1.func_74782_a("points", (NBTBase)nbttaglist2);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74782_a("sources", (NBTBase)nbttaglist);
        nbttaglist = new NBTTagList();
        for (Point p : this.chests) {
            nbttagcompound12 = new NBTTagCompound();
            p.write(nbttagcompound12, "pos");
            nbttaglist.func_74742_a((NBTBase)nbttagcompound12);
        }
        nbttagcompound.func_74782_a("chests", (NBTBase)nbttaglist);
        nbttaglist = new NBTTagList();
        for (Point p : this.furnaces) {
            nbttagcompound12 = new NBTTagCompound();
            p.write(nbttagcompound12, "pos");
            nbttaglist.func_74742_a((NBTBase)nbttagcompound12);
        }
        nbttagcompound.func_74782_a("furnaces", (NBTBase)nbttaglist);
        nbttaglist = new NBTTagList();
        for (Point p : this.brewingStands) {
            nbttagcompound12 = new NBTTagCompound();
            p.write(nbttagcompound12, "pos");
            nbttaglist.func_74742_a((NBTBase)nbttagcompound12);
        }
        nbttagcompound.func_74782_a("brewingStands", (NBTBase)nbttaglist);
    }
}

