/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common.building;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.imageio.ImageIO;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.world.World;
import org.millenaire.common.Culture;
import org.millenaire.common.InvItem;
import org.millenaire.common.MLN;
import org.millenaire.common.MillWorld;
import org.millenaire.common.MillWorldInfo;
import org.millenaire.common.Point;
import org.millenaire.common.VillageType;
import org.millenaire.common.building.Building;
import org.millenaire.common.building.BuildingBlock;
import org.millenaire.common.building.BuildingFileFiler;
import org.millenaire.common.building.BuildingLocation;
import org.millenaire.common.building.BuildingPlanSet;
import org.millenaire.common.building.BuildingProject;
import org.millenaire.common.building.IBuildingPlan;
import org.millenaire.common.building.PointType;
import org.millenaire.common.core.MillCommonUtilities;
import org.millenaire.common.forge.Mill;
import org.millenaire.common.item.Goods;
import org.millenaire.common.network.ServerSender;
import org.millenaire.common.pathing.AStarPathing;

public class BuildingPlan
implements IBuildingPlan {
    public static final String bempty = "empty";
    public static final String bpreserveground = "preserveground";
    public static final String ballbuttrees = "allbuttrees";
    public static final String bgrass = "grass";
    public static final String bsoil = "soil";
    public static final String bricesoil = "ricesoil";
    public static final String bturmericsoil = "turmericsoil";
    public static final String bmaizesoil = "maizesoil";
    public static final String bcarrotsoil = "carrotsoil";
    public static final String bpotatosoil = "potatosoil";
    public static final String bsugarcanesoil = "sugarcanesoil";
    public static final String bnetherwartsoil = "netherwartsoil";
    public static final String bvinesoil = "vinesoil";
    public static final String bsilkwormblock = "silkwormblock";
    public static final String bcacaospot = "cacaospot";
    public static final String blockedchest = "lockedchest";
    public static final String bmainchest = "mainchest";
    public static final String bsleepingPos = "sleepingPos";
    public static final String bsellingPos = "sellingPos";
    public static final String bcraftingPos = "craftingPos";
    public static final String bdefendingPos = "defendingPos";
    public static final String bshelterPos = "shelterPos";
    public static final String bpathStartPos = "pathStartPos";
    public static final String bleasurePos = "leasurePos";
    public static final String blogoakvert = "logoakvert";
    public static final String blogoakhor = "logoakhor";
    public static final String blogpinevert = "logpinevert";
    public static final String blogpinehor = "logpinehor";
    public static final String blogbirchvert = "logbirchvert";
    public static final String blogbirchhor = "logbirchhor";
    public static final String blogjunglevert = "logjunglevert";
    public static final String blogjunglehor = "logjunglehor";
    public static final String bstonestairGuess = "stonestairGuess";
    public static final String bladderGuess = "ladderGuess";
    public static final String bsignwallGuess = "signwallGuess";
    public static final String bwoodstairsOakGuess = "woodstairsOakGuess";
    public static final String bwoodstairsOakTop = "woodstairsOakTop";
    public static final String bwoodstairsOakBottom = "woodstairsOakBottom";
    public static final String bwoodstairsOakLeft = "woodstairsOakLeft";
    public static final String bwoodstairsOakRight = "woodstairsOakRight";
    public static final String bwoodstairsPineTop = "woodstairsPineTop";
    public static final String bwoodstairsPineBottom = "woodstairsPineBottom";
    public static final String bwoodstairsPineLeft = "woodstairsPineLeft";
    public static final String bwoodstairsPineRight = "woodstairsPineRight";
    public static final String bwoodstairsBirchTop = "woodstairsBirchTop";
    public static final String bwoodstairsBirchBottom = "woodstairsBirchBottom";
    public static final String bwoodstairsBirchLeft = "woodstairsBirchLeft";
    public static final String bwoodstairsBirchRight = "woodstairsBirchRight";
    public static final String bwoodstairsJungleTop = "woodstairsJungleTop";
    public static final String bwoodstairsJungleBottom = "woodstairsJungleBottom";
    public static final String bwoodstairsJungleLeft = "woodstairsJungleLeft";
    public static final String bwoodstairsJungleRight = "woodstairsJungleRight";
    public static final String bstonestairsTop = "stonestairsTop";
    public static final String bstonestairsBottom = "stonestairsBottom";
    public static final String bstonestairsLeft = "stonestairsLeft";
    public static final String bstonestairsRight = "stonestairsRight";
    public static final String bstonebrickstairsTop = "stonebrickstairsTop";
    public static final String bstonebrickstairsBottom = "stonebrickstairsBottom";
    public static final String bstonebrickstairsLeft = "stonebrickstairsLeft";
    public static final String bstonebrickstairsRight = "stonebrickstairsRight";
    public static final String bbrickstairsTop = "brickstairsTop";
    public static final String bbrickstairsBottom = "brickstairsBottom";
    public static final String bbrickstairsLeft = "brickstairsLeft";
    public static final String bbrickstairsRight = "brickstairsRight";
    public static final String bsandstonestairsTop = "sandstonestairsTop";
    public static final String bsandstonestairsBottom = "sandstonestairsBottom";
    public static final String bsandstonestairsLeft = "sandstonestairsLeft";
    public static final String bsandstonestairsRight = "sandstonestairsRight";
    public static final String bwoodstairsOakInvTop = "woodstairsOakInvTop";
    public static final String bwoodstairsOakInvBottom = "woodstairsOakInvBottom";
    public static final String bwoodstairsOakInvLeft = "woodstairsOakInvLeft";
    public static final String bwoodstairsOakInvRight = "woodstairsOakInvRight";
    public static final String bwoodstairsPineInvTop = "woodstairsPineInvTop";
    public static final String bwoodstairsPineInvBottom = "woodstairsPineInvBottom";
    public static final String bwoodstairsPineInvLeft = "woodstairsPineInvLeft";
    public static final String bwoodstairsPineInvRight = "woodstairsPineInvRight";
    public static final String bwoodstairsBirchInvTop = "woodstairsBirchInvTop";
    public static final String bwoodstairsBirchInvBottom = "woodstairsBirchInvBottom";
    public static final String bwoodstairsBirchInvLeft = "woodstairsBirchInvLeft";
    public static final String bwoodstairsBirchInvRight = "woodstairsBirchInvRight";
    public static final String bwoodstairsJungleInvTop = "woodstairsJungleInvTop";
    public static final String bwoodstairsJungleInvBottom = "woodstairsJungleInvBottom";
    public static final String bwoodstairsJungleInvLeft = "woodstairsJungleInvLeft";
    public static final String bwoodstairsJungleInvRight = "woodstairsJungleInvRight";
    public static final String bstonestairsInvTop = "stonestairsInvTop";
    public static final String bstonestairsInvBottom = "stonestairsInvBottom";
    public static final String bstonestairsInvLeft = "stonestairsInvLeft";
    public static final String bstonestairsInvRight = "stonestairsInvRight";
    public static final String bstonebrickstairsInvTop = "stonebrickstairsInvTop";
    public static final String bstonebrickstairsInvBottom = "stonebrickstairsInvBottom";
    public static final String bstonebrickstairsInvLeft = "stonebrickstairsInvLeft";
    public static final String bstonebrickstairsInvRight = "stonebrickstairsInvRight";
    public static final String bbrickstairsInvTop = "brickstairsInvTop";
    public static final String bbrickstairsInvBottom = "brickstairsInvBottom";
    public static final String bbrickstairsInvLeft = "brickstairsInvLeft";
    public static final String bbrickstairsInvRight = "brickstairsInvRight";
    public static final String bsandstonestairsInvTop = "sandstonestairsInvTop";
    public static final String bsandstonestairsInvBottom = "sandstonestairsInvBottom";
    public static final String bsandstonestairsInvLeft = "sandstonestairsInvLeft";
    public static final String bsandstonestairsInvRight = "sandstonestairsInvRight";
    public static final String bbyzantinetiles_bottomtop = "byzantinetiles_bottomtop";
    public static final String bbyzantinetiles_leftright = "byzantinetiles_leftright";
    public static final String bbyzantinestonetiles_bottomtop = "byzantinestonetiles_bottomtop";
    public static final String bbyzantinestonetiles_leftright = "byzantinestonetiles_leftright";
    public static final String bbyzantineslab_bottomtop = "byzantinetileslab_bottomtop";
    public static final String bbyzantineslab_leftright = "byzantinetileslab_leftright";
    public static final String bbyzantineslab_bottomtop_inv = "byzantinetileslab_bottomtop_inv";
    public static final String bbyzantineslab_leftright_inv = "byzantinetileslab_leftright_inv";
    public static final String bsignpostTop = "signpostTop";
    public static final String bsignpostBottom = "signpostBottom";
    public static final String bsignpostLeft = "signpostLeft";
    public static final String bsignpostRight = "signpostRight";
    public static final String bsignwallTop = "signwallTop";
    public static final String bsignwallBottom = "signwallBottom";
    public static final String bsignwallLeft = "signwallLeft";
    public static final String bsignwallRight = "signwallRight";
    public static final String bladderTop = "ladderTop";
    public static final String bladderBottom = "ladderBottom";
    public static final String bladderLeft = "ladderLeft";
    public static final String bladderRight = "ladderRight";
    public static final String bcowspawn = "cowspawn";
    public static final String bsheepspawn = "sheepspawn";
    public static final String bchickenspawn = "chickenspawn";
    public static final String bpigspawn = "pigspawn";
    public static final String bsquidspawn = "squidspawn";
    public static final String bwolfspawn = "wolfspawn";
    public static final String bstonesource = "stonesource";
    public static final String bsandsource = "sandsource";
    public static final String bsandstonesource = "sandstonesource";
    public static final String bclaysource = "claysource";
    public static final String bgravelsource = "gravelsource";
    public static final String bfurnace = "furnace";
    public static final String bfreestone = "freestone";
    public static final String bfreesand = "freesand";
    public static final String bfreesandstone = "freesandstone";
    public static final String bfreegravel = "freegravel";
    public static final String btapestry = "tapestry";
    public static final String bstall = "stall";
    public static final String bfreewool = "freewool";
    public static final String bdoorTop = "doorTop";
    public static final String bdoorBottom = "doorBottom";
    public static final String bdoorRight = "doorRight";
    public static final String bdoorLeft = "doorLeft";
    public static final String birondoorTop = "irondoorTop";
    public static final String birondoorBottom = "irondoorBottom";
    public static final String birondoorRight = "irondoorRight";
    public static final String birondoorLeft = "irondoorLeft";
    public static final String btrapdoorTop = "trapdoorTop";
    public static final String btrapdoorBottom = "trapdoorBottom";
    public static final String btrapdoorRight = "trapdoorRight";
    public static final String btrapdoorLeft = "trapdoorLeft";
    public static final String bfenceGateHorizontal = "fencegateHorizontal";
    public static final String bfenceGateVertical = "fencegateVertical";
    public static final String bbedTop = "bedTop";
    public static final String bbedBottom = "bedBottom";
    public static final String bbedRight = "bedRight";
    public static final String bbedLeft = "bedLeft";
    public static final String boakspawn = "oakspawn";
    public static final String bpinespawn = "pinespawn";
    public static final String bbirchspawn = "birchspawn";
    public static final String bjunglespawn = "junglespawn";
    public static final String bbrickspot = "brickspot";
    public static final String bindianstatue = "indianstatue";
    public static final String bmayanstatue = "mayanstatue";
    public static final String bbyzantineiconsmall = "byzantineiconsmall";
    public static final String bbyzantineiconmedium = "byzantineiconmedium";
    public static final String bbyzantineiconlarge = "byzantineiconlarge";
    public static final String bfishingspot = "fishingspot";
    public static final String bspawnerskeleton = "spawnerskeleton";
    public static final String bspawnerzombie = "spawnerzombie";
    public static final String bspawnerspider = "spawnerspider";
    public static final String bspawnercavespider = "spawnercavespider";
    public static final String bspawnercreeper = "spawnercreeper";
    public static final String bspawnerblaze = "spawnerblaze";
    public static final String bdispenserunknownpowder = "dispenserunknownpowder";
    public static final String bhealingspot = "healingspot";
    public static final String bplainSignGuess = "plainSignGuess";
    public static final String bbrewingstand = "brewingstand";
    public static HashMap<Character, PointType> charPoints;
    public static HashMap<Integer, PointType> colourPoints;
    public static HashMap<Integer, PointType> reverseColourPoints;
    public static final int EAST_FACING = 3;
    private static final String EOL;
    public static boolean loadingDone;
    public static final int NORTH_FACING = 0;
    private static final String prefixWoodstairOak = "woodstairsOak";
    private static final String prefixWoodstairPine = "woodstairsPine";
    private static final String prefixWoodstairBirch = "woodstairsBirch";
    private static final String prefixWoodstairJungle = "woodstairsJungle";
    private static final String prefixStonestair = "stonestair";
    private static final String prefixBrickstair = "brickstairs";
    private static final String prefixBrickStonestair = "stonebrickstairs";
    private static final String prefixSandStoneStair = "standstonestairs";
    private static final String prefixLadder = "ladder";
    private static final String prefixSign = "sign";
    private static final String prefixDoor = "door";
    private static final String prefixTrapdoor = "trapdoor";
    private static final String prefixBed = "bed";
    public static final int SOUTH_FACING = 2;
    public static final int WEST_FACING = 1;
    public static String TYPE_SUBBUILDING;
    public int startLevel;
    public int areaToClear;
    public int length;
    public int width;
    public int nbfloors;
    public int lengthOffset;
    public int widthOffset;
    public int buildingOrientation;
    public String nativeName;
    public String shop;
    public final HashMap<String, String> names = new HashMap();
    public List<String> maleResident = new ArrayList<String>();
    public List<String> femaleResident = new ArrayList<String>();
    public boolean isUpdate = false;
    public int level;
    public int max;
    public int priority;
    public int reputation;
    public int price;
    public int priorityMoveIn;
    public boolean isgift = false;
    public float minDistance;
    public float maxDistance;
    public String requiredTag = null;
    public int nbBlocksToPut = 0;
    public PointType[][][] plan = null;
    public String planName = "";
    public String buildingKey;
    public String type = null;
    public HashMap<InvItem, Integer> resCost;
    public int[] signOrder;
    public List<String> tags;
    public int variation;
    public List<String> subBuildings;
    public List<String> startingSubBuildings;
    public boolean showTownHallSigns = true;
    public List<StartingGood> startingGoods;
    public String exploreTag = null;
    public int irrigation = 0;
    public Culture culture;
    public int pathLevel = 0;
    public int pathWidth = 2;
    public boolean rebuildPath = false;
    public BuildingPlan parent;

    public static Point adjustForOrientation(int x, int y, int z, int xoffset, int zoffset, int orientation) {
        Point pos = null;
        if (orientation == 0) {
            pos = new Point(x + xoffset, y, z + zoffset);
        } else if (orientation == 1) {
            pos = new Point(x + zoffset, y, z - xoffset);
        } else if (orientation == 2) {
            pos = new Point(x - xoffset, y, z - zoffset);
        } else if (orientation == 3) {
            pos = new Point(x - zoffset, y, z + xoffset);
        }
        return pos;
    }

    public static void exportBuilding(EntityPlayer player, World world, Point startPoint) {
        try {
            PointType pt;
            int zEnd;
            int xEnd;
            TileEntitySign sign = startPoint.getSign(world);
            if (sign == null) {
                return;
            }
            if (sign.field_145915_a[0] == null || sign.field_145915_a[0].length() == 0) {
                Mill.proxy.localTranslatedSentence(Mill.proxy.getTheSinglePlayer(), '6', "export.errornoname", new String[0]);
                return;
            }
            String planName = sign.field_145915_a[0];
            boolean found = false;
            for (xEnd = startPoint.getiX() + 1; !found && xEnd < startPoint.getiX() + 257; ++xEnd) {
                Block block = world.func_147439_a(xEnd, startPoint.getiY(), startPoint.getiZ());
                if (block != Blocks.field_150472_an) continue;
                found = true;
                break;
            }
            if (!found) {
                Mill.proxy.localTranslatedSentence(Mill.proxy.getTheSinglePlayer(), '6', "export.errornoendsigneast", new String[0]);
                return;
            }
            found = false;
            for (zEnd = startPoint.getiZ() + 1; !found && zEnd < startPoint.getiZ() + 257; ++zEnd) {
                Block block = world.func_147439_a(startPoint.getiX(), startPoint.getiY(), zEnd);
                if (block != Blocks.field_150472_an) continue;
                found = true;
                break;
            }
            if (!found) {
                Mill.proxy.localTranslatedSentence(Mill.proxy.getTheSinglePlayer(), '6', "export.errornoendsignsouth", new String[0]);
                return;
            }
            int length = xEnd - startPoint.getiX() - 1;
            int width = zEnd - startPoint.getiZ() - 1;
            File exportDir = new File(Mill.proxy.getCustomDir(), "exports");
            if (!exportDir.exists()) {
                exportDir.mkdirs();
            }
            File buildingFile = new File(exportDir, planName + "_A.txt");
            PointType[][][] existingPoints = null;
            int existingMinLevel = 0;
            int upgradeLevel = 0;
            if (buildingFile.exists()) {
                BuildingPlanSet existingSet = new BuildingPlanSet(null, buildingFile.getName().substring(0, buildingFile.getName().length() - 6), exportDir);
                existingSet.loadPictPlans(true);
                if (existingSet.plans.get((int)0)[0].length != length) {
                    Mill.proxy.localTranslatedSentence(Mill.proxy.getTheSinglePlayer(), '6', "export.errorlength", "" + length, "" + existingSet.plans.get((int)0)[0].length);
                    return;
                }
                if (existingSet.plans.get((int)0)[0].width != width) {
                    Mill.proxy.localTranslatedSentence(Mill.proxy.getTheSinglePlayer(), '6', "export.errorwidth", "" + width, "" + existingSet.plans.get((int)0)[0].width);
                    return;
                }
                existingPoints = existingSet.getConsolidatedPlan(0, existingSet.plans.get(0).length - 1);
                existingMinLevel = existingSet.getMinLevel(0, existingSet.plans.get(0).length - 1);
                upgradeLevel = existingSet.plans.get(0).length;
            }
            int startLevel = -1;
            if (sign.field_145915_a[2] != null && sign.field_145915_a[2].length() > 0) {
                try {
                    startLevel = Integer.parseInt(sign.field_145915_a[2]);
                }
                catch (Exception e) {
                    Mill.proxy.localTranslatedSentence(Mill.proxy.getTheSinglePlayer(), '6', "export.errorstartinglevel", new String[0]);
                }
            } else {
                Mill.proxy.localTranslatedSentence(Mill.proxy.getTheSinglePlayer(), 'f', "export.defaultstartinglevel", new String[0]);
            }
            boolean exportSnow = false;
            if (sign.field_145915_a[3] != null && sign.field_145915_a[3].equals("snow")) {
                exportSnow = true;
            }
            ArrayList<PointType[][]> export = new ArrayList<PointType[][]>();
            boolean stop = false;
            int j = 0;
            while (!stop) {
                PointType[][] level = new PointType[length][width];
                boolean blockFound = false;
                for (int i = 0; i < length; ++i) {
                    for (int k = 0; k < width; ++k) {
                        level[i][k] = null;
                        Block block = world.func_147439_a(i + startPoint.getiX() + 1, j + startPoint.getiY() + startLevel, k + startPoint.getiZ() + 1);
                        int meta = world.func_72805_g(i + startPoint.getiX() + 1, j + startPoint.getiY() + startLevel, k + startPoint.getiZ() + 1);
                        if (block != Blocks.field_150350_a) {
                            blockFound = true;
                        }
                        if ((pt = reverseColourPoints.get(MillCommonUtilities.getPointHash(block, meta))) != null) {
                            if (!exportSnow && pt.block == Blocks.field_150433_aE) continue;
                            PointType existing = null;
                            if (existingPoints != null && j + startLevel >= existingMinLevel && j + startLevel < existingMinLevel + existingPoints.length && (existing = existingPoints[j + startLevel - existingMinLevel][i][k]) == null) {
                                MLN.major(null, "Existing pixel is null");
                            }
                            if (existing == null) {
                                if (pt.name == null && pt.block == Blocks.field_150350_a && upgradeLevel == 0) continue;
                                level[i][k] = pt;
                                continue;
                            }
                            if (existing == pt || existing.isType(bempty) && pt.block != Blocks.field_150350_a) continue;
                            level[i][k] = pt;
                            continue;
                        }
                        Mill.proxy.localTranslatedSentence(Mill.proxy.getTheSinglePlayer(), '6', "export.errorunknownblockid", "" + block + "/" + meta + "/" + MillCommonUtilities.getPointHash(block, meta));
                    }
                }
                if (blockFound) {
                    export.add(level);
                } else {
                    stop = true;
                }
                if (++j + startPoint.getiY() + startLevel < 256) continue;
                stop = true;
            }
            BufferedImage pict = new BufferedImage(export.size() * width + export.size() - 1, length, 1);
            Graphics2D graphics = pict.createGraphics();
            graphics.setColor(new Color(11730865));
            graphics.fillRect(0, 0, pict.getWidth(), pict.getHeight());
            for (j = 0; j < export.size(); ++j) {
                PointType[][] level = (PointType[][])export.get(j);
                for (int i = 0; i < length; ++i) {
                    for (int k = 0; k < width; ++k) {
                        int colour = 0xFFFFFF;
                        pt = level[i][k];
                        if (pt != null) {
                            colour = pt.colour;
                        }
                        graphics.setColor(new Color(colour));
                        graphics.fillRect(j * width + j + width - k - 1, i, 1, 1);
                    }
                }
            }
            String fileName = planName + "_A" + upgradeLevel + ".png";
            ImageIO.write((RenderedImage)pict, "png", new File(exportDir, fileName));
            if (upgradeLevel == 0) {
                BufferedWriter writer = MillCommonUtilities.getWriter(new File(exportDir, planName + "_A.txt"));
                writer.write("native:nameinvillagelangue;name_en:inenglish;name_fr:enfrancais;around:4;startLevel:" + startLevel + ";orientation:3;width:" + width + ";length:" + length);
                writer.close();
            } else {
                BufferedReader reader = MillCommonUtilities.getReader(new File(exportDir, planName + "_A.txt"));
                ArrayList<String> existing = new ArrayList<String>();
                String line = reader.readLine();
                while (line != null) {
                    existing.add(line);
                    line = reader.readLine();
                }
                reader.close();
                for (int i = existing.size(); i <= upgradeLevel; ++i) {
                    existing.add("");
                }
                existing.add(upgradeLevel, "startLevel:" + startLevel);
                BufferedWriter writer = MillCommonUtilities.getWriter(new File(exportDir, planName + "_A.txt"));
                for (String s : existing) {
                    writer.write(s + MLN.EOL);
                }
                writer.close();
            }
            Mill.proxy.localTranslatedSentence(Mill.proxy.getTheSinglePlayer(), 'f', "export.buildingexported", planName);
        }
        catch (Exception e) {
            MLN.printException("Error when trying to store a building: ", e);
        }
    }

    public static void generateBuildingRes() {
        File file = new File(Mill.proxy.getBaseDir(), "resources used.txt");
        try {
            BufferedWriter writer = MillCommonUtilities.getWriter(file);
            if (MLN.DEV) {
                BuildingPlan.generateSignBuildings(writer);
            }
            for (Culture culture : Culture.ListCultures) {
                writer.write(culture.key + ": " + EOL);
                BuildingPlan.generateVillageTypeListing(writer, culture.listVillageTypes);
                writer.write(EOL);
                BuildingPlan.generateVillageTypeListing(writer, culture.listLoneBuildingTypes);
            }
            writer.write(EOL);
            writer.write(EOL);
            for (Culture culture : Culture.ListCultures) {
                for (BuildingPlanSet set : culture.ListPlanSets) {
                    writer.write(set.plans.get((int)0)[0].nativeName + EOL + set.plans.get((int)0)[0].buildingKey + EOL + EOL);
                    writer.write("==Requirements==" + EOL);
                    for (BuildingPlan[] plans : set.plans) {
                        if (set.plans.size() > 1) {
                            writer.write("===Variation " + (char)(65 + plans[0].variation) + "===" + EOL);
                        }
                        for (BuildingPlan plan : plans) {
                            if (plan.level == 0) {
                                writer.write("Initial Construction" + EOL + EOL);
                            } else {
                                writer.write("Upgrade " + plan.level + EOL + EOL);
                            }
                            writer.write("{| border=\"1\" cellpadding=\"1\" cellspacing=\"1\" style=\"width: 300px;\"" + EOL);
                            writer.write("! scope=\"col\"|Resource" + EOL);
                            writer.write("! scope=\"col\"|Quantity" + EOL);
                            for (InvItem key : plan.resCost.keySet()) {
                                writer.write("|-" + EOL);
                                writer.write("| style=\"text-align: center; \"|" + key.getName() + EOL);
                                writer.write("| style=\"text-align: center; \"|" + plan.resCost.get(key) + EOL);
                            }
                            writer.write("|}" + EOL + EOL + EOL);
                        }
                    }
                }
            }
            writer.close();
        }
        catch (Exception e) {
            MLN.printException(e);
        }
        if (MLN.LogBuildingPlan >= 1) {
            MLN.major(null, "Wrote resources used.txt");
        }
    }

    private static void generateColourSheet() {
        if (MLN.LogBuildingPlan >= 1) {
            MLN.major(null, "Generating colour sheet.");
        }
        BufferedImage pict = new BufferedImage(200, colourPoints.size() * 20 + 25, 1);
        Graphics2D graphics = pict.createGraphics();
        graphics.setColor(new Color(0xFFFFFF));
        graphics.fillRect(0, 0, pict.getWidth(), pict.getHeight());
        graphics.setColor(new Color(0));
        graphics.drawString("Generated colour sheet.", 5, 20);
        int pos = 1;
        for (File loadDir : Mill.loadingDirs) {
            File mainList = new File(loadDir, "blocklist.txt");
            if (!mainList.exists()) continue;
            pos = BuildingPlan.generateColourSheetHandleFile(graphics, pos, mainList);
        }
        try {
            ImageIO.write((RenderedImage)pict, "png", new File(Mill.proxy.getBaseDir(), "Colour Sheet.png"));
        }
        catch (Exception e) {
            MLN.printException(e);
        }
        if (MLN.LogBuildingPlan >= 1) {
            MLN.major(null, "Finished generating colour sheet.");
        }
    }

    private static int generateColourSheetHandleFile(Graphics2D graphics, int pos, File file) {
        try {
            String line;
            BufferedReader reader = MillCommonUtilities.getReader(file);
            while ((line = reader.readLine()) != null) {
                if (line.trim().length() <= 0 || line.startsWith("//")) continue;
                String[] params = line.split(";", -1);
                String[] rgb = params[4].split("/", -1);
                int colour = (Integer.parseInt(rgb[0]) << 16) + (Integer.parseInt(rgb[1]) << 8) + (Integer.parseInt(rgb[2]) << 0);
                graphics.setColor(new Color(0));
                graphics.drawString(params[0], 20, 17 + 20 * pos);
                graphics.setColor(new Color(colour));
                graphics.fillRect(0, 5 + 20 * pos, 15, 15);
                ++pos;
            }
        }
        catch (Exception e) {
            MLN.printException(e);
        }
        return pos;
    }

    private static void generateSignBuildings(BufferedWriter writer) throws Exception {
        writer.write(EOL + EOL + EOL + "Buildings with signs (not panels):" + EOL + EOL + EOL);
        for (Culture culture : Culture.ListCultures) {
            for (BuildingPlanSet set : culture.ListPlanSets) {
                for (BuildingPlan[] plans : set.plans) {
                    for (BuildingPlan plan : plans) {
                        if (plan.tags.contains("hof")) continue;
                        PointType[][][] arr$ = plan.plan;
                        int len$ = arr$.length;
                        for (int i$ = 0; i$ < len$; ++i$) {
                            PointType[][] level;
                            PointType[][] arr$2 = level = arr$[i$];
                            int len$2 = arr$2.length;
                            for (int i$2 = 0; i$2 < len$2; ++i$2) {
                                PointType[] row;
                                for (PointType pt : row = arr$2[i$2]) {
                                    if (pt == null || pt.name == null || !pt.name.startsWith(bplainSignGuess)) continue;
                                    writer.write("Sign in " + plan.toString() + EOL);
                                }
                            }
                        }
                    }
                }
            }
        }
        writer.write(EOL + EOL + EOL);
    }

    private static void generateVillageTypeListing(BufferedWriter writer, List<VillageType> villages) throws IOException {
        for (VillageType villageType : villages) {
            HashMap<InvItem, Integer> cultureRes = new HashMap<InvItem, Integer>();
            for (List<BuildingProject> projects : villageType.getBuildingProjects().values()) {
                for (BuildingProject project : projects) {
                    if (project.planSet == null) continue;
                    for (BuildingPlan[] plans : project.planSet.plans) {
                        for (BuildingPlan plan : plans) {
                            for (InvItem key : plan.resCost.keySet()) {
                                if (cultureRes.containsKey(key)) {
                                    cultureRes.put(key, (Integer)cultureRes.get(key) + plan.resCost.get(key));
                                    continue;
                                }
                                cultureRes.put(key, plan.resCost.get(key));
                            }
                        }
                    }
                }
            }
            writer.write(villageType.key + " resource use: " + EOL);
            for (InvItem key : cultureRes.keySet()) {
                writer.write(key.getName() + ": " + cultureRes.get(key) + EOL);
            }
            writer.write(EOL);
        }
    }

    public static void generateWikiTable() throws MLN.MillenaireException {
        HashMap<InvItem, String> picts = new HashMap<InvItem, String>();
        HashMap<InvItem, String> links = new HashMap<InvItem, String>();
        picts.put(new InvItem(Blocks.field_150364_r, -1), "Wood_Any.gif");
        picts.put(new InvItem(Blocks.field_150364_r, 0), "Wood.png");
        picts.put(new InvItem(Blocks.field_150364_r, 1), "Wood_Pine.png");
        picts.put(new InvItem(Blocks.field_150364_r, 2), "Wood_Birch.png");
        picts.put(new InvItem(Blocks.field_150364_r, 3), "Wood_Jungle.png");
        picts.put(new InvItem(Blocks.field_150348_b, 0), "Stone.png");
        picts.put(new InvItem(Blocks.field_150359_w, 0), "Glass.png");
        picts.put(new InvItem(Blocks.field_150325_L, 0), "White_Wool.png");
        picts.put(new InvItem(Blocks.field_150322_A, 0), "Sandstone.png");
        picts.put(new InvItem(Blocks.field_150347_e, 0), "Cobblestone.png");
        picts.put(new InvItem(Blocks.field_150336_V, 0), "Brick.png");
        picts.put(new InvItem((Block)Blocks.field_150354_m, 0), "Sand.png");
        picts.put(new InvItem(Blocks.field_150426_aN, 0), "Glowstone_(Block).png");
        picts.put(new InvItem(Blocks.field_150342_X, 0), "Bookshelf.png");
        picts.put(new InvItem(Blocks.field_150351_n, 0), "Gravel.png");
        picts.put(new InvItem(Blocks.field_150322_A, 2), "SmoothSandstone.png");
        picts.put(new InvItem(Blocks.field_150417_aV, 3), "ChiselledStoneBricks.png");
        picts.put(new InvItem(Blocks.field_150417_aV, 2), "CrackedStoneBricks.png");
        picts.put(new InvItem((Block)Blocks.field_150329_H, 1), "TallGrass.png");
        picts.put(new InvItem((Block)Blocks.field_150329_H, 2), "Fern.png");
        picts.put(new InvItem(Blocks.field_150341_Y, 0), "MossyCobblestone.png");
        picts.put(new InvItem(Blocks.field_150417_aV, 1), "MossyStoneBricks.png");
        picts.put(new InvItem(Blocks.field_150366_p, 0), "Ore_Iron.png");
        picts.put(new InvItem(Blocks.field_150365_q, 0), "Ore_Coal.png");
        picts.put(new InvItem(Blocks.field_150352_o, 0), "Ore_Gold.png");
        picts.put(new InvItem(Blocks.field_150450_ax, 0), "Ore_Redstone.png");
        picts.put(new InvItem(Blocks.field_150369_x, 0), "Ore_Lapis_Lazuli.png");
        picts.put(new InvItem(Blocks.field_150482_ag, 0), "Ore_Diamond.png");
        picts.put(new InvItem(Blocks.field_150428_aP, 0), "Jack-O-Lantern.png");
        picts.put(new InvItem(Blocks.field_150440_ba, 0), "Melon (Block).png");
        picts.put(new InvItem(Blocks.field_150368_y, 0), "Lapis_Lazuli_(Block).png");
        picts.put(new InvItem(Blocks.field_150437_az, 0), "Redstone_Torch.png");
        picts.put(new InvItem(Blocks.field_150357_h, 0), "Bedrock.png");
        picts.put(new InvItem(Blocks.field_150388_bm, 0), "Nether_Wart.png");
        picts.put(new InvItem(Blocks.field_150353_l, 0), "Lava.png");
        picts.put(new InvItem((Block)Blocks.field_150356_k, 0), "Lava.png");
        picts.put(new InvItem(Blocks.field_150430_aB, 0), "Stone_Button.png");
        picts.put(new InvItem((Block)Blocks.field_150488_af, 0), "Redstone_Dust.png");
        picts.put(new InvItem(Blocks.field_150348_b, 0), "Stone.png");
        picts.put(new InvItem(Items.field_151042_j, 0), "Ironitm.png");
        picts.put(new InvItem(Items.field_151043_k, 0), "Golditm.png");
        picts.put(new InvItem(Mill.wood_decoration, 0), "ML_colombages_plain.png");
        links.put(new InvItem(Mill.wood_decoration, 0), "|link=Norman:Colombages");
        picts.put(new InvItem(Mill.wood_decoration, 1), "ML_colombages_cross.png");
        links.put(new InvItem(Mill.wood_decoration, 1), "|link=Norman:Colombages");
        picts.put(new InvItem(Mill.wood_decoration, 2), "ML_Thatch.png");
        links.put(new InvItem(Mill.wood_decoration, 2), "|link=Japanese:Thatch");
        picts.put(new InvItem(Mill.stone_decoration, 0), "ML_whitewashedbricks.png");
        links.put(new InvItem(Mill.stone_decoration, 0), "|link=Hindi:Cooked brick");
        picts.put(new InvItem(Mill.stone_decoration, 1), "ML_mudbrick.png");
        links.put(new InvItem(Mill.stone_decoration, 1), "|link=Hindi:Mud brick");
        picts.put(new InvItem(Mill.stone_decoration, 2), "ML_Mayan_Gold.png");
        links.put(new InvItem(Mill.stone_decoration, 2), "|link=Mayan:Gold Ornament");
        picts.put(new InvItem(Mill.paperWall, 0), "ML_paperwall.png");
        links.put(new InvItem(Mill.paperWall, 0), "|link=Japanese:Paper Wall");
        picts.put(new InvItem(Mill.tapestry, 0), "ML_tapestry.png");
        links.put(new InvItem(Mill.tapestry, 0), "|link=Norman:Tapisserie");
        picts.put(new InvItem(Mill.indianstatue, 0), "ML_IndianStatue.png");
        links.put(new InvItem(Mill.indianstatue, 0), "|link=Hindi:Statue");
        picts.put(new InvItem(Mill.mayanstatue, 0), "ML_MayanStatue.png");
        links.put(new InvItem(Mill.mayanstatue, 0), "|link=Mayan:Carving");
        picts.put(new InvItem(Mill.byzantineiconsmall, 0), "ML_ByzantineIconSmall.png");
        links.put(new InvItem(Mill.byzantineiconsmall, 0), "|link=Byzantine:IIcon");
        picts.put(new InvItem(Mill.byzantineiconmedium, 0), "ML_ByzantineIconMedium.png");
        links.put(new InvItem(Mill.byzantineiconmedium, 0), "|link=Byzantine:IIcon");
        picts.put(new InvItem(Mill.byzantineiconlarge, 0), "ML_ByzantineIconLarge.png");
        links.put(new InvItem(Mill.byzantineiconlarge, 0), "|link=Byzantine:IIcon");
        picts.put(new InvItem(Mill.byzantine_tiles, 0), "ML_byzSlab.png");
        links.put(new InvItem(Mill.byzantine_tiles, 0), "|link=Blocks#Byzantine");
        try {
            HashMap<String, Integer> nameCount = new HashMap<String, Integer>();
            HashMap<BuildingPlanSet, String> uniqueNames = new HashMap<BuildingPlanSet, String>();
            for (Culture culture : Culture.ListCultures) {
                for (BuildingPlanSet set : culture.ListPlanSets) {
                    String name = set.plans.get((int)0)[0].nativeName;
                    if (!nameCount.containsKey(name)) {
                        nameCount.put(name, 1);
                        continue;
                    }
                    nameCount.put(name, (Integer)nameCount.get(name) + 1);
                }
            }
            for (Culture culture : Culture.ListCultures) {
                for (BuildingPlanSet set : culture.ListPlanSets) {
                    if ((Integer)nameCount.get(set.plans.get((int)0)[0].nativeName) > 1) {
                        uniqueNames.put(set, set.plans.get((int)0)[0].nativeName + "~" + set.key);
                        continue;
                    }
                    uniqueNames.put(set, set.plans.get((int)0)[0].nativeName);
                }
            }
            File file = new File(Mill.proxy.getBaseDir(), "resources used wiki building list.txt");
            BufferedWriter writer = MillCommonUtilities.getWriter(file);
            writer.write("{| class=\"wikitable\"" + EOL);
            writer.write("|-" + EOL);
            writer.write("! Requirements Template Building Name" + EOL);
            writer.write("|-" + EOL);
            for (Culture culture : Culture.ListCultures) {
                for (BuildingPlanSet set : culture.ListPlanSets) {
                    writer.write("! " + (String)uniqueNames.get(set) + EOL);
                    writer.write("|-" + EOL);
                }
            }
            writer.write("|}");
            writer.close();
            file = new File(Mill.proxy.getBaseDir(), "resources used wiki.txt");
            writer = MillCommonUtilities.getWriter(file);
            writer.write("{{#switch: {{{1|{{BASEPAGENAME}}}}}" + EOL);
            for (Culture culture : Culture.ListCultures) {
                for (BuildingPlanSet set : culture.ListPlanSets) {
                    writer.write("|" + (String)uniqueNames.get(set) + " = <table><tr><td style=\"vertical-align:top;\">" + EOL);
                    for (BuildingPlan[] plans : set.plans) {
                        if (set.plans.size() > 1) {
                            writer.write("<table class=\"reqirements\"><tr><th scope=\"col\" style=\"text-align:center;\">Variation " + (char)(65 + plans[0].variation) + "</th>");
                        } else {
                            writer.write("<table class=\"reqirements\"><tr><th scope=\"col\" style=\"text-align:center;\"></th>");
                        }
                        ArrayList<InvItem> items = new ArrayList<InvItem>();
                        for (BuildingPlan plan : plans) {
                            for (InvItem key : plan.resCost.keySet()) {
                                if (items.contains(key)) continue;
                                items.add(key);
                            }
                        }
                        Collections.sort(items);
                        for (InvItem key : items) {
                            String pict = "Unknown Pict:" + key.item + "/" + key.meta;
                            String link = "";
                            if (picts.containsKey(key)) {
                                pict = (String)picts.get(key);
                            }
                            if (links.containsKey(key)) {
                                link = (String)links.get(key);
                            }
                            writer.write("<td>[[File:" + pict + "|32px" + link + "|" + key.getName() + "]]</td>");
                        }
                        writer.write("</tr>" + EOL);
                        for (BuildingPlan plan : plans) {
                            if (plan.level == 0) {
                                writer.write("<tr><th scope=\"row\">Construction</th>");
                            } else {
                                writer.write("<tr><th scope=\"row\">Upgrade " + plan.level + "</th>");
                            }
                            for (InvItem key : items) {
                                if (plan.resCost.containsKey(key)) {
                                    writer.write("<td>" + plan.resCost.get(key) + "</td>");
                                    continue;
                                }
                                writer.write("<td></td>");
                            }
                            writer.write("</tr>" + EOL);
                        }
                        writer.write("</table>" + EOL);
                    }
                    writer.write("</table>" + EOL + EOL);
                }
            }
            writer.write("| #default = {{msgbox | title = Requirements not found| text = The requirements template couldn't find the upgrade table of the building you were looking for.Please consult the building list at [[Template:Requirements|this page]] to find the correct name.}}}}<noinclude>[[Category:Templates formatting|{{PAGENAME}}]]{{documentation}}</noinclude>");
            writer.close();
        }
        catch (Exception e) {
            MLN.printException(e);
        }
        if (MLN.LogBuildingPlan >= 1) {
            MLN.major(null, "Wrote resources used wiki.txt");
        }
    }

    static String getColourString(int colour) {
        return ((colour & 0xFF0000) >> 16) + "/" + ((colour & 0xFF00) >> 8) + "/" + ((colour & 0xFF) >> 0) + "/" + Integer.toHexString(colour);
    }

    public static void importBuilding(EntityPlayer player, World world, Point startPoint) {
        try {
            File buildingFile;
            TileEntitySign sign = startPoint.getSign(world);
            if (sign == null) {
                return;
            }
            if (sign.field_145915_a[0] == null || sign.field_145915_a[0].length() == 0) {
                ServerSender.sendTranslatedSentence(player, '6', "import.errornoname", new String[0]);
                return;
            }
            String planName = sign.field_145915_a[0];
            File exportDir = new File(Mill.proxy.getCustomDir(), "exports");
            if (!exportDir.exists()) {
                exportDir.mkdirs();
            }
            if (!(buildingFile = new File(exportDir, planName + "_A.txt")).exists()) {
                ServerSender.sendTranslatedSentence(player, '6', "import.errornotfound", new String[0]);
                return;
            }
            BuildingPlanSet existingSet = new BuildingPlanSet(null, buildingFile.getName().substring(0, buildingFile.getName().length() - 6), exportDir);
            existingSet.loadPictPlans(true);
            int upgradeLevel = 0;
            if (sign.field_145915_a[1] != null && sign.field_145915_a[1].length() > 0) {
                try {
                    upgradeLevel = Integer.parseInt(sign.field_145915_a[1]);
                    ServerSender.sendTranslatedSentence(player, 'f', "import.buildingupto", "" + upgradeLevel);
                }
                catch (Exception e) {
                    ServerSender.sendTranslatedSentence(player, '6', "import.errorinvalidupgradelevel", new String[0]);
                    return;
                }
            } else {
                ServerSender.sendTranslatedSentence(player, 'f', "import.buildinginitialphase", new String[0]);
            }
            if (upgradeLevel >= existingSet.plans.get(0).length) {
                ServerSender.sendTranslatedSentence(player, '6', "import.errorupgradeleveltoohigh", new String[0]);
                return;
            }
            if (sign.field_145915_a[2] != null && sign.field_145915_a[2].equals("x2")) {
                for (BuildingPlan[] plans : existingSet.plans) {
                    for (BuildingPlan plan : plans) {
                        PointType[][][] newPlan = new PointType[plan.plan.length * 2][plan.plan[0].length][plan.plan[0][0].length];
                        for (int i = 0; i < plan.plan.length; ++i) {
                            for (int j = 0; j < plan.plan[0].length; ++j) {
                                for (int k = 0; k < plan.plan[0][0].length; ++k) {
                                    newPlan[i * 2][j][k] = plan.plan[i][j][k];
                                    newPlan[i * 2 + 1][j][k] = plan.plan[i][j][k];
                                }
                            }
                        }
                        plan.plan = newPlan;
                        plan.nbfloors *= 2;
                    }
                }
                ServerSender.sendTranslatedSentence(player, 'f', "import.doublevertical", new String[0]);
                MLN.major(null, "Building height: " + existingSet.plans.get((int)0)[0].plan.length);
            }
            BuildingPlan plan = existingSet.plans.get(0)[0];
            BuildingLocation location = new BuildingLocation(plan, startPoint.getRelative(plan.length / 2 + 1, 0.0, plan.width / 2 + 1), 0);
            for (int i = 0; i <= upgradeLevel; ++i) {
                ServerSender.sendTranslatedSentence(player, 'f', "import.buildinglevel", "" + i);
                existingSet.buildLocation(Mill.getMillWorld(world), null, location, true, false, null, true, null);
                ++location.level;
            }
        }
        catch (Exception e) {
            MLN.printException("Error when importing a building:", e);
        }
    }

    public static boolean loadBuildingPoints() {
        for (File loadDir : Mill.loadingDirs) {
            File mainList = new File(loadDir, "blocklist.txt");
            if (!mainList.exists() || !BuildingPlan.loadBuildingPointsFile(mainList)) continue;
            return true;
        }
        BuildingPlan.loadReverseBuildingPoints();
        if (MLN.generateColourSheet) {
            BuildingPlan.generateColourSheet();
        }
        return false;
    }

    private static boolean loadBuildingPointsFile(File file) {
        try {
            String line;
            BufferedReader reader = MillCommonUtilities.getReader(file);
            while ((line = reader.readLine()) != null) {
                if (line.trim().length() <= 0 || line.startsWith("//")) continue;
                PointType cp = PointType.readColourPoint(line);
                for (PointType cp2 : colourPoints.values()) {
                    if (cp2.colour != cp.colour) continue;
                    throw new MLN.MillenaireException("Colour " + BuildingPlan.getColourString(cp.colour) + " in line <" + line + "> is already taken.");
                }
                colourPoints.put(cp.colour, cp);
            }
        }
        catch (Exception e) {
            MLN.printException(e);
            return true;
        }
        charPoints = new HashMap();
        charPoints.put(Character.valueOf('-'), new PointType('-', bempty));
        charPoints.put(Character.valueOf('*'), new PointType('*', bmainchest));
        charPoints.put(Character.valueOf('G'), new PointType('G', bgrass));
        charPoints.put(Character.valueOf('s'), new PointType('s', bsoil));
        charPoints.put(Character.valueOf('H'), new PointType('H', blockedchest));
        charPoints.put(Character.valueOf('X'), new PointType('X', bsleepingPos));
        charPoints.put(Character.valueOf('t'), new PointType('t', bwoodstairsOakGuess));
        charPoints.put(Character.valueOf('a'), new PointType('a', bstonestairGuess));
        charPoints.put(Character.valueOf('L'), new PointType('L', bladderGuess));
        charPoints.put(Character.valueOf('S'), new PointType('S', bsignwallGuess));
        charPoints.put(Character.valueOf('/'), new PointType('/', Blocks.field_150350_a, 0, false));
        charPoints.put(Character.valueOf('d'), new PointType('d', Blocks.field_150346_d, 0, false));
        charPoints.put(Character.valueOf('p'), new PointType('p', Blocks.field_150344_f, 0, false));
        charPoints.put(Character.valueOf('g'), new PointType('g', Blocks.field_150359_w, 0, false));
        charPoints.put(Character.valueOf('c'), new PointType('c', Blocks.field_150347_e, 0, false));
        charPoints.put(Character.valueOf('C'), new PointType('C', Blocks.field_150462_ai, 0, false));
        charPoints.put(Character.valueOf('F'), new PointType('F', Blocks.field_150460_al, 0, false));
        charPoints.put(Character.valueOf('W'), new PointType('W', Blocks.field_150325_L, 0, false));
        charPoints.put(Character.valueOf('o'), new PointType('o', Blocks.field_150348_b, 0, false));
        charPoints.put(Character.valueOf('h'), new PointType('h', Blocks.field_150446_ar, 0, false));
        charPoints.put(Character.valueOf('I'), new PointType('I', Blocks.field_150339_S, 0, false));
        charPoints.put(Character.valueOf('l'), new PointType('h', (Block)Blocks.field_150333_U, 0, false));
        charPoints.put(Character.valueOf('T'), new PointType('T', Blocks.field_150478_aa, 0, true));
        charPoints.put(Character.valueOf('f'), new PointType('f', Blocks.field_150422_aJ, 0, true));
        charPoints.put(Character.valueOf('w'), new PointType('w', Blocks.field_150355_j, 0, true));
        return false;
    }

    public static HashMap<String, BuildingPlanSet> loadPlans(List<File> culturesDirs, Culture culture) {
        HashMap<String, BuildingPlanSet> plans = new HashMap<String, BuildingPlanSet>();
        ArrayList<File> dirs = new ArrayList<File>();
        ArrayList<Boolean> isolatedDirs = new ArrayList<Boolean>();
        for (File cultureDir : culturesDirs) {
            File buildingsDir = new File(cultureDir, "buildings");
            File coreDir = new File(buildingsDir, "core");
            File extraDir = new File(buildingsDir, "extra");
            File isolatedDir = new File(buildingsDir, "lone");
            if (coreDir.exists()) {
                dirs.add(coreDir);
                isolatedDirs.add(false);
            }
            if (extraDir.exists()) {
                dirs.add(extraDir);
                isolatedDirs.add(false);
            }
            if (!isolatedDir.exists()) continue;
            dirs.add(isolatedDir);
            isolatedDirs.add(true);
        }
        File customDir = new File(new File(new File(Mill.proxy.getCustomDir(), "cultures"), culture.key), "custom buildings");
        if (customDir.exists()) {
            dirs.add(customDir);
            isolatedDirs.add(false);
        }
        BuildingFileFiler textPlans = new BuildingFileFiler("_A0.txt");
        BuildingFileFiler pictPlans = new BuildingFileFiler("_A.txt");
        for (int i = 0; i < dirs.size(); ++i) {
            BuildingPlanSet set;
            for (File file : ((File)dirs.get(i)).listFiles(textPlans)) {
                try {
                    if (MLN.LogBuildingPlan >= 1) {
                        MLN.major(file, "Loading building: " + file.getAbsolutePath());
                    }
                    set = new BuildingPlanSet(culture, file.getName().split("_")[0], (File)dirs.get(i));
                    set.loadPlans(culture, false);
                    if (((Boolean)isolatedDirs.get(i)).booleanValue()) {
                        set.max = 0;
                    }
                    plans.put(set.key, set);
                }
                catch (Exception e) {
                    MLN.printException("Error when loading " + file.getAbsolutePath(), e);
                }
            }
            for (File file : ((File)dirs.get(i)).listFiles(pictPlans)) {
                try {
                    if (MLN.LogBuildingPlan >= 1) {
                        MLN.major(file, "Loading pict building: " + file.getAbsolutePath());
                    }
                    set = new BuildingPlanSet(culture, file.getName().substring(0, file.getName().length() - 6), (File)dirs.get(i));
                    set.loadPictPlans(false);
                    if (((Boolean)isolatedDirs.get(i)).booleanValue()) {
                        set.max = 0;
                    }
                    plans.put(set.key, set);
                }
                catch (Exception e) {
                    MLN.printException("Exception when loading " + file.getName() + " plan set in culture " + culture.key + ":", e);
                }
            }
        }
        return plans;
    }

    public static HashMap<String, BuildingPlanSet> loadPlanSetMap(List<BuildingPlanSet> planSets) {
        HashMap<String, BuildingPlanSet> map = new HashMap<String, BuildingPlanSet>();
        for (BuildingPlanSet set : planSets) {
            map.put(set.key, set);
        }
        return map;
    }

    private static void loadReverseBuildingPoints() {
        for (PointType pt : colourPoints.values()) {
            if (pt.name != null) continue;
            Block block = pt.getBlock();
            reverseColourPoints.put(MillCommonUtilities.getPointHash(pt.block, pt.meta), pt);
            if (block == Blocks.field_150478_aa || block == Blocks.field_150437_az || block == Blocks.field_150362_t) {
                for (int i = 0; i < 16; ++i) {
                    reverseColourPoints.put(MillCommonUtilities.getPointHash(pt.block, i), pt);
                }
                continue;
            }
            if (block != Mill.path && block != Mill.pathSlab) continue;
            reverseColourPoints.put(MillCommonUtilities.getPointHash(pt.block, pt.meta & 7), pt);
        }
        for (PointType pt : colourPoints.values()) {
            int i;
            if (pt.name == null) continue;
            if (pt.name.equals(bpreserveground)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150346_d, 0), pt);
                reverseColourPoints.put(MillCommonUtilities.getPointHash((Block)Blocks.field_150349_c, 0), pt);
                continue;
            }
            if (pt.name.equals(blockedchest)) {
                for (i = 0; i < 16; ++i) {
                    reverseColourPoints.put(MillCommonUtilities.getPointHash((Block)Blocks.field_150486_ae, i), pt);
                }
                for (i = 0; i < 16; ++i) {
                    reverseColourPoints.put(MillCommonUtilities.getPointHash(Mill.lockedChest, i), pt);
                }
                continue;
            }
            if (pt.name.equals(blogoakhor)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150364_r, 8), pt);
                continue;
            }
            if (pt.name.equals(blogoakvert)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150364_r, 4), pt);
                continue;
            }
            if (pt.name.equals(blogpinehor)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150364_r, 9), pt);
                continue;
            }
            if (pt.name.equals(blogpinevert)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150364_r, 5), pt);
                continue;
            }
            if (pt.name.equals(blogbirchhor)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150364_r, 10), pt);
                continue;
            }
            if (pt.name.equals(blogbirchvert)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150364_r, 6), pt);
                continue;
            }
            if (pt.name.equals(blogjunglehor)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150364_r, 11), pt);
                continue;
            }
            if (pt.name.equals(blogjunglevert)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150364_r, 7), pt);
                continue;
            }
            if (pt.name.equals(bwoodstairsOakTop)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150476_ad, 1), pt);
                continue;
            }
            if (pt.name.equals(bwoodstairsOakBottom)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150476_ad, 0), pt);
                continue;
            }
            if (pt.name.equals(bwoodstairsOakLeft)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150476_ad, 2), pt);
                continue;
            }
            if (pt.name.equals(bwoodstairsOakRight)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150476_ad, 3), pt);
                continue;
            }
            if (pt.name.equals(bwoodstairsPineTop)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150485_bF, 1), pt);
                continue;
            }
            if (pt.name.equals(bwoodstairsPineBottom)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150485_bF, 0), pt);
                continue;
            }
            if (pt.name.equals(bwoodstairsPineLeft)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150485_bF, 2), pt);
                continue;
            }
            if (pt.name.equals(bwoodstairsPineRight)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150485_bF, 3), pt);
                continue;
            }
            if (pt.name.equals(bwoodstairsBirchTop)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150487_bG, 1), pt);
                continue;
            }
            if (pt.name.equals(bwoodstairsBirchBottom)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150487_bG, 0), pt);
                continue;
            }
            if (pt.name.equals(bwoodstairsBirchLeft)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150487_bG, 2), pt);
                continue;
            }
            if (pt.name.equals(bwoodstairsBirchRight)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150487_bG, 3), pt);
                continue;
            }
            if (pt.name.equals(bwoodstairsJungleTop)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150481_bH, 1), pt);
                continue;
            }
            if (pt.name.equals(bwoodstairsJungleBottom)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150481_bH, 0), pt);
                continue;
            }
            if (pt.name.equals(bwoodstairsJungleLeft)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150481_bH, 2), pt);
                continue;
            }
            if (pt.name.equals(bwoodstairsJungleRight)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150481_bH, 3), pt);
                continue;
            }
            if (pt.name.equals(bstonestairsTop)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150446_ar, 1), pt);
                continue;
            }
            if (pt.name.equals(bstonestairsBottom)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150446_ar, 0), pt);
                continue;
            }
            if (pt.name.equals(bstonestairsLeft)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150446_ar, 2), pt);
                continue;
            }
            if (pt.name.equals(bstonestairsRight)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150446_ar, 3), pt);
                continue;
            }
            if (pt.name.equals(bstonebrickstairsTop)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150390_bg, 1), pt);
                continue;
            }
            if (pt.name.equals(bstonebrickstairsBottom)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150390_bg, 0), pt);
                continue;
            }
            if (pt.name.equals(bstonebrickstairsLeft)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150390_bg, 2), pt);
                continue;
            }
            if (pt.name.equals(bstonebrickstairsRight)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150390_bg, 3), pt);
                continue;
            }
            if (pt.name.equals(bbrickstairsTop)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150389_bf, 1), pt);
                continue;
            }
            if (pt.name.equals(bbrickstairsBottom)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150389_bf, 0), pt);
                continue;
            }
            if (pt.name.equals(bbrickstairsLeft)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150389_bf, 2), pt);
                continue;
            }
            if (pt.name.equals(bbrickstairsRight)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150389_bf, 3), pt);
                continue;
            }
            if (pt.name.equals(bsandstonestairsTop)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150372_bz, 1), pt);
                continue;
            }
            if (pt.name.equals(bsandstonestairsBottom)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150372_bz, 0), pt);
                continue;
            }
            if (pt.name.equals(bsandstonestairsLeft)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150372_bz, 2), pt);
                continue;
            }
            if (pt.name.equals(bsandstonestairsRight)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150372_bz, 3), pt);
                continue;
            }
            if (pt.name.equals(bwoodstairsOakInvTop)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150476_ad, 5), pt);
                continue;
            }
            if (pt.name.equals(bwoodstairsOakInvBottom)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150476_ad, 4), pt);
                continue;
            }
            if (pt.name.equals(bwoodstairsOakInvLeft)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150476_ad, 6), pt);
                continue;
            }
            if (pt.name.equals(bwoodstairsOakInvRight)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150476_ad, 7), pt);
                continue;
            }
            if (pt.name.equals(bwoodstairsPineInvTop)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150485_bF, 5), pt);
                continue;
            }
            if (pt.name.equals(bwoodstairsPineInvBottom)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150485_bF, 4), pt);
                continue;
            }
            if (pt.name.equals(bwoodstairsPineInvLeft)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150485_bF, 6), pt);
                continue;
            }
            if (pt.name.equals(bwoodstairsPineInvRight)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150485_bF, 7), pt);
                continue;
            }
            if (pt.name.equals(bwoodstairsBirchInvTop)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150487_bG, 5), pt);
                continue;
            }
            if (pt.name.equals(bwoodstairsBirchInvBottom)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150487_bG, 4), pt);
                continue;
            }
            if (pt.name.equals(bwoodstairsBirchInvLeft)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150487_bG, 6), pt);
                continue;
            }
            if (pt.name.equals(bwoodstairsBirchInvRight)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150487_bG, 7), pt);
                continue;
            }
            if (pt.name.equals(bwoodstairsJungleInvTop)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150481_bH, 5), pt);
                continue;
            }
            if (pt.name.equals(bwoodstairsJungleInvBottom)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150481_bH, 4), pt);
                continue;
            }
            if (pt.name.equals(bwoodstairsJungleInvLeft)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150481_bH, 6), pt);
                continue;
            }
            if (pt.name.equals(bwoodstairsJungleInvRight)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150481_bH, 7), pt);
                continue;
            }
            if (pt.name.equals(bstonestairsInvTop)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150446_ar, 5), pt);
                continue;
            }
            if (pt.name.equals(bstonestairsInvBottom)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150446_ar, 4), pt);
                continue;
            }
            if (pt.name.equals(bstonestairsInvLeft)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150446_ar, 6), pt);
                continue;
            }
            if (pt.name.equals(bstonestairsInvRight)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150446_ar, 7), pt);
                continue;
            }
            if (pt.name.equals(bstonebrickstairsInvTop)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150390_bg, 5), pt);
                continue;
            }
            if (pt.name.equals(bstonebrickstairsInvBottom)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150390_bg, 4), pt);
                continue;
            }
            if (pt.name.equals(bstonebrickstairsInvLeft)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150390_bg, 6), pt);
                continue;
            }
            if (pt.name.equals(bstonebrickstairsInvRight)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150390_bg, 7), pt);
                continue;
            }
            if (pt.name.equals(bbrickstairsInvTop)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150389_bf, 5), pt);
                continue;
            }
            if (pt.name.equals(bbrickstairsInvBottom)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150389_bf, 4), pt);
                continue;
            }
            if (pt.name.equals(bbrickstairsInvLeft)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150389_bf, 6), pt);
                continue;
            }
            if (pt.name.equals(bbrickstairsInvRight)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150389_bf, 7), pt);
                continue;
            }
            if (pt.name.equals(bsandstonestairsInvTop)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150372_bz, 5), pt);
                continue;
            }
            if (pt.name.equals(bsandstonestairsInvBottom)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150372_bz, 4), pt);
                continue;
            }
            if (pt.name.equals(bsandstonestairsInvLeft)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150372_bz, 6), pt);
                continue;
            }
            if (pt.name.equals(bsandstonestairsInvRight)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150372_bz, 7), pt);
                continue;
            }
            if (pt.name.equals(bbyzantinetiles_bottomtop)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Mill.byzantine_tiles, 1), pt);
                continue;
            }
            if (pt.name.equals(bbyzantinetiles_leftright)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Mill.byzantine_tiles, 0), pt);
                continue;
            }
            if (pt.name.equals(bbyzantinestonetiles_bottomtop)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Mill.byzantine_stone_tiles, 1), pt);
                continue;
            }
            if (pt.name.equals(bbyzantinestonetiles_leftright)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Mill.byzantine_stone_tiles, 0), pt);
                continue;
            }
            if (pt.name.equals(bbyzantineslab_bottomtop)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash((Block)Mill.byzantine_tile_slab, 1), pt);
                continue;
            }
            if (pt.name.equals(bbyzantineslab_leftright)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash((Block)Mill.byzantine_tile_slab, 0), pt);
                continue;
            }
            if (pt.name.equals(bbyzantineslab_bottomtop_inv)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash((Block)Mill.byzantine_tile_slab, 9), pt);
                continue;
            }
            if (pt.name.equals(bbyzantineslab_leftright_inv)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash((Block)Mill.byzantine_tile_slab, 8), pt);
                continue;
            }
            if (pt.name.equals(bsignpostTop)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150472_an, 5), pt);
                continue;
            }
            if (pt.name.equals(bsignpostBottom)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150472_an, 4), pt);
                continue;
            }
            if (pt.name.equals(bsignpostLeft)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150472_an, 2), pt);
                continue;
            }
            if (pt.name.equals(bsignpostRight)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150472_an, 3), pt);
                continue;
            }
            if (pt.name.equals(bsignwallTop)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150444_as, 5), pt);
                continue;
            }
            if (pt.name.equals(bsignwallBottom)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150444_as, 4), pt);
                continue;
            }
            if (pt.name.equals(bsignwallLeft)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150444_as, 2), pt);
                continue;
            }
            if (pt.name.equals(bsignwallRight)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150444_as, 3), pt);
                continue;
            }
            if (pt.name.equals(bladderTop)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150468_ap, 5), pt);
                continue;
            }
            if (pt.name.equals(bladderBottom)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150468_ap, 4), pt);
                continue;
            }
            if (pt.name.equals(bladderLeft)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150468_ap, 2), pt);
                continue;
            }
            if (pt.name.equals(bladderRight)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150468_ap, 3), pt);
                continue;
            }
            if (pt.name.equals(bfurnace)) {
                for (i = 0; i < 16; ++i) {
                    reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150460_al, i), pt);
                    reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150470_am, i), pt);
                }
                continue;
            }
            if (pt.name.equals(bbrewingstand)) {
                for (i = 0; i < 16; ++i) {
                    reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150382_bo, i), pt);
                }
                continue;
            }
            if (pt.name.equals(bdoorTop)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150466_ao, 0), pt);
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150466_ao, 7), pt);
                continue;
            }
            if (pt.name.equals(bdoorBottom)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150466_ao, 2), pt);
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150466_ao, 5), pt);
                continue;
            }
            if (pt.name.equals(bdoorLeft)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150466_ao, 3), pt);
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150466_ao, 6), pt);
                continue;
            }
            if (pt.name.equals(bdoorRight)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150466_ao, 1), pt);
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150466_ao, 4), pt);
                continue;
            }
            if (pt.name.equals(birondoorTop)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150454_av, 0), pt);
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150454_av, 7), pt);
                continue;
            }
            if (pt.name.equals(birondoorBottom)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150454_av, 2), pt);
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150454_av, 5), pt);
                continue;
            }
            if (pt.name.equals(birondoorLeft)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150454_av, 3), pt);
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150454_av, 6), pt);
                continue;
            }
            if (pt.name.equals(birondoorRight)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150454_av, 1), pt);
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150454_av, 4), pt);
                continue;
            }
            if (pt.name.equals(btrapdoorTop)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150415_aT, 1), pt);
                continue;
            }
            if (pt.name.equals(btrapdoorBottom)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150415_aT, 0), pt);
                continue;
            }
            if (pt.name.equals(btrapdoorLeft)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150415_aT, 3), pt);
                continue;
            }
            if (pt.name.equals(btrapdoorRight)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150415_aT, 2), pt);
                continue;
            }
            if (pt.name.equals(bfenceGateHorizontal)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150396_be, 1), pt);
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150396_be, 3), pt);
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150396_be, 5), pt);
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150396_be, 7), pt);
                continue;
            }
            if (pt.name.equals(bfenceGateVertical)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150396_be, 0), pt);
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150396_be, 2), pt);
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150396_be, 4), pt);
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150396_be, 6), pt);
                continue;
            }
            if (pt.name.equals(bbedTop)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150324_C, 8), pt);
                continue;
            }
            if (pt.name.equals(bbedBottom)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150324_C, 10), pt);
                continue;
            }
            if (pt.name.equals(bbedLeft)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150324_C, 9), pt);
                continue;
            }
            if (pt.name.equals(bbedRight)) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150324_C, 11), pt);
                continue;
            }
            if (!pt.name.equals(bplainSignGuess)) continue;
            for (i = 0; i < 16; ++i) {
                reverseColourPoints.put(MillCommonUtilities.getPointHash(Blocks.field_150444_as, i), pt);
            }
        }
    }

    public BuildingPlan(File dir, String buildingKey, int level, int variation, BuildingPlan parent, Culture c, boolean importPlan) throws Exception {
        char varChar = 'A';
        varChar = (char)(varChar + variation);
        this.planName = buildingKey + "_" + varChar + "" + level;
        this.buildingKey = buildingKey;
        this.isUpdate = level > 0;
        this.level = level;
        this.variation = variation;
        this.culture = c;
        File file = new File(dir, this.planName + ".txt");
        this.initialiseConfig(parent);
        BufferedReader reader = MillCommonUtilities.getReader(file);
        String line = null;
        line = reader.readLine();
        this.readConfigLine(file, line, importPlan);
        line = reader.readLine();
        ArrayList textPlan = new ArrayList();
        ArrayList<String> v = new ArrayList<String>();
        textPlan.add(v);
        while ((line = reader.readLine()) != null) {
            if (line.trim().equals("")) {
                v = new ArrayList();
                textPlan.add(v);
                continue;
            }
            v.add(line);
        }
        this.length = ((List)textPlan.get(0)).size();
        this.lengthOffset = (int)Math.floor((double)this.length * 0.5);
        this.width = ((String)((List)textPlan.get(0)).get(0)).length();
        this.widthOffset = (int)Math.floor((double)this.width * 0.5);
        this.nbfloors = textPlan.size();
        int i = 0;
        for (List list : textPlan) {
            if (list.size() != this.length) {
                throw new MLN.MillenaireException(this.planName + ": " + "Floor " + i + " is " + list.size() + " long, " + this.length + " expected.");
            }
            int j = 0;
            for (String s : list) {
                if (s.length() != this.width) {
                    throw new MLN.MillenaireException(this.planName + ": " + "Line " + j + " in floor " + i + " is " + s.length() + " wide, " + this.width + " expected.");
                }
                ++j;
            }
            ++i;
        }
        reader.close();
        this.plan = new PointType[this.nbfloors][this.length][this.width];
        for (i = 0; i < textPlan.size(); ++i) {
            for (int j = 0; j < this.length; ++j) {
                for (int k = 0; k < this.width; ++k) {
                    if (!charPoints.containsKey(Character.valueOf(((String)((List)textPlan.get(i)).get(j)).charAt(this.width - k - 1)))) {
                        throw new MLN.MillenaireException(this.planName + ": In floor " + i + " line " + j + " char " + (this.width - k - 1) + " unknow character: " + ((String)((List)textPlan.get(i)).get(j)).charAt(this.width - k - 1));
                    }
                    this.plan[i][j][k] = charPoints.get(Character.valueOf(((String)((List)textPlan.get(i)).get(j)).charAt(this.width - k - 1)));
                    if (this.plan[i][j][k] != null) continue;
                    throw new MLN.MillenaireException(this.planName + ": In floor " + i + " line " + j + " char " + (this.width - k - 1) + " null PointType for: " + ((String)((List)textPlan.get(i)).get(j)).charAt(this.width - k - 1));
                }
            }
        }
        this.computeCost();
        if (MLN.LogBuildingPlan >= 1) {
            MLN.major(this, "Loaded plan " + buildingKey + "_" + level + ": " + this.nativeName + " pop: " + this.maleResident + "/" + this.femaleResident + " / priority: " + this.priority);
        }
    }

    public BuildingPlan(File dir, String buildingKey, int level, int variation, BuildingPlan parent, String configLine, Culture c, boolean importPlan) throws Exception {
        char varChar = 'A';
        varChar = (char)(varChar + variation);
        this.planName = buildingKey + "_" + varChar + "" + level;
        this.buildingKey = buildingKey;
        this.isUpdate = level > 0;
        this.level = level;
        this.variation = variation;
        this.culture = c;
        this.initialiseConfig(parent);
        File file = new File(dir, this.planName + ".png");
        if (configLine != null) {
            this.readConfigLine(file, configLine, importPlan);
        }
        BufferedImage PNGFile = ImageIO.read(file);
        BufferedImage pictPlan = new BufferedImage(PNGFile.getWidth(), PNGFile.getHeight(), 6);
        Graphics2D fig = pictPlan.createGraphics();
        fig.drawImage((Image)PNGFile, 0, 0, null);
        fig.dispose();
        pictPlan.flush();
        this.lengthOffset = (int)Math.floor((double)this.length * 0.5);
        this.widthOffset = (int)Math.floor((double)this.width * 0.5);
        if (pictPlan.getHeight() != this.length) {
            throw new MLN.MillenaireException(this.planName + ": " + "Expected length is " + this.length + " but file height is " + pictPlan.getHeight());
        }
        float fnbfloors = ((float)pictPlan.getWidth() + 1.0f) / ((float)this.width + 1.0f);
        if ((float)Math.round(fnbfloors) != fnbfloors) {
            throw new MLN.MillenaireException(this.planName + ": With a width of " + this.width + ", getting non-integer floor number: " + fnbfloors);
        }
        this.nbfloors = (int)fnbfloors;
        this.plan = new PointType[this.nbfloors][this.length][this.width];
        if (pictPlan.getType() != 5 && pictPlan.getType() != 6) {
            MLN.error(this, "Picture " + this.planName + ".png could not be loaded as type TYPE_3BYTE_BGR or TYPE_4BYTE_ABGR but instead as: " + pictPlan.getType());
        }
        boolean alphaLayer = false;
        if (pictPlan.getType() == 6) {
            alphaLayer = true;
        }
        boolean sleepingPos = false;
        for (int i = 0; i < this.nbfloors; ++i) {
            for (int j = 0; j < this.length; ++j) {
                for (int k = 0; k < this.width; ++k) {
                    int colour = pictPlan.getRGB(i * this.width + i + this.width - k - 1, j);
                    colour = alphaLayer ? ((colour & 0xFF000000) != -16777216 ? 0xFFFFFF : (colour &= 0xFFFFFF)) : (colour &= 0xFFFFFF);
                    if (!colourPoints.containsKey(colour)) {
                        MLN.error(this, this.planName + ": Unknown colour " + BuildingPlan.getColourString(colour) + " at: " + (i * this.width + i + this.width - k - 1) + "/" + j + ", skipping it.");
                        colour = 0xFFFFFF;
                    }
                    this.plan[i][j][k] = colourPoints.get(colour);
                    if (bsleepingPos.equals(this.plan[i][j][k].name)) {
                        sleepingPos = true;
                    }
                    if (this.plan[i][j][k].name == null || !this.plan[i][j][k].name.equals(bmainchest) || level <= 0) continue;
                    MLN.error(this, "Main chest detected at " + (i * this.width + i + this.width - k - 1) + "/" + j + " but we are in an upgrade. Removing it.");
                    this.plan[i][j][k] = colourPoints.get(0xFFFFFF);
                }
            }
        }
        this.computeCost();
        if (MLN.LogBuildingPlan >= 1) {
            MLN.major(this, "Loaded plan " + buildingKey + "_" + level + ": " + this.nativeName + " pop: " + this.maleResident + "/" + this.femaleResident + "/priority:" + this.priority);
        }
        if (this.maleResident.size() > 0 && this.femaleResident.size() > 0 && level == 0 && !sleepingPos) {
            MLN.error(this, "Has residents but the sleeping pos is missing!");
        }
        int pigs = 0;
        int sheep = 0;
        int chicken = 0;
        int cow = 0;
        for (int i = 0; i < this.nbfloors; ++i) {
            for (int j = 0; j < this.length; ++j) {
                for (int k = 0; k < this.width; ++k) {
                    if (this.plan[i][j][k].isType(bchickenspawn) && !this.tags.contains("chicken")) {
                        MLN.warning(this, "Building has chicken spawn but no chicken tag.");
                    } else if (this.plan[i][j][k].isType(bcowspawn) && !this.tags.contains("cattle")) {
                        MLN.warning(this, "Building has cattle spawn but no cattle tag.");
                    } else if (this.plan[i][j][k].isType(bsheepspawn) && !this.tags.contains("sheeps")) {
                        MLN.warning(this, "Building has sheeps spawn but no sheeps tag.");
                    } else if (this.plan[i][j][k].isType(bpigspawn) && !this.tags.contains("pigs")) {
                        MLN.warning(this, "Building has pig spawn but no pig tag.");
                    } else if (this.plan[i][j][k].isType(bsquidspawn) && !this.tags.contains("squids")) {
                        MLN.warning(this, "Building has squid spawn but no squid tag.");
                    }
                    if (this.plan[i][j][k].isType(bchickenspawn)) {
                        ++chicken;
                        continue;
                    }
                    if (this.plan[i][j][k].isType(bcowspawn)) {
                        ++cow;
                        continue;
                    }
                    if (this.plan[i][j][k].isType(bsheepspawn)) {
                        ++sheep;
                        continue;
                    }
                    if (!this.plan[i][j][k].isType(bpigspawn)) continue;
                    ++pigs;
                }
            }
        }
        if (chicken % 2 == 1) {
            MLN.warning(this, "Odd number of chicken spawn: " + chicken);
        }
        if (sheep % 2 == 1) {
            MLN.warning(this, "Odd number of sheep spawn: " + sheep);
        }
        if (cow % 2 == 1) {
            MLN.warning(this, "Odd number of cow spawn: " + cow);
        }
        if (pigs % 2 == 1) {
            MLN.warning(this, "Odd number of pigs spawn: " + pigs);
        }
    }

    public BuildingPlan(String buildingKey, int level, int variation, Culture c) {
        this.buildingKey = buildingKey;
        this.isUpdate = level > 0;
        this.level = level;
        this.variation = variation;
        this.culture = c;
    }

    private void addToCost(Block block, int nb) {
        this.addToCost(block, 0, nb);
    }

    private void addToCost(Block block, int meta, int nb) {
        try {
            InvItem key = new InvItem(block, meta);
            if (this.resCost.containsKey(key)) {
                this.resCost.put(key, nb += this.resCost.get(key).intValue());
            } else {
                this.resCost.put(key, nb);
            }
        }
        catch (Exception e) {
            MLN.printException("Exception when calculating cost of: " + this, e);
        }
    }

    private void addToCost(Item item, int nb) {
        this.addToCost(item, 0, nb);
    }

    private void addToCost(Item item, int meta, int nb) {
        try {
            InvItem key = new InvItem(item, meta);
            if (this.resCost.containsKey(key)) {
                this.resCost.put(key, nb += this.resCost.get(key).intValue());
            } else {
                this.resCost.put(key, nb);
            }
        }
        catch (Exception e) {
            MLN.printException("Exception when calculating cost of: " + this, e);
        }
    }

    public List<LocationBuildingPair> build(MillWorld mw, VillageType villageType, BuildingLocation location, boolean villageGeneration, boolean townHall, Point townHallPos, boolean wandimport, EntityPlayer owner, boolean rushBuilding) {
        BuildingBlock[] bblocks;
        if (!townHall && townHallPos == null && !wandimport) {
            MLN.error(this, "Building is not TH and does not have TH's position.");
        }
        World worldObj = mw.world;
        ArrayList<LocationBuildingPair> buildings = new ArrayList<LocationBuildingPair>();
        for (BuildingBlock bblock : bblocks = this.getBuildingPoints(worldObj, location, villageGeneration)) {
            bblock.build(worldObj, villageGeneration, wandimport);
        }
        if (this.tags.contains("hof")) {
            int signNb = 0;
            List<String> hofData = MLN.getHoFData();
            for (int z = location.pos.getiZ() - this.width / 2; z < location.pos.getiZ() + this.width / 2; ++z) {
                for (int x = location.pos.getiX() + this.length / 2; x >= location.pos.getiX() - this.length / 2; --x) {
                    for (int y = location.pos.getiY() + this.plan.length; y >= location.pos.getiY(); --y) {
                        TileEntitySign sign;
                        if (worldObj.func_147439_a(x, y, z) != Blocks.field_150444_as || (sign = new Point(x, y, z).getSign(worldObj)) == null) continue;
                        if (signNb < hofData.size()) {
                            String[] lines = hofData.get(signNb).split(";");
                            for (int i = 0; i < Math.min(4, lines.length); ++i) {
                                sign.field_145915_a[i] = i == 0 || lines[i].length() == 0 ? lines[i] : MLN.string(lines[i]);
                            }
                        }
                        ++signNb;
                    }
                }
            }
        }
        if (bblocks.length > 0 && !wandimport && location.level == 0) {
            Building building = new Building(mw, this.culture, villageType, location, townHall, villageGeneration, bblocks[bblocks.length - 1].p, townHallPos);
            if (MLN.LogWorldGeneration >= 2) {
                MLN.minor(this, "Building " + this.planName + " at " + location);
            }
            this.referenceBuildingPoints(worldObj, building, location);
            building.initialise(owner, villageGeneration || rushBuilding);
            building.fillStartingGoods();
            buildings.add(new LocationBuildingPair(building, location));
            if (townHall) {
                townHallPos = building.getPos();
            }
        }
        if (this.culture != null) {
            for (String sb : this.startingSubBuildings) {
                BuildingPlan plan = this.culture.getBuildingPlanSet(sb).getRandomStartingPlan();
                BuildingLocation l = location.createLocationForStartingSubBuilding(sb);
                List<LocationBuildingPair> vb = plan.build(mw, villageType, l, villageGeneration, false, townHallPos, false, owner, rushBuilding);
                location.subBuildings.add(sb);
                for (LocationBuildingPair p : vb) {
                    buildings.add(p);
                }
            }
        }
        worldObj.func_147458_c(location.pos.getiX() - this.length / 2 - 5, location.pos.getiY() - this.plan.length - 5, location.pos.getiZ() - this.width / 2 - 5, location.pos.getiX() + this.length / 2 + 5, location.pos.getiY() - 5, location.pos.getiZ() + this.width / 2 + 5);
        return buildings;
    }

    private void computeCost() throws MLN.MillenaireException {
        this.resCost = new HashMap();
        int plankCost = 0;
        int plankOakCost = 0;
        int plankPineCost = 0;
        int plankBirchCost = 0;
        int plankJungleCost = 0;
        int glassPaneCost = 0;
        int byzBricksHalf = 0;
        for (int i = 0; i < this.nbfloors; ++i) {
            for (int j = 0; j < this.length; ++j) {
                for (int k = 0; k < this.width; ++k) {
                    PointType p = this.plan[i][j][k];
                    if (p == null) {
                        throw new MLN.MillenaireException("PointType null at " + i + "/" + j + "/" + k);
                    }
                    if (p.block == Blocks.field_150364_r && (p.meta & 3) == 0) {
                        plankOakCost += 4;
                        continue;
                    }
                    if (p.block == Blocks.field_150364_r && (p.meta & 3) == 1) {
                        plankPineCost += 4;
                        continue;
                    }
                    if (p.block == Blocks.field_150364_r && (p.meta & 3) == 2) {
                        plankBirchCost += 4;
                        continue;
                    }
                    if (p.block == Blocks.field_150364_r && (p.meta & 3) == 3) {
                        plankJungleCost += 4;
                        continue;
                    }
                    if (p.block == Blocks.field_150344_f && p.meta == 0) {
                        ++plankOakCost;
                        continue;
                    }
                    if (p.block == Blocks.field_150344_f && p.meta == 1) {
                        ++plankPineCost;
                        continue;
                    }
                    if (p.block == Blocks.field_150344_f && p.meta == 2) {
                        ++plankBirchCost;
                        continue;
                    }
                    if (p.block == Blocks.field_150344_f && p.meta == 3) {
                        ++plankJungleCost;
                        continue;
                    }
                    if (p.block == Mill.byzantine_tiles) {
                        byzBricksHalf += 2;
                        continue;
                    }
                    if (p.block == Mill.byzantine_tile_slab) {
                        ++byzBricksHalf;
                        continue;
                    }
                    if (p.block == Mill.byzantine_stone_tiles) {
                        ++byzBricksHalf;
                        this.addToCost(Blocks.field_150348_b, 1);
                        continue;
                    }
                    if (p.block == Blocks.field_150410_aZ) {
                        ++glassPaneCost;
                        continue;
                    }
                    if (p.block == Blocks.field_150462_ai) {
                        plankCost += 4;
                        continue;
                    }
                    if (p.block == Blocks.field_150486_ae) {
                        plankCost += 8;
                        continue;
                    }
                    if (p.block == Blocks.field_150460_al) {
                        this.addToCost(Blocks.field_150347_e, 8);
                        continue;
                    }
                    if (p.block == Blocks.field_150478_aa) {
                        ++plankCost;
                        continue;
                    }
                    if (p.block == Blocks.field_150422_aJ) {
                        ++plankCost;
                        continue;
                    }
                    if (p.block == Blocks.field_150396_be) {
                        plankCost += 4;
                        continue;
                    }
                    if (p.block == Blocks.field_150452_aw) {
                        plankCost += 2;
                        continue;
                    }
                    if (p.block == Blocks.field_150456_au) {
                        this.addToCost(Blocks.field_150348_b, 2);
                        continue;
                    }
                    if (p.block == Blocks.field_150417_aV && p.meta == 0) {
                        this.addToCost(Blocks.field_150348_b, 1);
                        continue;
                    }
                    if (p.block == Blocks.field_150333_U && (p.meta & 7) == 0) {
                        this.addToCost(Blocks.field_150348_b, 1);
                        continue;
                    }
                    if (p.block == Blocks.field_150333_U && (p.meta & 7) == 1) {
                        this.addToCost(Blocks.field_150322_A, 1);
                        continue;
                    }
                    if (p.block == Blocks.field_150333_U && (p.meta & 7) == 2) {
                        ++plankCost;
                        continue;
                    }
                    if (p.block == Blocks.field_150333_U && (p.meta & 7) == 3) {
                        this.addToCost(Blocks.field_150347_e, 1);
                        continue;
                    }
                    if (p.block == Blocks.field_150333_U && (p.meta & 7) == 4) {
                        this.addToCost(Blocks.field_150336_V, 1);
                        continue;
                    }
                    if (p.block == Blocks.field_150333_U && (p.meta & 7) == 5) {
                        this.addToCost(Blocks.field_150348_b, 1);
                        continue;
                    }
                    if (p.block == Blocks.field_150376_bx && (p.meta & 7) == 0) {
                        ++plankOakCost;
                        continue;
                    }
                    if (p.block == Blocks.field_150376_bx && (p.meta & 7) == 1) {
                        ++plankPineCost;
                        continue;
                    }
                    if (p.block == Blocks.field_150376_bx && (p.meta & 7) == 2) {
                        ++plankBirchCost;
                        continue;
                    }
                    if (p.block == Blocks.field_150376_bx && (p.meta & 7) == 3) {
                        ++plankJungleCost;
                        continue;
                    }
                    if (p.block == Blocks.field_150325_L) {
                        this.addToCost(Blocks.field_150325_L, 1);
                        continue;
                    }
                    if (p.block == Blocks.field_150388_bm) {
                        this.addToCost(Items.field_151075_bm, 1);
                        continue;
                    }
                    if (p.block == Blocks.field_150334_T) {
                        this.addToCost(Blocks.field_150348_b, 1);
                        continue;
                    }
                    if (p.block == Blocks.field_150339_S) {
                        this.addToCost(Items.field_151042_j, 9);
                        continue;
                    }
                    if (p.block == Blocks.field_150411_aY) {
                        this.addToCost(Items.field_151042_j, 1);
                        continue;
                    }
                    if (p.block == Blocks.field_150340_R) {
                        this.addToCost(Items.field_151043_k, 9);
                        continue;
                    }
                    if (p.block == Blocks.field_150383_bp) {
                        this.addToCost(Items.field_151042_j, 7);
                        continue;
                    }
                    if (p.block == Blocks.field_150463_bK) {
                        this.addToCost(Blocks.field_150347_e, 1);
                        continue;
                    }
                    if (p.isType(blockedchest)) {
                        plankCost += 8;
                        continue;
                    }
                    if (p.isType(bfurnace)) {
                        this.addToCost(Blocks.field_150347_e, 8);
                        continue;
                    }
                    if (p.isType(bmainchest)) {
                        plankCost += 8;
                        continue;
                    }
                    if (p.isSubType(prefixWoodstairOak)) {
                        plankOakCost += 2;
                        continue;
                    }
                    if (p.isSubType(prefixWoodstairPine)) {
                        plankPineCost += 2;
                        continue;
                    }
                    if (p.isSubType(prefixWoodstairBirch)) {
                        plankBirchCost += 2;
                        continue;
                    }
                    if (p.isSubType(prefixWoodstairJungle)) {
                        plankJungleCost += 2;
                        continue;
                    }
                    if (p.isSubType(prefixStonestair)) {
                        this.addToCost(Blocks.field_150347_e, 2);
                        continue;
                    }
                    if (p.isSubType(prefixBrickStonestair)) {
                        this.addToCost(Blocks.field_150348_b, 2);
                        continue;
                    }
                    if (p.isSubType(prefixSandStoneStair)) {
                        this.addToCost(Blocks.field_150322_A, 2);
                        continue;
                    }
                    if (p.isSubType(prefixBrickstair)) {
                        this.addToCost(Blocks.field_150336_V, 2);
                        continue;
                    }
                    if (p.isSubType(prefixLadder)) {
                        plankCost += 2;
                        continue;
                    }
                    if (p.isSubType(prefixSign)) {
                        plankCost += 7;
                        continue;
                    }
                    if (p.isSubType(prefixDoor)) {
                        plankCost += 6;
                        continue;
                    }
                    if (p.isSubType(prefixTrapdoor)) {
                        plankCost += 6;
                        continue;
                    }
                    if (p.isSubType(prefixBed)) {
                        plankCost += 3;
                        this.addToCost(Blocks.field_150325_L, 0, 3);
                        continue;
                    }
                    if (p.isType(btapestry)) {
                        this.addToCost(Mill.tapestry, 1);
                        continue;
                    }
                    if (p.isType(bindianstatue)) {
                        this.addToCost(Mill.indianstatue, 1);
                        continue;
                    }
                    if (p.isType(bmayanstatue)) {
                        this.addToCost(Mill.mayanstatue, 1);
                        continue;
                    }
                    if (p.isType(bbyzantineiconsmall)) {
                        this.addToCost(Mill.byzantineiconsmall, 1);
                        continue;
                    }
                    if (p.isType(bbyzantineiconmedium)) {
                        this.addToCost(Mill.byzantineiconmedium, 1);
                        continue;
                    }
                    if (p.isType(bbyzantineiconmedium)) {
                        this.addToCost(Mill.byzantineiconmedium, 1);
                        continue;
                    }
                    if (p.isType(bsilkwormblock)) {
                        plankCost += 4;
                        continue;
                    }
                    if (p.isType(bbyzantinetiles_bottomtop)) {
                        byzBricksHalf += 2;
                        continue;
                    }
                    if (p.isType(bbyzantinetiles_leftright)) {
                        byzBricksHalf += 2;
                        continue;
                    }
                    if (p.isType(bbyzantinestonetiles_bottomtop)) {
                        ++byzBricksHalf;
                        this.addToCost(Blocks.field_150348_b, 1);
                        continue;
                    }
                    if (p.isType(bbyzantinestonetiles_leftright)) {
                        ++byzBricksHalf;
                        this.addToCost(Blocks.field_150348_b, 1);
                        continue;
                    }
                    if (p.isType(bbyzantineslab_bottomtop)) {
                        ++byzBricksHalf;
                        continue;
                    }
                    if (p.isType(bbyzantineslab_leftright)) {
                        ++byzBricksHalf;
                        continue;
                    }
                    if (p.isType(bbyzantineslab_bottomtop_inv)) {
                        ++byzBricksHalf;
                        continue;
                    }
                    if (p.isType(bbyzantineslab_leftright_inv)) {
                        ++byzBricksHalf;
                        continue;
                    }
                    if (p.block == null || p.block == Blocks.field_150350_a || Goods.freeGoods.contains(new InvItem(p.block, p.meta)) || Goods.freeGoods.contains(new InvItem(p.block, -1))) continue;
                    this.addToCost(p.block, p.meta, 1);
                }
            }
        }
        if (plankCost > 0) {
            this.addToCost(Blocks.field_150364_r, -1, (int)Math.max(Math.ceil((double)plankCost * 1.0 / 4.0), 1.0));
        }
        if (plankOakCost > 0) {
            this.addToCost(Blocks.field_150364_r, 0, (int)Math.max(Math.ceil((double)plankOakCost * 1.0 / 4.0), 1.0));
        }
        if (plankPineCost > 0) {
            this.addToCost(Blocks.field_150364_r, 1, (int)Math.max(Math.ceil((double)plankPineCost * 1.0 / 4.0), 1.0));
        }
        if (plankBirchCost > 0) {
            this.addToCost(Blocks.field_150364_r, 2, (int)Math.max(Math.ceil((double)plankBirchCost * 1.0 / 4.0), 1.0));
        }
        if (plankJungleCost > 0) {
            this.addToCost(Blocks.field_150364_r, 3, (int)Math.max(Math.ceil((double)plankJungleCost * 1.0 / 4.0), 1.0));
        }
        if (glassPaneCost > 0) {
            this.addToCost(Blocks.field_150359_w, 0, (int)Math.max(Math.ceil((double)glassPaneCost * 6.0 / 16.0), 1.0));
        }
        if (byzBricksHalf > 0) {
            this.addToCost(Mill.byzantine_tiles, 0, (int)Math.max(Math.ceil(byzBricksHalf / 2), 1.0));
        }
        if (MLN.LogBuildingPlan >= 1) {
            MLN.major(this, "Loaded plan for " + this.planName + ".");
        }
    }

    public BuildingLocation findBuildingLocation(MillWorldInfo winfo, AStarPathing pathing, Point centre, int maxRadius, Random random, int porientation) {
        long startTime = System.nanoTime();
        int ci = centre.getiX() - winfo.mapStartX;
        int cj = centre.getiZ() - winfo.mapStartZ;
        int radius = (int)((float)maxRadius * this.minDistance);
        maxRadius = (int)((float)maxRadius * this.maxDistance);
        if (MLN.LogWorldGeneration >= 1) {
            MLN.major(this, "testBuildWorldInfo: Called to test for building " + this.planName + " around " + centre + "(" + ci + "/" + cj + "), start radius: " + radius + ", max radius: " + maxRadius);
        }
        for (int i = 0; i < winfo.length; ++i) {
            for (int j = 0; j < winfo.width; ++j) {
                winfo.buildTested[i][j] = false;
            }
        }
        while (radius < maxRadius) {
            LocationReturn lr;
            int mini = Math.max(0, ci - radius);
            int maxi = Math.min(winfo.length - 1, ci + radius);
            int minj = Math.max(0, cj - radius);
            int maxj = Math.min(winfo.width - 1, cj + radius);
            if (MLN.LogWorldGeneration >= 3) {
                MLN.debug(this, "Testing square: " + mini + "/" + minj + " to " + maxi + "/" + maxj);
            }
            for (int i = mini; i < maxi; ++i) {
                if (cj - radius == minj) {
                    lr = this.testSpot(winfo, pathing, centre, i, minj, random, porientation);
                    if (lr.location != null) {
                        if (MLN.LogBuildingPlan >= 2) {
                            MLN.minor(this, "Time taken for location search: " + (double)(System.nanoTime() - startTime) / 1000000.0);
                        }
                        return lr.location;
                    }
                }
                if (cj + radius != maxj) continue;
                lr = this.testSpot(winfo, pathing, centre, i, maxj, random, porientation);
                if (lr.location == null) continue;
                if (MLN.LogBuildingPlan >= 2) {
                    MLN.minor(this, "Time taken for location search: " + (double)(System.nanoTime() - startTime) / 1000000.0);
                }
                return lr.location;
            }
            for (int j = minj; j < maxj; ++j) {
                if (ci - radius == mini) {
                    lr = this.testSpot(winfo, pathing, centre, mini, j, random, porientation);
                    if (lr.location != null) {
                        if (MLN.LogBuildingPlan >= 2) {
                            MLN.minor(this, "Time taken for location search: " + (double)(System.nanoTime() - startTime) / 1000000.0);
                        }
                        return lr.location;
                    }
                }
                if (ci + radius != maxi) continue;
                lr = this.testSpot(winfo, pathing, centre, maxi, j, random, porientation);
                if (lr.location == null) continue;
                if (MLN.LogBuildingPlan >= 2) {
                    MLN.minor(this, "Time taken for location search: " + (double)(System.nanoTime() - startTime) / 1000000.0);
                }
                return lr.location;
            }
            ++radius;
        }
        if (MLN.LogWorldGeneration >= 1) {
            MLN.major(this, "Could not find acceptable location (radius: " + radius + ")");
        }
        if (MLN.LogBuildingPlan >= 2) {
            MLN.minor(this, "Time taken for unsuccessful location search: " + (double)(System.nanoTime() - startTime) / 1000000.0);
        }
        return null;
    }

    private int getBedMeta(int direction, int orientation) {
        int faces = (direction + 4 - orientation) % 4;
        if (faces == 0) {
            return 1;
        }
        if (faces == 1) {
            return 2;
        }
        if (faces == 2) {
            return 3;
        }
        return 0;
    }

    public Block getBlock(World worldObj, Point p) {
        return MillCommonUtilities.getBlock(worldObj, p);
    }

    public BuildingBlock[] getBuildingPoints(World world, BuildingLocation location, boolean villageGeneration) {
        Point p;
        Object b;
        int m;
        PointType pt;
        int k;
        int j;
        int i;
        Point p2;
        int i2;
        int x = location.pos.getiX();
        int y = location.pos.getiY();
        int z = location.pos.getiZ();
        int orientation = location.orientation;
        this.nbBlocksToPut = 0;
        int approximateBlocks = (this.length + this.areaToClear * 2) * (this.width + this.areaToClear * 2) * (this.nbfloors + 50);
        ArrayList<BuildingBlock> bblocks = new ArrayList<BuildingBlock>(approximateBlocks + 100);
        if (MLN.LogWorldGeneration >= 2) {
            MLN.minor(this, "Getting blocks for " + this.planName + " at " + x + "/" + y + "/" + z + "/" + orientation);
        }
        if (!(this.isUpdate || this.isSubBuilding() || location.bedrocklevel)) {
            int offset;
            int ak;
            int k2;
            int j2;
            for (j2 = -this.areaToClear; j2 < this.length + this.areaToClear; ++j2) {
                for (k2 = -this.areaToClear; k2 < this.width + this.areaToClear; ++k2) {
                    for (i2 = this.nbfloors + 50; i2 > -1; --i2) {
                        ak = j2 % 2 == 0 ? k2 : this.width - k2 - 1;
                        offset = 0;
                        if (j2 < 0) {
                            offset = -j2;
                        } else if (j2 >= this.length - 1) {
                            offset = j2 - this.length + 1;
                        }
                        if (ak < 0 && -ak > offset) {
                            offset = -ak;
                        } else if (ak >= this.width - 1 && ak - this.width + 1 > offset) {
                            offset = ak - this.width + 1;
                        }
                        if (i2 >= --offset - 1) {
                            p2 = BuildingPlan.adjustForOrientation(x, y + i2, z, j2 - this.lengthOffset, ak - this.widthOffset, orientation);
                            bblocks.add(new BuildingBlock(p2, 0, 0, (int)BuildingBlock.CLEARGROUND));
                            continue;
                        }
                        p2 = BuildingPlan.adjustForOrientation(x, y + i2, z, j2 - this.lengthOffset, k2 - this.widthOffset, orientation);
                        bblocks.add(new BuildingBlock(p2, 0, 0, (int)BuildingBlock.CLEARTREE));
                    }
                }
            }
            for (j2 = -this.areaToClear; j2 < this.length + this.areaToClear; ++j2) {
                for (k2 = -this.areaToClear; k2 < this.width + this.areaToClear; ++k2) {
                    for (i2 = -10 + this.startLevel; i2 < 0; ++i2) {
                        ak = j2 % 2 == 0 ? k2 : this.width - k2 - 1;
                        offset = 0;
                        if (j2 < 0) {
                            offset = -j2;
                        } else if (j2 >= this.length - 1) {
                            offset = j2 - this.length + 1;
                        }
                        if (ak < 0 && -ak > offset) {
                            offset = -ak;
                        } else if (ak >= this.width - 1 && ak - this.width + 1 > offset) {
                            offset = ak - this.width + 1;
                        }
                        if (-i2 > --offset) {
                            p2 = BuildingPlan.adjustForOrientation(x, y + i2, z, j2 - this.lengthOffset, k2 - this.widthOffset, orientation);
                            bblocks.add(new BuildingBlock(p2, 0, 0, (int)BuildingBlock.PRESERVEGROUNDDEPTH));
                            ++this.nbBlocksToPut;
                            continue;
                        }
                        if (-i2 == offset) {
                            p2 = BuildingPlan.adjustForOrientation(x, y + i2, z, j2 - this.lengthOffset, k2 - this.widthOffset, orientation);
                            bblocks.add(new BuildingBlock(p2, 0, 0, (int)BuildingBlock.PRESERVEGROUNDSURFACE));
                            ++this.nbBlocksToPut;
                            continue;
                        }
                        p2 = BuildingPlan.adjustForOrientation(x, y + i2, z, j2 - this.lengthOffset, k2 - this.widthOffset, orientation);
                        bblocks.add(new BuildingBlock(p2, 0, 0, (int)BuildingBlock.CLEARTREE));
                    }
                }
            }
        }
        for (i = 0; i < this.nbfloors; ++i) {
            for (j = 0; j < this.length; ++j) {
                for (k = 0; k < this.width; ++k) {
                    Point p3;
                    PointType pt2 = this.plan[i][j][k];
                    if (pt2.isType(bpreserveground)) {
                        p3 = BuildingPlan.adjustForOrientation(x, y + i + this.startLevel, z, j - this.lengthOffset, k - this.widthOffset, orientation);
                        bblocks.add(new BuildingBlock(p3, 0, 0, (int)BuildingBlock.PRESERVEGROUNDSURFACE));
                        ++this.nbBlocksToPut;
                        continue;
                    }
                    if (!pt2.isType(ballbuttrees)) continue;
                    p3 = BuildingPlan.adjustForOrientation(x, y + i + this.startLevel, z, j - this.lengthOffset, k - this.widthOffset, orientation);
                    bblocks.add(new BuildingBlock(p3, 0, 0, (int)BuildingBlock.CLEARTREE));
                    ++this.nbBlocksToPut;
                }
            }
        }
        for (i = this.nbfloors - 1; i >= 0; --i) {
            for (j = 0; j < this.length; ++j) {
                for (k = 0; k < this.width; ++k) {
                    int ak = j % 2 == 0 ? k : this.width - k - 1;
                    PointType pt3 = this.plan[i][j][ak];
                    p2 = BuildingPlan.adjustForOrientation(x, y + i + this.startLevel, z, j - this.lengthOffset, ak - this.widthOffset, orientation);
                    if (pt3.block != Blocks.field_150350_a) continue;
                    bblocks.add(new BuildingBlock(p2, Blocks.field_150350_a, 0));
                }
            }
        }
        for (i = 0; i < this.nbfloors; ++i) {
            for (j = 0; j < this.length; ++j) {
                for (k = 0; k < this.width; ++k) {
                    int ak = j % 2 == 0 ? k : this.width - k - 1;
                    int ai = i + this.startLevel < 0 ? -i - this.startLevel - 1 : i;
                    pt = this.plan[ai][j][ak];
                    m = 0;
                    b = null;
                    p = BuildingPlan.adjustForOrientation(x, y + ai + this.startLevel, z, j - this.lengthOffset, ak - this.widthOffset, orientation);
                    if (pt.block != null && pt.block != Blocks.field_150350_a && !pt.secondStep) {
                        b = pt.block;
                        m = pt.meta;
                    } else if (pt.isType(bempty) && !this.isUpdate && !TYPE_SUBBUILDING.equals(this.type)) {
                        b = Blocks.field_150350_a;
                    } else if (pt.isType(bgrass) && villageGeneration) {
                        b = Blocks.field_150349_c;
                    } else if (pt.isType(bgrass) && !villageGeneration) {
                        b = Blocks.field_150346_d;
                    } else if (pt.isType(bsoil) && villageGeneration) {
                        b = Blocks.field_150349_c;
                    } else if (pt.isType(bricesoil) && villageGeneration) {
                        b = Blocks.field_150349_c;
                    } else if (pt.isType(bturmericsoil) && villageGeneration) {
                        b = Blocks.field_150349_c;
                    } else if (pt.isType(bmaizesoil) && villageGeneration) {
                        b = Blocks.field_150349_c;
                    } else if (pt.isType(bcarrotsoil) && villageGeneration) {
                        b = Blocks.field_150349_c;
                    } else if (pt.isType(bpotatosoil) && villageGeneration) {
                        b = Blocks.field_150349_c;
                    } else if (pt.isType(bsugarcanesoil) && villageGeneration) {
                        b = Blocks.field_150349_c;
                    } else if (pt.isType(bvinesoil) && villageGeneration) {
                        b = Blocks.field_150349_c;
                    } else if (pt.isType(bcacaospot) && villageGeneration) {
                        b = Blocks.field_150375_by;
                    } else if (pt.isType(bsoil) && !villageGeneration) {
                        b = Blocks.field_150346_d;
                    } else if (pt.isType(bricesoil) && !villageGeneration) {
                        b = Blocks.field_150346_d;
                    } else if (pt.isType(bturmericsoil) && !villageGeneration) {
                        b = Blocks.field_150346_d;
                    } else if (pt.isType(bmaizesoil) && !villageGeneration) {
                        b = Blocks.field_150346_d;
                    } else if (pt.isType(bpotatosoil) && villageGeneration) {
                        b = Blocks.field_150346_d;
                    } else if (pt.isType(bcarrotsoil) && !villageGeneration) {
                        b = Blocks.field_150346_d;
                    } else if (pt.isType(bsugarcanesoil) && !villageGeneration) {
                        b = Blocks.field_150346_d;
                    } else if (pt.isType(bvinesoil) && !villageGeneration) {
                        b = Blocks.field_150346_d;
                    } else if (pt.isType(bcacaospot) && !villageGeneration) {
                        b = null;
                    } else if (pt.isType(bnetherwartsoil)) {
                        b = Blocks.field_150425_aM;
                    } else if (pt.isType(bsilkwormblock)) {
                        b = Mill.wood_decoration;
                        m = 3;
                    } else if (pt.isType(blockedchest)) {
                        b = Mill.lockedChest;
                    } else if (pt.isType(bfurnace)) {
                        b = Blocks.field_150460_al;
                    } else if (pt.isType(bbrewingstand)) {
                        b = Blocks.field_150382_bo;
                    } else if (pt.isType(blogoakhor)) {
                        b = Blocks.field_150364_r;
                        m = this.getWoodMeta(0, orientation);
                    } else if (pt.isType(blogoakvert)) {
                        b = Blocks.field_150364_r;
                        m = this.getWoodMeta(1, orientation);
                    } else if (pt.isType(blogpinehor)) {
                        b = Blocks.field_150364_r;
                        m = 1 + this.getWoodMeta(0, orientation);
                    } else if (pt.isType(blogpinevert)) {
                        b = Blocks.field_150364_r;
                        m = 1 + this.getWoodMeta(1, orientation);
                    } else if (pt.isType(blogbirchhor)) {
                        b = Blocks.field_150364_r;
                        m = 2 + this.getWoodMeta(0, orientation);
                    } else if (pt.isType(blogbirchvert)) {
                        b = Blocks.field_150364_r;
                        m = 2 + this.getWoodMeta(1, orientation);
                    } else if (pt.isType(blogjunglehor)) {
                        b = Blocks.field_150364_r;
                        m = 3 + this.getWoodMeta(0, orientation);
                    } else if (pt.isType(blogjunglevert)) {
                        b = Blocks.field_150364_r;
                        m = 3 + this.getWoodMeta(1, orientation);
                    } else if (pt.isType(bwoodstairsOakTop)) {
                        b = Blocks.field_150476_ad;
                        m = this.getStairMeta(0, orientation);
                    } else if (pt.isType(bwoodstairsOakRight)) {
                        b = Blocks.field_150476_ad;
                        m = this.getStairMeta(1, orientation);
                    } else if (pt.isType(bwoodstairsOakBottom)) {
                        b = Blocks.field_150476_ad;
                        m = this.getStairMeta(2, orientation);
                    } else if (pt.isType(bwoodstairsOakLeft)) {
                        b = Blocks.field_150476_ad;
                        m = this.getStairMeta(3, orientation);
                    } else if (pt.isType(bwoodstairsPineTop)) {
                        b = Blocks.field_150485_bF;
                        m = this.getStairMeta(0, orientation);
                    } else if (pt.isType(bwoodstairsPineRight)) {
                        b = Blocks.field_150485_bF;
                        m = this.getStairMeta(1, orientation);
                    } else if (pt.isType(bwoodstairsPineBottom)) {
                        b = Blocks.field_150485_bF;
                        m = this.getStairMeta(2, orientation);
                    } else if (pt.isType(bwoodstairsPineLeft)) {
                        b = Blocks.field_150485_bF;
                        m = this.getStairMeta(3, orientation);
                    } else if (pt.isType(bwoodstairsBirchTop)) {
                        b = Blocks.field_150487_bG;
                        m = this.getStairMeta(0, orientation);
                    } else if (pt.isType(bwoodstairsBirchRight)) {
                        b = Blocks.field_150487_bG;
                        m = this.getStairMeta(1, orientation);
                    } else if (pt.isType(bwoodstairsBirchBottom)) {
                        b = Blocks.field_150487_bG;
                        m = this.getStairMeta(2, orientation);
                    } else if (pt.isType(bwoodstairsBirchLeft)) {
                        b = Blocks.field_150487_bG;
                        m = this.getStairMeta(3, orientation);
                    } else if (pt.isType(bwoodstairsJungleTop)) {
                        b = Blocks.field_150481_bH;
                        m = this.getStairMeta(0, orientation);
                    } else if (pt.isType(bwoodstairsJungleRight)) {
                        b = Blocks.field_150481_bH;
                        m = this.getStairMeta(1, orientation);
                    } else if (pt.isType(bwoodstairsJungleBottom)) {
                        b = Blocks.field_150481_bH;
                        m = this.getStairMeta(2, orientation);
                    } else if (pt.isType(bwoodstairsJungleLeft)) {
                        b = Blocks.field_150481_bH;
                        m = this.getStairMeta(3, orientation);
                    } else if (pt.isType(bstonestairsTop)) {
                        b = Blocks.field_150446_ar;
                        m = this.getStairMeta(0, orientation);
                    } else if (pt.isType(bstonestairsRight)) {
                        b = Blocks.field_150446_ar;
                        m = this.getStairMeta(1, orientation);
                    } else if (pt.isType(bstonestairsBottom)) {
                        b = Blocks.field_150446_ar;
                        m = this.getStairMeta(2, orientation);
                    } else if (pt.isType(bstonestairsLeft)) {
                        b = Blocks.field_150446_ar;
                        m = this.getStairMeta(3, orientation);
                    } else if (pt.isType(bstonebrickstairsTop)) {
                        b = Blocks.field_150390_bg;
                        m = this.getStairMeta(0, orientation);
                    } else if (pt.isType(bstonebrickstairsRight)) {
                        b = Blocks.field_150390_bg;
                        m = this.getStairMeta(1, orientation);
                    } else if (pt.isType(bstonebrickstairsBottom)) {
                        b = Blocks.field_150390_bg;
                        m = this.getStairMeta(2, orientation);
                    } else if (pt.isType(bstonebrickstairsLeft)) {
                        b = Blocks.field_150390_bg;
                        m = this.getStairMeta(3, orientation);
                    } else if (pt.isType(bbrickstairsTop)) {
                        b = Blocks.field_150389_bf;
                        m = this.getStairMeta(0, orientation);
                    } else if (pt.isType(bbrickstairsRight)) {
                        b = Blocks.field_150389_bf;
                        m = this.getStairMeta(1, orientation);
                    } else if (pt.isType(bbrickstairsBottom)) {
                        b = Blocks.field_150389_bf;
                        m = this.getStairMeta(2, orientation);
                    } else if (pt.isType(bbrickstairsLeft)) {
                        b = Blocks.field_150389_bf;
                        m = this.getStairMeta(3, orientation);
                    } else if (pt.isType(bsandstonestairsTop)) {
                        b = Blocks.field_150372_bz;
                        m = this.getStairMeta(0, orientation);
                    } else if (pt.isType(bsandstonestairsRight)) {
                        b = Blocks.field_150372_bz;
                        m = this.getStairMeta(1, orientation);
                    } else if (pt.isType(bsandstonestairsBottom)) {
                        b = Blocks.field_150372_bz;
                        m = this.getStairMeta(2, orientation);
                    } else if (pt.isType(bsandstonestairsLeft)) {
                        b = Blocks.field_150372_bz;
                        m = this.getStairMeta(3, orientation);
                    } else if (pt.isType(bwoodstairsOakInvTop)) {
                        b = Blocks.field_150476_ad;
                        m = this.getStairMeta(0, orientation) + 4;
                    } else if (pt.isType(bwoodstairsOakInvRight)) {
                        b = Blocks.field_150476_ad;
                        m = this.getStairMeta(1, orientation) + 4;
                    } else if (pt.isType(bwoodstairsOakInvBottom)) {
                        b = Blocks.field_150476_ad;
                        m = this.getStairMeta(2, orientation) + 4;
                    } else if (pt.isType(bwoodstairsOakInvLeft)) {
                        b = Blocks.field_150476_ad;
                        m = this.getStairMeta(3, orientation) + 4;
                    } else if (pt.isType(bwoodstairsPineInvTop)) {
                        b = Blocks.field_150485_bF;
                        m = this.getStairMeta(0, orientation) + 4;
                    } else if (pt.isType(bwoodstairsPineInvRight)) {
                        b = Blocks.field_150485_bF;
                        m = this.getStairMeta(1, orientation) + 4;
                    } else if (pt.isType(bwoodstairsPineInvBottom)) {
                        b = Blocks.field_150485_bF;
                        m = this.getStairMeta(2, orientation) + 4;
                    } else if (pt.isType(bwoodstairsPineInvLeft)) {
                        b = Blocks.field_150485_bF;
                        m = this.getStairMeta(3, orientation) + 4;
                    } else if (pt.isType(bwoodstairsBirchInvTop)) {
                        b = Blocks.field_150487_bG;
                        m = this.getStairMeta(0, orientation) + 4;
                    } else if (pt.isType(bwoodstairsBirchInvRight)) {
                        b = Blocks.field_150487_bG;
                        m = this.getStairMeta(1, orientation) + 4;
                    } else if (pt.isType(bwoodstairsBirchInvBottom)) {
                        b = Blocks.field_150487_bG;
                        m = this.getStairMeta(2, orientation) + 4;
                    } else if (pt.isType(bwoodstairsBirchInvLeft)) {
                        b = Blocks.field_150487_bG;
                        m = this.getStairMeta(3, orientation) + 4;
                    } else if (pt.isType(bwoodstairsJungleInvTop)) {
                        b = Blocks.field_150481_bH;
                        m = this.getStairMeta(0, orientation) + 4;
                    } else if (pt.isType(bwoodstairsJungleInvRight)) {
                        b = Blocks.field_150481_bH;
                        m = this.getStairMeta(1, orientation) + 4;
                    } else if (pt.isType(bwoodstairsJungleInvBottom)) {
                        b = Blocks.field_150481_bH;
                        m = this.getStairMeta(2, orientation) + 4;
                    } else if (pt.isType(bwoodstairsJungleInvLeft)) {
                        b = Blocks.field_150481_bH;
                        m = this.getStairMeta(3, orientation) + 4;
                    } else if (pt.isType(bstonestairsInvTop)) {
                        b = Blocks.field_150446_ar;
                        m = this.getStairMeta(0, orientation) + 4;
                    } else if (pt.isType(bstonestairsInvRight)) {
                        b = Blocks.field_150446_ar;
                        m = this.getStairMeta(1, orientation) + 4;
                    } else if (pt.isType(bstonestairsInvBottom)) {
                        b = Blocks.field_150446_ar;
                        m = this.getStairMeta(2, orientation) + 4;
                    } else if (pt.isType(bstonestairsInvLeft)) {
                        b = Blocks.field_150446_ar;
                        m = this.getStairMeta(3, orientation) + 4;
                    } else if (pt.isType(bstonebrickstairsInvTop)) {
                        b = Blocks.field_150390_bg;
                        m = this.getStairMeta(0, orientation) + 4;
                    } else if (pt.isType(bstonebrickstairsInvRight)) {
                        b = Blocks.field_150390_bg;
                        m = this.getStairMeta(1, orientation) + 4;
                    } else if (pt.isType(bstonebrickstairsInvBottom)) {
                        b = Blocks.field_150390_bg;
                        m = this.getStairMeta(2, orientation) + 4;
                    } else if (pt.isType(bstonebrickstairsInvLeft)) {
                        b = Blocks.field_150390_bg;
                        m = this.getStairMeta(3, orientation) + 4;
                    } else if (pt.isType(bbrickstairsInvTop)) {
                        b = Blocks.field_150389_bf;
                        m = this.getStairMeta(0, orientation) + 4;
                    } else if (pt.isType(bbrickstairsInvRight)) {
                        b = Blocks.field_150389_bf;
                        m = this.getStairMeta(1, orientation) + 4;
                    } else if (pt.isType(bbrickstairsInvBottom)) {
                        b = Blocks.field_150389_bf;
                        m = this.getStairMeta(2, orientation) + 4;
                    } else if (pt.isType(bbrickstairsInvLeft)) {
                        b = Blocks.field_150389_bf;
                        m = this.getStairMeta(3, orientation) + 4;
                    } else if (pt.isType(bsandstonestairsInvTop)) {
                        b = Blocks.field_150372_bz;
                        m = this.getStairMeta(0, orientation) + 4;
                    } else if (pt.isType(bsandstonestairsInvRight)) {
                        b = Blocks.field_150372_bz;
                        m = this.getStairMeta(1, orientation) + 4;
                    } else if (pt.isType(bsandstonestairsInvBottom)) {
                        b = Blocks.field_150372_bz;
                        m = this.getStairMeta(2, orientation) + 4;
                    } else if (pt.isType(bsandstonestairsInvLeft)) {
                        b = Blocks.field_150372_bz;
                        m = this.getStairMeta(3, orientation) + 4;
                    } else if (pt.isType(bbyzantinetiles_bottomtop)) {
                        b = Mill.byzantine_tiles;
                        m = this.getOrientedBlockMeta(0, orientation);
                    } else if (pt.isType(bbyzantinetiles_leftright)) {
                        b = Mill.byzantine_tiles;
                        m = this.getOrientedBlockMeta(1, orientation);
                    } else if (pt.isType(bbyzantinestonetiles_bottomtop)) {
                        b = Mill.byzantine_stone_tiles;
                        m = this.getOrientedBlockMeta(0, orientation);
                    } else if (pt.isType(bbyzantinestonetiles_leftright)) {
                        b = Mill.byzantine_stone_tiles;
                        m = this.getOrientedBlockMeta(1, orientation);
                    } else if (pt.isType(bbyzantineslab_bottomtop)) {
                        b = Mill.byzantine_tile_slab;
                        m = this.getOrientedBlockMeta(0, orientation);
                    } else if (pt.isType(bbyzantineslab_leftright)) {
                        b = Mill.byzantine_tile_slab;
                        m = this.getOrientedBlockMeta(1, orientation);
                    } else if (pt.isType(bbyzantineslab_bottomtop_inv)) {
                        b = Mill.byzantine_tile_slab;
                        m = this.getOrientedBlockMeta(0, orientation) + 8;
                    } else if (pt.isType(bbyzantineslab_leftright_inv)) {
                        b = Mill.byzantine_tile_slab;
                        m = this.getOrientedBlockMeta(1, orientation) + 8;
                    } else if (pt.isType(bsignpostTop)) {
                        b = Blocks.field_150472_an;
                        m = this.getSignOrLadderMeta(0, orientation);
                    } else if (pt.isType(bsignpostRight)) {
                        b = Blocks.field_150472_an;
                        m = this.getSignOrLadderMeta(1, orientation);
                    } else if (pt.isType(bsignpostBottom)) {
                        b = Blocks.field_150472_an;
                        m = this.getSignOrLadderMeta(2, orientation);
                    } else if (pt.isType(bsignpostLeft)) {
                        b = Blocks.field_150472_an;
                        m = this.getSignOrLadderMeta(3, orientation);
                    } else if (pt.isType(bsleepingPos)) {
                        b = Blocks.field_150350_a;
                        location.sleepingPos = p;
                    } else if (pt.isType(bsellingPos)) {
                        b = Blocks.field_150350_a;
                        location.sellingPos = p;
                    } else if (pt.isType(bcraftingPos)) {
                        b = Blocks.field_150350_a;
                        location.craftingPos = p;
                    } else if (pt.isType(bshelterPos)) {
                        b = Blocks.field_150350_a;
                        location.shelterPos = p;
                    } else if (pt.isType(bdefendingPos)) {
                        b = Blocks.field_150350_a;
                        location.defendingPos = p;
                    } else if (pt.isType(bsandsource)) {
                        b = Blocks.field_150354_m;
                    } else if (pt.isType(bsandstonesource)) {
                        b = Blocks.field_150322_A;
                    } else if (pt.isType(bclaysource)) {
                        b = Blocks.field_150435_aG;
                    } else if (pt.isType(bgravelsource)) {
                        b = Blocks.field_150351_n;
                    } else if (pt.isType(bstonesource)) {
                        b = Blocks.field_150348_b;
                    } else if (pt.isType(bfreesand)) {
                        b = Blocks.field_150354_m;
                    } else if (pt.isType(bfreesandstone)) {
                        b = Blocks.field_150322_A;
                    } else if (pt.isType(bfreegravel)) {
                        b = Blocks.field_150351_n;
                    } else if (pt.isType(bfreewool)) {
                        b = Blocks.field_150325_L;
                    } else if (pt.isType(bfreestone)) {
                        b = Blocks.field_150348_b;
                    } else if (pt.isType(bsquidspawn)) {
                        b = Blocks.field_150355_j;
                    }
                    if (b == null) continue;
                    bblocks.add(new BuildingBlock(p, (Block)b, m));
                    ++this.nbBlocksToPut;
                }
            }
        }
        for (i = 0; i < this.nbfloors; ++i) {
            for (j = 0; j < this.length; ++j) {
                for (k = 0; k < this.width; ++k) {
                    int ak = j % 2 == 0 ? k : this.width - k - 1;
                    int ai = i + this.startLevel < 0 ? -i - this.startLevel - 1 : i;
                    pt = this.plan[ai][j][ak];
                    m = 0;
                    b = null;
                    p = BuildingPlan.adjustForOrientation(x, y + ai + this.startLevel, z, j - this.lengthOffset, ak - this.widthOffset, orientation);
                    if (pt.block != null && pt.secondStep) {
                        b = pt.block;
                        m = pt.meta;
                    } else if (pt.isType(bwoodstairsOakGuess)) {
                        b = Blocks.field_150476_ad;
                        m = -1;
                    } else if (pt.isType(bstonestairGuess)) {
                        b = Blocks.field_150446_ar;
                        m = -1;
                    } else if (pt.isType(bladderGuess)) {
                        b = Blocks.field_150468_ap;
                        m = -1;
                    } else if (pt.isType(bsignwallGuess)) {
                        b = Mill.panel;
                        m = this.guessSignMeta(bblocks, p);
                    } else if (pt.isType(bplainSignGuess)) {
                        b = Blocks.field_150444_as;
                        m = this.guessSignMeta(bblocks, p);
                    } else if (pt.isType(bsignwallTop)) {
                        b = Mill.panel;
                        m = this.getSignOrLadderMeta(0, orientation);
                    } else if (pt.isType(bsignwallRight)) {
                        b = Mill.panel;
                        m = this.getSignOrLadderMeta(3, orientation);
                    } else if (pt.isType(bsignwallBottom)) {
                        b = Mill.panel;
                        m = this.getSignOrLadderMeta(2, orientation);
                    } else if (pt.isType(bsignwallLeft)) {
                        b = Mill.panel;
                        m = this.getSignOrLadderMeta(1, orientation);
                    } else if (pt.isType(bladderTop)) {
                        b = Blocks.field_150468_ap;
                        m = this.getSignOrLadderMeta(0, orientation);
                    } else if (pt.isType(bladderRight)) {
                        b = Blocks.field_150468_ap;
                        m = this.getSignOrLadderMeta(3, orientation);
                    } else if (pt.isType(bladderBottom)) {
                        b = Blocks.field_150468_ap;
                        m = this.getSignOrLadderMeta(2, orientation);
                    } else if (pt.isType(bladderLeft)) {
                        b = Blocks.field_150468_ap;
                        m = this.getSignOrLadderMeta(1, orientation);
                    } else if (pt.isType(bdoorTop)) {
                        b = Blocks.field_150466_ao;
                        m = this.getDoorMeta(0, orientation);
                    } else if (pt.isType(bdoorRight)) {
                        b = Blocks.field_150466_ao;
                        m = this.getDoorMeta(1, orientation);
                    } else if (pt.isType(bdoorBottom)) {
                        b = Blocks.field_150466_ao;
                        m = this.getDoorMeta(2, orientation);
                    } else if (pt.isType(bdoorLeft)) {
                        b = Blocks.field_150466_ao;
                        m = this.getDoorMeta(3, orientation);
                    } else if (pt.isType(birondoorTop)) {
                        b = Blocks.field_150454_av;
                        m = this.getDoorMeta(0, orientation);
                    } else if (pt.isType(birondoorRight)) {
                        b = Blocks.field_150454_av;
                        m = this.getDoorMeta(1, orientation);
                    } else if (pt.isType(birondoorBottom)) {
                        b = Blocks.field_150454_av;
                        m = this.getDoorMeta(2, orientation);
                    } else if (pt.isType(birondoorLeft)) {
                        b = Blocks.field_150454_av;
                        m = this.getDoorMeta(3, orientation);
                    } else if (pt.isType(btrapdoorTop)) {
                        b = Blocks.field_150415_aT;
                        m = this.getTrapdoorMeta(0, orientation);
                    } else if (pt.isType(btrapdoorRight)) {
                        b = Blocks.field_150415_aT;
                        m = this.getTrapdoorMeta(1, orientation);
                    } else if (pt.isType(btrapdoorBottom)) {
                        b = Blocks.field_150415_aT;
                        m = this.getTrapdoorMeta(2, orientation);
                    } else if (pt.isType(btrapdoorLeft)) {
                        b = Blocks.field_150415_aT;
                        m = this.getTrapdoorMeta(3, orientation);
                    } else if (pt.isType(bfenceGateHorizontal)) {
                        b = Blocks.field_150396_be;
                        m = this.getFenceGateMeta(0, orientation);
                    } else if (pt.isType(bfenceGateVertical)) {
                        b = Blocks.field_150396_be;
                        m = this.getFenceGateMeta(1, orientation);
                    } else if (pt.isType(bbedTop)) {
                        b = Blocks.field_150324_C;
                        m = this.getBedMeta(0, orientation) + 8;
                    } else if (pt.isType(bbedRight)) {
                        b = Blocks.field_150324_C;
                        m = this.getBedMeta(1, orientation) + 8;
                    } else if (pt.isType(bbedBottom)) {
                        b = Blocks.field_150324_C;
                        m = this.getBedMeta(2, orientation) + 8;
                    } else if (pt.isType(bbedLeft)) {
                        b = Blocks.field_150324_C;
                        m = this.getBedMeta(3, orientation) + 8;
                    }
                    if (b == null) continue;
                    bblocks.add(new BuildingBlock(p, (Block)b, m));
                    ++this.nbBlocksToPut;
                }
            }
        }
        for (i = 0; i < this.nbfloors; ++i) {
            for (j = 0; j < this.length; ++j) {
                for (k = 0; k < this.width; ++k) {
                    Point p4;
                    PointType pt4 = this.plan[i][j][k];
                    if (pt4.isType(btapestry)) {
                        p4 = BuildingPlan.adjustForOrientation(x, y + i + this.startLevel, z, j - this.lengthOffset, k - this.widthOffset, orientation);
                        bblocks.add(new BuildingBlock(p4, 0, 0, (int)BuildingBlock.TAPESTRY));
                        ++this.nbBlocksToPut;
                        continue;
                    }
                    if (pt4.isType(bindianstatue)) {
                        p4 = BuildingPlan.adjustForOrientation(x, y + i + this.startLevel, z, j - this.lengthOffset, k - this.widthOffset, orientation);
                        bblocks.add(new BuildingBlock(p4, 0, 0, (int)BuildingBlock.INDIANSTATUE));
                        ++this.nbBlocksToPut;
                        continue;
                    }
                    if (pt4.isType(bmayanstatue)) {
                        p4 = BuildingPlan.adjustForOrientation(x, y + i + this.startLevel, z, j - this.lengthOffset, k - this.widthOffset, orientation);
                        bblocks.add(new BuildingBlock(p4, 0, 0, (int)BuildingBlock.MAYANSTATUE));
                        ++this.nbBlocksToPut;
                        continue;
                    }
                    if (pt4.isType(bbyzantineiconsmall)) {
                        p4 = BuildingPlan.adjustForOrientation(x, y + i + this.startLevel, z, j - this.lengthOffset, k - this.widthOffset, orientation);
                        bblocks.add(new BuildingBlock(p4, 0, 0, (int)BuildingBlock.BYZANTINEICONSMALL));
                        ++this.nbBlocksToPut;
                        continue;
                    }
                    if (pt4.isType(bbyzantineiconmedium)) {
                        p4 = BuildingPlan.adjustForOrientation(x, y + i + this.startLevel, z, j - this.lengthOffset, k - this.widthOffset, orientation);
                        bblocks.add(new BuildingBlock(p4, 0, 0, (int)BuildingBlock.BYZANTINEICONMEDIUM));
                        ++this.nbBlocksToPut;
                        continue;
                    }
                    if (pt4.isType(bbyzantineiconlarge)) {
                        p4 = BuildingPlan.adjustForOrientation(x, y + i + this.startLevel, z, j - this.lengthOffset, k - this.widthOffset, orientation);
                        bblocks.add(new BuildingBlock(p4, 0, 0, (int)BuildingBlock.BYZANTINEICONLARGE));
                        ++this.nbBlocksToPut;
                        continue;
                    }
                    if (pt4.isType(boakspawn)) {
                        p4 = BuildingPlan.adjustForOrientation(x, y + i + this.startLevel, z, j - this.lengthOffset, k - this.widthOffset, orientation);
                        bblocks.add(new BuildingBlock(p4, 0, 0, (int)BuildingBlock.OAKSPAWN));
                        ++this.nbBlocksToPut;
                        continue;
                    }
                    if (pt4.isType(bpinespawn)) {
                        p4 = BuildingPlan.adjustForOrientation(x, y + i + this.startLevel, z, j - this.lengthOffset, k - this.widthOffset, orientation);
                        bblocks.add(new BuildingBlock(p4, 0, 0, (int)BuildingBlock.PINESPAWN));
                        ++this.nbBlocksToPut;
                        continue;
                    }
                    if (pt4.isType(bbirchspawn)) {
                        p4 = BuildingPlan.adjustForOrientation(x, y + i + this.startLevel, z, j - this.lengthOffset, k - this.widthOffset, orientation);
                        bblocks.add(new BuildingBlock(p4, 0, 0, (int)BuildingBlock.BIRCHSPAWN));
                        ++this.nbBlocksToPut;
                        continue;
                    }
                    if (pt4.isType(bjunglespawn)) {
                        p4 = BuildingPlan.adjustForOrientation(x, y + i + this.startLevel, z, j - this.lengthOffset, k - this.widthOffset, orientation);
                        bblocks.add(new BuildingBlock(p4, 0, 0, (int)BuildingBlock.JUNGLESPAWN));
                        ++this.nbBlocksToPut;
                        continue;
                    }
                    if (pt4.isType(bspawnerskeleton)) {
                        p4 = BuildingPlan.adjustForOrientation(x, y + i + this.startLevel, z, j - this.lengthOffset, k - this.widthOffset, orientation);
                        bblocks.add(new BuildingBlock(p4, 0, 0, (int)BuildingBlock.SPAWNERSKELETON));
                        ++this.nbBlocksToPut;
                        continue;
                    }
                    if (pt4.isType(bspawnerzombie)) {
                        p4 = BuildingPlan.adjustForOrientation(x, y + i + this.startLevel, z, j - this.lengthOffset, k - this.widthOffset, orientation);
                        bblocks.add(new BuildingBlock(p4, 0, 0, (int)BuildingBlock.SPAWNERZOMBIE));
                        ++this.nbBlocksToPut;
                        continue;
                    }
                    if (pt4.isType(bspawnerspider)) {
                        p4 = BuildingPlan.adjustForOrientation(x, y + i + this.startLevel, z, j - this.lengthOffset, k - this.widthOffset, orientation);
                        bblocks.add(new BuildingBlock(p4, 0, 0, (int)BuildingBlock.SPAWNERSPIDER));
                        ++this.nbBlocksToPut;
                        continue;
                    }
                    if (pt4.isType(bspawnercavespider)) {
                        p4 = BuildingPlan.adjustForOrientation(x, y + i + this.startLevel, z, j - this.lengthOffset, k - this.widthOffset, orientation);
                        bblocks.add(new BuildingBlock(p4, 0, 0, (int)BuildingBlock.SPAWNERCAVESPIDER));
                        ++this.nbBlocksToPut;
                        continue;
                    }
                    if (pt4.isType(bspawnercreeper)) {
                        p4 = BuildingPlan.adjustForOrientation(x, y + i + this.startLevel, z, j - this.lengthOffset, k - this.widthOffset, orientation);
                        bblocks.add(new BuildingBlock(p4, 0, 0, (int)BuildingBlock.SPAWNERCREEPER));
                        ++this.nbBlocksToPut;
                        continue;
                    }
                    if (pt4.isType(bspawnerblaze)) {
                        p4 = BuildingPlan.adjustForOrientation(x, y + i + this.startLevel, z, j - this.lengthOffset, k - this.widthOffset, orientation);
                        bblocks.add(new BuildingBlock(p4, 0, 0, (int)BuildingBlock.SPAWNERBLAZE));
                        ++this.nbBlocksToPut;
                        continue;
                    }
                    if (!pt4.isType(bdispenserunknownpowder)) continue;
                    p4 = BuildingPlan.adjustForOrientation(x, y + i + this.startLevel, z, j - this.lengthOffset, k - this.widthOffset, orientation);
                    bblocks.add(new BuildingBlock(p4, 0, 0, (int)BuildingBlock.DISPENDERUNKNOWNPOWDER));
                    ++this.nbBlocksToPut;
                }
            }
        }
        for (i = 0; i < this.nbfloors; ++i) {
            for (j = 0; j < this.length; ++j) {
                for (k = 0; k < this.width; ++k) {
                    Point p5;
                    PointType pt5 = this.plan[i][j][k];
                    if (!pt5.isType(bmainchest)) continue;
                    location.chestPos = p5 = BuildingPlan.adjustForOrientation(x, y + i + this.startLevel, z, j - this.lengthOffset, k - this.widthOffset, orientation);
                    bblocks.add(new BuildingBlock(p5, Mill.lockedChest, 1));
                    ++this.nbBlocksToPut;
                }
            }
        }
        if (location.chestPos == null) {
            location.chestPos = ((BuildingBlock)bblocks.get((int)(bblocks.size() - 1))).p;
        }
        this.setMetadata(bblocks);
        if (location.sleepingPos == null) {
            location.sleepingPos = location.chestPos;
        }
        HashMap<Point, BuildingBlock> bbmap = new HashMap<Point, BuildingBlock>();
        boolean[] toDelete = new boolean[bblocks.size()];
        for (i2 = 0; i2 < bblocks.size(); ++i2) {
            byte special;
            int bmeta;
            Block block;
            BuildingBlock bb = (BuildingBlock)bblocks.get(i2);
            if (bbmap.containsKey(bb.p)) {
                block = ((BuildingBlock)bbmap.get((Object)bb.p)).block;
                bmeta = ((BuildingBlock)bbmap.get((Object)bb.p)).meta;
                special = ((BuildingBlock)bbmap.get((Object)bb.p)).special;
            } else {
                block = MillCommonUtilities.getBlock(world, bb.p);
                bmeta = MillCommonUtilities.getBlockMeta(world, bb.p);
                special = 0;
            }
            if ((block == bb.block && bmeta == bb.meta && special == 0 || block == Blocks.field_150349_c && bb.block == Blocks.field_150346_d) && bb.special == 0) {
                toDelete[i2] = true;
                continue;
            }
            if (bb.special == BuildingBlock.CLEARTREE && block != Blocks.field_150364_r && block != Blocks.field_150362_t) {
                toDelete[i2] = true;
                continue;
            }
            if (bb.special == BuildingBlock.CLEARGROUND && (block == null || block == Blocks.field_150350_a)) {
                toDelete[i2] = true;
                continue;
            }
            if (bb.special == BuildingBlock.PRESERVEGROUNDDEPTH && MillCommonUtilities.getBlockIdValidGround(block, false) == block) {
                toDelete[i2] = true;
                continue;
            }
            if (bb.special == BuildingBlock.PRESERVEGROUNDSURFACE && MillCommonUtilities.getBlockIdValidGround(block, true) == block) {
                toDelete[i2] = true;
                continue;
            }
            bbmap.put(bb.p, bb);
            toDelete[i2] = false;
        }
        for (i2 = toDelete.length - 1; i2 >= 0; --i2) {
            if (!toDelete[i2]) continue;
            bblocks.remove(i2);
        }
        BuildingBlock[] abblocks = new BuildingBlock[bblocks.size()];
        for (int i3 = 0; i3 < bblocks.size(); ++i3) {
            abblocks[i3] = (BuildingBlock)bblocks.get(i3);
        }
        if (abblocks.length == 0) {
            MLN.error(this, "BBlocks size is zero.");
        }
        return abblocks;
    }

    @Override
    public Culture getCulture() {
        return this.culture;
    }

    private int getDoorMeta(int direction, int orientation) {
        int faces = (direction + 4 - orientation) % 4;
        if (faces == 0) {
            return 0;
        }
        if (faces == 1) {
            return 1;
        }
        if (faces == 2) {
            return 2;
        }
        return 3;
    }

    @Override
    public List<String> getFemaleResident() {
        return this.femaleResident;
    }

    private int getFenceGateMeta(int direction, int orientation) {
        int faces = (direction + 4 - orientation) % 4;
        if (faces == 0) {
            return 1;
        }
        if (faces == 1) {
            return 0;
        }
        if (faces == 2) {
            return 1;
        }
        return 0;
    }

    public String getFullDisplayName() {
        String name = this.nativeName;
        if (this.getGameName().length() > 0) {
            name = name + " (" + this.getGameName() + ")";
        }
        return name;
    }

    @Override
    public String getGameName() {
        if (this.culture.canReadBuildingNames()) {
            return this.culture.getBuildingGameName(this);
        }
        return "";
    }

    public String getGameNameKey() {
        return "_buildingGame:" + this.culture.key + ":" + this.buildingKey + ":" + this.variation + ":" + this.level;
    }

    @Override
    public List<String> getMaleResident() {
        return this.maleResident;
    }

    @Override
    public String getNativeName() {
        return this.nativeName;
    }

    private int getOrientedBlockMeta(int direction, int orientation) {
        int faces = (direction + 4 - orientation) % 4;
        if (faces == 0) {
            return 1;
        }
        if (faces == 1) {
            return 0;
        }
        if (faces == 2) {
            return 1;
        }
        return 0;
    }

    private int getSignOrLadderMeta(int direction, int orientation) {
        int faces = (direction + orientation) % 4;
        if (faces == 0) {
            return 5;
        }
        if (faces == 1) {
            return 2;
        }
        if (faces == 2) {
            return 4;
        }
        return 3;
    }

    private int getStairMeta(int direction, int orientation) {
        int faces = (direction + 4 - orientation) % 4;
        if (faces == 0) {
            return 1;
        }
        if (faces == 1) {
            return 3;
        }
        if (faces == 2) {
            return 0;
        }
        return 2;
    }

    private int getTrapdoorMeta(int direction, int orientation) {
        int faces = (direction + 4 - orientation) % 4;
        if (faces == 0) {
            return 3;
        }
        if (faces == 1) {
            return 0;
        }
        if (faces == 2) {
            return 2;
        }
        return 1;
    }

    private int getWoodMeta(int direction, int orientation) {
        int faces = (direction + 4 - orientation) % 4;
        if (faces == 0) {
            return 8;
        }
        if (faces == 1) {
            return 4;
        }
        if (faces == 2) {
            return 8;
        }
        return 4;
    }

    private int guessSignMeta(List<BuildingBlock> bblocks, Point p) {
        boolean westOpen = true;
        boolean eastOpen = true;
        boolean northOpen = true;
        boolean southOpen = true;
        int m = 0;
        Point west = p.getRelative(-1.0, 0.0, 0.0);
        Point east = p.getRelative(1.0, 0.0, 0.0);
        Point south = p.getRelative(0.0, 0.0, -1.0);
        Point north = p.getRelative(0.0, 0.0, 1.0);
        for (BuildingBlock block : bblocks) {
            if (block.p.sameBlock(west) && this.isBlockOpaqueCube(block.block)) {
                westOpen = false;
                continue;
            }
            if (block.p.sameBlock(east) && this.isBlockOpaqueCube(block.block)) {
                eastOpen = false;
                continue;
            }
            if (block.p.sameBlock(south) && this.isBlockOpaqueCube(block.block)) {
                southOpen = false;
                continue;
            }
            if (!block.p.sameBlock(north) || !this.isBlockOpaqueCube(block.block)) continue;
            northOpen = false;
        }
        if (!northOpen) {
            if (MLN.LogBuildingPlan >= 3) {
                MLN.debug(this, this.planName + ": Putting sign again north wall");
            }
            m = 2;
        } else if (!southOpen) {
            if (MLN.LogBuildingPlan >= 3) {
                MLN.debug(this, this.planName + ": Putting sign again south wall");
            }
            m = 3;
        } else if (!eastOpen) {
            if (MLN.LogBuildingPlan >= 3) {
                MLN.debug(this, this.planName + ": Putting sign again east wall");
            }
            m = 4;
        } else if (!westOpen) {
            if (MLN.LogBuildingPlan >= 3) {
                MLN.debug(this, this.planName + ": Putting sign again west wall");
            }
            m = 5;
        } else {
            if (MLN.LogBuildingPlan >= 1) {
                MLN.major(this, this.planName + ": No idea where to put sign.");
            }
            m = 2;
        }
        return m;
    }

    private void initialiseConfig(BuildingPlan parent) {
        if (parent == null) {
            this.max = 1;
            this.priority = 1;
            this.priorityMoveIn = 10;
            this.nativeName = null;
            this.areaToClear = 1;
            this.startLevel = 0;
            this.buildingOrientation = 1;
            this.signOrder = new int[]{0};
            this.tags = new ArrayList<String>();
            this.shop = null;
            this.minDistance = 0.0f;
            this.maxDistance = 1.0f;
            this.reputation = 0;
            this.price = 0;
            this.subBuildings = new ArrayList<String>();
            this.startingSubBuildings = new ArrayList<String>();
            this.startingGoods = new ArrayList<StartingGood>();
            this.showTownHallSigns = true;
            this.rebuildPath = true;
        } else {
            this.max = parent.max;
            this.priority = parent.priority;
            this.priorityMoveIn = parent.priorityMoveIn;
            this.nativeName = parent.nativeName;
            this.areaToClear = parent.areaToClear;
            this.startLevel = parent.startLevel;
            this.buildingOrientation = parent.buildingOrientation;
            this.signOrder = parent.signOrder;
            this.tags = new ArrayList<String>(parent.tags);
            this.maleResident = parent.maleResident;
            this.femaleResident = parent.femaleResident;
            this.shop = parent.shop;
            this.width = parent.width;
            this.length = parent.length;
            this.minDistance = parent.minDistance;
            this.maxDistance = parent.maxDistance;
            this.reputation = parent.reputation;
            this.isgift = parent.isgift;
            this.price = parent.price;
            this.pathLevel = parent.pathLevel;
            this.pathWidth = parent.pathWidth;
            this.subBuildings = new ArrayList<String>(parent.subBuildings);
            this.startingSubBuildings = new ArrayList<String>();
            this.startingGoods = new ArrayList<StartingGood>();
            this.parent = parent;
            if (MLN.LogBuildingPlan >= 2) {
                String s = "";
                for (String s2 : this.subBuildings) {
                    s = s + s2 + " ";
                }
                if (s.length() > 0) {
                    MLN.minor(this, "Copied sub-buildings from parent: " + s);
                }
            }
            this.showTownHallSigns = parent.showTownHallSigns;
            this.exploreTag = parent.exploreTag;
            this.irrigation = parent.irrigation;
        }
    }

    public boolean isBlockOpaqueCube(Block block) {
        return MillCommonUtilities.isBlockOpaqueCube(block);
    }

    public boolean isBuildable(Block block) {
        return block == Blocks.field_150350_a || block == Blocks.field_150362_t || block == Blocks.field_150364_r || block == Blocks.field_150338_P || block == Blocks.field_150337_Q || block == Blocks.field_150328_O || block == Blocks.field_150327_N;
    }

    public boolean isSubBuilding() {
        return TYPE_SUBBUILDING.equals(this.type);
    }

    public boolean mapIsOpaqueBlock(Map<Point, BuildingBlock> map, Point p) {
        return map.containsKey(p) && this.isBlockOpaqueCube(map.get((Object)p).block);
    }

    public boolean mapIsStairBlock(Map<Point, BuildingBlock> map, Point p) {
        if (!map.containsKey(p)) {
            return false;
        }
        Block block = map.get((Object)p).block;
        return block == Blocks.field_150446_ar || block == Blocks.field_150476_ad;
    }

    private void readConfigLine(File file, String line, boolean importPlan) {
        String[] configs;
        for (String config : configs = line.split(";", -1)) {
            String[] temp;
            if (config.split(":").length != 2) continue;
            String key = config.split(":")[0].toLowerCase();
            String value = config.split(":")[1];
            if (key.equalsIgnoreCase("max")) {
                this.max = Integer.parseInt(value);
                continue;
            }
            if (key.equalsIgnoreCase("priority")) {
                this.priority = Integer.parseInt(value);
                continue;
            }
            if (key.equalsIgnoreCase("moveinpriority")) {
                this.priorityMoveIn = Integer.parseInt(value);
                continue;
            }
            if (key.equalsIgnoreCase("french") || key.equalsIgnoreCase("native")) {
                this.nativeName = value;
                continue;
            }
            if (key.equalsIgnoreCase("english") || key.startsWith("name_")) {
                this.names.put(key, value);
                continue;
            }
            if (key.equalsIgnoreCase("around")) {
                this.areaToClear = Integer.parseInt(value);
                continue;
            }
            if (key.equalsIgnoreCase("startLevel")) {
                this.startLevel = Integer.parseInt(value);
                continue;
            }
            if (key.equalsIgnoreCase("orientation")) {
                this.buildingOrientation = Integer.parseInt(value);
                continue;
            }
            if (key.equalsIgnoreCase("pathlevel")) {
                this.pathLevel = Integer.parseInt(value);
                this.rebuildPath = true;
                continue;
            }
            if (key.equalsIgnoreCase("rebuildpath")) {
                this.rebuildPath = Boolean.parseBoolean(value);
                continue;
            }
            if (key.equalsIgnoreCase("isgift")) {
                this.isgift = Boolean.parseBoolean(value);
                continue;
            }
            if (key.equalsIgnoreCase("pathwidth")) {
                this.pathWidth = Integer.parseInt(value);
                continue;
            }
            if (key.equalsIgnoreCase("reputation")) {
                try {
                    this.reputation = MillCommonUtilities.readInteger(value);
                }
                catch (Exception e) {
                    this.reputation = 0;
                    MLN.error(null, "Error when reading reputation line in " + file.getName() + ": " + line + " : " + e.getMessage());
                }
                continue;
            }
            if (key.equalsIgnoreCase("price")) {
                try {
                    this.price = MillCommonUtilities.readInteger(value);
                }
                catch (Exception e) {
                    this.price = 0;
                    MLN.error(this, "Error when reading reputation line in " + file.getName() + ": " + line + " : " + e.getMessage());
                }
                continue;
            }
            if (key.equalsIgnoreCase("length")) {
                this.length = Integer.parseInt(value);
                continue;
            }
            if (key.equalsIgnoreCase("width")) {
                this.width = Integer.parseInt(value);
                continue;
            }
            if (!importPlan && key.equalsIgnoreCase("male")) {
                if (this.culture.villagerTypes.containsKey(value.toLowerCase())) {
                    this.maleResident.add(value.toLowerCase());
                    continue;
                }
                MLN.error(this, "Attempted to load unknown male villager: " + value);
                continue;
            }
            if (!importPlan && key.equalsIgnoreCase("female")) {
                if (this.culture.villagerTypes.containsKey(value.toLowerCase())) {
                    this.femaleResident.add(value.toLowerCase());
                    continue;
                }
                MLN.error(this, "Attempted to load unknown female villager: " + value);
                continue;
            }
            if (key.equalsIgnoreCase("exploretag")) {
                this.exploreTag = value.toLowerCase();
                continue;
            }
            if (key.equalsIgnoreCase("requiredTag")) {
                this.requiredTag = value.toLowerCase();
                continue;
            }
            if (key.equalsIgnoreCase("irrigation")) {
                this.irrigation = Integer.parseInt(value);
                continue;
            }
            if (!importPlan && key.equalsIgnoreCase("shop")) {
                if (this.culture == null) continue;
                if (this.culture.shopBuys.containsKey(value) || this.culture.shopSells.containsKey(value) || this.culture.shopBuysOptional.containsKey(value)) {
                    this.shop = value;
                    continue;
                }
                MLN.error(this, "Undefined shop type: " + value);
                continue;
            }
            if (key.equalsIgnoreCase("minDistance")) {
                this.minDistance = Float.parseFloat(value) / 100.0f;
                continue;
            }
            if (key.equalsIgnoreCase("maxDistance")) {
                this.maxDistance = Float.parseFloat(value) / 100.0f;
                continue;
            }
            if (key.equalsIgnoreCase("signs")) {
                temp = value.split(",");
                if (temp[0].length() <= 0) continue;
                this.signOrder = new int[temp.length];
                for (int i = 0; i < temp.length; ++i) {
                    this.signOrder[i] = Integer.parseInt(temp[i]);
                }
                continue;
            }
            if (key.equalsIgnoreCase("tag")) {
                this.tags.add(value.toLowerCase());
                continue;
            }
            if (key.equalsIgnoreCase("subbuilding")) {
                this.subBuildings.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("startingsubbuilding")) {
                this.startingSubBuildings.add(value);
                continue;
            }
            if (!importPlan && key.equalsIgnoreCase("startinggood")) {
                temp = value.split(",");
                if (temp.length != 4) {
                    MLN.error(this, "Error when reading starting good: expected four fields, found " + temp.length + ": " + value);
                    continue;
                }
                String s = temp[0];
                if (!Goods.goodsName.containsKey(s)) {
                    MLN.error(this, "Error when reading starting good: unknown good: " + s);
                    continue;
                }
                StartingGood sg = new StartingGood(Goods.goodsName.get(s), Double.parseDouble(temp[1]), Integer.parseInt(temp[2]), Integer.parseInt(temp[3]));
                this.startingGoods.add(sg);
                continue;
            }
            if (key.equalsIgnoreCase("type")) {
                this.type = value.toLowerCase();
                continue;
            }
            if (key.equalsIgnoreCase("showtownhallsigns")) {
                this.showTownHallSigns = Boolean.parseBoolean(value);
                continue;
            }
            if (importPlan) continue;
            MLN.error(this, "Could not recognise key on line: " + config);
        }
        if (TYPE_SUBBUILDING.equals(this.type)) {
            this.max = 0;
        }
        if (this.priority < 1) {
            MLN.error(this, "Null or negative weight found in config!");
        }
        if (MLN.LogBuildingPlan >= 3) {
            String s = "";
            for (String s2 : this.subBuildings) {
                s = s + s2 + " ";
            }
            if (s.length() > 0) {
                MLN.minor(this, "Sub-buildings after read: " + s);
            }
        }
    }

    public void referenceBuildingPoints(World worldObj, Building building, BuildingLocation location) {
        int i;
        int x = location.pos.getiX();
        int y = location.pos.getiY();
        int z = location.pos.getiZ();
        int orientation = location.orientation;
        int signNb = 0;
        for (i = 0; i < this.signOrder.length; ++i) {
            building.getResManager().signs.add(null);
        }
        for (i = 0; i < this.nbfloors; ++i) {
            for (int j = 0; j < this.length; ++j) {
                for (int k = 0; k < this.width; ++k) {
                    PointType pt = this.plan[i][j][k];
                    Point p = BuildingPlan.adjustForOrientation(x, y + i + this.startLevel, z, j - this.lengthOffset, k - this.widthOffset, orientation);
                    if (pt.isType(bsoil)) {
                        building.getResManager().addSoilPoint("wheat", p);
                        continue;
                    }
                    if (pt.isType(bricesoil)) {
                        building.getResManager().addSoilPoint("rice", p);
                        continue;
                    }
                    if (pt.isType(bturmericsoil)) {
                        building.getResManager().addSoilPoint("turmeric", p);
                        continue;
                    }
                    if (pt.isType(bmaizesoil)) {
                        building.getResManager().addSoilPoint("maize", p);
                        continue;
                    }
                    if (pt.isType(bcarrotsoil)) {
                        building.getResManager().addSoilPoint("carrot", p);
                        continue;
                    }
                    if (pt.isType(bpotatosoil)) {
                        building.getResManager().addSoilPoint("potato", p);
                        continue;
                    }
                    if (pt.isType(bsugarcanesoil)) {
                        if (building.getResManager().sugarcanesoils.contains(p)) continue;
                        building.getResManager().sugarcanesoils.add(p);
                        continue;
                    }
                    if (pt.isType(bnetherwartsoil)) {
                        if (building.getResManager().netherwartsoils.contains(p)) continue;
                        building.getResManager().netherwartsoils.add(p);
                        continue;
                    }
                    if (pt.isType(bvinesoil)) {
                        building.getResManager().addSoilPoint("vine", p);
                        continue;
                    }
                    if (pt.isType(bcacaospot)) {
                        building.getResManager().addSoilPoint("cacao", p);
                        continue;
                    }
                    if (pt.isType(bsilkwormblock)) {
                        if (building.getResManager().silkwormblock.contains(p)) continue;
                        building.getResManager().silkwormblock.add(p);
                        continue;
                    }
                    if (pt.isType(bstall)) {
                        if (building.getResManager().stalls.contains(p)) continue;
                        building.getResManager().stalls.add(p);
                        continue;
                    }
                    if (pt.isType(boakspawn)) {
                        if (building.getResManager().woodspawn.contains(p)) continue;
                        building.getResManager().woodspawn.add(p);
                        continue;
                    }
                    if (pt.isType(bpinespawn)) {
                        if (building.getResManager().woodspawn.contains(p)) continue;
                        building.getResManager().woodspawn.add(p);
                        continue;
                    }
                    if (pt.isType(bbirchspawn)) {
                        if (building.getResManager().woodspawn.contains(p)) continue;
                        building.getResManager().woodspawn.add(p);
                        continue;
                    }
                    if (pt.isType(bjunglespawn)) {
                        if (building.getResManager().woodspawn.contains(p)) continue;
                        building.getResManager().woodspawn.add(p);
                        continue;
                    }
                    if (pt.isType(bbrickspot)) {
                        if (building.getResManager().brickspot.contains(p)) continue;
                        building.getResManager().brickspot.add(p);
                        continue;
                    }
                    if (pt.isType(bchickenspawn)) {
                        building.getResManager().addSpawnPoint("Chicken", p);
                        continue;
                    }
                    if (pt.isType(bcowspawn)) {
                        building.getResManager().addSpawnPoint("Cow", p);
                        continue;
                    }
                    if (pt.isType(bpigspawn)) {
                        building.getResManager().addSpawnPoint("Pig", p);
                        continue;
                    }
                    if (pt.isType(bsquidspawn)) {
                        building.getResManager().addSpawnPoint("Squid", p);
                        continue;
                    }
                    if (pt.isType(bsheepspawn)) {
                        building.getResManager().addSpawnPoint("Sheep", p);
                        continue;
                    }
                    if (pt.isType(bwolfspawn)) {
                        building.getResManager().addSpawnPoint("Wolf", p);
                        continue;
                    }
                    if (pt.isType(bstonesource)) {
                        building.getResManager().addSourcePoint(Blocks.field_150348_b, p);
                        continue;
                    }
                    if (pt.isType(bsandsource)) {
                        building.getResManager().addSourcePoint((Block)Blocks.field_150354_m, p);
                        continue;
                    }
                    if (pt.isType(bsandstonesource)) {
                        building.getResManager().addSourcePoint(Blocks.field_150322_A, p);
                        continue;
                    }
                    if (pt.isType(bclaysource)) {
                        building.getResManager().addSourcePoint(Blocks.field_150435_aG, p);
                        continue;
                    }
                    if (pt.isType(bgravelsource)) {
                        building.getResManager().addSourcePoint(Blocks.field_150351_n, p);
                        continue;
                    }
                    if (pt.isType(bspawnerskeleton)) {
                        building.getResManager().addMobSpawnerPoint("Skeleton", p);
                        continue;
                    }
                    if (pt.isType(bspawnerzombie)) {
                        building.getResManager().addMobSpawnerPoint("Zombie", p);
                        continue;
                    }
                    if (pt.isType(bspawnerspider)) {
                        building.getResManager().addMobSpawnerPoint("Spider", p);
                        continue;
                    }
                    if (pt.isType(bspawnercavespider)) {
                        building.getResManager().addMobSpawnerPoint("CaveSpider", p);
                        continue;
                    }
                    if (pt.isType(bspawnercreeper)) {
                        building.getResManager().addMobSpawnerPoint("Creeper", p);
                        continue;
                    }
                    if (pt.isType(bdispenserunknownpowder)) {
                        if (building.getResManager().dispenderUnknownPowder.contains(p)) continue;
                        building.getResManager().dispenderUnknownPowder.add(p);
                        continue;
                    }
                    if (pt.isType(bfishingspot)) {
                        if (building.getResManager().fishingspots.contains(p)) continue;
                        building.getResManager().fishingspots.add(p);
                        continue;
                    }
                    if (pt.isType(bhealingspot)) {
                        if (building.getResManager().healingspots.contains(p)) continue;
                        building.getResManager().healingspots.add(p);
                        continue;
                    }
                    if (pt.isType(blockedchest) || pt.isType(bmainchest)) {
                        if (building.getResManager().chests.contains(p)) continue;
                        building.getResManager().chests.add(p);
                        continue;
                    }
                    if (pt.isType(bfurnace)) {
                        if (building.getResManager().furnaces.contains(p)) continue;
                        building.getResManager().furnaces.add(p);
                        continue;
                    }
                    if (pt.isType(bbrewingstand)) {
                        if (building.getResManager().brewingStands.contains(p)) continue;
                        building.getResManager().brewingStands.add(p);
                        continue;
                    }
                    if (pt.isType(bsleepingPos)) {
                        building.getResManager().setSleepingPos(p);
                        continue;
                    }
                    if (pt.isType(bsellingPos)) {
                        building.getResManager().setSellingPos(p);
                        continue;
                    }
                    if (pt.isType(bcraftingPos)) {
                        building.getResManager().setCraftingPos(p);
                        continue;
                    }
                    if (pt.isType(bdefendingPos)) {
                        building.getResManager().setDefendingPos(p);
                        continue;
                    }
                    if (pt.isType(bshelterPos)) {
                        building.getResManager().setShelterPos(p);
                        continue;
                    }
                    if (pt.isType(bpathStartPos)) {
                        building.getResManager().setPathStartPos(p);
                        continue;
                    }
                    if (pt.isType(bleasurePos)) {
                        building.getResManager().setLeasurePos(p);
                        continue;
                    }
                    if (!pt.isType(bsignwallGuess) && !pt.isType(bsignwallTop) && !pt.isType(bsignwallBottom) && !pt.isType(bsignwallLeft) && !pt.isType(bsignwallRight)) continue;
                    building.getResManager().signs.set(this.signOrder[signNb], p);
                    ++signNb;
                }
            }
        }
    }

    public void setMetadata(List<BuildingBlock> bblocks) {
        ArrayList<BuildingBlock> stairs = new ArrayList<BuildingBlock>();
        ArrayList<BuildingBlock> ladders = new ArrayList<BuildingBlock>();
        ArrayList<BuildingBlock> doors = new ArrayList<BuildingBlock>();
        HashMap<Point, BuildingBlock> map = new HashMap<Point, BuildingBlock>();
        for (BuildingBlock block : bblocks) {
            map.put(block.p, block);
            if (block.block == Blocks.field_150468_ap && block.meta == -1) {
                ladders.add(block);
                continue;
            }
            if (block.block == Blocks.field_150466_ao) {
                doors.add(block);
                continue;
            }
            if (block.block != Blocks.field_150446_ar && block.block != Blocks.field_150476_ad || block.meta != -1) continue;
            block.meta = (byte)-1;
            stairs.add(block);
        }
        boolean[] northValid = new boolean[ladders.size()];
        boolean[] southValid = new boolean[ladders.size()];
        boolean[] westValid = new boolean[ladders.size()];
        boolean[] eastValid = new boolean[ladders.size()];
        int i = 0;
        for (BuildingBlock ladder : ladders) {
            northValid[i] = this.mapIsOpaqueBlock(map, ladder.p.getNorth());
            southValid[i] = this.mapIsOpaqueBlock(map, ladder.p.getSouth());
            westValid[i] = this.mapIsOpaqueBlock(map, ladder.p.getWest());
            eastValid[i] = this.mapIsOpaqueBlock(map, ladder.p.getEast());
            if (northValid[i] && !southValid[i] && !westValid[i] && !eastValid[i]) {
                ladder.meta = (byte)5;
            }
            if (!northValid[i] && southValid[i] && !westValid[i] && !eastValid[i]) {
                ladder.meta = (byte)4;
            }
            if (!northValid[i] && !southValid[i] && westValid[i] && !eastValid[i]) {
                ladder.meta = (byte)2;
            }
            if (!northValid[i] && !southValid[i] && !westValid[i] && eastValid[i]) {
                ladder.meta = (byte)3;
            }
            ++i;
        }
        boolean goOn = true;
        while (goOn) {
            goOn = false;
            i = 0;
            for (BuildingBlock ladder : ladders) {
                if (ladder.meta == 0) {
                    BuildingBlock b;
                    if (MLN.LogBuildingPlan >= 1) {
                        MLN.major(this, this.buildingKey + ": ladder " + ladder + " has no metada, trying to find neighbours.");
                        if (map.containsKey(ladder.p.getAbove())) {
                            MLN.major(this, this.buildingKey + ": Above: " + map.get(ladder.p.getAbove()));
                        }
                        if (map.containsKey(ladder.p.getBelow())) {
                            MLN.major(this, this.buildingKey + ": Below: " + map.get(ladder.p.getBelow()));
                        }
                    }
                    if (map.containsKey(ladder.p.getAbove())) {
                        b = map.get(ladder.p.getAbove());
                        if (b.block == Blocks.field_150468_ap && b.meta != 0) {
                            if (b.meta == 5 && northValid[i]) {
                                ladder.meta = b.meta;
                                goOn = true;
                            } else if (b.meta == 4 && southValid[i]) {
                                ladder.meta = b.meta;
                                goOn = true;
                            } else if (b.meta == 3 && westValid[i]) {
                                ladder.meta = b.meta;
                                goOn = true;
                            } else if (b.meta == 2 && eastValid[i]) {
                                ladder.meta = b.meta;
                                goOn = true;
                            }
                        }
                    }
                    if (ladder.meta == 0 && map.containsKey(ladder.p.getBelow())) {
                        if (MLN.LogBuildingPlan >= 1) {
                            MLN.major(this, this.buildingKey + ": trying ladder below. " + northValid[i] + "/" + southValid[i] + "/" + westValid[i] + "/" + eastValid[i]);
                        }
                        b = map.get(ladder.p.getBelow());
                        if (b.block == Blocks.field_150468_ap && b.meta != 0) {
                            if (b.meta == 5 && northValid[i]) {
                                if (MLN.LogBuildingPlan >= 1) {
                                    MLN.major(this, this.buildingKey + ": copying blow: north");
                                }
                                ladder.meta = b.meta;
                                goOn = true;
                            } else if (b.meta == 4 && southValid[i]) {
                                if (MLN.LogBuildingPlan >= 1) {
                                    MLN.major(this, this.buildingKey + ": copying blow: south");
                                }
                                ladder.meta = b.meta;
                                goOn = true;
                            } else if (b.meta == 3 && westValid[i]) {
                                if (MLN.LogBuildingPlan >= 1) {
                                    MLN.major(this, this.buildingKey + ": copying blow: west");
                                }
                                ladder.meta = b.meta;
                                goOn = true;
                            } else if (b.meta == 2 && eastValid[i]) {
                                if (MLN.LogBuildingPlan >= 1) {
                                    MLN.major(this, this.buildingKey + ": copying blow: east");
                                }
                                ladder.meta = b.meta;
                                goOn = true;
                            }
                        }
                    }
                }
                ++i;
            }
        }
        northValid = new boolean[stairs.size()];
        southValid = new boolean[stairs.size()];
        westValid = new boolean[stairs.size()];
        eastValid = new boolean[stairs.size()];
        i = 0;
        for (BuildingBlock stair : stairs) {
            northValid[i] = !this.mapIsOpaqueBlock(map, stair.p.getSouth()) && (!this.mapIsOpaqueBlock(map, stair.p.getNorth().getAbove()) || this.mapIsOpaqueBlock(map, stair.p.getNorth().getAbove()));
            southValid[i] = !this.mapIsOpaqueBlock(map, stair.p.getNorth()) && (!this.mapIsOpaqueBlock(map, stair.p.getSouth().getAbove()) || this.mapIsOpaqueBlock(map, stair.p.getSouth().getAbove()));
            westValid[i] = !this.mapIsOpaqueBlock(map, stair.p.getEast()) && (!this.mapIsOpaqueBlock(map, stair.p.getWest().getAbove()) || this.mapIsOpaqueBlock(map, stair.p.getWest().getAbove()));
            boolean bl = eastValid[i] = !this.mapIsOpaqueBlock(map, stair.p.getWest()) && (!this.mapIsOpaqueBlock(map, stair.p.getEast().getAbove()) || this.mapIsOpaqueBlock(map, stair.p.getEast().getAbove()));
            if (MLN.LogBuildingPlan >= 1) {
                if (northValid[i]) {
                    MLN.major(this, this.buildingKey + ": northValid");
                } else if (southValid[i]) {
                    MLN.major(this, this.buildingKey + ": southValid");
                } else if (westValid[i]) {
                    MLN.major(this, this.buildingKey + ": westValid");
                } else if (eastValid[i]) {
                    MLN.major(this, this.buildingKey + ": eastValid");
                } else {
                    MLN.major(this, this.buildingKey + ": none valid");
                }
            }
            stair.meta = northValid[i] ? (byte)1 : (southValid[i] ? (byte)0 : (westValid[i] ? (byte)3 : (eastValid[i] ? (byte)2 : (byte)0)));
            ++i;
        }
        for (BuildingBlock door : doors) {
            int orientation = door.meta & 3;
            if (orientation == 2) {
                if (map.containsKey(door.p.getWest()) && map.get((Object)door.p.getWest()).block != Blocks.field_150350_a && map.get((Object)door.p.getWest()).block != Blocks.field_150466_ao || !map.containsKey(door.p.getEast())) continue;
                door.special = BuildingBlock.INVERTEDDOOR;
                continue;
            }
            if (orientation == 3) {
                if (map.containsKey(door.p.getNorth()) && map.get((Object)door.p.getNorth()).block != Blocks.field_150350_a && map.get((Object)door.p.getNorth()).block != Blocks.field_150466_ao || !map.containsKey(door.p.getSouth())) continue;
                door.special = BuildingBlock.INVERTEDDOOR;
                continue;
            }
            if (orientation == 0) {
                if (map.containsKey(door.p.getEast()) && map.get((Object)door.p.getEast()).block != Blocks.field_150350_a && map.get((Object)door.p.getEast()).block != Blocks.field_150466_ao || !map.containsKey(door.p.getWest())) continue;
                door.special = BuildingBlock.INVERTEDDOOR;
                continue;
            }
            if (orientation != 1 || map.containsKey(door.p.getSouth()) && map.get((Object)door.p.getSouth()).block != Blocks.field_150350_a && map.get((Object)door.p.getSouth()).block != Blocks.field_150466_ao || !map.containsKey(door.p.getNorth())) continue;
            door.special = BuildingBlock.INVERTEDDOOR;
        }
    }

    public LocationReturn testSpot(MillWorldInfo winfo, AStarPathing pathing, Point centre, int x, int z, Random random, int porientation) {
        int zwidth;
        int xwidth;
        int relx = x + winfo.mapStartX - centre.getiX();
        int relz = z + winfo.mapStartZ - centre.getiZ();
        winfo.buildTested[x][z] = true;
        if (MLN.LogWorldGeneration >= 3) {
            MLN.debug(this, "Testing: " + x + "/" + z);
        }
        int orientation = porientation == -1 ? (relx * relx > relz * relz ? (relx > 0 ? 0 : 2) : (relz > 0 ? 3 : 1)) : porientation;
        orientation = (orientation + this.buildingOrientation) % 4;
        if (orientation == 0 || orientation == 2) {
            xwidth = this.length + this.areaToClear * 2 + 2;
            zwidth = this.width + this.areaToClear * 2 + 2;
        } else {
            xwidth = this.width + this.areaToClear * 2 + 2;
            zwidth = this.length + this.areaToClear * 2 + 2;
        }
        int altitudeTotal = 0;
        int nbPoints = 0;
        int nbError = 0;
        int allowedErrors = 10;
        boolean hugeBuilding = false;
        if (xwidth * zwidth > 6000) {
            allowedErrors = 1500;
            hugeBuilding = true;
        } else if (xwidth * zwidth > 200) {
            allowedErrors = xwidth * zwidth / 20;
        }
        boolean reachable = false;
        for (int i = 0; i <= (int)Math.floor(xwidth / 2); ++i) {
            for (int j = 0; j <= (int)Math.floor(zwidth / 2); ++j) {
                for (int k = 0; k < 4; ++k) {
                    int cj;
                    int ci;
                    if (k == 0) {
                        ci = x + i;
                        cj = z + j;
                    } else if (k == 1) {
                        ci = x - i;
                        cj = z + j;
                    } else if (k == 2) {
                        ci = x - i;
                        cj = z - j;
                    } else {
                        ci = x + i;
                        cj = z - j;
                    }
                    if (ci < 0 || cj < 0 || ci >= winfo.length || cj >= winfo.width) {
                        Point p = new Point(ci + winfo.mapStartX, 64.0, cj + winfo.mapStartZ);
                        return new LocationReturn(1, p);
                    }
                    if (winfo.buildingLoc[ci][cj]) {
                        if (nbError > allowedErrors) {
                            Point p = new Point(ci + winfo.mapStartX, 64.0, cj + winfo.mapStartZ);
                            return new LocationReturn(2, p);
                        }
                        nbError += 5;
                    } else if (winfo.buildingForbidden[ci][cj]) {
                        if (!hugeBuilding || nbError > allowedErrors) {
                            Point p = new Point(ci + winfo.mapStartX, 64.0, cj + winfo.mapStartZ);
                            return new LocationReturn(3, p);
                        }
                        ++nbError;
                    } else if (winfo.danger[ci][cj]) {
                        if (nbError > allowedErrors) {
                            Point p = new Point(ci + winfo.mapStartX, 64.0, cj + winfo.mapStartZ);
                            return new LocationReturn(5, p);
                        }
                        ++nbError;
                    } else if (!winfo.canBuild[ci][cj]) {
                        if (nbError > allowedErrors) {
                            Point p = new Point(ci + winfo.mapStartX, 64.0, cj + winfo.mapStartZ);
                            return new LocationReturn(4, p);
                        }
                        ++nbError;
                    }
                    reachable = pathing == null || pathing.regions[ci][cj] == pathing.thRegion;
                    altitudeTotal += winfo.constructionHeight[ci][cj];
                    ++nbPoints;
                }
            }
        }
        if (pathing != null && !reachable) {
            return new LocationReturn(4, centre);
        }
        int altitude = (int)((float)altitudeTotal * 1.0f / (float)nbPoints);
        BuildingLocation l = new BuildingLocation(this, new Point(x + winfo.mapStartX, altitude, z + winfo.mapStartZ), orientation);
        return new LocationReturn(l);
    }

    public LocationReturn testSpotBedrock(World world, int cx, int cz) {
        for (int x = cx - this.width - 2; x < cx + this.width + 2; ++x) {
            for (int z = cz - this.length - 2; z < cz + this.length + 2; ++z) {
                for (int y = 0; y < this.plan.length + 2; ++y) {
                    Block block = world.func_147439_a(x, y, z);
                    if (block == Blocks.field_150357_h || block == Blocks.field_150348_b || block == Blocks.field_150346_d || block == Blocks.field_150351_n || block == Blocks.field_150365_q || block == Blocks.field_150482_ag || block == Blocks.field_150352_o || block == Blocks.field_150366_p || block == Blocks.field_150369_x || block == Blocks.field_150450_ax) continue;
                    return new LocationReturn(3, null);
                }
            }
        }
        BuildingLocation l = new BuildingLocation(this, new Point(cx, 2.0, cz), 0);
        l.bedrocklevel = true;
        return new LocationReturn(l);
    }

    public String toString() {
        if (this.culture != null) {
            return this.culture.key + ":" + this.planName;
        }
        return "null culture:" + this.planName;
    }

    static {
        colourPoints = new HashMap();
        reverseColourPoints = new HashMap();
        EOL = System.getProperty("line.separator");
        loadingDone = false;
        TYPE_SUBBUILDING = "subbuilding";
    }

    public static class StartingGood {
        public InvItem item;
        public double probability;
        public int fixedNumber;
        public int randomNumber;

        StartingGood(InvItem item, double probability, int fixedNumber, int randomNumber) {
            this.item = item;
            this.probability = probability;
            this.fixedNumber = fixedNumber;
            this.randomNumber = randomNumber;
        }
    }

    public static class LocationReturn {
        public static final int OUTSIDE_RADIUS = 1;
        public static final int LOCATION_CLASH = 2;
        public static final int CONSTRUCTION_FORBIDEN = 3;
        public static final int WRONG_ALTITUDE = 4;
        public static final int DANGER = 5;
        public static final int NOT_REACHABLE = 4;
        public BuildingLocation location;
        public int errorCode;
        public Point errorPos;

        public LocationReturn(BuildingLocation l) {
            this.location = l;
            this.errorCode = 0;
            this.errorPos = null;
        }

        public LocationReturn(int error, Point p) {
            this.location = null;
            this.errorCode = error;
            this.errorPos = p;
        }
    }

    public static class LocationBuildingPair {
        public Building building;
        public BuildingLocation location;

        public LocationBuildingPair(Building b, BuildingLocation l) {
            this.building = b;
            this.location = l;
        }
    }
}

