/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common.block;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.IGrowable;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;
import org.millenaire.common.core.MillCommonUtilities;

public class BlockMillCrops
extends BlockCrops
implements IGrowable {
    private final String[] textureNames;
    private final IIcon[] textures = new IIcon[8];
    private final boolean requireIrrigation;
    private final boolean slowGrowth;
    private IPlantable seed;

    public BlockMillCrops(String[] textureNames, boolean requireIrrigation, boolean slowGrowth) {
        this.textureNames = textureNames;
        this.requireIrrigation = requireIrrigation;
        this.slowGrowth = slowGrowth;
        this.func_149675_a(true);
        float f = 0.5f;
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.25f, 1.0f);
    }

    protected Item func_149865_P() {
        return (Item)this.seed;
    }

    protected Item func_149866_i() {
        return (Item)this.seed;
    }

    public ArrayList getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(new ItemStack(this.func_149865_P(), 1, 0));
        if (metadata == 7) {
            for (int n = 0; n < 3 + fortune; ++n) {
                if (world.field_73012_v.nextInt(15) > metadata) continue;
                ret.add(new ItemStack(this.func_149865_P(), 1, 0));
            }
        }
        return ret;
    }

    public int getFireSpreadSpeed(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return 60;
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return 150;
    }

    protected float getGrowthRate(World world, int i, int j, int k) {
        int irrigation = world.func_72805_g(i, j - 1, k);
        if (this.requireIrrigation && irrigation == 0) {
            return 0.0f;
        }
        return !this.slowGrowth ? 8.0f : 4.0f;
    }

    public IIcon func_149691_a(int p_149691_1_, int meta) {
        if (meta < 0 || meta > 7) {
            meta = 7;
        }
        return this.textures[meta];
    }

    public Item func_149650_a(int par1, Random par2Random, int par3) {
        return (Item)this.seed;
    }

    public int func_149645_b() {
        return 6;
    }

    public IPlantable getSeed() {
        return this.seed;
    }

    public int func_149745_a(Random par1Random) {
        return 1;
    }

    public void func_149651_a(IIconRegister iconRegister) {
        for (int i = 0; i < 8; ++i) {
            this.textures[i] = MillCommonUtilities.getIcon(iconRegister, this.textureNames[i]);
        }
    }

    public void setSeed(IPlantable seed) {
        this.seed = seed;
    }

    public void func_149674_a(World world, int i, int j, int k, Random random) {
        float f;
        int l;
        this.func_149855_e(world, i, j, k);
        if (world.func_72957_l(i, j + 1, k) >= 9 && (l = world.func_72805_g(i, j, k)) < 7 && (f = this.getGrowthRate(world, i, j, k)) > 0.0f && random.nextInt((int)(100.0f / f)) == 0) {
            MillCommonUtilities.setBlockMetadata(world, i, j, k, l + 1, true);
        }
    }
}

