/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common;

import io.netty.buffer.ByteBufInputStream;
import java.io.BufferedReader;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import org.millenaire.common.Culture;
import org.millenaire.common.InvItem;
import org.millenaire.common.MLN;
import org.millenaire.common.MillWorld;
import org.millenaire.common.Point;
import org.millenaire.common.UserProfile;
import org.millenaire.common.building.BuildingCustomPlan;
import org.millenaire.common.building.BuildingPlanSet;
import org.millenaire.common.building.BuildingProject;
import org.millenaire.common.core.MillCommonUtilities;
import org.millenaire.common.forge.Mill;
import org.millenaire.common.item.Goods;
import org.millenaire.common.network.StreamReadWrite;

public class VillageType
implements MillCommonUtilities.WeightedChoice {
    public static final String HAMEAU = "hameau";
    public String name = null;
    public String key = null;
    public String type = null;
    public int weight;
    public int radius = MLN.VillageRadius;
    public int max = 0;
    public BuildingCustomPlan customCentre = null;
    public BuildingPlanSet centreBuilding = null;
    public List<BuildingPlanSet> startBuildings = new ArrayList<BuildingPlanSet>();
    public List<BuildingPlanSet> playerBuildings = new ArrayList<BuildingPlanSet>();
    public List<BuildingPlanSet> coreBuildings = new ArrayList<BuildingPlanSet>();
    public List<BuildingPlanSet> secondaryBuildings = new ArrayList<BuildingPlanSet>();
    public List<BuildingPlanSet> extraBuildings = new ArrayList<BuildingPlanSet>();
    public List<BuildingPlanSet> excludedBuildings = new ArrayList<BuildingPlanSet>();
    public List<BuildingCustomPlan> customBuildings = new ArrayList<BuildingCustomPlan>();
    public List<String> hamlets = new ArrayList<String>();
    public List<String> qualifiers = new ArrayList<String>();
    public HashMap<InvItem, Integer> sellingPrices = new HashMap();
    public HashMap<InvItem, Integer> buyingPrices = new HashMap();
    public List<InvItem> pathMaterial = new ArrayList<InvItem>();
    public Culture culture;
    public List<String> biomes = new ArrayList<String>();
    List<String> requiredTags = new ArrayList<String>();
    List<String> forbiddenTags = new ArrayList<String>();
    public String nameList = null;
    public String hillQualifier = null;
    public String mountainQualifier = null;
    public String desertQualifier = null;
    public String forestQualifier = null;
    public String lavaQualifier = null;
    public String lakeQualifier = null;
    public String oceanQualifier = null;
    public boolean lonebuilding = false;
    public boolean keyLonebuilding = false;
    public String keyLoneBuildingGenerateTag = null;
    public boolean spawnable = true;
    public boolean carriesRaid = false;
    public boolean playerControlled = false;
    public boolean generateOnServer = true;
    public int minDistanceFromSpawn = 0;
    public boolean generatedForPlayer = false;

    public static List<VillageType> loadLoneBuildings(List<File> culturesDirs, Culture culture) {
        ArrayList<File> dirs = new ArrayList<File>();
        for (File culturesDir : culturesDirs) {
            File dir = new File(culturesDir, "lonebuildings");
            if (!dir.exists()) continue;
            dirs.add(dir);
        }
        File dircusto = new File(new File(new File(Mill.proxy.getCustomDir(), "cultures"), culture.key), "custom lonebuildings");
        if (dircusto.exists()) {
            dirs.add(dircusto);
        }
        ArrayList<VillageType> v = new ArrayList<VillageType>();
        VillageFileFiler filer = new VillageFileFiler(".txt");
        for (File villageDir : dirs) {
            villageDir.mkdirs();
            for (File file : villageDir.listFiles(filer)) {
                try {
                    if (MLN.LogVillage >= 1) {
                        MLN.major(file, "Loading lone building: " + file.getAbsolutePath());
                    }
                    VillageType village = new VillageType(culture, file, true);
                    village.lonebuilding = true;
                    v.remove(village);
                    v.add(village);
                }
                catch (MLN.MillenaireException e) {
                    MLN.error(null, e.getMessage());
                }
                catch (Exception e) {
                    MLN.printException(e);
                }
            }
        }
        return v;
    }

    public static List<VillageType> loadVillages(List<File> culturesDirs, Culture culture) {
        ArrayList<File> dirs = new ArrayList<File>();
        for (File culturesDir : culturesDirs) {
            File dir = new File(culturesDir, "villages");
            if (!dir.exists()) continue;
            dirs.add(dir);
        }
        File dircusto = new File(new File(new File(Mill.proxy.getCustomDir(), "cultures"), culture.key), "custom villages");
        if (dircusto.exists()) {
            dirs.add(dircusto);
        }
        ArrayList<VillageType> v = new ArrayList<VillageType>();
        VillageFileFiler filer = new VillageFileFiler(".txt");
        for (File villageDir : dirs) {
            villageDir.mkdirs();
            for (File file : villageDir.listFiles(filer)) {
                try {
                    if (MLN.LogVillage >= 1) {
                        MLN.major(file, "Loading village: " + file.getAbsolutePath());
                    }
                    VillageType village = new VillageType(culture, file, false);
                    v.remove(village);
                    v.add(village);
                }
                catch (MLN.MillenaireException e) {
                    MLN.error(null, e.getMessage());
                }
                catch (Exception e) {
                    MLN.printException(e);
                }
            }
        }
        return v;
    }

    public static List<VillageType> spawnableVillages(EntityPlayer player) {
        ArrayList<VillageType> villages = new ArrayList<VillageType>();
        UserProfile profile = Mill.getMillWorld(player.field_70170_p).getProfile(player.getDisplayName());
        for (Culture culture : Culture.ListCultures) {
            for (VillageType village : culture.listVillageTypes) {
                if (!village.spawnable || !village.playerControlled || !MLN.DEV && !profile.isTagSet("culturecontrol_" + village.culture.key)) continue;
                villages.add(village);
            }
            for (VillageType village : culture.listVillageTypes) {
                if (!village.spawnable || village.playerControlled) continue;
                villages.add(village);
            }
            for (VillageType village : culture.listLoneBuildingTypes) {
                if (!village.spawnable || !MLN.DEV && village.playerControlled && !profile.isTagSet("culturecontrol_" + village.culture.key)) continue;
                villages.add(village);
            }
        }
        return villages;
    }

    public VillageType(Culture c, File file, boolean lone) throws Exception {
        String line;
        this.lonebuilding = lone;
        this.spawnable = !this.lonebuilding;
        this.culture = c;
        this.key = file.getName().split("\\.")[0];
        this.nameList = this.lonebuilding ? null : "villages";
        BufferedReader reader = MillCommonUtilities.getReader(file);
        while ((line = reader.readLine()) != null) {
            if (line.trim().length() <= 0 || line.trim().startsWith("//")) continue;
            String[] temp = line.trim().split("\\:");
            if (temp.length == 2) {
                String[] pricestr;
                InvItem item;
                String goodstr;
                String paramkey = temp[0].trim();
                String value = temp[1].trim();
                if (paramkey.equalsIgnoreCase("name")) {
                    this.name = value;
                    continue;
                }
                if (paramkey.equalsIgnoreCase("spawnable")) {
                    this.spawnable = Boolean.parseBoolean(value);
                    continue;
                }
                if (paramkey.equalsIgnoreCase("generateonserver")) {
                    this.generateOnServer = Boolean.parseBoolean(value);
                    continue;
                }
                if (paramkey.equalsIgnoreCase("generateforplayer")) {
                    this.generatedForPlayer = Boolean.parseBoolean(value);
                    continue;
                }
                if (paramkey.equalsIgnoreCase("carriesraid")) {
                    this.carriesRaid = Boolean.parseBoolean(value);
                    continue;
                }
                if (paramkey.equalsIgnoreCase("keyLoneBuilding")) {
                    this.keyLonebuilding = Boolean.parseBoolean(value);
                    continue;
                }
                if (paramkey.equalsIgnoreCase("keyLoneBuildingGenerateTag")) {
                    this.keyLoneBuildingGenerateTag = value;
                    continue;
                }
                if (paramkey.equalsIgnoreCase("playerControlled")) {
                    this.playerControlled = Boolean.parseBoolean(value);
                    continue;
                }
                if (paramkey.equalsIgnoreCase("weight")) {
                    this.weight = Integer.parseInt(value);
                    continue;
                }
                if (paramkey.equalsIgnoreCase("max")) {
                    this.max = Integer.parseInt(value);
                    continue;
                }
                if (paramkey.equalsIgnoreCase("radius")) {
                    this.radius = Integer.parseInt(value);
                    continue;
                }
                if (paramkey.equalsIgnoreCase("minDistanceFromSpawn")) {
                    this.minDistanceFromSpawn = Integer.parseInt(value);
                    continue;
                }
                if (paramkey.equalsIgnoreCase("qualifier")) {
                    this.qualifiers.add(value);
                    continue;
                }
                if (paramkey.equalsIgnoreCase(HAMEAU)) {
                    this.hamlets.add(value);
                    continue;
                }
                if (paramkey.equalsIgnoreCase("type")) {
                    this.type = value;
                    continue;
                }
                if (paramkey.equalsIgnoreCase("nameList")) {
                    this.nameList = value;
                    continue;
                }
                if (paramkey.equalsIgnoreCase("biome")) {
                    this.biomes.add(value.toLowerCase());
                    continue;
                }
                if (paramkey.equalsIgnoreCase("requiredtag")) {
                    this.requiredTags.add(value);
                    continue;
                }
                if (paramkey.equalsIgnoreCase("forbiddentag")) {
                    this.forbiddenTags.add(value);
                    continue;
                }
                if (paramkey.equalsIgnoreCase("hillQualifier")) {
                    this.hillQualifier = value;
                    continue;
                }
                if (paramkey.equalsIgnoreCase("mountainQualifier")) {
                    this.mountainQualifier = value;
                    continue;
                }
                if (paramkey.equalsIgnoreCase("desertQualifier")) {
                    this.desertQualifier = value;
                    continue;
                }
                if (paramkey.equalsIgnoreCase("forestQualifier")) {
                    this.forestQualifier = value;
                    continue;
                }
                if (paramkey.equalsIgnoreCase("lavaQualifier")) {
                    this.lavaQualifier = value;
                    continue;
                }
                if (paramkey.equalsIgnoreCase("lakeQualifier")) {
                    this.lakeQualifier = value;
                    continue;
                }
                if (paramkey.equalsIgnoreCase("oceanQualifier")) {
                    this.oceanQualifier = value;
                    continue;
                }
                if (paramkey.equalsIgnoreCase("pathMaterial")) {
                    if (Goods.goodsName.containsKey(value.toLowerCase())) {
                        this.pathMaterial.add(Goods.goodsName.get(value.toLowerCase()));
                        continue;
                    }
                    MLN.error(this, "When loading village type " + this.key + " could not recognise path material: " + value);
                    continue;
                }
                if (paramkey.equalsIgnoreCase("centre")) {
                    if (this.culture.getBuildingPlanSet(value) != null) {
                        this.centreBuilding = this.culture.getBuildingPlanSet(value);
                        if (MLN.LogVillage < 2) continue;
                        MLN.minor(this, "Loading centre building: " + value);
                        continue;
                    }
                    throw new MLN.MillenaireException("When loading village type " + this.key + " could not find centre building type " + value + ".");
                }
                if (paramkey.equalsIgnoreCase("customcentre")) {
                    if (this.culture.getBuildingCustom(value) != null) {
                        this.customCentre = this.culture.getBuildingCustom(value);
                        if (MLN.LogVillage < 2) continue;
                        MLN.minor(this, "Loading custom centre building: " + value);
                        continue;
                    }
                    throw new MLN.MillenaireException("When loading village type " + this.key + " could not find custom centre building type " + value + ".");
                }
                if (paramkey.equalsIgnoreCase("start")) {
                    if (this.culture.getBuildingPlanSet(value) != null) {
                        this.startBuildings.add(this.culture.getBuildingPlanSet(value));
                        if (MLN.LogVillage < 2) continue;
                        MLN.minor(this, "Loading start building: " + value);
                        continue;
                    }
                    MLN.error(this, "When loading village type " + this.key + " could not find start building type " + value + ".");
                    continue;
                }
                if (paramkey.equalsIgnoreCase("player")) {
                    if (this.culture.getBuildingPlanSet(value) != null) {
                        this.playerBuildings.add(this.culture.getBuildingPlanSet(value));
                        if (MLN.LogVillage < 2) continue;
                        MLN.minor(this, "Loading player building: " + value);
                        continue;
                    }
                    MLN.error(this, "When loading village type " + this.key + " could not find player building type " + value + ".");
                    continue;
                }
                if (paramkey.equalsIgnoreCase("core")) {
                    if (this.culture.getBuildingPlanSet(value) != null) {
                        this.coreBuildings.add(this.culture.getBuildingPlanSet(value));
                        if (MLN.LogVillage < 2) continue;
                        MLN.minor(this, "Loading core building: " + value);
                        continue;
                    }
                    MLN.error(this, "When loading village type " + this.key + " could not find core building type " + value + ".");
                    continue;
                }
                if (paramkey.equalsIgnoreCase("secondary")) {
                    if (this.culture.getBuildingPlanSet(value) != null) {
                        this.secondaryBuildings.add(this.culture.getBuildingPlanSet(value));
                        if (MLN.LogVillage < 2) continue;
                        MLN.minor(this, "Loading secondary building: " + value);
                        continue;
                    }
                    MLN.error(this, "When loading village type " + this.key + " could not find secondary building type " + value + ".");
                    continue;
                }
                if (paramkey.equalsIgnoreCase("never")) {
                    if (this.culture.getBuildingPlanSet(value) != null) {
                        this.excludedBuildings.add(this.culture.getBuildingPlanSet(value));
                        if (MLN.LogVillage < 2) continue;
                        MLN.minor(this, "Loading excluded building: " + value);
                        continue;
                    }
                    MLN.error(this, "When loading village type " + this.key + " could not find excluded building type " + value + ".");
                    continue;
                }
                if (paramkey.equalsIgnoreCase("customBuilding")) {
                    if (this.culture.getBuildingCustom(value) != null) {
                        this.customBuildings.add(this.culture.getBuildingCustom(value));
                        if (MLN.LogVillage < 2) continue;
                        MLN.minor(this, "Loading custom building: " + value);
                        continue;
                    }
                    MLN.error(this, "When loading village type " + this.key + " could not find custom building type " + value + ".");
                    continue;
                }
                if (paramkey.equalsIgnoreCase("sellingPrice")) {
                    goodstr = value.split(",")[0].toLowerCase();
                    if (Goods.goodsName.containsKey(goodstr)) {
                        item = Goods.goodsName.get(goodstr);
                        int price = 0;
                        try {
                            pricestr = value.split(",")[1].split("/");
                            if (pricestr.length == 1) {
                                price = Integer.parseInt(pricestr[0]);
                            } else if (pricestr.length == 2) {
                                price = Integer.parseInt(pricestr[0]) * 64 + Integer.parseInt(pricestr[1]);
                            } else if (pricestr.length == 3) {
                                price = Integer.parseInt(pricestr[0]) * 64 * 64 + Integer.parseInt(pricestr[1]) * 64 + Integer.parseInt(pricestr[2]);
                            } else {
                                MLN.error(this, "Could not parse the price in line: " + line);
                            }
                        }
                        catch (Exception e) {
                            MLN.error(this, "Exception when parsing the price in line: " + line);
                        }
                        if (price <= 0) continue;
                        this.sellingPrices.put(item, price);
                        continue;
                    }
                    MLN.error(this, "Could not find the good in line: " + line);
                    continue;
                }
                if (paramkey.equalsIgnoreCase("buyingPrice")) {
                    goodstr = value.split(",")[0].toLowerCase();
                    if (Goods.goodsName.containsKey(goodstr)) {
                        item = Goods.goodsName.get(goodstr);
                        try {
                            int price = 0;
                            pricestr = value.split(",")[1].split("/");
                            if (pricestr.length == 1) {
                                price = Integer.parseInt(pricestr[0]);
                            } else if (pricestr.length == 2) {
                                price = Integer.parseInt(pricestr[0]) * 64 + Integer.parseInt(pricestr[1]);
                            } else if (pricestr.length == 3) {
                                price = Integer.parseInt(pricestr[0]) * 64 * 64 + Integer.parseInt(pricestr[1]) * 64 + Integer.parseInt(pricestr[2]);
                            } else {
                                MLN.error(this, "Could not parse the price in line: " + line);
                            }
                            if (price <= 0) continue;
                            this.buyingPrices.put(item, price);
                        }
                        catch (Exception e) {
                            MLN.error(this, "Exception when parsing the price in line: " + line);
                        }
                        continue;
                    }
                    MLN.error(this, "Could not find the good in line: " + line);
                    continue;
                }
                MLN.error(this, "Could not recognise parameter " + paramkey + ": " + line);
                continue;
            }
            MLN.error(this, "Could not understand line: " + line);
        }
        if (this.name == null) {
            throw new MLN.MillenaireException("No name found for village: " + this.key);
        }
        if (this.centreBuilding == null && this.customCentre == null) {
            throw new MLN.MillenaireException("No central building found for village: " + this.key);
        }
        for (BuildingPlanSet set : this.culture.ListPlanSets) {
            if (this.excludedBuildings.contains(set)) continue;
            int nb = 0;
            for (BuildingPlanSet aset : this.startBuildings) {
                if (aset != set) continue;
                ++nb;
            }
            for (BuildingPlanSet aset : this.coreBuildings) {
                if (aset != set) continue;
                ++nb;
            }
            for (BuildingPlanSet aset : this.secondaryBuildings) {
                if (aset != set) continue;
                ++nb;
            }
            for (int i = nb; i < set.max; ++i) {
                this.extraBuildings.add(set);
            }
        }
        if (this.pathMaterial.size() == 0) {
            this.pathMaterial.add(Goods.goodsName.get("pathgravel"));
        }
        if (MLN.LogVillage >= 1) {
            MLN.major(this, "Loaded village type " + this.name + ". NameList: " + this.nameList);
        }
    }

    public VillageType(Culture c, String key, boolean lone) {
        this.key = key;
        this.culture = c;
        this.lonebuilding = lone;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof VillageType)) {
            return false;
        }
        VillageType v = (VillageType)obj;
        return v.culture == this.culture && v.key.equals(this.key);
    }

    public Map<BuildingProject.EnumProjects, List<BuildingProject>> getBuildingProjects() {
        ArrayList<BuildingProject> centre = new ArrayList<BuildingProject>();
        if (this.centreBuilding != null) {
            centre.add(this.centreBuilding.getBuildingProject());
        }
        ArrayList<BuildingProject> start = new ArrayList<BuildingProject>();
        for (BuildingPlanSet set : this.startBuildings) {
            start.add(set.getBuildingProject());
        }
        ArrayList<BuildingProject> players = new ArrayList<BuildingProject>();
        if (!this.playerControlled) {
            for (BuildingPlanSet set : this.playerBuildings) {
                players.add(set.getBuildingProject());
            }
        }
        ArrayList<BuildingProject> core = new ArrayList<BuildingProject>();
        if (!this.playerControlled) {
            for (BuildingPlanSet set : this.coreBuildings) {
                core.add(set.getBuildingProject());
            }
        }
        ArrayList<BuildingProject> secondary = new ArrayList<BuildingProject>();
        if (!this.playerControlled) {
            for (BuildingPlanSet set : this.secondaryBuildings) {
                secondary.add(set.getBuildingProject());
            }
        }
        ArrayList<BuildingProject> extra = new ArrayList<BuildingProject>();
        if (!(this.playerControlled || this.type != null && this.type.equalsIgnoreCase(HAMEAU) || this.lonebuilding)) {
            for (BuildingPlanSet set : this.extraBuildings) {
                extra.add(set.getBuildingProject());
            }
        }
        HashMap<BuildingProject.EnumProjects, List<BuildingProject>> v = new HashMap<BuildingProject.EnumProjects, List<BuildingProject>>();
        v.put(BuildingProject.EnumProjects.CENTRE, centre);
        v.put(BuildingProject.EnumProjects.START, start);
        v.put(BuildingProject.EnumProjects.PLAYER, players);
        v.put(BuildingProject.EnumProjects.CORE, core);
        v.put(BuildingProject.EnumProjects.SECONDARY, secondary);
        v.put(BuildingProject.EnumProjects.EXTRA, extra);
        v.put(BuildingProject.EnumProjects.CUSTOMBUILDINGS, new ArrayList());
        return v;
    }

    @Override
    public int getChoiceWeight(EntityPlayer player) {
        if (this.isKeyLoneBuildingForGeneration(player)) {
            return 10000;
        }
        return this.weight;
    }

    public int hashCode() {
        return this.culture.hashCode() + this.key.hashCode();
    }

    public boolean isKeyLoneBuildingForGeneration(EntityPlayer player) {
        if (this.keyLonebuilding) {
            return true;
        }
        if (player != null) {
            UserProfile profile = Mill.getMillWorld(player.field_70170_p).getProfile(player.getDisplayName());
            if (this.keyLoneBuildingGenerateTag != null && profile.isTagSet(this.keyLoneBuildingGenerateTag)) {
                return true;
            }
        }
        return false;
    }

    public boolean isValidForGeneration(MillWorld mw, EntityPlayer player, HashMap<String, Integer> nbVillages, Point pos, String biome, boolean keyLoneBuildingsOnly) {
        if (!this.generateOnServer && Mill.proxy.isTrueServer()) {
            return false;
        }
        if (this.minDistanceFromSpawn > 0 && pos.horizontalDistanceTo(mw.world.func_72861_E()) <= (double)this.minDistanceFromSpawn) {
            return false;
        }
        for (String tag : this.requiredTags) {
            if (mw.isGlobalTagSet(tag)) continue;
            return false;
        }
        for (String tag : this.forbiddenTags) {
            if (!mw.isGlobalTagSet(tag)) continue;
            return false;
        }
        if (keyLoneBuildingsOnly && !this.isKeyLoneBuildingForGeneration(player)) {
            return false;
        }
        if (!this.biomes.contains(biome)) {
            return false;
        }
        if (!this.isKeyLoneBuildingForGeneration(player)) {
            if (this.max != 0 && nbVillages.containsKey(this.key) && nbVillages.get(this.key) >= this.max) {
                return false;
            }
        } else {
            boolean existingOneInRange = false;
            for (int i = 0; i < mw.loneBuildingsList.pos.size(); ++i) {
                if (!mw.loneBuildingsList.types.get(i).equals(this.key) || !(pos.horizontalDistanceTo(mw.loneBuildingsList.pos.get(i)) < 2000.0)) continue;
                existingOneInRange = true;
            }
            if (existingOneInRange) {
                return false;
            }
        }
        return true;
    }

    public void readVillageTypeInfoPacket(ByteBufInputStream ds) throws IOException {
        this.playerControlled = ds.readBoolean();
        this.spawnable = ds.readBoolean();
        this.name = StreamReadWrite.readNullableString((DataInput)ds);
        this.type = StreamReadWrite.readNullableString((DataInput)ds);
        this.radius = ds.read();
    }

    public void sendVillageTypePacket(EntityPlayer player) {
    }

    public String toString() {
        return this.key;
    }

    public void writeVillageTypeInfo(DataOutput data) throws IOException {
        data.writeUTF(this.key);
        data.writeBoolean(this.playerControlled);
        data.writeBoolean(this.spawnable);
        StreamReadWrite.writeNullableString(this.name, data);
        StreamReadWrite.writeNullableString(this.type, data);
        data.write(this.radius);
    }

    private static class VillageFileFiler
    implements FilenameFilter {
        String end;

        public VillageFileFiler(String ending) {
            this.end = ending;
        }

        @Override
        public boolean accept(File file, String name) {
            if (!name.endsWith(this.end)) {
                return false;
            }
            return !name.startsWith(".");
        }
    }
}

