/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common;

import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.millenaire.common.MLN;
import org.millenaire.common.forge.Mill;

public class InvItem
implements Comparable<InvItem> {
    public static final int ANYENCHANTED = 1;
    public static final int ENCHANTEDSWORD = 2;
    public final Item item;
    public final Block block;
    public final ItemStack staticStack;
    public final ItemStack[] staticStackArray;
    public final int meta;
    public final int special;

    public InvItem(Block block) throws MLN.MillenaireException {
        this(block, 0);
    }

    public InvItem(Block block, int meta) throws MLN.MillenaireException {
        this.block = block;
        this.item = Item.func_150898_a((Block)block);
        this.meta = meta;
        this.staticStack = new ItemStack(this.item, 1, meta);
        this.staticStackArray = new ItemStack[]{this.staticStack};
        this.special = 0;
        this.checkValidity();
    }

    public InvItem(int special) throws MLN.MillenaireException {
        this.special = special;
        this.staticStack = null;
        this.staticStackArray = new ItemStack[]{this.staticStack};
        this.item = null;
        this.block = null;
        this.meta = 0;
        this.checkValidity();
    }

    public InvItem(Item item) throws MLN.MillenaireException {
        this(item, 0);
    }

    public InvItem(Item item, int meta) throws MLN.MillenaireException {
        this.item = item;
        this.block = Block.func_149634_a((Item)item) != Blocks.field_150350_a ? Block.func_149634_a((Item)item) : null;
        this.meta = meta;
        this.staticStack = new ItemStack(item, 1, meta);
        this.staticStackArray = new ItemStack[]{this.staticStack};
        this.special = 0;
        this.checkValidity();
    }

    public InvItem(ItemStack is) throws MLN.MillenaireException {
        this.item = is.func_77973_b();
        this.block = Block.func_149634_a((Item)this.item) != Blocks.field_150350_a ? Block.func_149634_a((Item)this.item) : null;
        this.meta = is.func_77960_j() > 0 ? is.func_77960_j() : 0;
        this.staticStack = new ItemStack(this.item, 1, this.meta);
        this.staticStackArray = new ItemStack[]{this.staticStack};
        this.special = 0;
        this.checkValidity();
    }

    public InvItem(String s) throws MLN.MillenaireException {
        this.special = 0;
        if (s.split("/").length > 2) {
            int id = Integer.parseInt(s.split("/")[0]);
            if (Item.func_150899_d((int)id) == null) {
                MLN.printException("Tried creating InvItem with null id from string: " + s, new Exception());
                this.item = null;
            } else {
                this.item = Item.func_150899_d((int)id);
            }
            this.block = Block.func_149729_e((int)id) == null ? null : (Block)Block.field_149771_c.func_148754_a(id);
            this.meta = Integer.parseInt(s.split("/")[1]);
            this.staticStack = new ItemStack(this.item, 1, this.meta);
        } else {
            this.staticStack = null;
            this.item = null;
            this.block = null;
            this.meta = 0;
        }
        this.staticStackArray = new ItemStack[]{this.staticStack};
        this.checkValidity();
    }

    private void checkValidity() throws MLN.MillenaireException {
        if (this.block == Blocks.field_150350_a) {
            throw new MLN.MillenaireException("Attempted to create an InvItem for air blocks.");
        }
        if (this.item == null && this.block == null && this.special == 0) {
            throw new MLN.MillenaireException("Attempted to create an empty InvItem.");
        }
    }

    @Override
    public int compareTo(InvItem ii) {
        if (this.special > 0 || ii.special > 0) {
            return this.special - ii.special;
        }
        if (this.item == null || ii.item == null) {
            return this.special - ii.special;
        }
        return this.item.func_77658_a().compareTo(ii.item.func_77658_a()) + this.meta - ii.meta;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof InvItem)) {
            return false;
        }
        InvItem other = (InvItem)obj;
        return other.item == this.item && other.meta == this.meta && other.special == this.special;
    }

    public Block getBlock() {
        return this.block;
    }

    public Item getItem() {
        return this.item;
    }

    public ItemStack getItemStack() {
        if (this.item == null) {
            return null;
        }
        return new ItemStack(this.item, 1, this.meta);
    }

    public String getName() {
        if (this.special == 1) {
            return MLN.string("ui.anyenchanted");
        }
        if (this.special == 2) {
            return MLN.string("ui.enchantedsword");
        }
        if (this.meta == -1 && this.block == Blocks.field_150364_r) {
            return MLN.string("ui.woodforplanks");
        }
        if (this.meta == 0 && this.block == Blocks.field_150364_r) {
            return MLN.string("ui.woodoak");
        }
        if (this.meta == 1 && this.block == Blocks.field_150364_r) {
            return MLN.string("ui.woodpine");
        }
        if (this.meta == 2 && this.block == Blocks.field_150364_r) {
            return MLN.string("ui.woodbirch");
        }
        if (this.meta == 3 && this.block == Blocks.field_150364_r) {
            return MLN.string("ui.woodjungle");
        }
        if (this.meta == -1) {
            return Mill.proxy.getItemName(this.item, 0);
        }
        if (this.item != null) {
            return Mill.proxy.getItemName(this.item, this.meta);
        }
        MLN.printException(new MLN.MillenaireException("Trying to get the name of an invalid InvItem."));
        return "id:" + this.item + ";meta:" + this.meta;
    }

    public String getTranslationKey() {
        return "_item:" + Item.func_150891_b((Item)this.item) + ":" + this.meta;
    }

    public int hashCode() {
        if (this.item == null) {
            return (this.meta << 8) + (this.special << 12);
        }
        return this.item.hashCode() + (this.meta << 8) + (this.special << 12);
    }

    public boolean matches(InvItem ii) {
        return ii.item == this.item && (ii.meta == this.meta || ii.meta == -1 || this.meta == -1);
    }

    public String toString() {
        return this.getName() + "/" + this.meta;
    }
}

