/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.client.gui;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import org.millenaire.client.gui.GuiText;
import org.millenaire.client.network.ClientSender;
import org.millenaire.common.MLN;
import org.millenaire.common.MillVillager;
import org.millenaire.common.Quest;
import org.millenaire.common.UserProfile;
import org.millenaire.common.forge.Mill;

public class GuiQuest
extends GuiText {
    private final MillVillager villager;
    private final EntityPlayer player;
    private boolean showOk = false;
    private int type;
    private boolean firstStep;
    ResourceLocation background = new ResourceLocation("millenaire", "textures/gui/ML_quest.png");

    public GuiQuest(EntityPlayer player, MillVillager villager) {
        this.villager = villager;
        this.player = player;
    }

    protected void func_146284_a(GuiButton guibutton) {
        if (!guibutton.field_146124_l) {
            return;
        }
        UserProfile profile = Mill.proxy.getClientProfile();
        if (guibutton.field_146127_k == 0) {
            Quest.QuestInstance qi = profile.villagersInQuests.get(this.villager.villager_id);
            boolean firstStep = qi.currentStep == 0;
            String res = qi.completeStep(this.player, this.villager);
            ClientSender.questCompleteStep(this.player, this.villager);
            this.initStatus(1, res, firstStep);
        } else if (guibutton.field_146127_k == 1) {
            Quest.QuestInstance qi = profile.villagersInQuests.get(this.villager.villager_id);
            boolean firstStep = qi.currentStep == 0;
            String res = qi.refuseQuest(this.player, this.villager);
            ClientSender.questRefuse(this.player, this.villager);
            this.initStatus(2, res, firstStep);
        } else {
            this.field_146297_k.func_147108_a(null);
            this.field_146297_k.func_71381_h();
            ClientSender.villagerInteractSpecial(this.player, this.villager);
        }
    }

    @Override
    public void buttonPagination() {
        super.buttonPagination();
        int xStart = (this.field_146294_l - this.getXSize()) / 2;
        int yStart = (this.field_146295_m - this.getYSize()) / 2;
        if (this.type == 0) {
            if (this.firstStep) {
                if (this.showOk) {
                    this.field_146292_n.add(new GuiButton(1, xStart + this.getXSize() / 2 - 100, yStart + this.getYSize() - 40, 95, 20, MLN.string("quest.refuse")));
                    this.field_146292_n.add(new GuiButton(0, xStart + this.getXSize() / 2 + 5, yStart + this.getYSize() - 40, 95, 20, MLN.string("quest.accept")));
                } else {
                    this.field_146292_n.add(new GuiButton(1, xStart + this.getXSize() / 2 - 100, yStart + this.getYSize() - 40, 95, 20, MLN.string("quest.refuse")));
                    this.field_146292_n.add(new GuiButton(2, xStart + this.getXSize() / 2 + 5, yStart + this.getYSize() - 40, 95, 20, MLN.string("quest.close")));
                }
            } else if (this.showOk) {
                this.field_146292_n.add(new GuiButton(0, xStart + this.getXSize() / 2 - 100, yStart + this.getYSize() - 40, MLN.string("quest.continue")));
            } else {
                this.field_146292_n.add(new GuiButton(2, xStart + this.getXSize() / 2 - 100, yStart + this.getYSize() - 40, MLN.string("quest.close")));
            }
        } else {
            this.field_146292_n.add(new GuiButton(2, xStart + this.getXSize() / 2 - 100, yStart + this.getYSize() - 40, MLN.string("quest.close")));
        }
    }

    @Override
    protected void customDrawBackground(int i, int j, float f) {
    }

    @Override
    protected void customDrawScreen(int i, int j, float f) {
    }

    @Override
    public boolean func_73868_f() {
        return false;
    }

    private List<List<GuiText.Line>> getData(int type, String baseText) {
        ArrayList<GuiText.Line> text = new ArrayList<GuiText.Line>();
        String game = "";
        if (this.villager.getGameOccupationName(this.player.getDisplayName()).length() > 0) {
            game = " (" + this.villager.getGameOccupationName(this.player.getDisplayName()) + ")";
        }
        text.add(new GuiText.Line(this.villager.getName() + ", " + this.villager.getNativeOccupationName() + game));
        text.add(new GuiText.Line());
        text.add(new GuiText.Line(baseText.replaceAll("\\$name", this.player.getDisplayName())));
        UserProfile profile = Mill.proxy.getClientProfile();
        if (type == 0) {
            Quest.QuestStep step = profile.villagersInQuests.get(this.villager.villager_id).getCurrentStep();
            String error = step.lackingConditions(this.player);
            if (error != null) {
                text.add(new GuiText.Line());
                text.add(new GuiText.Line(error));
                this.showOk = false;
            } else {
                this.showOk = true;
            }
        }
        ArrayList<List<GuiText.Line>> ftext = new ArrayList<List<GuiText.Line>>();
        ftext.add(text);
        return this.adjustText(ftext);
    }

    @Override
    public int getLineSizeInPx() {
        return 240;
    }

    @Override
    public int getPageSize() {
        return 16;
    }

    @Override
    public ResourceLocation getPNGPath() {
        return this.background;
    }

    @Override
    public int getXSize() {
        return 256;
    }

    @Override
    public int getYSize() {
        return 220;
    }

    @Override
    public void initData() {
        UserProfile profile = Mill.proxy.getClientProfile();
        String baseText = profile.villagersInQuests.get(this.villager.villager_id).getDescription(profile);
        boolean firstStep = profile.villagersInQuests.get((Object)Long.valueOf((long)this.villager.villager_id)).currentStep == 0;
        this.initStatus(0, baseText, firstStep);
    }

    private void initStatus(int type, String baseText, boolean firstStep) {
        this.pageNum = 0;
        this.type = type;
        this.firstStep = firstStep;
        this.descText = this.getData(type, baseText);
        this.buttonPagination();
    }

    @Override
    protected void func_73869_a(char c, int i) {
        if (i == 1) {
            this.field_146297_k.func_147108_a(null);
            this.field_146297_k.func_71381_h();
            ClientSender.villagerInteractSpecial(this.player, this.villager);
        }
    }
}

