/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.client.gui;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import org.millenaire.client.gui.DisplayActions;
import org.millenaire.client.gui.GuiText;
import org.millenaire.client.network.ClientSender;
import org.millenaire.common.MLN;
import org.millenaire.common.Point;
import org.millenaire.common.building.Building;
import org.millenaire.common.building.BuildingCustomPlan;
import org.millenaire.common.building.BuildingPlanSet;
import org.millenaire.common.building.IBuildingPlan;

public class GuiNewBuildingProject
extends GuiText {
    private final Building townHall;
    private final Point pos;
    private final EntityPlayer player;
    ResourceLocation background = new ResourceLocation("millenaire", "textures/gui/ML_panel.png");

    public GuiNewBuildingProject(EntityPlayer player, Building th, Point p) {
        this.townHall = th;
        this.pos = p;
        this.player = player;
    }

    protected void func_146284_a(GuiButton guibutton) {
        if (!guibutton.field_146124_l) {
            return;
        }
        GuiButtonNewBuilding button = (GuiButtonNewBuilding)guibutton;
        if (!button.custom) {
            ClientSender.newBuilding(this.player, this.townHall, this.pos, button.key);
        } else {
            this.closeWindow();
            BuildingCustomPlan customBuilding = this.townHall.culture.getBuildingCustom(button.key);
            if (customBuilding != null) {
                DisplayActions.displayNewCustomBuildingGUI(this.player, this.townHall, this.pos, customBuilding);
            }
        }
    }

    @Override
    protected void customDrawBackground(int i, int j, float f) {
    }

    @Override
    protected void customDrawScreen(int i, int j, float f) {
    }

    @Override
    public void decrementPage() {
        super.decrementPage();
        this.buttonPagination();
    }

    private String getCustomPlanDesc(IBuildingPlan customPlan) {
        String desc = "";
        if (customPlan.getGameName() != null && customPlan.getGameName().length() > 0) {
            desc = desc + customPlan.getGameName() + ". ";
        }
        if (customPlan.getMaleResident().size() > 0 || customPlan.getFemaleResident().size() > 0) {
            desc = desc + MLN.string("ui.inhabitants") + ": ";
            boolean first = true;
            for (String inhabitant : customPlan.getMaleResident()) {
                if (first) {
                    first = false;
                } else {
                    desc = desc + ", ";
                }
                desc = desc + customPlan.getCulture().getVillagerType((String)inhabitant).name;
            }
            for (String inhabitant : customPlan.getFemaleResident()) {
                if (first) {
                    first = false;
                } else {
                    desc = desc + ", ";
                }
                desc = desc + customPlan.getCulture().getVillagerType((String)inhabitant).name;
            }
            desc = desc + ". ";
        }
        return desc;
    }

    @Override
    public int getLineSizeInPx() {
        return 195;
    }

    @Override
    public int getPageSize() {
        return 19;
    }

    @Override
    public ResourceLocation getPNGPath() {
        return this.background;
    }

    @Override
    public int getXSize() {
        return 204;
    }

    @Override
    public int getYSize() {
        return 220;
    }

    @Override
    public void incrementPage() {
        super.incrementPage();
        this.buttonPagination();
    }

    @Override
    public void initData() {
        String desc;
        ArrayList<List<GuiText.Line>> pages = new ArrayList<List<GuiText.Line>>();
        ArrayList<GuiText.Line> text = new ArrayList<GuiText.Line>();
        text.add(new GuiText.Line(this.townHall.getVillageQualifiedName()));
        text.add(new GuiText.Line());
        text.add(new GuiText.Line(MLN.string("ui.selectabuildingproject")));
        text.add(new GuiText.Line());
        text.add(new GuiText.Line(MLN.string("ui.selectabuildingproject_custom")));
        for (BuildingCustomPlan customBuilding : this.townHall.villageType.customBuildings) {
            text.add(new GuiText.Line(new GuiButtonNewBuilding(customBuilding.buildingKey, customBuilding.getNativeName(), true)));
            text.add(new GuiText.Line(false));
            desc = this.getCustomPlanDesc(customBuilding).trim();
            if (desc.length() > 0) {
                text.add(new GuiText.Line(desc));
            }
            text.add(new GuiText.Line());
        }
        pages.add(text);
        text = new ArrayList();
        text.add(new GuiText.Line());
        text.add(new GuiText.Line(MLN.string("ui.selectabuildingproject_standard")));
        for (BuildingPlanSet planSet : this.townHall.villageType.coreBuildings) {
            if (!this.townHall.isValidProject(planSet.getBuildingProject())) continue;
            text.add(new GuiText.Line(new GuiButtonNewBuilding(planSet.key, planSet.getNativeName(), false)));
            text.add(new GuiText.Line(false));
            desc = this.getCustomPlanDesc(planSet.getFirstStartingPlan()).trim();
            if (desc.length() > 0) {
                text.add(new GuiText.Line(desc));
            }
            text.add(new GuiText.Line());
        }
        pages.add(text);
        this.descText = this.adjustText(pages);
    }

    public static class GuiButtonNewBuilding
    extends GuiText.MillGuiButton {
        private final String key;
        private final boolean custom;

        public GuiButtonNewBuilding(String key, String label, boolean custom) {
            super(0, 0, 0, 0, 0, label);
            this.key = key;
            this.custom = custom;
        }
    }
}

