/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.tileentity.transfernodes;

import com.rwtema.extrautils.block.Box;
import com.rwtema.extrautils.block.BoxModel;
import com.rwtema.extrautils.item.ItemNodeUpgrade;
import com.rwtema.extrautils.tileentity.transfernodes.BlockTransferNode;
import com.rwtema.extrautils.tileentity.transfernodes.TileEntityTransferNode;
import com.rwtema.extrautils.tileentity.transfernodes.nodebuffer.FluidBuffer;
import com.rwtema.extrautils.tileentity.transfernodes.nodebuffer.INodeBuffer;
import com.rwtema.extrautils.tileentity.transfernodes.nodebuffer.INodeLiquid;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.Facing;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityTransferNodeLiquid
extends TileEntityTransferNode
implements INodeLiquid {
    public boolean nearSource = false;
    public long checkTimer = 0L;

    public TileEntityTransferNodeLiquid() {
        super("Liquid", new FluidBuffer());
        this.pr = 0.001f;
        this.pg = 0.0f;
        this.pb = 1.0f;
    }

    public TileEntityTransferNodeLiquid(String s, INodeBuffer buffer) {
        super(s, buffer);
        this.pr = 0.001f;
        this.pg = 0.0f;
        this.pb = 1.0f;
    }

    @Override
    public void processBuffer() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            if (this.coolDown > 0) {
                this.coolDown -= this.stepCoolDown;
            }
            if (this.checkRedstone()) {
                return;
            }
            while (this.coolDown <= 0) {
                this.coolDown += baseMaxCoolDown;
                if (this.handleInventories()) {
                    this.advPipeSearch();
                }
                this.loadTank();
            }
        }
    }

    public void loadTank() {
        int dir = this.func_145832_p() % 6;
        if (this.field_145850_b.func_147438_o(this.field_145851_c + Facing.field_71586_b[dir], this.field_145848_d + Facing.field_71587_c[dir], this.field_145849_e + Facing.field_71585_d[dir]) instanceof IFluidHandler) {
            IFluidHandler source = (IFluidHandler)this.field_145850_b.func_147438_o(this.field_145851_c + Facing.field_71586_b[dir], this.field_145848_d + Facing.field_71587_c[dir], this.field_145849_e + Facing.field_71585_d[dir]);
            FluidStack liquid = source.drain(ForgeDirection.getOrientation((int)dir).getOpposite(), this.upgradeNo(3) == 0 ? 200 : ((FluidTank)this.buffer.getBuffer()).getCapacity(), false);
            int k = this.fill(this.getNodeDir(), liquid, false);
            if (k > 0) {
                this.fill(this.getNodeDir(), source.drain(ForgeDirection.getOrientation((int)dir).getOpposite(), k, true), true);
            }
        } else if (this.upgradeNo(2) > 0) {
            if (this.field_145850_b.func_82737_E() - this.checkTimer > 20L) {
                this.checkTimer = this.field_145850_b.func_82737_E();
                this.nearSource = false;
                if (this.isWaterSource(this.field_145851_c + Facing.field_71586_b[dir], this.field_145848_d + Facing.field_71587_c[dir], this.field_145849_e + Facing.field_71585_d[dir])) {
                    int n = 0;
                    for (int i = 2; i < 6; ++i) {
                        if (!this.isWaterSource(this.field_145851_c + Facing.field_71586_b[dir] + Facing.field_71586_b[i], this.field_145848_d + Facing.field_71587_c[dir], this.field_145849_e + Facing.field_71585_d[dir] + Facing.field_71585_d[i])) continue;
                        ++n;
                    }
                    if (n >= 2) {
                        this.nearSource = true;
                    }
                }
            }
            if (this.nearSource) {
                long t = this.field_145850_b.func_82737_E() / (long)TileEntityTransferNode.baseMaxCoolDown * (long)TileEntityTransferNode.baseMaxCoolDown;
                int a = 1000 * TileEntityTransferNode.baseMaxCoolDown / (20 * this.stepCoolDown);
                float b = 1000.0f * (float)TileEntityTransferNode.baseMaxCoolDown / (float)(20 * this.stepCoolDown);
                if ((float)a != b && b - (float)a > this.field_145850_b.field_73012_v.nextFloat()) {
                    ++a;
                }
                if (a > 0) {
                    this.fill(this.getNodeDir(), new FluidStack(FluidRegistry.WATER, a * (1 + this.upgradeNo(2))), true);
                }
            }
        }
    }

    public boolean isWaterSource(int x, int y, int z) {
        Block id = this.field_145850_b.func_147439_a(x, y, z);
        return (id == Blocks.field_150355_j || id == Blocks.field_150358_i) && this.field_145850_b.func_72805_g(x, y, z) == 0;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (from == this.getNodeDir()) {
            if (resource == null) {
                return 0;
            }
            for (int j = 0; j < this.upgrades.func_70302_i_(); ++j) {
                if (this.upgrades.func_70301_a(j) == null || this.upgrades.func_70301_a(j).func_77960_j() != 1 || this.upgrades.func_70301_a(j).func_77978_p() == null || ItemNodeUpgrade.matchesFilterLiquid(resource, this.upgrades.func_70301_a(j))) continue;
                return 0;
            }
            return ((FluidTank)this.buffer.getBuffer()).fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return from.ordinal() == this.func_145832_p() % 6;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{((FluidTank)this.buffer.getBuffer()).getInfo()};
    }

    @Override
    public TileEntityTransferNodeLiquid getNode() {
        return this;
    }

    @Override
    public BoxModel getModel(ForgeDirection dir) {
        BoxModel boxes = new BoxModel();
        float w = 0.125f;
        boxes.add(new Box(0.0625f, 0.0f, 0.0625f, 0.9375f, 0.0625f, 0.9375f).rotateToSide(dir).setTextureSides(dir.ordinal(), BlockTransferNode.nodeBase));
        boxes.add(new Box(0.1875f, 0.0625f, 0.1875f, 0.8125f, 0.25f, 0.8125f).rotateToSide(dir));
        boxes.add(new Box(0.3125f, 0.25f, 0.3125f, 0.6875f, 0.375f, 0.6875f).rotateToSide(dir));
        boxes.add(new Box(0.375f, 0.25f, 0.375f, 0.625f, 0.375f, 0.625f).rotateToSide(dir).setTexture(BlockTransferNode.nodeBase).setAllSideInvisible().setSideInvisible(dir.getOpposite().ordinal(), false));
        return boxes;
    }
}

