/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.tileentity.transfernodes;

import buildcraft.api.mj.IBatteryObject;
import buildcraft.api.mj.IBatteryProvider;
import buildcraft.api.mj.MjAPI;
import buildcraft.api.power.PowerHandler;
import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyContainerItem;
import cofh.api.energy.IEnergyHandler;
import com.rwtema.extrautils.ChunkPos;
import com.rwtema.extrautils.block.Box;
import com.rwtema.extrautils.block.BoxModel;
import com.rwtema.extrautils.modintegration.BCEnergy;
import com.rwtema.extrautils.modintegration.BCEnergyHandler;
import com.rwtema.extrautils.modintegration.IC2EnergyHandler;
import com.rwtema.extrautils.tileentity.transfernodes.TNHelper;
import com.rwtema.extrautils.tileentity.transfernodes.TileEntityTransferNode;
import com.rwtema.extrautils.tileentity.transfernodes.nodebuffer.EnergyBuffer;
import com.rwtema.extrautils.tileentity.transfernodes.nodebuffer.INode;
import com.rwtema.extrautils.tileentity.transfernodes.nodebuffer.INodeBuffer;
import com.rwtema.extrautils.tileentity.transfernodes.nodebuffer.INodeEnergy;
import com.rwtema.extrautils.tileentity.transfernodes.pipes.IPipe;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModAPIManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Facing;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityTransferNodeEnergy
extends TileEntityTransferNode
implements INodeEnergy,
IEnergyHandler,
IBatteryProvider {
    public static final int RF_PER_MJ = 10;
    public static final int RF_PER_EU = 4;
    public static final double RFtoBC = 0.1;
    public static final double BCtoRF = 10.0;
    public static boolean infiniteEnergy = false;
    public static boolean isBCPresent = false;
    public EnergyStorage powerHandler = new EnergyStorage(10000);
    public BCEnergyHandler powerHandlerBC = null;
    public IC2EnergyHandler powerHandlerIC2 = null;
    public int powerInserted = 0;
    public boolean lastStep = false;
    public List<ChunkPos> searchLocations = new ArrayList<ChunkPos>();
    public List<EnergyPosition> clientele = new ArrayList<EnergyPosition>();
    public List<EnergyPosition> clientele_temp = new ArrayList<EnergyPosition>();
    public Object battery = null;
    private int search_i;

    public TileEntityTransferNodeEnergy() {
        this("Energy", new EnergyBuffer());
    }

    public TileEntityTransferNodeEnergy(String s, INodeBuffer buffer) {
        super(s, buffer);
        this.pr = 1.0f;
        this.pg = 0.7f;
        this.pb = 0.0f;
        if (ModAPIManager.INSTANCE.hasAPI("BuildCraftAPI|power")) {
            isBCPresent = true;
            this.powerHandlerBC = BCEnergy.newHandler(this);
            this.powerHandlerBC.configure(0, 100, 99999, 3200);
        }
        if (Loader.isModLoaded((String)"IC2")) {
            this.powerHandlerIC2 = new IC2EnergyHandler(this, 512, 1);
        }
    }

    public static double RFtoBC(int RF) {
        return (double)RF * 0.1;
    }

    public static int toRF2(double BC) {
        return (int)Math.floor(BC * 10.0);
    }

    public static int toRF3(double BC) {
        return (int)Math.round(BC * 10.0);
    }

    public static int BCtoRF(double BC) {
        return (int)Math.floor(BC * 10.0);
    }

    public static double toIC2(int k) {
        return (double)k / 4.0;
    }

    public static int fromIC2(double t) {
        return (int)Math.floor(t * 4.0);
    }

    public int numMachines() {
        return this.clientele.size();
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.clientele.clear();
        int i = 0;
        while (tag.func_74764_b("cx" + i)) {
            this.clientele.add(new EnergyPosition(tag.func_74762_e("cx" + i), tag.func_74762_e("cy" + i), tag.func_74762_e("cz" + i), tag.func_74771_c("cs" + i), tag.func_74767_n("ce")));
            this.clientele_temp.add(new EnergyPosition(tag.func_74762_e("cx" + i), tag.func_74762_e("cy" + i), tag.func_74762_e("cz" + i), tag.func_74771_c("cs" + i), tag.func_74767_n("ce")));
            ++i;
        }
        if (this.powerHandlerBC != null) {
            this.powerHandlerBC.readFromNBT(tag.func_74775_l("buffer"));
        }
        if (this.powerHandlerIC2 != null) {
            this.powerHandlerIC2.readFromNBT(tag);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        for (int i = 0; i < this.clientele.size(); ++i) {
            par1NBTTagCompound.func_74768_a("cx" + i, this.clientele.get((int)i).x);
            par1NBTTagCompound.func_74768_a("cy" + i, this.clientele.get((int)i).y);
            par1NBTTagCompound.func_74768_a("cz" + i, this.clientele.get((int)i).z);
            par1NBTTagCompound.func_74774_a("cs" + i, this.clientele.get((int)i).side);
            par1NBTTagCompound.func_74757_a("ce", this.clientele.get((int)i).extract);
        }
        NBTTagCompound nbttagcompound1 = new NBTTagCompound();
        if (this.powerHandlerBC != null) {
            this.powerHandlerBC.writeToNBT(nbttagcompound1);
        }
        par1NBTTagCompound.func_74782_a("buffer", (NBTBase)nbttagcompound1);
        if (this.powerHandlerIC2 != null) {
            this.powerHandlerIC2.writeToNBT(nbttagcompound1);
        }
    }

    @Override
    public boolean checkRedstone() {
        return false;
    }

    @Override
    public void processBuffer() {
        if (isBCPresent && this.powerHandlerBC != null) {
            this.powerHandlerBC.update();
            double d = this.powerHandlerBC.useEnergy(0.0, this.powerHandlerBC.getMaxEnergyStored(), false);
            double t = TileEntityTransferNodeEnergy.RFtoBC(this.powerHandler.receiveEnergy(TileEntityTransferNodeEnergy.BCtoRF(d), false));
            this.powerHandlerBC.useEnergy(0.0, t, true);
        }
        if (this.powerHandlerIC2 != null) {
            this.powerHandlerIC2.updateEntity();
            this.powerHandlerIC2.useEnergy(TileEntityTransferNodeEnergy.toIC2(this.powerHandler.receiveEnergy(TileEntityTransferNodeEnergy.fromIC2(this.powerHandlerIC2.getEnergyStored()), false)));
        }
        if (this.powerHandler.getEnergyStored() > 0) {
            for (int i = 0; i < this.upgrades.func_70302_i_(); ++i) {
                ItemStack itemstack = this.upgrades.func_70301_a(i);
                if (itemstack == null || !(itemstack.func_77973_b() instanceof IEnergyContainerItem)) continue;
                int a = ((IEnergyContainerItem)itemstack.func_77973_b()).receiveEnergy(itemstack, this.powerHandler.extractEnergy(10000, true), false);
                this.powerHandler.extractEnergy(a, false);
                if (a <= 0) continue;
                this.func_70296_d();
            }
        }
        if (this.upgradeNo(4) > 0) {
            this.powerHandler.setEnergyStored(6400000);
        }
        if (this.coolDown > 0) {
            this.coolDown -= this.stepCoolDown;
        }
        while (this.coolDown <= 0) {
            this.coolDown += baseMaxCoolDown;
            this.findMachines();
        }
        this.sendEnergy();
    }

    @Override
    public void onChunkUnload() {
        if (this.powerHandlerIC2 != null) {
            this.powerHandlerIC2.onChunkUnload();
        }
        super.onChunkUnload();
    }

    @Override
    public void func_145843_s() {
        if (this.powerHandlerIC2 != null) {
            this.powerHandlerIC2.invalidate();
        }
        super.func_145843_s();
    }

    private void sendEnergy() {
        if (this.clientele.size() > 0) {
            IBatteryObject obj;
            ForgeDirection from;
            TileEntity tile;
            int z;
            int y;
            int x;
            Collections.shuffle(this.clientele);
            ArrayList<EnergyPosition> repeat = new ArrayList<EnergyPosition>();
            int m1 = this.powerHandler.getEnergyStored() / this.clientele.size();
            for (EnergyPosition client : this.clientele) {
                x = this.field_145851_c + client.x;
                y = this.field_145848_d + client.y;
                z = this.field_145849_e + client.z;
                tile = this.field_145850_b.func_147438_o(x, y, z);
                from = ForgeDirection.getOrientation((int)client.side);
                if (client.extract) {
                    int a;
                    if (!(tile instanceof IEnergyHandler) || !((IEnergyHandler)tile).canConnectEnergy(from) || (a = this.powerHandler.receiveEnergy(((IEnergyHandler)tile).extractEnergy(from, this.powerHandler.getMaxEnergyStored(), true), true)) <= 0) continue;
                    this.powerHandler.receiveEnergy(((IEnergyHandler)tile).extractEnergy(from, a, false), false);
                    continue;
                }
                if (this.powerHandler.getEnergyStored() <= 0) continue;
                if (tile instanceof IEnergyHandler && ((IEnergyHandler)tile).canConnectEnergy(from)) {
                    IEnergyHandler machine = (IEnergyHandler)tile;
                    int a = machine.receiveEnergy(from, this.powerHandler.getEnergyStored(), true);
                    if (a > m1) {
                        if (m1 >= 1) {
                            a = machine.receiveEnergy(from, this.powerHandler.extractEnergy(m1, true), false);
                            this.powerHandler.extractEnergy(a, false);
                        }
                        repeat.add(client);
                        continue;
                    }
                    if (a <= 0) continue;
                    a = machine.receiveEnergy(from, this.powerHandler.extractEnergy(a, false), false);
                    this.powerHandler.extractEnergy(a, false);
                    continue;
                }
                obj = MjAPI.getMjBattery(tile, "buildcraft.kinesis", from);
                if (obj == null) continue;
                int e = TileEntityTransferNodeEnergy.BCtoRF(obj.getEnergyRequested());
                if (e > m1) {
                    double a = obj.addEnergy(TileEntityTransferNodeEnergy.RFtoBC(this.powerHandler.extractEnergy(m1, true)));
                    repeat.add(client);
                    this.powerHandler.extractEnergy(TileEntityTransferNodeEnergy.BCtoRF(a), false);
                    continue;
                }
                double a = obj.addEnergy(TileEntityTransferNodeEnergy.RFtoBC(this.powerHandler.extractEnergy(e, true)));
                this.powerHandler.extractEnergy(TileEntityTransferNodeEnergy.BCtoRF(a), false);
            }
            if (this.powerHandler.getEnergyStored() > 0) {
                for (EnergyPosition aRepeat : repeat) {
                    x = this.field_145851_c + aRepeat.x;
                    y = this.field_145848_d + aRepeat.y;
                    z = this.field_145849_e + aRepeat.z;
                    tile = this.field_145850_b.func_147438_o(x, y, z);
                    from = ForgeDirection.getOrientation((int)aRepeat.side);
                    if (tile instanceof IEnergyHandler) {
                        IEnergyHandler machine = (IEnergyHandler)tile;
                        int e = machine.receiveEnergy(from, this.powerHandler.getEnergyStored(), true);
                        if (e <= 0) continue;
                        int a = machine.receiveEnergy(from, this.powerHandler.extractEnergy(e, true), false);
                        this.powerHandler.extractEnergy(a, false);
                        continue;
                    }
                    obj = MjAPI.getMjBattery(tile, "buildcraft.kinesis", from);
                    if (obj == null) continue;
                    int e = TileEntityTransferNodeEnergy.BCtoRF(obj.getEnergyRequested());
                    double a = obj.addEnergy(TileEntityTransferNodeEnergy.RFtoBC(this.powerHandler.extractEnergy(e - m1, true)));
                    this.powerHandler.extractEnergy(TileEntityTransferNodeEnergy.BCtoRF(a), false);
                }
            }
        }
    }

    public int hashCode() {
        return this.field_145851_c * 8976890 + this.field_145848_d * 981131 + this.field_145849_e;
    }

    public static double getEnergyIn(PowerHandler.PowerReceiver machine) {
        double e = machine.powerRequest();
        if (machine.getMinEnergyReceived() > e) {
            e = machine.getMinEnergyReceived();
        }
        return e;
    }

    private void findMachines() {
        ++this.search_i;
        if (this.searchLocations.size() == 0 || this.search_i >= this.searchLocations.size()) {
            this.clientele.clear();
            this.clientele.addAll(this.clientele_temp);
            this.clientele_temp.clear();
            this.search_i = 0;
            this.searchLocations.clear();
            this.searchLocations.add(new ChunkPos(0, 0, 0));
        }
        this.pipe_x = this.searchLocations.get((int)this.search_i).x;
        this.pipe_y = this.searchLocations.get((int)this.search_i).y;
        this.pipe_z = this.searchLocations.get((int)this.search_i).z;
        int x = this.pipe_x + this.field_145851_c;
        int y = this.pipe_y + this.field_145848_d;
        int z = this.pipe_z + this.field_145849_e;
        this.sendParticleUpdate();
        Block id = this.field_145850_b.func_147439_a(x, y, z);
        IPipe pipeBlock = TNHelper.getPipe((IBlockAccess)this.field_145850_b, this.field_145851_c + this.pipe_x, this.field_145848_d + this.pipe_y, this.field_145849_e + this.pipe_z);
        if (pipeBlock != null) {
            for (int i = 0; i < 6; ++i) {
                if (pipeBlock.shouldConnectToTile((IBlockAccess)this.field_145850_b, x, y, z, ForgeDirection.getOrientation((int)i)) || pipeBlock instanceof INode && ((INode)pipeBlock).getNodeDir() == ForgeDirection.getOrientation((int)i)) {
                    TileEntity tile = this.field_145850_b.func_147438_o(x + Facing.field_71586_b[i], y + Facing.field_71587_c[i], z + Facing.field_71585_d[i]);
                    if (!TNHelper.isEnergy(tile, ForgeDirection.getOrientation((int)i).getOpposite())) continue;
                    EnergyPosition pos = new EnergyPosition(this.pipe_x + Facing.field_71586_b[i], this.pipe_y + Facing.field_71587_c[i], this.pipe_z + Facing.field_71585_d[i], (byte)Facing.field_71588_a[i], "Energy_Extract".equals(pipeBlock.getPipeType()));
                    if ("Energy_Extract".equals(pipeBlock.getPipeType()) && !this.clientele_temp.contains(pos)) {
                        boolean k = true;
                        k = false;
                    }
                    if (!this.clientele_temp.contains(pos)) {
                        this.clientele_temp.add(pos);
                    }
                    if (this.clientele.contains(pos)) continue;
                    this.clientele.add(pos);
                    continue;
                }
                if (!TNHelper.doesPipeConnect((IBlockAccess)this.field_145850_b, x, y, z, ForgeDirection.getOrientation((int)i)) || this.searchLocations.contains(new ChunkPos(this.pipe_x + Facing.field_71586_b[i], this.pipe_y + Facing.field_71587_c[i], this.pipe_z + Facing.field_71585_d[i]))) continue;
                this.searchLocations.add(new ChunkPos(this.pipe_x + Facing.field_71586_b[i], this.pipe_y + Facing.field_71587_c[i], this.pipe_z + Facing.field_71585_d[i]));
            }
        }
    }

    @Override
    public ForgeDirection getNodeDir() {
        return ForgeDirection.UNKNOWN;
    }

    @Override
    public void resetSearch() {
        this.powerInserted = 0;
        super.resetSearch();
    }

    @Override
    public TileEntityTransferNodeEnergy getNode() {
        return this;
    }

    @Override
    public BoxModel getModel(ForgeDirection dir) {
        BoxModel boxes = new BoxModel();
        boxes.add(new Box(0.1875f, 0.3125f, 0.3125f, 0.8125f, 0.6875f, 0.6875f));
        boxes.add(new Box(0.3125f, 0.1875f, 0.3125f, 0.6875f, 0.8125f, 0.6875f));
        boxes.add(new Box(0.3125f, 0.3125f, 0.1875f, 0.6875f, 0.6875f, 0.8125f));
        boxes.add(new Box(0.25f, 0.25f, 0.25f, 0.75f, 0.75f, 0.75f));
        return boxes;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.powerHandler.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.powerHandler.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.powerHandler.getMaxEnergyStored();
    }

    @Override
    public IBatteryObject getMjBattery(String kind) {
        return MjAPI.getMjBattery(this.powerHandlerBC, kind);
    }

    public static class EnergyPosition
    extends ChunkPos {
        public byte side = (byte)7;
        public boolean extract = false;

        public EnergyPosition(int par1, int par2, int par3, byte par4, boolean extract) {
            super(par1, par2, par3);
            this.side = par4;
            this.extract = extract;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            EnergyPosition that = (EnergyPosition)o;
            if (this.extract != that.extract) {
                return false;
            }
            return this.side == that.side;
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.side;
            result = 31 * result + (this.extract ? 1 : 0);
            return result;
        }
    }
}

