/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.tileentity;

import com.rwtema.extrautils.XUHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityFilingCabinet
extends TileEntity
implements IInventory {
    public List<ItemStack> itemSlots = new ArrayList<ItemStack>();
    public List<ItemStack> inputSlots = new ArrayList<ItemStack>();
    private boolean needsUpdate = false;

    public static boolean areCloseEnoughForBasic(ItemStack a, ItemStack b) {
        if (a == null || b == null) {
            return false;
        }
        int[] da = OreDictionary.getOreIDs((ItemStack)a);
        int[] db = OreDictionary.getOreIDs((ItemStack)b);
        return da.length > 0 || db.length > 0 ? TileEntityFilingCabinet.arrayContain(da, db) : a.func_77973_b() == b.func_77973_b();
    }

    public static boolean arrayContain(int[] a, int[] b) {
        if (a.length == 0 || b.length == 0) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            for (int j = 0; j < b.length; ++j) {
                if (a[i] != a[j]) continue;
                return true;
            }
        }
        return false;
    }

    public int getMaxSlots() {
        if (this.func_145832_p() < 6) {
            return 1728;
        }
        return 1728;
    }

    public void func_145845_h() {
        this.handleInput();
    }

    public void handleInput() {
        if (this.needsUpdate) {
            for (int i = 0; i < this.itemSlots.size(); ++i) {
                if (this.itemSlots.get(i) != null) continue;
                this.itemSlots.remove(i);
                --i;
            }
            while (this.inputSlots.size() > 0) {
                boolean added = false;
                for (ItemStack itemSlot : this.itemSlots) {
                    if (!XUHelper.canItemsStack(itemSlot, this.inputSlots.get(0), false, true)) continue;
                    itemSlot.field_77994_a += this.inputSlots.get((int)0).field_77994_a;
                    added = true;
                    break;
                }
                if (!added) {
                    this.itemSlots.add(this.inputSlots.get(0));
                }
                this.inputSlots.remove(0);
            }
        }
    }

    public void func_70296_d() {
        this.needsUpdate = true;
        super.func_70296_d();
    }

    public int func_70302_i_() {
        return this.itemSlots.size() + this.inputSlots.size() + 1;
    }

    public ItemStack func_70301_a(int i) {
        if (i < this.itemSlots.size()) {
            return this.itemSlots.get(i);
        }
        if (i - this.itemSlots.size() < this.inputSlots.size()) {
            return this.inputSlots.get(i - this.itemSlots.size());
        }
        return null;
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (par1 < this.itemSlots.size() && this.itemSlots.get(par1) != null) {
            if (par2 > this.itemSlots.get(par1).func_77976_d()) {
                par2 = this.itemSlots.get(par1).func_77976_d();
            }
            if (this.itemSlots.get((int)par1).field_77994_a <= par2) {
                ItemStack itemstack = this.itemSlots.get(par1);
                this.itemSlots.set(par1, null);
                this.func_70296_d();
                return itemstack;
            }
            ItemStack itemstack = this.itemSlots.get(par1).func_77979_a(par2);
            if (this.itemSlots.get((int)par1).field_77994_a == 0) {
                this.itemSlots.set(par1, null);
            }
            this.func_70296_d();
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int i) {
        if (i < this.itemSlots.size()) {
            return this.itemSlots.get(i);
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        if (i < this.itemSlots.size()) {
            this.itemSlots.set(i, itemstack);
        } else if (i - this.itemSlots.size() < this.inputSlots.size()) {
            this.inputSlots.set(i - this.itemSlots.size(), itemstack);
        } else if (i == this.itemSlots.size() + this.inputSlots.size() && itemstack != null) {
            this.inputSlots.add(itemstack);
        }
        this.needsUpdate = true;
    }

    public String func_145825_b() {
        return "extrautils:filing.cabinet";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        if (this.func_145832_p() >= 6) {
            return 1;
        }
        int n = 0;
        for (int j = 0; j < this.itemSlots.size() && n <= this.getMaxSlots(); ++j) {
            if (this.itemSlots.get(j) == null) continue;
            n += this.itemSlots.get((int)j).field_77994_a;
        }
        for (ItemStack inputSlot : this.inputSlots) {
            if (inputSlot == null) continue;
            n += inputSlot.field_77994_a;
        }
        return Math.max(1, this.getMaxSlots() - n);
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return !this.func_145837_r();
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        if (i == this.itemSlots.size() + this.inputSlots.size()) {
            int j;
            boolean basic;
            boolean bl = basic = this.func_145832_p() < 6;
            if (!basic && itemstack.func_77976_d() != 1) {
                return false;
            }
            int n = 0;
            for (j = 0; j < this.itemSlots.size() && n < this.getMaxSlots(); ++j) {
                if (this.itemSlots.get(j) == null) continue;
                if (basic && !TileEntityFilingCabinet.areCloseEnoughForBasic(this.itemSlots.get(j), itemstack)) {
                    return false;
                }
                n += this.itemSlots.get((int)j).field_77994_a;
            }
            for (j = 0; j < this.inputSlots.size() && n < this.getMaxSlots(); ++j) {
                if (this.inputSlots.get(j) == null) continue;
                n += this.inputSlots.get((int)j).field_77994_a;
            }
            return n < this.getMaxSlots();
        }
        return false;
    }

    public void readInvFromTags(NBTTagCompound tags) {
        int n = 0;
        if (tags.func_74764_b("item_no")) {
            n = tags.func_74762_e("item_no");
        }
        this.itemSlots.clear();
        this.inputSlots.clear();
        for (int i = 0; i < n; ++i) {
            ItemStack item = ItemStack.func_77949_a((NBTTagCompound)tags.func_74775_l("item_" + i));
            if (item == null) continue;
            item.field_77994_a = tags.func_74775_l("item_" + i).func_74762_e("Size");
            if (item.field_77994_a <= 0) continue;
            this.itemSlots.add(item);
        }
    }

    public void writeInvToTags(NBTTagCompound tags) {
        this.handleInput();
        if (this.itemSlots.size() > 0) {
            tags.func_74768_a("item_no", this.itemSlots.size());
            for (int i = 0; i < this.itemSlots.size(); ++i) {
                NBTTagCompound t = new NBTTagCompound();
                this.itemSlots.get(i).func_77955_b(t);
                t.func_74768_a("Size", this.itemSlots.get((int)i).field_77994_a);
                tags.func_74782_a("item_" + i, (NBTBase)t);
            }
        }
    }

    public void func_145839_a(NBTTagCompound tags) {
        super.func_145839_a(tags);
        this.readInvFromTags(tags);
    }

    public void func_145841_b(NBTTagCompound tags) {
        super.func_145841_b(tags);
        this.writeInvToTags(tags);
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }
}

