/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.modintegration;

import buildcraft.api.core.JavaTools;
import buildcraft.api.mj.IBatteryObject;
import buildcraft.api.mj.IBatteryProvider;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class BCEnergyHandler
implements IBatteryObject,
IBatteryProvider {
    private final TileEntity receptor;
    private double energyStored;
    private double maxCapacity;
    private double maxReceivedPerCycle;
    private double minimumConsumption;

    public BCEnergyHandler(TileEntity receptor) {
        this.receptor = receptor;
    }

    public void configure(int min_power, int max_power_recieved, int i2, int maxCapacity) {
        this.reconfigure(maxCapacity, max_power_recieved, 0.0);
    }

    public void readFromNBT(NBTTagCompound buffer) {
        NBTTagCompound nbt = buffer.func_74775_l("powerProvider");
        this.setEnergyStored(nbt.func_74769_h("energyStored"));
    }

    public void writeToNBT(NBTTagCompound buffer) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74780_a("energyStored", this.getEnergyStored());
        buffer.func_74782_a("powerProvider", (NBTBase)nbt);
    }

    public void update() {
    }

    public double getMaxEnergyStored() {
        return this.maxCapacity();
    }

    public double useEnergy(double min_power, double max_power, boolean doDrain) {
        if (this.getEnergyStored() < min_power) {
            return 0.0;
        }
        double t = JavaTools.bounds(this.getEnergyStored(), min_power, max_power);
        if (doDrain) {
            this.setEnergyStored(this.getEnergyStored() - t);
        }
        return t;
    }

    @Override
    public double getEnergyRequested() {
        return JavaTools.bounds(this.maxCapacity() - this.energyStored, this.minimumConsumption(), this.maxReceivedPerCycle());
    }

    @Override
    public double addEnergy(double mj) {
        double used;
        double contained = this.energyStored;
        double maxAccepted = this.maxCapacity() - contained + this.minimumConsumption();
        if (maxAccepted > this.maxReceivedPerCycle()) {
            maxAccepted = this.maxReceivedPerCycle();
        }
        if ((used = Math.min(maxAccepted, mj)) > 0.0) {
            this.setEnergyStored(Math.min(contained + used, this.maxCapacity()));
            return used;
        }
        return 0.0;
    }

    @Override
    public double addEnergy(double mj, boolean ignoreCycleLimit) {
        return this.addEnergy(mj);
    }

    @Override
    public double getEnergyStored() {
        return this.energyStored;
    }

    @Override
    public void setEnergyStored(double mj) {
        this.energyStored = mj;
    }

    @Override
    public double maxCapacity() {
        return this.maxCapacity;
    }

    @Override
    public double minimumConsumption() {
        return this.minimumConsumption;
    }

    @Override
    public double maxReceivedPerCycle() {
        return this.maxReceivedPerCycle;
    }

    @Override
    public IBatteryObject reconfigure(double maxCapacity, double maxReceivedPerCycle, double minimumConsumption) {
        this.maxCapacity = maxCapacity;
        this.maxReceivedPerCycle = maxReceivedPerCycle;
        this.minimumConsumption = minimumConsumption;
        return this;
    }

    @Override
    public String kind() {
        return "buildcraft.kinesis";
    }

    @Override
    public IBatteryObject getMjBattery(String kind) {
        return this;
    }
}

