/*
 * Decompiled with CFR 0.152.
 */
package codechicken.chunkloader;

import codechicken.chunkloader.ChunkLoaderManager;
import codechicken.chunkloader.PlayerChunkViewerManager;
import codechicken.core.ServerUtils;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.WorldEvent;

public class ChunkLoaderEventHandler {
    @SubscribeEvent
    public void serverTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            PlayerChunkViewerManager.instance().update();
        }
    }

    @SubscribeEvent
    public void worldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !event.world.field_72995_K) {
            ChunkLoaderManager.tickEnd((WorldServer)event.world);
            PlayerChunkViewerManager.instance().calculateChunkChanges((WorldServer)event.world);
        }
    }

    @SubscribeEvent
    public void playerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        ChunkLoaderManager.playerLogin(event.player.func_70005_c_());
    }

    @SubscribeEvent
    public void playerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        PlayerChunkViewerManager.instance().logouts.add(event.player.func_70005_c_());
        ChunkLoaderManager.playerLogout(event.player.func_70005_c_());
    }

    @SubscribeEvent
    public void onChunkDataLoad(ChunkDataEvent.Load event) {
        ChunkLoaderManager.load((WorldServer)event.world);
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (!event.world.field_72995_K) {
            ChunkLoaderManager.load((WorldServer)event.world);
            ChunkLoaderManager.loadWorld((WorldServer)event.world);
            PlayerChunkViewerManager.instance().dimChanges.add(new PlayerChunkViewerManager.DimensionChange((WorldServer)event.world, true));
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (!event.world.field_72995_K) {
            if (ServerUtils.mc().func_71278_l()) {
                ChunkLoaderManager.unloadWorld(event.world);
                PlayerChunkViewerManager.instance().dimChanges.add(new PlayerChunkViewerManager.DimensionChange((WorldServer)event.world, false));
            } else {
                PlayerChunkViewerManager.serverShutdown();
                ChunkLoaderManager.serverShutdown();
            }
        }
    }

    @SubscribeEvent
    public void onWorldSave(WorldEvent.Save event) {
        ChunkLoaderManager.save((WorldServer)event.world);
    }

    @SubscribeEvent
    public void onChunkForce(ForgeChunkManager.ForceChunkEvent event) {
        PlayerChunkViewerManager.instance().ticketChanges.add(new PlayerChunkViewerManager.TicketChange(event.ticket, event.location, true));
    }

    @SubscribeEvent
    public void onChunkUnForce(ForgeChunkManager.UnforceChunkEvent event) {
        PlayerChunkViewerManager.instance().ticketChanges.add(new PlayerChunkViewerManager.TicketChange(event.ticket, event.location, false));
    }
}

