/*
 * Decompiled with CFR 0.152.
 */
package com.aesireanempire.eplus.handlers;

import com.aesireanempire.eplus.EnchantingPlus;
import com.aesireanempire.eplus.handlers.ConfigurationHandler;
import com.aesireanempire.eplus.handlers.ModVersion;
import cpw.mods.fml.common.Loader;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import net.minecraftforge.common.config.Property;

public class Version
implements Runnable {
    private static final String REMOTE_VERSION_FILE = "https://dl.dropboxusercontent.com/u/21347544/EnchantingPlus/eplusvers.txt";
    private static final String REMOTE_CHANGELOG = "https://dl.dropboxusercontent.com/u/21347544/EnchantingPlus/changelogs/";
    public static Version instance = new Version();
    public static EnumUpdateState currentVersion = EnumUpdateState.CURRENT;
    private static boolean updated;
    private static boolean versionCheckCompleted;
    private static ModVersion recommendedVersion;
    private static ModVersion currentModVersion;
    private static String[] cachedChangelog;
    private static String recommendedDownload;

    public static void check() {
        new Thread(instance).start();
    }

    public static String[] getChangelog() {
        if (cachedChangelog == null) {
            cachedChangelog = Version.grabChangelog(recommendedVersion);
        }
        return cachedChangelog;
    }

    public static ModVersion getCurrentModVersion() {
        return currentModVersion;
    }

    public static String getMinecraftVersion() {
        return Loader.instance().getMinecraftModContainer().getVersion();
    }

    public static String getRecommendedDownload() {
        return recommendedDownload;
    }

    public static ModVersion getRecommendedVersion() {
        return recommendedVersion;
    }

    public static String[] grabChangelog(ModVersion recommendedVersion) {
        String recommendedVersionFile = recommendedVersion.getAsFileExtension() + ".txt";
        String changelogURL = REMOTE_CHANGELOG + recommendedVersionFile;
        try {
            URL url = new URL(changelogURL);
            BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
            String line = null;
            ArrayList<String> changelog = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#") || line.isEmpty()) continue;
                changelog.add(line);
            }
            return changelog.toArray(new String[changelog.size()]);
        }
        catch (Exception exception) {
            return new String[]{"Failed to grab changelog."};
        }
    }

    public static boolean hasUpdated() {
        return updated;
    }

    public static void init(Properties versionProperties) {
        if (versionProperties == null) {
            currentModVersion = new ModVersion("0.0.0");
            return;
        }
        String major = versionProperties.getProperty("eplus.major.number");
        String minor = versionProperties.getProperty("eplus.minor.number");
        versionProperties.getProperty("eplus.revision.number");
        currentModVersion = new ModVersion(major + "." + minor);
    }

    public static boolean isVersionCheckComplete() {
        return versionCheckCompleted;
    }

    public static void versionCheck() {
        Properties props = new Properties();
        try {
            URL url = new URL(REMOTE_VERSION_FILE);
            InputStreamReader inputStreamReader = new InputStreamReader(url.openStream());
            BufferedReader reader = new BufferedReader(inputStreamReader);
            String line = null;
            String mcVersion = Version.getMinecraftVersion();
            while ((line = reader.readLine()) != null) {
                if (!line.startsWith(mcVersion) || !line.contains("eplus")) continue;
                String[] tokens = line.split(":");
                recommendedVersion = new ModVersion(tokens[2]);
                if (!line.endsWith(currentModVersion.toString())) continue;
                EnchantingPlus.log.info("Using the latest version [" + Version.getCurrentModVersion() + "] for Minecraft " + mcVersion);
                currentVersion = EnumUpdateState.CURRENT;
                return;
            }
        }
        catch (Exception ex) {
            EnchantingPlus.log.warn("Unable to read from remote version authority.", new Object[0]);
            ex.printStackTrace();
            currentVersion = EnumUpdateState.CONNECTION_ERROR;
            recommendedVersion = new ModVersion("0.0.0");
            return;
        }
        int compared = currentModVersion.compareTo(recommendedVersion);
        if (compared == 0) {
            EnchantingPlus.log.info("Using the latest version for Minecraft " + Version.getMinecraftVersion(), new Object[0]);
            currentVersion = EnumUpdateState.CURRENT;
            updated = false;
        } else if (compared > 0) {
            EnchantingPlus.log.info("Using a Beta version of Enchanting Plus: " + Version.getCurrentModVersion());
            currentVersion = EnumUpdateState.BETA;
            updated = false;
        } else if (compared < 0) {
            EnchantingPlus.log.info("An updated version of Enchanting Plus is available: " + Version.getRecommendedVersion());
            currentVersion = EnumUpdateState.OUTDATED;
            updated = true;
        }
        props.clear();
    }

    public static boolean versionSeen() {
        if (currentVersion != EnumUpdateState.OUTDATED || currentVersion == EnumUpdateState.BETA) {
            return false;
        }
        Property property = ConfigurationHandler.configuration.get("version", "SeenVersion", currentModVersion.toString());
        String seenVersion = property.getString();
        if (recommendedVersion == null || recommendedVersion.equals(new ModVersion(seenVersion))) {
            return false;
        }
        property.set(Version.getRecommendedVersion().toString());
        ConfigurationHandler.configuration.save();
        return true;
    }

    @Override
    public void run() {
        currentVersion = null;
        EnchantingPlus.log.info("Starting version check thread");
        for (int count = 0; count < 3 && (currentVersion == null || currentVersion == EnumUpdateState.CONNECTION_ERROR); ++count) {
            Version.versionCheck();
        }
        EnchantingPlus.log.info("Version check complete with " + (Object)((Object)currentVersion));
        versionCheckCompleted = true;
    }

    public static enum EnumUpdateState {
        CURRENT,
        OUTDATED,
        CONNECTION_ERROR,
        BETA;

    }
}

