/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.powersink;

import Reika.RotaryCraft.API.Interfaces.Transducerable;
import Reika.RotaryCraft.API.Power.AdvancedShaftPowerReceiver;
import appeng.api.config.PowerUnits;
import appeng.integration.IntegrationType;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import appeng.tile.powersink.IC2;
import appeng.transformer.annotations.Integration;
import java.util.ArrayList;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@Integration.InterfaceList(value={@Integration.Interface(iname=IntegrationType.RotaryCraft, iface="Reika.RotaryCraft.API.Power.AdvancedShaftPowerReceiver"), @Integration.Interface(iname=IntegrationType.RotaryCraft, iface="Reika.RotaryCraft.API.Interfaces.Transducerable")})
public abstract class RotaryCraft
extends IC2
implements AdvancedShaftPowerReceiver,
Transducerable {
    private int omega = 0;
    private int torque = 0;
    private long power = 0L;
    private int alpha = 0;
    private long currentPower = 0L;

    @TileEvent(value=TileEventType.TICK)
    @Integration.Method(iname=IntegrationType.RotaryCraft)
    public void Tick_RotaryCraft() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && this.currentPower > 0L) {
            this.injectExternalPower(PowerUnits.WA, this.currentPower);
            this.currentPower = 0L;
        }
    }

    public final boolean addPower(int torque, int omega, long power, ForgeDirection side) {
        this.omega = omega;
        this.torque = torque;
        this.power = power;
        this.currentPower += power;
        return true;
    }

    public final int getOmega() {
        return this.omega;
    }

    public final int getTorque() {
        return this.torque;
    }

    public final long getPower() {
        return this.power;
    }

    public final String getName() {
        return "AE";
    }

    public final int getIORenderAlpha() {
        return this.alpha;
    }

    public final void setIORenderAlpha(int io) {
        this.alpha = io;
    }

    public final boolean canReadFromBlock(int x, int y, int z) {
        ForgeDirection side = ForgeDirection.UNKNOWN;
        if (x == this.field_145851_c - 1) {
            side = ForgeDirection.WEST;
        } else if (x == this.field_145851_c + 1) {
            side = ForgeDirection.EAST;
        } else if (z == this.field_145849_e - 1) {
            side = ForgeDirection.NORTH;
        } else if (z == this.field_145849_e + 1) {
            side = ForgeDirection.SOUTH;
        } else if (y == this.field_145848_d - 1) {
            side = ForgeDirection.DOWN;
        } else if (y == this.field_145848_d + 1) {
            side = ForgeDirection.UP;
        }
        return this.getPowerSides().contains(side);
    }

    public final boolean canReadFrom(ForgeDirection side) {
        return this.getPowerSides().contains(side);
    }

    public final boolean isReceiving() {
        return true;
    }

    public final int getMinTorque(int available) {
        return 1;
    }

    public final ArrayList<String> getMessages(World world, int x, int y, int z, int side) {
        String out = this.power >= 1000000000L ? String.format("Receiving %.3f GW @ %d rad/s.", (double)this.power / 1.0E9, this.omega) : (this.power >= 1000000L ? String.format("Receiving %.3f MW @ %d rad/s.", (double)this.power / 1000000.0, this.omega) : (this.power >= 1000L ? String.format("Receiving %.3f kW @ %d rad/s.", (double)this.power / 1000.0, this.omega) : String.format("Receiving %d W @ %d rad/s.", this.power, this.omega)));
        ArrayList<String> messages = new ArrayList<String>(1);
        messages.add(out);
        return messages;
    }
}

